﻿var Vcity = {};

Vcity._m = {
    /* 选择元素 */
    $:function (arg, context) {
        var tagAll, n, eles = [], i, sub = arg.substring(1);
        context = context || document;
        if (typeof arg == 'string') {
            switch (arg.charAt(0)) {
                case '#':
                    return document.getElementById(sub);
                    break;
                case '.':
                    if (context.getElementsByClassName) return context.getElementsByClassName(sub);
                    tagAll = Vcity._m.$('*', context);
                    n = tagAll.length;
                    for (i = 0; i < n; i++) {
                        if (tagAll[i].className.indexOf(sub) > -1) eles.push(tagAll[i]);
                    }
                    return eles;
                    break;
                default:
                    return context.getElementsByTagName(arg);
                    break;
            }
        }
    },

    /* 绑定事件 */
    on:function (node, type, handler) {
    	if(!node) return;
        node.addEventListener ? node.addEventListener(type, handler, false) : node.attachEvent('on' + type, handler);
    },

    /* 获取事件 */
    getEvent:function(event){
        return event || window.event;
    },

    /* 获取事件目标 */
    getTarget:function(event){
        return event.target || event.srcElement;
    },

    /* 获取元素位置 */
    getPos:function (node) {
        var scrollx = document.documentElement.scrollLeft || document.body.scrollLeft,
                scrollt = document.documentElement.scrollTop || document.body.scrollTop;
        var pos = node.getBoundingClientRect();
        return {top:pos.top + scrollt, right:pos.right + scrollx, bottom:pos.bottom + scrollt, left:pos.left + scrollx }
    },

    /* 添加样式名 */
    addClass:function (c, node) {
        if(!node)return;
        node.className = Vcity._m.hasClass(c,node) ? node.className : node.className + ' ' + c ;
    },

    /* 移除样式名 */
    removeClass:function (c, node) {
        var reg = new RegExp("(^|\\s+)" + c + "(\\s+|$)", "g");
        if(!Vcity._m.hasClass(c,node))return;
        node.className = reg.test(node.className) ? node.className.replace(reg, '') : node.className;
    },

    /* 是否含有CLASS */
    hasClass:function (c, node) {
        if(!node || !node.className)return false;
        return node.className.indexOf(c)>-1;
    },

    /* 阻止冒泡 */
    stopPropagation:function (event) {
        event = event || window.event;
        event.stopPropagation ? event.stopPropagation() : event.cancelBubble = true;
    },
    /* 去除两端空格 */
    trim:function (str) {
        return str.replace(/^\s+|\s+$/g,'');
    }
};

/* 所有城市数据,可以按照格式自行添加（北京|beijing|bj），前16条为热门城市 */

Vcity.allCity = ['北京|beijing|bj',
                 '南京|nanjing|nj',
                 '上海|shanghai|sh',
                 '广州|guangzhou|gz',
                 '杭州|hangzhou|hz',
                 '合肥|hefei|hf',
                 '西安|xian|xa',
                 '重庆|chongqing|cq',
                 '石家庄|shijiazhuang|sjz',
                 '武汉|wuhan|wh',
                 '昆明|kunming|km',
                 '拉萨|lasa|ls',
                 '钓鱼岛|diaoyudao|dyd',
                 '香港|xianggang|xg',
                 '台北|taibei|tb',
                 '海口|haikou|hk',
                 '东川|dongchuan|dc',
                 '寻甸|xundian|xd',
                 '晋宁|jinning|jn',
                 '宜良|yiliang|yl',
                 '石林|shilin|sl',
                 '呈贡|chenggong|cg',
                 '富民|fumin|fm',
                 '嵩明|songming|sm',
                 '禄劝|luquan|lq',
                 '安宁|anning|an',
                 '太华山|taihuashan|ths',
                 '大理|dali|dl',
                 '云龙|yunlong|yl',
                 '漾濞|yangbi|yb',
                 '永平|yongping|yp',
                 '宾川|binchuan|bc',
                 '弥渡|midu|md',
                 '祥云|xiangyun|xy',
                 '巍山|weishan|ws',
                 '剑川|jianchuan|jc',
                 '洱源|eryuan|ey',
                 '鹤庆|heqing|hq',
                 '南涧|nanjian|nj',
                 '红河|honghe|hh',
                 '石屏|shiping|sp',
                 '建水|jianshui|js',
                 '弥勒|mile|ml',
                 '元阳|yuanyang|yy',
                 '绿春|lvchun|lc',
                 '开远|kaiyuan|ky',
                 '个旧|gejiu|gj',
                 '蒙自|mengzi|mz',
                 '屏边|pingbian|pb',
                 '泸西|luxi|lx',
                 '金平|jinping|jp',
                 '河口|hekou|hk',
                 '曲靖|qujing|qj',
                 '沾益|zhanyi|zy',
                 '陆良|luliang|ll',
                 '富源|fuyuan|fy',
                 '马龙|malong|ml',
                 '师宗|shizong|sz',
                 '罗平|luoping|lp',
                 '会泽|huize|hz',
                 '宣威|xuanwei|xw',
                 '保山|baoshan|bs',
                 '龙陵|longling|ll',
                 '施甸|shidian|sd',
                 '昌宁|changning|cn',
                 '腾冲|tengchong|tc',
                 '文山|wenshan|ws',
                 '西畴|xichou|xc',
                 '马关|maguan|mg',
                 '麻栗坡|malipo|mlp',
                 '砚山|yanshan|ys',
                 '丘北|qiubei|qb',
                 '广南|guangnan|gn',
                 '富宁|funing|fn',
                 '玉溪|yuxi|yx',
                 '澄江|chengjiang|cj',
                 '江川|jiangchuan|jc',
                 '通海|tonghai|th',
                 '华宁|huaning|hn',
                 '新平|xinping|xp',
                 '易门|yimen|ym',
                 '峨山|eshan|es',
                 '元江|yuanjiang|yj',
                 '楚雄|chuxiong|cx',
                 '大姚|dayao|dy',
                 '元谋|yuanmou|ym',
                 '姚安|yaoan|ya',
                 '牟定|mouding|md',
                 '南华|nanhua|nh',
                 '武定|wuding|wd',
                 '禄丰|lufeng|lf',
                 '双柏|shuangbo|sb',
                 '永仁|yongren|yr',
                 '普洱|puer|pe',
                 '景谷|jinggu|jg',
                 '景东|jingdong|jd',
                 '澜沧|lancang|lc',
                 '墨江|mojiang|mj',
                 '江城|jiangcheng|jc',
                 '孟连|menglian|ml',
                 '西盟|ximeng|xm',
                 '镇沅|zhenyuan|zy',
                 '宁洱|ninger|ne',
                 '昭通|zhaotong|zt',
                 '鲁甸|ludian|ld',
                 '彝良|yiliang|yl',
                 '镇雄|zhenxiong|zx',
                 '威信|weixin|wx',
                 '巧家|qiaojia|qj',
                 '绥江|suijiang|sj',
                 '永善|yongshan|ys',
                 '盐津|yanjin|yj',
                 '大关|daguan|dg',
                 '水富|shuifu|sf',
                 '临沧|lincang|lc',
                 '沧源|cangyuan|cy',
                 '耿马|gengma|gm',
                 '双江|shuangjiang|sj',
                 '凤庆|fengqing|fq',
                 '永德|yongde|yd',
                 '云县|yunxian|yx',
                 '镇康|zhenkang|zk',
                 '怒江|nujiang|nj',
                 '福贡|fugong|fg',
                 '兰坪|lanping|lp',
                 '泸水|lushui|ls',
                 '六库|liuku|lk',
                 '贡山|gongshan|gs',
                 '香格里拉|xianggelila|xgll',
                 '德钦|deqin|dq',
                 '维西|weixi|wx',
                 '中甸|zhongdian|zd',
                 '丽江|lijiang|lj',
                 '永胜|yongsheng|ys',
                 '华坪|huaping|hp',
                 '宁蒗|ninglang|nl',
                 '德宏|dehong|dh',
                 '陇川|longchuan|lc',
                 '盈江|yingjiang|yj',
                 '瑞丽|ruili|rl',
                 '梁河|lianghe|lh',
                 '潞西|luxi|lx',
                 '景洪|jinghong|jh',
                 '勐海|menghai|mh',
                 '勐腊|mengla|ml',
                 '长丰|zhangfeng|zf',
                 '肥东|feidong|fd',
                 '肥西|feixi|fx',
                 '蚌埠|bangbu|bb',
                 '怀远|huaiyuan|hy',
                 '固镇|guzhen|gz',
                 '五河|wuhe|wh',
                 '芜湖|wuhu|wh',
                 '繁昌|fanchang|fc',
                 '芜湖县|wuhuxian|whx',
                 '南陵|nanling|nl',
                 '淮南|huainan|hn',
                 '凤台|fengtai|ft',
                 '潘集|panji|pj',
                 '马鞍山|maanshan|mas',
                 '当涂|dangtu|dt',
                 '安庆|anqing|aq',
                 '枞阳|zongyang|zy',
                 '太湖|taihu|th',
                 '潜山|qianshan|qs',
                 '怀宁|huaining|hn',
                 '宿松|susong|ss',
                 '望江|wangjiang|wj',
                 '岳西|yuexi|yx',
                 '桐城|tongcheng|tc',
                 '宿州|suzhou|sz',
                 '砀山|dangshan|ds',
                 '灵璧|lingbi|lb',
                 '泗县|sixian|sx',
                 '萧县|xiaoxian|xx',
                 '阜阳|fuyang|fy',
                 '阜南|funan|fn',
                 '颍上|yingshang|ys',
                 '临泉|linquan|lq',
                 '界首|jieshou|js',
                 '太和|taihe|th',
                 '亳州|bozhou|bz',
                 '涡阳|woyang|wy',
                 '利辛|lixin|lx',
                 '蒙城|mengcheng|mc',
                 '黄山|huangshan|hs',
                 '黄山区|huangshanqu|hsq',
                 '屯溪|tunxi|tx',
                 '祁门|qimen|qm',
                 '黟县|yixian|yx',
                 '歙县|shexian|sx',
                 '休宁|xiuning|xn',
                 '黄山市|huangshanshi|hss',
                 '滁州|chuzhou|cz',
                 '凤阳|fengyang|fy',
                 '明光|mingguang|mg',
                 '定远|dingyuan|dy',
                 '全椒|quanjiao|qj',
                 '来安|laian|la',
                 '天长|tianzhang|tz',
                 '淮北|huaibei|hb',
                 '濉溪|suixi|sx',
                 '铜陵|tongling|tl',
                 '宣城|xuancheng|xc',
                 '泾县|jingxian|jx',
                 '旌德|jingde|jd',
                 '宁国|ningguo|ng',
                 '绩溪|jixi|jx',
                 '广德|guangde|gd',
                 '郎溪|langxi|lx',
                 '六安|liuan|la',
                 '霍邱|huoqiu|hq',
                 '寿县|shouxian|sx',
                 '金寨|jinzhai|jz',
                 '霍山|huoshan|hs',
                 '舒城|shucheng|sc',
                 '巢湖|chaohu|ch',
                 '庐江|lujiang|lj',
                 '无为|wuwei|ww',
                 '含山|hanshan|hs',
                 '和县|hexian|hx',
                 '池州|chizhou|cz',
                 '东至|dongzhi|dz',
                 '青阳|qingyang|qy',
                 '九华山|jiuhuashan|jhs',
                 '石台|shitai|st',
                 '蔡甸|caidian|cd',
                 '黄陂|huangpo|hp',
                 '新洲|xinzhou|xz',
                 '江夏|jiangxia|jx',
                 '东西湖|dongxihu|dxh',
                 '襄阳|xiangyang|xy',
                 '襄州|xiangzhou|xz',
                 '保康|baokang|bk',
                 '南漳|nanzhang|nz',
                 '宜城|yicheng|yc',
                 '老河口|laohekou|lhk',
                 '谷城|gucheng|gc',
                 '枣阳|zaoyang|zy',
                 '鄂州|ezhou|ez',
                 '梁子湖|liangzihu|lzh',
                 '孝感|xiaogan|xg',
                 '安陆|anlu|al',
                 '云梦|yunmeng|ym',
                 '大悟|dawu|dw',
                 '应城|yingcheng|yc',
                 '汉川|hanchuan|hc',
                 '孝昌|xiaochang|xc',
                 '黄冈|huanggang|hg',
                 '红安|hongan|ha',
                 '麻城|macheng|mc',
                 '罗田|luotian|lt',
                 '英山|yingshan|ys',
                 '浠水|xishui|xs',
                 '蕲春|qichun|qc',
                 '黄梅|huangmei|hm',
                 '武穴|wuxue|wx',
                 '团风|tuanfeng|tf',
                 '黄石|huangshi|hs',
                 '大冶|daye|dy',
                 '阳新|yangxin|yx',
                 '铁山|tieshan|ts',
                 '下陆|xialu|xl',
                 '西塞山|xisaishan|xss',
                 '咸宁|xianning|xn',
                 '赤壁|chibi|cb',
                 '嘉鱼|jiayu|jy',
                 '崇阳|chongyang|cy',
                 '通城|tongcheng|tc',
                 '通山|tongshan|ts',
                 '荆州|jingzhou|jz',
                 '江陵|jiangling|jl',
                 '公安|gongan|ga',
                 '石首|shishou|ss',
                 '监利|jianli|jl',
                 '洪湖|honghu|hh',
                 '松滋|songzi|sz',
                 '沙市|shashi|ss',
                 '宜昌|yichang|yc',
                 '远安|yuanan|ya',
                 '秭归|zigui|zg',
                 '兴山|xingshan|xs',
                 '五峰|wufeng|wf',
                 '当阳|dangyang|dy',
                 '长阳|zhangyang|zy',
                 '宜都|yidou|yd',
                 '枝江|zhijiang|zj',
                 '三峡|sanxia|sx',
                 '夷陵|yiling|yl',
                 '恩施|enshi|es',
                 '利川|lichuan|lc',
                 '建始|jianshi|js',
                 '咸丰|xianfeng|xf',
                 '宣恩|xuanen|xe',
                 '鹤峰|hefeng|hf',
                 '来凤|laifeng|lf',
                 '巴东|badong|bd',
                 '十堰|shiyan|sy',
                 '竹溪|zhuxi|zx',
                 '郧西|yunxi|yx',
                 '郧县|yunxian|yx',
                 '竹山|zhushan|zs',
                 '房县|fangxian|fx',
                 '丹江口|danjiangkou|djk',
                 '茅箭|maojian|mj',
                 '张湾|zhangwan|zw',
                 '神农架|shennongjia|snj',
                 '随州|suizhou|sz',
                 '广水|guangshui|gs',
                 '荆门|jingmen|jm',
                 '钟祥|zhongxiang|zx',
                 '京山|jingshan|js',
                 '掇刀|duodao|dd',
                 '沙洋|shayang|sy',
                 '天门|tianmen|tm',
                 '仙桃|xiantao|xt',
                 '潜江|qianjiang|qj',
                 '郑州|zhengzhou|zz',
                 '巩义|gongyi|gy',
                 '荥阳|yingyang|yy',
                 '登封|dengfeng|df',
                 '新密|xinmi|xm',
                 '新郑|xinzheng|xz',
                 '中牟|zhongmou|zm',
                 '上街|shangjie|sj',
                 '安阳|anyang|ay',
                 '汤阴|tangyin|ty',
                 '滑县|huaxian|hx',
                 '内黄|neihuang|nh',
                 '林州|linzhou|lz',
                 '新乡|xinxiang|xx',
                 '获嘉|huojia|hj',
                 '原阳|yuanyang|yy',
                 '辉县|huixian|hx',
                 '卫辉|weihui|wh',
                 '延津|yanjin|yj',
                 '封丘|fengqiu|fq',
                 '长垣|zhangyuan|zy',
                 '许昌|xuchang|xc',
                 '鄢陵|yanling|yl',
                 '襄城|xiangcheng|xc',
                 '长葛|zhangge|zg',
                 '禹州|yuzhou|yz',
                 '平顶山|pingdingshan|pds',
                 '郏县|jiaxian|jx',
                 '宝丰|baofeng|bf',
                 '汝州|ruzhou|rz',
                 '叶县|yexian|yx',
                 '舞钢|wugang|wg',
                 '鲁山|lushan|ls',
                 '石龙|shilong|sl',
                 '信阳|xinyang|xy',
                 '息县|xixian|xx',
                 '罗山|luoshan|ls',
                 '光山|guangshan|gs',
                 '新县|xinxian|xx',
                 '淮滨|huaibin|hb',
                 '潢川|huangchuan|hc',
                 '固始|gushi|gs',
                 '商城|shangcheng|sc',
                 '南阳|nanyang|ny',
                 '南召|nanzhao|nz',
                 '方城|fangcheng|fc',
                 '社旗|sheqi|sq',
                 '西峡|xixia|xx',
                 '内乡|neixiang|nx',
                 '镇平|zhenping|zp',
                 '淅川|xichuan|xc',
                 '新野|xinye|xy',
                 '唐河|tanghe|th',
                 '邓州|dengzhou|dz',
                 '桐柏|tongbo|tb',
                 '开封|kaifeng|kf',
                 '杞县|qixian|qx',
                 '尉氏|weishi|ws',
                 '通许|tongxu|tx',
                 '兰考|lankao|lk',
                 '洛阳|luoyang|ly',
                 '新安|xinan|xa',
                 '孟津|mengjin|mj',
                 '宜阳|yiyang|yy',
                 '洛宁|luoning|ln',
                 '伊川|yichuan|yc',
                 '嵩县|songxian|sx',
                 '偃师|yanshi|ys',
                 '栾川|luanchuan|lc',
                 '汝阳|ruyang|ry',
                 '吉利|jili|jl',
                 '商丘|shangqiu|sq',
                 '睢县|suixian|sx',
                 '民权|minquan|mq',
                 '虞城|yucheng|yc',
                 '柘城|zhecheng|zc',
                 '宁陵|ningling|nl',
                 '夏邑|xiayi|xy',
                 '永城|yongcheng|yc',
                 '焦作|jiaozuo|jz',
                 '修武|xiuwu|xw',
                 '武陟|wuzhi|wz',
                 '沁阳|qinyang|qy',
                 '博爱|boai|ba',
                 '温县|wenxian|wx',
                 '孟州|mengzhou|mz',
                 '鹤壁|hebi|hb',
                 '浚县|junxian|jx',
                 '淇县|qixian|qx',
                 '濮阳|puyang|py',
                 '台前|taiqian|tq',
                 '南乐|nanle|nl',
                 '清丰|qingfeng|qf',
                 '范县|fanxian|fx',
                 '周口|zhoukou|zk',
                 '扶沟|fugou|fg',
                 '太康|taikang|tk',
                 '淮阳|huaiyang|hy',
                 '西华|xihua|xh',
                 '商水|shangshui|ss',
                 '项城|xiangcheng|xc',
                 '郸城|dancheng|dc',
                 '鹿邑|luyi|ly',
                 '沈丘|shenqiu|sq',
                 '漯河|luohe|lh',
                 '临颍|linying|ly',
                 '舞阳|wuyang|wy',
                 '驻马店|zhumadian|zmd',
                 '西平|xiping|xp',
                 '遂平|suiping|sp',
                 '上蔡|shangcai|sc',
                 '汝南|runan|rn',
                 '泌阳|miyang|my',
                 '平舆|pingyu|py',
                 '新蔡|xincai|xc',
                 '确山|queshan|qs',
                 '正阳|zhengyang|zy',
                 '三门峡|sanmenxia|smx',
                 '灵宝|lingbao|lb',
                 '渑池|mianchi|mc',
                 '卢氏|lushi|ls',
                 '义马|yima|ym',
                 '陕县|shanxian|sx',
                 '济源|jiyuan|jy',
                 '成都|chengdou|cd',
                 '龙泉驿|longquanyi|lqy',
                 '新都|xindou|xd',
                 '温江|wenjiang|wj',
                 '金堂|jintang|jt',
                 '双流|shuangliu|sl',
                 '郫县|pixian|px',
                 '大邑|dayi|dy',
                 '蒲江|pujiang|pj',
                 '新津|xinjin|xj',
                 '都江堰|doujiangyan|djy',
                 '彭州|pengzhou|pz',
                 '邛崃|qionglai|ql',
                 '崇州|chongzhou|cz',
                 '攀枝花|panzhihua|pzh',
                 '仁和|renhe|rh',
                 '米易|miyi|my',
                 '盐边|yanbian|yb',
                 '自贡|zigong|zg',
                 '富顺|fushun|fs',
                 '荣县|rongxian|rx',
                 '绵阳|mianyang|my',
                 '三台|santai|st',
                 '盐亭|yanting|yt',
                 '安县|anxian|ax',
                 '梓潼|zitong|zt',
                 '北川|beichuan|bc',
                 '平武|pingwu|pw',
                 '江油|jiangyou|jy',
                 '南充|nanchong|nc',
                 '南部|nanbu|nb',
                 '营山|yingshan|ys',
                 '蓬安|pengan|pa',
                 '仪陇|yilong|yl',
                 '西充|xichong|xc',
                 '阆中|langzhong|lz',
                 '达州|dazhou|dz',
                 '宣汉|xuanhan|xh',
                 '开江|kaijiang|kj',
                 '大竹|dazhu|dz',
                 '渠县|quxian|qx',
                 '万源|wanyuan|wy',
                 '达川|dachuan|dc',
                 '达县|daxian|dx',
                 '遂宁|suining|sn',
                 '蓬溪|pengxi|px',
                 '射洪|shehong|sh',
                 '广安|guangan|ga',
                 '岳池|yuechi|yc',
                 '武胜|wusheng|ws',
                 '邻水|linshui|ls',
                 '华蓥|huaying|hy',
                 '巴中|bazhong|bz',
                 '通江|tongjiang|tj',
                 '南江|nanjiang|nj',
                 '平昌|pingchang|pc',
                 '泸州|luzhou|lz',
                 '泸县|luxian|lx',
                 '合江|hejiang|hj',
                 '叙永|xuyong|xy',
                 '古蔺|gulin|gl',
                 '纳溪|naxi|nx',
                 '宜宾|yibin|yb',
                 '宜宾县|yibinxian|ybx',
                 '南溪|nanxi|nx',
                 '江安|jiangan|ja',
                 '长宁|zhangning|zn',
                 '高县|gaoxian|gx',
                 '珙县|gongxian|gx',
                 '筠连|yunlian|yl',
                 '兴文|xingwen|xw',
                 '屏山|pingshan|ps',
                 '内江|neijiang|nj',
                 '东兴|dongxing|dx',
                 '威远|weiyuan|wy',
                 '资中|zizhong|zz',
                 '隆昌|longchang|lc',
                 '资阳|ziyang|zy',
                 '安岳|anyue|ay',
                 '乐至|lezhi|lz',
                 '简阳|jianyang|jy',
                 '乐山|leshan|ls',
                 '犍为|jianwei|jw',
                 '井研|jingyan|jy',
                 '夹江|jiajiang|jj',
                 '沐川|muchuan|mc',
                 '峨边|ebian|eb',
                 '马边|mabian|mb',
                 '峨眉|emei|em',
                 '峨眉山|emeishan|ems',
                 '眉山|meishan|ms',
                 '仁寿|renshou|rs',
                 '彭山|pengshan|ps',
                 '洪雅|hongya|hy',
                 '丹棱|danleng|dl',
                 '青神|qingshen|qs',
                 '凉山|liangshan|ls',
                 '木里|muli|ml',
                 '盐源|yanyuan|yy',
                 '德昌|dechang|dc',
                 '会理|huili|hl',
                 '会东|huidong|hd',
                 '宁南|ningnan|nn',
                 '普格|puge|pg',
                 '西昌|xichang|xc',
                 '金阳|jinyang|jy',
                 '昭觉|zhaojue|zj',
                 '喜德|xide|xd',
                 '冕宁|mianning|mn',
                 '越西|yuexi|yx',
                 '甘洛|ganluo|gl',
                 '雷波|leibo|lb',
                 '美姑|meigu|mg',
                 '布拖|butuo|bt',
                 '雅安|yaan|ya',
                 '名山|mingshan|ms',
                 '荥经|yingjing|yj',
                 '汉源|hanyuan|hy',
                 '石棉|shimian|sm',
                 '天全|tianquan|tq',
                 '芦山|lushan|ls',
                 '宝兴|baoxing|bx',
                 '甘孜|ganzi|gz',
                 '康定|kangding|kd',
                 '泸定|luding|ld',
                 '丹巴|danba|db',
                 '九龙县|jiulongxian|jlx',
                 '雅江|yajiang|yj',
                 '道孚|daofu|df',
                 '炉霍|luhuo|lh',
                 '新龙|xinlong|xl',
                 '德格|dege|dg',
                 '白玉|baiyu|by',
                 '石渠|shiqu|sq',
                 '色达|seda|sd',
                 '理塘|litang|lt',
                 '巴塘|batang|bt',
                 '乡城|xiangcheng|xc',
                 '稻城|daocheng|dc',
                 '得荣|derong|dr',
                 '阿坝|aba|ab',
                 '汶川|wenchuan|wc',
                 '理县|lixian|lx',
                 '茂县|maoxian|mx',
                 '松潘|songpan|sp',
                 '九寨沟|jiuzhaigou|jzg',
                 '金川|jinchuan|jc',
                 '小金|xiaojin|xj',
                 '黑水|heishui|hs',
                 '马尔康|maerkang|mek',
                 '壤塘|rangtang|rt',
                 '若尔盖|ruoergai|reg',
                 '红原|hongyuan|hy',
                 '德阳|deyang|dy',
                 '中江|zhongjiang|zj',
                 '广汉|guanghan|gh',
                 '什邡|shenfang|sf',
                 '绵竹|mianzhu|mz',
                 '罗江|luojiang|lj',
                 '广元|guangyuan|gy',
                 '旺苍|wangcang|wc',
                 '青川|qingchuan|qc',
                 '剑阁|jiange|jg',
                 '苍溪|cangxi|cx',
                 '西宁|xining|xn',
                 '大通|datong|dt',
                 '湟源|huangyuan|hy',
                 '湟中|huangzhong|hz',
                 '海东|haidong|hd',
                 '乐都|ledou|ld',
                 '民和|minhe|mh',
                 '互助|huzhu|hz',
                 '化隆|hualong|hl',
                 '循化|xunhua|xh',
                 '冷湖|lenghu|lh',
                 '平安|pingan|pa',
                 '黄南|huangnan|hn',
                 '尖扎|jianzha|jz',
                 '泽库|zeku|zk',
                 '河南|henan|hn',
                 '同仁|tongren|tr',
                 '海南|hainan|hn',
                 '贵德|guide|gd',
                 '兴海|xinghai|xh',
                 '贵南|guinan|gn',
                 '同德|tongde|td',
                 '共和|gonghe|gh',
                 '果洛|guoluo|gl',
                 '班玛|banma|bm',
                 '甘德|gande|gd',
                 '达日|dari|dr',
                 '久治|jiuzhi|jz',
                 '玛多|maduo|md',
                 '多县|duoxian|dx',
                 '玛沁|maqin|mq',
                 '玉树|yushu|ys',
                 '称多|chengduo|cd',
                 '治多|zhiduo|zd',
                 '杂多|zaduo|zd',
                 '囊谦|nangqian|nq',
                 '曲麻莱|qumalai|qml',
                 '海西|haixi|hx',
                 '天峻|tianjun|tj',
                 '乌兰|wulan|wl',
                 '茫崖|mangya|my',
                 '大柴旦|dachaidan|dcd',
                 '德令哈|delingha|dlh',
                 '海北|haibei|hb',
                 '门源|menyuan|my',
                 '祁连|qilian|ql',
                 '海晏|haiyan|hy',
                 '刚察|gangcha|gc',
                 '格尔木|geermu|gem',
                 '都兰|doulan|dl',
                 '桃园|taoyuan|ty',
                 '新竹|xinzhu|xz',
                 '宜兰|yilan|yl',
                 '高雄|gaoxiong|gx',
                 '嘉义|jiayi|jy',
                 '台南|tainan|tn',
                 '台东|taidong|td',
                 '屏东|pingdong|pd',
                 '台中|taizhong|tz',
                 '苗栗|miaoli|ml',
                 '彰化|zhanghua|zh',
                 '南投|nantou|nt',
                 '花莲|hualian|hl',
                 '云林|yunlin|yl',
                 '沈阳|shenyang|sy',
                 '辽中|liaozhong|lz',
                 '康平|kangping|kp',
                 '法库|faku|fk',
                 '新民|xinmin|xm',
                 '大连|dalian|dl',
                 '瓦房店|wafangdian|wfd',
                 '金州|jinzhou|jz',
                 '普兰店|pulandian|pld',
                 '旅顺|lvshun|ls',
                 '长海|zhanghai|zh',
                 '庄河|zhuanghe|zh',
                 '鞍山|anshan|as',
                 '台安|taian|ta',
                 '岫岩|xiuyan|xy',
                 '海城|haicheng|hc',
                 '抚顺|fushun|fs',
                 '新宾|xinbin|xb',
                 '清原|qingyuan|qy',
                 '章党|zhangdang|zd',
                 '本溪|benxi|bx',
                 '本溪县|benxixian|bxx',
                 '桓仁|huanren|hr',
                 '丹东|dandong|dd',
                 '凤城|fengcheng|fc',
                 '宽甸|kuandian|kd',
                 '东港|donggang|dg',
                 '锦州|jinzhou|jz',
                 '凌海|linghai|lh',
                 '义县|yixian|yx',
                 '黑山|heishan|hs',
                 '北镇|beizhen|bz',
                 '营口|yingkou|yk',
                 '大石桥|dashiqiao|dsq',
                 '盖州|gaizhou|gz',
                 '阜新|fuxin|fx',
                 '彰武|zhangwu|zw',
                 '辽阳|liaoyang|ly',
                 '辽阳县|liaoyangxian|lyx',
                 '灯塔|dengta|dt',
                 '弓长岭|gongzhangling|gzl',
                 '铁岭|tieling|tl',
                 '开原|kaiyuan|ky',
                 '昌图|changtu|ct',
                 '西丰|xifeng|xf',
                 '调兵山|diaobingshan|dbs',
                 '朝阳县|chaoyangxian|cyx',
                 '凌源|lingyuan|ly',
                 '喀左|kazuo|kz',
                 '北票|beipiao|bp',
                 '建平县|jianpingxian|jpx',
                 '盘锦|panjin|pj',
                 '大洼|dawa|dw',
                 '盘山|panshan|ps',
                 '葫芦岛|huludao|hld',
                 '建昌|jianchang|jc',
                 '绥中|suizhong|sz',
                 '兴城|xingcheng|xc',
                 '萧山|xiaoshan|xs',
                 '桐庐|tonglu|tl',
                 '淳安|chunan|ca',
                 '建德|jiande|jd',
                 '余杭|yuhang|yh',
                 '临安|linan|la',
                 '富阳|fuyang|fy',
                 '湖州|huzhou|hz',
                 '长兴|zhangxing|zx',
                 '安吉|anji|aj',
                 '德清|deqing|dq',
                 '嘉兴|jiaxing|jx',
                 '嘉善|jiashan|js',
                 '海宁|haining|hn',
                 '桐乡|tongxiang|tx',
                 '平湖|pinghu|ph',
                 '海盐|haiyan|hy',
                 '宁波|ningbo|nb',
                 '慈溪|cixi|cx',
                 '余姚|yuyao|yy',
                 '奉化|fenghua|fh',
                 '象山|xiangshan|xs',
                 '宁海|ninghai|nh',
                 '北仑|beilun|bl',
                 '鄞州|yinzhou|yz',
                 '镇海|zhenhai|zh',
                 '绍兴|shaoxing|sx',
                 '诸暨|zhuji|zj',
                 '上虞|shangyu|sy',
                 '新昌|xinchang|xc',
                 '嵊州|shengzhou|sz',
                 '台州|taizhou|tz',
                 '玉环|yuhuan|yh',
                 '三门|sanmen|sm',
                 '天台|tiantai|tt',
                 '仙居|xianju|xj',
                 '温岭|wenling|wl',
                 '洪家|hongjia|hj',
                 '临海|linhai|lh',
                 '椒江|jiaojiang|jj',
                 '黄岩|huangyan|hy',
                 '路桥|luqiao|lq',
                 '温州|wenzhou|wz',
                 '泰顺|taishun|ts',
                 '文成|wencheng|wc',
                 '平阳|pingyang|py',
                 '瑞安|ruian|ra',
                 '洞头|dongtou|dt',
                 '乐清|leqing|lq',
                 '永嘉|yongjia|yj',
                 '苍南|cangnan|cn',
                 '丽水|lishui|ls',
                 '遂昌|suichang|sc',
                 '龙泉|longquan|lq',
                 '缙云|jinyun|jy',
                 '青田|qingtian|qt',
                 '云和|yunhe|yh',
                 '庆元|qingyuan|qy',
                 '松阳|songyang|sy',
                 '景宁|jingning|jn',
                 '金华|jinhua|jh',
                 '浦江|pujiang|pj',
                 '兰溪|lanxi|lx',
                 '义乌|yiwu|yw',
                 '东阳|dongyang|dy',
                 '武义|wuyi|wy',
                 '永康|yongkang|yk',
                 '磐安|panan|pa',
                 '衢州|quzhou|qz',
                 '常山|changshan|cs',
                 '开化|kaihua|kh',
                 '龙游|longyou|ly',
                 '江山|jiangshan|js',
                 '衢江|qujiang|qj',
                 '舟山|zhoushan|zs',
                 '嵊泗|shengsi|ss',
                 '岱山|daishan|ds',
                 '普陀|putuo|pt',
                 '定海|dinghai|dh',
                 '太原|taiyuan|ty',
                 '清徐|qingxu|qx',
                 '阳曲|yangqu|yq',
                 '娄烦|loufan|lf',
                 '古交|gujiao|gj',
                 '尖草坪区|jiancaopingqu|jcpq',
                 '小店区|xiaodianqu|xdq',
                 '大同|datong|dt',
                 '阳高|yanggao|yg',
                 '大同县|datongxian|dtx',
                 '天镇|tianzhen|tz',
                 '广灵|guangling|gl',
                 '灵丘|lingqiu|lq',
                 '浑源|hunyuan|hy',
                 '左云|zuoyun|zy',
                 '阳泉|yangquan|yq',
                 '盂县|yuxian|yx',
                 '平定|pingding|pd',
                 '晋中|jinzhong|jz',
                 '榆次|yuci|yc',
                 '榆社|yushe|ys',
                 '左权|zuoquan|zq',
                 '和顺|heshun|hs',
                 '昔阳|xiyang|xy',
                 '寿阳|shouyang|sy',
                 '太谷|taigu|tg',
                 '祁县|qixian|qx',
                 '平遥|pingyao|py',
                 '灵石|lingshi|ls',
                 '介休|jiexiu|jx',
                 '长治|zhangzhi|zz',
                 '黎城|licheng|lc',
                 '屯留|tunliu|tl',
                 '潞城|lucheng|lc',
                 '襄垣|xiangyuan|xy',
                 '平顺|pingshun|ps',
                 '武乡|wuxiang|wx',
                 '沁县|qinxian|qx',
                 '长子|zhangzi|zz',
                 '沁源|qinyuan|qy',
                 '壶关|huguan|hg',
                 '晋城|jincheng|jc',
                 '沁水|qinshui|qs',
                 '阳城|yangcheng|yc',
                 '陵川|lingchuan|lc',
                 '高平|gaoping|gp',
                 '泽州|zezhou|zz',
                 '临汾|linfen|lf',
                 '曲沃|quwo|qw',
                 '永和|yonghe|yh',
                 '隰县|xixian|xx',
                 '大宁|daning|dn',
                 '吉县|jixian|jx',
                 '襄汾|xiangfen|xf',
                 '蒲县|puxian|px',
                 '汾西|fenxi|fx',
                 '洪洞|hongdong|hd',
                 '霍州|huozhou|hz',
                 '乡宁|xiangning|xn',
                 '翼城|yicheng|yc',
                 '侯马|houma|hm',
                 '浮山|fushan|fs',
                 '安泽|anze|az',
                 '古县|guxian|gx',
                 '运城|yuncheng|yc',
                 '临猗|linyi|ly',
                 '稷山|jishan|js',
                 '万荣|wanrong|wr',
                 '河津|hejin|hj',
                 '新绛|xinjiang|xj',
                 '绛县|jiangxian|jx',
                 '闻喜|wenxi|wx',
                 '垣曲|yuanqu|yq',
                 '永济|yongji|yj',
                 '芮城|ruicheng|rc',
                 '夏县|xiaxian|xx',
                 '平陆|pinglu|pl',
                 '朔州|shuozhou|sz',
                 '平鲁|pinglu|pl',
                 '山阴|shanyin|sy',
                 '右玉|youyu|yy',
                 '应县|yingxian|yx',
                 '怀仁|huairen|hr',
                 '忻州|xinzhou|xz',
                 '定襄|dingxiang|dx',
                 '五台县|wutaixian|wtx',
                 '河曲|hequ|hq',
                 '偏关|pianguan|pg',
                 '神池|shenchi|sc',
                 '宁武|ningwu|nw',
                 '代县|daixian|dx',
                 '繁峙|fanzhi|fz',
                 '五台山|wutaishan|wts',
                 '保德|baode|bd',
                 '静乐|jingle|jl',
                 '岢岚|kelan|kl',
                 '五寨|wuzhai|wz',
                 '原平|yuanping|yp',
                 '吕梁|lvliang|ll',
                 '离石|lishi|ls',
                 '临县|linxian|lx',
                 '兴县|xingxian|xx',
                 '岚县|lanxian|lx',
                 '柳林|liulin|ll',
                 '石楼|shilou|sl',
                 '方山|fangshan|fs',
                 '交口|jiaokou|jk',
                 '中阳|zhongyang|zy',
                 '孝义|xiaoyi|xy',
                 '汾阳|fenyang|fy',
                 '文水|wenshui|ws',
                 '交城|jiaocheng|jc',
                 '南宁|nanning|nn',
                 '邕宁|yongning|yn',
                 '横县|hengxian|hx',
                 '隆安|longan|la',
                 '马山|mashan|ms',
                 '上林|shanglin|sl',
                 '武鸣|wuming|wm',
                 '宾阳|binyang|by',
                 '崇左|chongzuo|cz',
                 '天等|tiandeng|td',
                 '龙州|longzhou|lz',
                 '凭祥|pingxiang|px',
                 '大新|daxin|dx',
                 '扶绥|fusui|fs',
                 '宁明|ningming|nm',
                 '柳州|liuzhou|lz',
                 '柳城|liucheng|lc',
                 '鹿寨|luzhai|lz',
                 '柳江|liujiang|lj',
                 '融安|rongan|ra',
                 '融水|rongshui|rs',
                 '三江|sanjiang|sj',
                 '来宾|laibin|lb',
                 '忻城|xincheng|xc',
                 '金秀|jinxiu|jx',
                 '象州|xiangzhou|xz',
                 '武宣|wuxuan|wx',
                 '合山|heshan|hs',
                 '桂林|guilin|gl',
                 '龙胜|longsheng|ls',
                 '永福|yongfu|yf',
                 '临桂|lingui|lg',
                 '兴安|xingan|xa',
                 '灵川|lingchuan|lc',
                 '全州|quanzhou|qz',
                 '灌阳|guanyang|gy',
                 '阳朔|yangshuo|ys',
                 '恭城|gongcheng|gc',
                 '平乐|pingle|pl',
                 '荔浦|lipu|lp',
                 '资源|ziyuan|zy',
                 '梧州|wuzhou|wz',
                 '藤县|tengxian|tx',
                 '苍梧|cangwu|cw',
                 '蒙山|mengshan|ms',
                 '岑溪|cenxi|cx',
                 '贺州|hezhou|hz',
                 '昭平|zhaoping|zp',
                 '富川|fuchuan|fc',
                 '钟山|zhongshan|zs',
                 '贵港|guigang|gg',
                 '桂平|guiping|gp',
                 '平南|pingnan|pn',
                 '玉林|yulin|yl',
                 '博白|bobai|bb',
                 '北流|beiliu|bl',
                 '容县|rongxian|rx',
                 '陆川|luchuan|lc',
                 '兴业|xingye|xy',
                 '百色|baise|bs',
                 '那坡|neipo|np',
                 '田阳|tianyang|ty',
                 '德保|debao|db',
                 '靖西|jingxi|jx',
                 '田东|tiandong|td',
                 '平果|pingguo|pg',
                 '隆林|longlin|ll',
                 '西林|xilin|xl',
                 '乐业|leye|ly',
                 '凌云|lingyun|ly',
                 '田林|tianlin|tl',
                 '钦州|qinzhou|qz',
                 '浦北|pubei|pb',
                 '灵山|lingshan|ls',
                 '河池|hechi|hc',
                 '天峨|tiane|te',
                 '东兰|donglan|dl',
                 '巴马|bama|bm',
                 '环江|huanjiang|hj',
                 '罗城|luocheng|lc',
                 '宜州|yizhou|yz',
                 '凤山|fengshan|fs',
                 '南丹|nandan|nd',
                 '都安|douan|da',
                 '大化|dahua|dh',
                 '北海|beihai|bh',
                 '合浦|hepu|hp',
                 '涠洲岛|weizhoudao|wzd',
                 '防城港|fangchenggang|fcg',
                 '上思|shangsi|ss',
                 '东兴|dongxing|dx',
                 '防城|fangcheng|fc',
                 '长春|zhangchun|zc',
                 '农安|nongan|na',
                 '德惠|dehui|dh',
                 '九台|jiutai|jt',
                 '榆树|yushu|ys',
                 '双阳|shuangyang|sy',
                 '吉林|jilin|jl',
                 '舒兰|shulan|sl',
                 '永吉|yongji|yj',
                 '蛟河|jiaohe|jh',
                 '磐石|panshi|ps',
                 '桦甸|huadian|hd',
                 '延吉|yanji|yj',
                 '敦化|dunhua|dh',
                 '安图|antu|at',
                 '汪清|wangqing|wq',
                 '和龙|helong|hl',
                 '龙井|longjing|lj',
                 '珲春|hunchun|hc',
                 '图们|tumen|tm',
                 '四平|siping|sp',
                 '双辽|shuangliao|sl',
                 '梨树|lishu|ls',
                 '公主岭|gongzhuling|gzl',
                 '伊通|yitong|yt',
                 '通化|tonghua|th',
                 '梅河口|meihekou|mhk',
                 '柳河|liuhe|lh',
                 '辉南|huinan|hn',
                 '集安|jian|ja',
                 '通化县|tonghuaxian|thx',
                 '白城|baicheng|bc',
                 '洮南|taonan|tn',
                 '大安|daan|da',
                 '镇赉|zhenlai|zl',
                 '通榆|tongyu|ty',
                 '辽源|liaoyuan|ly',
                 '东丰|dongfeng|df',
                 '东辽|dongliao|dl',
                 '松原|songyuan|sy',
                 '乾安|qianan|qa',
                 '前郭|qianguo|qg',
                 '长岭|zhangling|zl',
                 '扶余|fuyu|fy',
                 '白山|baishan|bs',
                 '靖宇|jingyu|jy',
                 '临江|linjiang|lj',
                 '东岗|donggang|dg',
                 '长白|zhangbai|zb',
                 '抚松|fusong|fs',
                 '江源|jiangyuan|jy',
                 '长安|zhangan|za',
                 '临潼|lintong|lt',
                 '蓝田|lantian|lt',
                 '周至|zhouzhi|zz',
                 '户县|huxian|hx',
                 '高陵|gaoling|gl',
                 '咸阳|xianyang|xy',
                 '三原|sanyuan|sy',
                 '礼泉|liquan|lq',
                 '永寿|yongshou|ys',
                 '淳化|chunhua|ch',
                 '泾阳|jingyang|jy',
                 '武功|wugong|wg',
                 '乾县|qianxian|qx',
                 '彬县|binxian|bx',
                 '长武|zhangwu|zw',
                 '旬邑|xunyi|xy',
                 '兴平|xingping|xp',
                 '延安|yanan|ya',
                 '延长|yanzhang|yz',
                 '延川|yanchuan|yc',
                 '子长|zizhang|zz',
                 '宜川|yichuan|yc',
                 '富县|fuxian|fx',
                 '志丹|zhidan|zd',
                 '安塞|ansai|as',
                 '甘泉|ganquan|gq',
                 '洛川|luochuan|lc',
                 '黄陵|huangling|hl',
                 '黄龙|huanglong|hl',
                 '吴起|wuqi|wq',
                 '榆林|yulin|yl',
                 '府谷|fugu|fg',
                 '神木|shenmu|sm',
                 '佳县|jiaxian|jx',
                 '定边|dingbian|db',
                 '靖边|jingbian|jb',
                 '横山|hengshan|hs',
                 '米脂|mizhi|mz',
                 '子洲|zizhou|zz',
                 '绥德|suide|sd',
                 '吴堡|wubao|wb',
                 '清涧|qingjian|qj',
                 '榆阳|yuyang|yy',
                 '渭南|weinan|wn',
                 '华县|huaxian|hx',
                 '潼关|tongguan|tg',
                 '大荔|dali|dl',
                 '白水|baishui|bs',
                 '富平|fuping|fp',
                 '蒲城|pucheng|pc',
                 '澄城|chengcheng|cc',
                 '合阳|heyang|hy',
                 '韩城|hancheng|hc',
                 '华阴|huayin|hy',
                 '商洛|shangluo|sl',
                 '洛南|luonan|ln',
                 '柞水|zuoshui|zs',
                 '商州|shangzhou|sz',
                 '镇安|zhenan|za',
                 '丹凤|danfeng|df',
                 '商南|shangnan|sn',
                 '山阳|shanyang|sy',
                 '安康|ankang|ak',
                 '紫阳|ziyang|zy',
                 '石泉|shiquan|sq',
                 '汉阴|hanyin|hy',
                 '旬阳|xunyang|xy',
                 '岚皋|langao|lg',
                 '平利|pingli|pl',
                 '白河|baihe|bh',
                 '镇坪|zhenping|zp',
                 '宁陕|ningshan|ns',
                 '汉中|hanzhong|hz',
                 '略阳|lveyang|ly',
                 '勉县|mianxian|mx',
                 '留坝|liuba|lb',
                 '洋县|yangxian|yx',
                 '城固|chenggu|cg',
                 '西乡|xixiang|xx',
                 '佛坪|foping|fp',
                 '宁强|ningqiang|nq',
                 '南郑|nanzheng|nz',
                 '镇巴|zhenba|zb',
                 '宝鸡|baoji|bj',
                 '千阳|qianyang|qy',
                 '麟游|linyou|ly',
                 '岐山|qishan|qs',
                 '凤翔|fengxiang|fx',
                 '扶风|fufeng|ff',
                 '眉县|meixian|mx',
                 '太白|taibai|tb',
                 '凤县|fengxian|fx',
                 '陇县|longxian|lx',
                 '陈仓|chencang|cc',
                 '铜川|tongchuan|tc',
                 '耀县|yaoxian|yx',
                 '宜君|yijun|yj',
                 '耀州|yaozhou|yz',
                 '杨凌|yangling|yl',
                 '呼和浩特|huhehaote|hhht',
                 '土左旗|tuzuoqi|tzq',
                 '托县|tuoxian|tx',
                 '和林|helin|hl',
                 '清水河|qingshuihe|qsh',
                 '呼市郊区|hushijiaoqu|hsjq',
                 '武川|wuchuan|wc',
                 '包头|baotou|bt',
                 '白云鄂博|baiyunebo|byeb',
                 '满都拉|mandoula|mdl',
                 '土右旗|tuyouqi|tyq',
                 '固阳|guyang|gy',
                 '达茂旗|damaoqi|dmq',
                 '乌海|wuhai|wh',
                 '集宁|jining|jn',
                 '卓资|zhuozi|zz',
                 '化德|huade|hd',
                 '商都|shangdou|sd',
                 '兴和|xinghe|xh',
                 '凉城|liangcheng|lc',
                 '察右前旗|chayouqianqi|cyqq',
                 '察右中旗|chayouzhongqi|cyzq',
                 '察右后旗|chayouhouqi|cyhq',
                 '四子王旗|siziwangqi|szwq',
                 '丰镇|fengzhen|fz',
                 '通辽|tongliao|tl',
                 '舍伯吐|shebotu|sbt',
                 '科左中旗|kezuozhongqi|kzzq',
                 '科左后旗|kezuohouqi|kzhq',
                 '青龙山|qinglongshan|qls',
                 '开鲁|kailu|kl',
                 '库伦|kulun|kl',
                 '奈曼|naiman|nm',
                 '扎鲁特|zhalute|zlt',
                 '巴雅尔吐胡硕|bayaertuhushuo|byeths',
                 '霍林郭勒|huolinguole|hlgl',
                 '赤峰|chifeng|cf',
                 '阿鲁旗|aluqi|alq',
                 '浩尔吐|haoertu|het',
                 '巴林左旗|balinzuoqi|blzq',
                 '巴林右旗|balinyouqi|blyq',
                 '林西|linxi|lx',
                 '克什克腾|keshenketeng|kskt',
                 '翁牛特|wengniute|wnt',
                 '岗子|gangzi|gz',
                 '喀喇沁|kalaqin|klq',
                 '八里罕|balihan|blh',
                 '宁城|ningcheng|nc',
                 '敖汉|aohan|ah',
                 '宝国吐|baoguotu|bgt',
                 '鄂尔多斯|eerduosi|eeds',
                 '达拉特|dalate|dlt',
                 '准格尔|zhungeer|zge',
                 '鄂前旗|eqianqi|eqq',
                 '河南|henan|hn',
                 '伊克乌素|yikewusu|ykws',
                 '鄂托克|etuoke|etk',
                 '杭锦旗|hangjinqi|hjq',
                 '乌审旗|wushenqi|wsq',
                 '伊金霍洛|yijinhuoluo|yjhl',
                 '乌审召|wushenzhao|wsz',
                 '东胜|dongsheng|ds',
                 '临河|linhe|lh',
                 '五原|wuyuan|wy',
                 '磴口|dengkou|dk',
                 '乌前旗|wuqianqi|wqq',
                 '大佘太|dashetai|dst',
                 '乌中旗|wuzhongqi|wzq',
                 '乌后旗|wuhouqi|whq',
                 '海力素|hailisu|hls',
                 '那仁宝力格|neirenbaolige|nrblg',
                 '杭锦后旗|hangjinhouqi|hjhq',
                 '锡林浩特|xilinhaote|xlht',
                 '二连浩特|erlianhaote|elht',
                 '阿巴嘎|abaga|abg',
                 '苏左旗|suzuoqi|szq',
                 '苏右旗|suyouqi|syq',
                 '朱日和|zhurihe|zrh',
                 '东乌旗|dongwuqi|dwq',
                 '西乌旗|xiwuqi|xwq',
                 '太仆寺|taipusi|tps',
                 '镶黄旗|xianghuangqi|xhq',
                 '正镶白旗|zhengxiangbaiqi|zxbq',
                 '正兰旗|zhenglanqi|zlq',
                 '多伦|duolun|dl',
                 '博克图|boketu|bkt',
                 '乌拉盖|wulagai|wlg',
                 '呼伦贝尔|hulunbeier|hlbe',
                 '海拉尔|hailaer|hle',
                 '小二沟|xiaoergou|xeg',
                 '阿荣旗|arongqi|arq',
                 '莫力达瓦|molidawa|mldw',
                 '鄂伦春旗|elunchunqi|elcq',
                 '鄂温克旗|ewenkeqi|ewkq',
                 '陈旗|chenqi|cq',
                 '新左旗|xinzuoqi|xzq',
                 '新右旗|xinyouqi|xyq',
                 '满洲里|manzhouli|mzl',
                 '牙克石|yakeshi|yks',
                 '扎兰屯|zhalantun|zlt',
                 '额尔古纳|eerguna|eegn',
                 '根河|genhe|gh',
                 '图里河|tulihe|tlh',
                 '高力板|gaoliban|glb',
                 '乌兰浩特|wulanhaote|wlht',
                 '阿尔山|aershan|aes',
                 '科右中旗|keyouzhongqi|kyzq',
                 '胡尔勒|huerle|hel',
                 '扎赉特|zhalaite|zlt',
                 '索伦|suolun|sl',
                 '突泉|tuquan|tq',
                 '科右前旗|keyouqianqi|kyqq',
                 '阿左旗|azuoqi|azq',
                 '阿右旗|ayouqi|ayq',
                 '额济纳|ejina|ejn',
                 '拐子湖|guaizihu|gzh',
                 '吉兰太|jilantai|jlt',
                 '锡林高勒|xilingaole|xlgl',
                 '头道湖|toudaohu|tdh',
                 '中泉子|zhongquanzi|zqz',
                 '诺尔公|nuoergong|neg',
                 '雅布赖|yabulai|ybl',
                 '乌斯泰|wusitai|wst',
                 '孪井滩|luanjingtan|ljt',
                 '银川|yinchuan|yc',
                 '永宁|yongning|yn',
                 '灵武|lingwu|lw',
                 '贺兰|helan|hl',
                 '石嘴山|shizuishan|szs',
                 '惠农|huinong|hn',
                 '平罗|pingluo|pl',
                 '陶乐|taole|tl',
                 '吴忠|wuzhong|wz',
                 '同心|tongxin|tx',
                 '盐池|yanchi|yc',
                 '青铜峡|qingtongxia|qtx',
                 '固原|guyuan|gy',
                 '西吉|xiji|xj',
                 '隆德|longde|ld',
                 '泾源|jingyuan|jy',
                 '彭阳|pengyang|py',
                 '中卫|zhongwei|zw',
                 '中宁|zhongning|zn',
                 '海原|haiyuan|hy',
                 '福州|fuzhou|fz',
                 '闽清|minqing|mq',
                 '闽侯|minhou|mh',
                 '罗源|luoyuan|ly',
                 '连江|lianjiang|lj',
                 '永泰|yongtai|yt',
                 '平潭|pingtan|pt',
                 '长乐|zhangle|zl',
                 '福清|fuqing|fq',
                 '厦门|shamen|sm',
                 '同安|tongan|ta',
                 '宁德|ningde|nd',
                 '古田|gutian|gt',
                 '霞浦|xiapu|xp',
                 '寿宁|shouning|sn',
                 '周宁|zhouning|zn',
                 '福安|fuan|fa',
                 '柘荣|zherong|zr',
                 '福鼎|fuding|fd',
                 '屏南|pingnan|pn',
                 '莆田|putian|pt',
                 '仙游|xianyou|xy',
                 '秀屿港|xiuyugang|xyg',
                 '涵江|hanjiang|hj',
                 '秀屿|xiuyu|xy',
                 '荔城|licheng|lc',
                 '城厢|chengxiang|cx',
                 '泉州|quanzhou|qz',
                 '安溪|anxi|ax',
                 '永春|yongchun|yc',
                 '德化|dehua|dh',
                 '南安|nanan|na',
                 '崇武|chongwu|cw',
                 '惠安|huian|ha',
                 '晋江|jinjiang|jj',
                 '石狮|shishi|ss',
                 '漳州|zhangzhou|zz',
                 '长泰|zhangtai|zt',
                 '南靖|nanjing|nj',
                 '平和|pinghe|ph',
                 '龙海|longhai|lh',
                 '漳浦|zhangpu|zp',
                 '诏安|zhaoan|za',
                 '东山|dongshan|ds',
                 '云霄|yunxiao|yx',
                 '华安|huaan|ha',
                 '龙岩|longyan|ly',
                 '长汀|zhangting|zt',
                 '连城|liancheng|lc',
                 '武平|wuping|wp',
                 '上杭|shanghang|sh',
                 '永定|yongding|yd',
                 '漳平|zhangping|zp',
                 '三明|sanming|sm',
                 '宁化|ninghua|nh',
                 '清流|qingliu|ql',
                 '泰宁|taining|tn',
                 '将乐|jiangle|jl',
                 '建宁|jianning|jn',
                 '明溪|mingxi|mx',
                 '沙县|shaxian|sx',
                 '尤溪|youxi|yx',
                 '永安|yongan|ya',
                 '大田|datian|dt',
                 '南平|nanping|np',
                 '顺昌|shunchang|sc',
                 '光泽|guangze|gz',
                 '邵武|shaowu|sw',
                 '武夷山|wuyishan|wys',
                 '浦城|pucheng|pc',
                 '建阳|jianyang|jy',
                 '松溪|songxi|sx',
                 '政和|zhenghe|zh',
                 '建瓯|jianou|jo',
                 '井陉|jingxing|jx',
                 '正定|zhengding|zd',
                 '栾城|luancheng|lc',
                 '行唐|xingtang|xt',
                 '灵寿|lingshou|ls',
                 '高邑|gaoyi|gy',
                 '深泽|shenze|sz',
                 '赞皇|zanhuang|zh',
                 '无极|wuji|wj',
                 '平山|pingshan|ps',
                 '元氏|yuanshi|ys',
                 '赵县|zhaoxian|zx',
                 '辛集|xinji|xj',
                 '藁城|gaocheng|gc',
                 '晋州|jinzhou|jz',
                 '新乐|xinle|xl',
                 '鹿泉|luquan|lq',
                 '保定|baoding|bd',
                 '满城|mancheng|mc',
                 '阜平|fuping|fp',
                 '徐水|xushui|xs',
                 '唐县|tangxian|tx',
                 '高阳|gaoyang|gy',
                 '容城|rongcheng|rc',
                 '涞源|laiyuan|ly',
                 '望都|wangdou|wd',
                 '安新|anxin|ax',
                 '易县|yixian|yx',
                 '曲阳|quyang|qy',
                 '蠡县|lixian|lx',
                 '顺平|shunping|sp',
                 '雄县|xiongxian|xx',
                 '涿州|zhuozhou|zz',
                 '定州|dingzhou|dz',
                 '安国|anguo|ag',
                 '高碑店|gaobeidian|gbd',
                 '涞水|laishui|ls',
                 '定兴|dingxing|dx',
                 '清苑|qingyuan|qy',
                 '博野|boye|by',
                 '张家口|zhangjiakou|zjk',
                 '宣化|xuanhua|xh',
                 '张北|zhangbei|zb',
                 '康保|kangbao|kb',
                 '沽源|guyuan|gy',
                 '尚义|shangyi|sy',
                 '蔚县|yuxian|yx',
                 '阳原|yangyuan|yy',
                 '怀安|huaian|ha',
                 '万全|wanquan|wq',
                 '怀来|huailai|hl',
                 '涿鹿|zhuolu|zl',
                 '赤城|chicheng|cc',
                 '崇礼|chongli|cl',
                 '承德|chengde|cd',
                 '承德县|chengdexian|cdx',
                 '兴隆|xinglong|xl',
                 '平泉|pingquan|pq',
                 '滦平|luanping|lp',
                 '隆化|longhua|lh',
                 '丰宁|fengning|fn',
                 '宽城|kuancheng|kc',
                 '围场|weichang|wc',
                 '唐山|tangshan|ts',
                 '丰南|fengnan|fn',
                 '丰润|fengrun|fr',
                 '滦县|luanxian|lx',
                 '滦南|luannan|ln',
                 '乐亭|leting|lt',
                 '迁西|qianxi|qx',
                 '玉田|yutian|yt',
                 '唐海|tanghai|th',
                 '遵化|zunhua|zh',
                 '迁安|qianan|qa',
                 '曹妃甸|caofeidian|cfd',
                 '廊坊|langfang|lf',
                 '固安|guan|ga',
                 '永清|yongqing|yq',
                 '香河|xianghe|xh',
                 '大城|dacheng|dc',
                 '文安|wenan|wa',
                 '大厂|dachang|dc',
                 '霸州|bazhou|bz',
                 '三河|sanhe|sh',
                 '沧州|cangzhou|cz',
                 '青县|qingxian|qx',
                 '东光|dongguang|dg',
                 '海兴|haixing|hx',
                 '盐山|yanshan|ys',
                 '肃宁|suning|sn',
                 '南皮|nanpi|np',
                 '吴桥|wuqiao|wq',
                 '献县|xianxian|xx',
                 '孟村|mengcun|mc',
                 '泊头|botou|bt',
                 '任丘|renqiu|rq',
                 '黄骅|huanghua|hh',
                 '河间|hejian|hj',
                 '沧县|cangxian|cx',
                 '衡水|hengshui|hs',
                 '枣强|zaoqiang|zq',
                 '武邑|wuyi|wy',
                 '武强|wuqiang|wq',
                 '饶阳|raoyang|ry',
                 '安平|anping|ap',
                 '故城|gucheng|gc',
                 '景县|jingxian|jx',
                 '阜城|fucheng|fc',
                 '冀州|jizhou|jz',
                 '深州|shenzhou|sz',
                 '邢台|xingtai|xt',
                 '临城|lincheng|lc',
                 '内丘|neiqiu|nq',
                 '柏乡|boxiang|bx',
                 '隆尧|longyao|ly',
                 '南和|nanhe|nh',
                 '宁晋|ningjin|nj',
                 '巨鹿|julu|jl',
                 '新河|xinhe|xh',
                 '广宗|guangzong|gz',
                 '平乡|pingxiang|px',
                 '威县|weixian|wx',
                 '清河|qinghe|qh',
                 '临西|linxi|lx',
                 '南宫|nangong|ng',
                 '沙河|shahe|sh',
                 '任县|renxian|rx',
                 '邯郸|handan|hd',
                 '峰峰|fengfeng|ff',
                 '临漳|linzhang|lz',
                 '成安|chengan|ca',
                 '大名|daming|dm',
                 '涉县|shexian|sx',
                 '磁县|cixian|cx',
                 '肥乡|feixiang|fx',
                 '永年|yongnian|yn',
                 '邱县|qiuxian|qx',
                 '鸡泽|jize|jz',
                 '广平|guangping|gp',
                 '馆陶|guantao|gt',
                 '魏县|weixian|wx',
                 '曲周|quzhou|qz',
                 '武安|wuan|wa',
                 '秦皇岛|qinhuangdao|qhd',
                 '青龙|qinglong|ql',
                 '昌黎|changli|cl',
                 '抚宁|funing|fn',
                 '卢龙|lulong|ll',
                 '北戴河|beidaihe|bdh',
                 '南昌|nanchang|nc',
                 '新建|xinjian|xj',
                 '南昌县|nanchangxian|ncx',
                 '安义|anyi|ay',
                 '进贤|jinxian|jx',
                 '九江|jiujiang|jj',
                 '瑞昌|ruichang|rc',
                 '庐山|lushan|ls',
                 '武宁|wuning|wn',
                 '德安|dean|da',
                 '永修|yongxiu|yx',
                 '湖口|hukou|hk',
                 '彭泽|pengze|pz',
                 '星子|xingzi|xz',
                 '都昌|douchang|dc',
                 '修水|xiushui|xs',
                 '上饶|shangrao|sr',
                 '鄱阳|poyang|py',
                 '婺源|wuyuan|wy',
                 '余干|yugan|yg',
                 '万年|wannian|wn',
                 '德兴|dexing|dx',
                 '上饶县|shangraoxian|srx',
                 '弋阳|yiyang|yy',
                 '横峰|hengfeng|hf',
                 '铅山|qianshan|qs',
                 '玉山|yushan|ys',
                 '广丰|guangfeng|gf',
                 '抚州|fuzhou|fz',
                 '广昌|guangchang|gc',
                 '乐安|lean|la',
                 '崇仁|chongren|cr',
                 '金溪|jinxi|jx',
                 '资溪|zixi|zx',
                 '宜黄|yihuang|yh',
                 '南城|nancheng|nc',
                 '南丰|nanfeng|nf',
                 '黎川|lichuan|lc',
                 '东乡|dongxiang|dx',
                 '宜春|yichun|yc',
                 '铜鼓|tonggu|tg',
                 '宜丰|yifeng|yf',
                 '万载|wanzai|wz',
                 '上高|shanggao|sg',
                 '靖安|jingan|ja',
                 '奉新|fengxin|fx',
                 '高安|gaoan|ga',
                 '樟树|zhangshu|zs',
                 '丰城|fengcheng|fc',
                 '吉安|jian|ja',
                 '吉安县|jianxian|jax',
                 '吉水|jishui|js',
                 '新干|xingan|xg',
                 '峡江|xiajiang|xj',
                 '永丰|yongfeng|yf',
                 '永新|yongxin|yx',
                 '井冈山|jinggangshan|jgs',
                 '万安|wanan|wa',
                 '遂川|suichuan|sc',
                 '泰和|taihe|th',
                 '安福|anfu|af',
                 '宁冈|ninggang|ng',
                 '赣州|ganzhou|gz',
                 '崇义|chongyi|cy',
                 '上犹|shangyou|sy',
                 '南康|nankang|nk',
                 '大余|dayu|dy',
                 '信丰|xinfeng|xf',
                 '宁都|ningdou|nd',
                 '石城|shicheng|sc',
                 '瑞金|ruijin|rj',
                 '于都|yudou|yd',
                 '会昌|huichang|hc',
                 '安远|anyuan|ay',
                 '全南|quannan|qn',
                 '龙南|longnan|ln',
                 '定南|dingnan|dn',
                 '寻乌|xunwu|xw',
                 '兴国|xingguo|xg',
                 '赣县|ganxian|gx',
                 '景德镇|jingdezhen|jdz',
                 '乐平|leping|lp',
                 '浮梁|fuliang|fl',
                 '萍乡|pingxiang|px',
                 '莲花|lianhua|lh',
                 '上栗|shangli|sl',
                 '安源|anyuan|ay',
                 '芦溪|luxi|lx',
                 '湘东|xiangdong|xd',
                 '新余|xinyu|xy',
                 '分宜|fenyi|fy',
                 '鹰潭|yingtan|yt',
                 '余江|yujiang|yj',
                 '贵溪|guixi|gx',
                 '永川|yongchuan|yc',
                 '合川|hechuan|hc',
                 '南川|nanchuan|nc',
                 '江津|jiangjin|jj',
                 '万盛|wansheng|ws',
                 '渝北|yubei|yb',
                 '北碚|beibei|bb',
                 '巴南|banan|bn',
                 '长寿|zhangshou|zs',
                 '黔江|qianjiang|qj',
                 '万州|wanzhou|wz',
                 '涪陵|fuling|fl',
                 '开县|kaixian|kx',
                 '城口|chengkou|ck',
                 '云阳|yunyang|yy',
                 '巫溪|wuxi|wx',
                 '奉节|fengjie|fj',
                 '巫山|wushan|ws',
                 '潼南|tongnan|tn',
                 '垫江|dianjiang|dj',
                 '梁平|liangping|lp',
                 '忠县|zhongxian|zx',
                 '石柱|shizhu|sz',
                 '大足|dazu|dz',
                 '荣昌|rongchang|rc',
                 '铜梁|tongliang|tl',
                 '璧山|bishan|bs',
                 '丰都|fengdou|fd',
                 '武隆|wulong|wl',
                 '彭水|pengshui|ps',
                 '綦江|qijiang|qj',
                 '酉阳|youyang|yy',
                 '秀山|xiushan|xs',
                 '哈尔滨|haerbin|heb',
                 '双城|shuangcheng|sc',
                 '呼兰|hulan|hl',
                 '阿城|acheng|ac',
                 '宾县|binxian|bx',
                 '依兰|yilan|yl',
                 '巴彦|bayan|by',
                 '通河|tonghe|th',
                 '方正|fangzheng|fz',
                 '延寿|yanshou|ys',
                 '尚志|shangzhi|sz',
                 '五常|wuchang|wc',
                 '木兰|mulan|ml',
                 '齐齐哈尔|qiqihaer|qqhe',
                 '讷河|nehe|nh',
                 '龙江|longjiang|lj',
                 '甘南|gannan|gn',
                 '富裕|fuyu|fy',
                 '依安|yian|ya',
                 '拜泉|baiquan|bq',
                 '克山|keshan|ks',
                 '克东|kedong|kd',
                 '泰来|tailai|tl',
                 '牡丹江|mudanjiang|mdj',
                 '海林|hailin|hl',
                 '穆棱|muleng|ml',
                 '林口|linkou|lk',
                 '绥芬河|suifenhe|sfh',
                 '宁安|ningan|na',
                 '东宁|dongning|dn',
                 '佳木斯|jiamusi|jms',
                 '汤原|tangyuan|ty',
                 '抚远|fuyuan|fy',
                 '桦川|huachuan|hc',
                 '桦南|huanan|hn',
                 '同江|tongjiang|tj',
                 '富锦|fujin|fj',
                 '绥化|suihua|sh',
                 '肇东|zhaodong|zd',
                 '安达|anda|ad',
                 '海伦|hailun|hl',
                 '明水|mingshui|ms',
                 '望奎|wangkui|wk',
                 '兰西|lanxi|lx',
                 '青冈|qinggang|qg',
                 '庆安|qingan|qa',
                 '绥棱|suileng|sl',
                 '黑河|heihe|hh',
                 '嫩江|nenjiang|nj',
                 '孙吴|sunwu|sw',
                 '逊克|xunke|xk',
                 '五大连池|wudalianchi|wdlc',
                 '北安|beian|ba',
                 '大兴安岭|daxinganling|dxal',
                 '塔河|tahe|th',
                 '漠河|mohe|mh',
                 '呼玛|huma|hm',
                 '呼中|huzhong|hz',
                 '新林|xinlin|xl',
                 '加格达奇|jiagedaqi|jgdq',
                 '伊春|yichun|yc',
                 '乌伊岭|wuyiling|wyl',
                 '五营|wuying|wy',
                 '铁力|tieli|tl',
                 '嘉荫|jiayin|jy',
                 '大庆|daqing|dq',
                 '林甸|lindian|ld',
                 '肇州|zhaozhou|zz',
                 '肇源|zhaoyuan|zy',
                 '杜尔伯特|duerbote|debt',
                 '七台河|qitaihe|qth',
                 '勃利|boli|bl',
                 '鸡西|jixi|jx',
                 '虎林|hulin|hl',
                 '密山|mishan|ms',
                 '鸡东|jidong|jd',
                 '鹤岗|hegang|hg',
                 '绥滨|suibin|sb',
                 '萝北|luobei|lb',
                 '双鸭山|shuangyashan|sys',
                 '集贤|jixian|jx',
                 '宝清|baoqing|bq',
                 '饶河|raohe|rh',
                 '友谊|youyi|yy',
                 '兰州|lanzhou|lz',
                 '皋兰|gaolan|gl',
                 '永登|yongdeng|yd',
                 '榆中|yuzhong|yz',
                 '定西|dingxi|dx',
                 '通渭|tongwei|tw',
                 '陇西|longxi|lx',
                 '渭源|weiyuan|wy',
                 '临洮|lintao|lt',
                 '漳县|zhangxian|zx',
                 '岷县|minxian|mx',
                 '安定|anding|ad',
                 '平凉|pingliang|pl',
                 '泾川|jingchuan|jc',
                 '灵台|lingtai|lt',
                 '崇信|chongxin|cx',
                 '华亭|huating|ht',
                 '庄浪|zhuanglang|zl',
                 '静宁|jingning|jn',
                 '崆峒|kongtong|kt',
                 '庆阳|qingyang|qy',
                 '西峰|xifeng|xf',
                 '环县|huanxian|hx',
                 '华池|huachi|hc',
                 '合水|heshui|hs',
                 '正宁|zhengning|zn',
                 '宁县|ningxian|nx',
                 '镇原|zhenyuan|zy',
                 '庆城|qingcheng|qc',
                 '武威|wuwei|ww',
                 '民勤|minqin|mq',
                 '古浪|gulang|gl',
                 '天祝|tianzhu|tz',
                 '金昌|jinchang|jc',
                 '永昌|yongchang|yc',
                 '张掖|zhangye|zy',
                 '肃南|sunan|sn',
                 '民乐|minle|ml',
                 '临泽|linze|lz',
                 '高台|gaotai|gt',
                 '山丹|shandan|sd',
                 '酒泉|jiuquan|jq',
                 '金塔|jinta|jt',
                 '阿克塞|akesai|aks',
                 '瓜州|guazhou|gz',
                 '肃北|subei|sb',
                 '玉门|yumen|ym',
                 '敦煌|dunhuang|dh',
                 '天水|tianshui|ts',
                 '清水|qingshui|qs',
                 '秦安|qinan|qa',
                 '甘谷|gangu|gg',
                 '武山|wushan|ws',
                 '张家川|zhangjiachuan|zjc',
                 '麦积|maiji|mj',
                 '武都|wudou|wd',
                 '成县|chengxian|cx',
                 '文县|wenxian|wx',
                 '宕昌|dangchang|dc',
                 '康县|kangxian|kx',
                 '西和|xihe|xh',
                 '礼县|lixian|lx',
                 '徽县|huixian|hx',
                 '两当|liangdang|ld',
                 '临夏|linxia|lx',
                 '康乐|kangle|kl',
                 '永靖|yongjing|yj',
                 '广河|guanghe|gh',
                 '和政|hezheng|hz',
                 '东乡|dongxiang|dx',
                 '积石山|jishishan|jss',
                 '合作|hezuo|hz',
                 '临潭|lintan|lt',
                 '卓尼|zhuoni|zn',
                 '舟曲|zhouqu|zq',
                 '迭部|diebu|db',
                 '玛曲|maqu|mq',
                 '碌曲|liuqu|lq',
                 '夏河|xiahe|xh',
                 '白银|baiyin|by',
                 '靖远|jingyuan|jy',
                 '会宁|huining|hn',
                 '平川|pingchuan|pc',
                 '景泰|jingtai|jt',
                 '嘉峪关|jiayuguan|jyg',
                 '海淀|haidian|hd',
                 '朝阳|chaoyang|cy',
                 '顺义|shunyi|sy',
                 '怀柔|huairou|hr',
                 '通州|tongzhou|tz',
                 '昌平|changping|cp',
                 '延庆|yanqing|yq',
                 '丰台|fengtai|ft',
                 '石景山|shijingshan|sjs',
                 '大兴|daxing|dx',
                 '房山|fangshan|fs',
                 '密云|miyun|my',
                 '门头沟|mentougou|mtg',
                 '平谷|pinggu|pg',
                 '九龙|jiulong|jl',
                 '新界|xinjie|xj',
                 '天津|tianjin|tj',
                 '武清|wuqing|wq',
                 '宝坻|baochi|bc',
                 '东丽|dongli|dl',
                 '西青|xiqing|xq',
                 '北辰|beichen|bc',
                 '宁河|ninghe|nh',
                 '汉沽|hangu|hg',
                 '静海|jinghai|jh',
                 '津南|jinnan|jn',
                 '塘沽|tanggu|tg',
                 '大港|dagang|dg',
                 '蓟县|jixian|jx',
                 '济南|jinan|jn',
                 '长清|zhangqing|zq',
                 '商河|shanghe|sh',
                 '章丘|zhangqiu|zq',
                 '平阴|pingyin|py',
                 '济阳|jiyang|jy',
                 '青岛|qingdao|qd',
                 '崂山|laoshan|ls',
                 '即墨|jimo|jm',
                 '胶州|jiaozhou|jz',
                 '胶南|jiaonan|jn',
                 '莱西|laixi|lx',
                 '平度|pingdu|pd',
                 '淄博|zibo|zb',
                 '淄川|zichuan|zc',
                 '博山|boshan|bs',
                 '高青|gaoqing|gq',
                 '周村|zhoucun|zc',
                 '沂源|yiyuan|yy',
                 '桓台|huantai|ht',
                 '临淄|linzi|lz',
                 '德州|dezhou|dz',
                 '武城|wucheng|wc',
                 '临邑|linyi|ly',
                 '陵县|lingxian|lx',
                 '齐河|qihe|qh',
                 '乐陵|leling|ll',
                 '庆云|qingyun|qy',
                 '平原|pingyuan|py',
                 '宁津|ningjin|nj',
                 '夏津|xiajin|xj',
                 '禹城|yucheng|yc',
                 '烟台|yantai|yt',
                 '莱州|laizhou|lz',
                 '长岛|zhangdao|zd',
                 '蓬莱|penglai|pl',
                 '龙口|longkou|lk',
                 '招远|zhaoyuan|zy',
                 '栖霞|qixia|qx',
                 '福山|fushan|fs',
                 '牟平|mouping|mp',
                 '莱阳|laiyang|ly',
                 '海阳|haiyang|hy',
                 '潍坊|weifang|wf',
                 '青州|qingzhou|qz',
                 '寿光|shouguang|sg',
                 '临朐|linqu|lq',
                 '昌乐|changle|cl',
                 '昌邑|changyi|cy',
                 '安丘|anqiu|aq',
                 '高密|gaomi|gm',
                 '诸城|zhucheng|zc',
                 '济宁|jining|jn',
                 '嘉祥|jiaxiang|jx',
                 '微山|weishan|ws',
                 '鱼台|yutai|yt',
                 '兖州|yanzhou|yz',
                 '金乡|jinxiang|jx',
                 '汶上|wenshang|ws',
                 '泗水|sishui|ss',
                 '梁山|liangshan|ls',
                 '曲阜|qufu|qf',
                 '邹城|zoucheng|zc',
                 '泰安|taian|ta',
                 '新泰|xintai|xt',
                 '肥城|feicheng|fc',
                 '东平|dongping|dp',
                 '宁阳|ningyang|ny',
                 '临沂|linyi|ly',
                 '莒南|junan|jn',
                 '沂南|yinan|yn',
                 '苍山|cangshan|cs',
                 '临沭|linshu|ls',
                 '郯城|tancheng|tc',
                 '蒙阴|mengyin|my',
                 '平邑|pingyi|py',
                 '费县|feixian|fx',
                 '沂水|yishui|ys',
                 '菏泽|heze|hz',
                 '鄄城|juancheng|jc',
                 '郓城|yuncheng|yc',
                 '东明|dongming|dm',
                 '定陶|dingtao|dt',
                 '巨野|juye|jy',
                 '曹县|caoxian|cx',
                 '成武|chengwu|cw',
                 '单县|danxian|dx',
                 '滨州|binzhou|bz',
                 '博兴|boxing|bx',
                 '无棣|wudi|wd',
                 '阳信|yangxin|yx',
                 '惠民|huimin|hm',
                 '沾化|zhanhua|zh',
                 '邹平|zouping|zp',
                 '东营|dongying|dy',
                 '河口|hekou|hk',
                 '垦利|kenli|kl',
                 '利津|lijin|lj',
                 '广饶|guangrao|gr',
                 '威海|weihai|wh',
                 '文登|wendeng|wd',
                 '荣成|rongcheng|rc',
                 '乳山|rushan|rs',
                 '成山头|chengshantou|cst',
                 '石岛|shidao|sd',
                 '枣庄|zaozhuang|zz',
                 '薛城|xuecheng|xc',
                 '峄城|yicheng|yc',
                 '台儿庄|taierzhuang|tez',
                 '滕州|tengzhou|tz',
                 '日照|rizhao|rz',
                 '五莲|wulian|wl',
                 '莒县|juxian|jx',
                 '莱芜|laiwu|lw',
                 '聊城|liaocheng|lc',
                 '冠县|guanxian|gx',
                 '阳谷|yanggu|yg',
                 '高唐|gaotang|gt',
                 '茌平|chiping|cp',
                 '东阿|donga|da',
                 '临清|linqing|lq',
                 '莘县|xinxian|xx',
                 '长沙|zhangsha|zs',
                 '宁乡|ningxiang|nx',
                 '浏阳|liuyang|ly',
                 '马坡岭|mapoling|mpl',
                 '望城|wangcheng|wc',
                 '湘潭|xiangtan|xt',
                 '韶山|shaoshan|ss',
                 '湘乡|xiangxiang|xx',
                 '株洲|zhuzhou|zz',
                 '攸县|youxian|yx',
                 '醴陵|liling|ll',
                 '茶陵|chaling|cl',
                 '炎陵|yanling|yl',
                 '衡阳|hengyang|hy',
                 '衡山|hengshan|hs',
                 '衡东|hengdong|hd',
                 '祁东|qidong|qd',
                 '衡阳县|hengyangxian|hyx',
                 '常宁|changning|cn',
                 '衡南|hengnan|hn',
                 '耒阳|leiyang|ly',
                 '南岳|nanyue|ny',
                 '郴州|chenzhou|cz',
                 '桂阳|guiyang|gy',
                 '嘉禾|jiahe|jh',
                 '宜章|yizhang|yz',
                 '临武|linwu|lw',
                 '资兴|zixing|zx',
                 '汝城|rucheng|rc',
                 '安仁|anren|ar',
                 '永兴|yongxing|yx',
                 '桂东|guidong|gd',
                 '苏仙|suxian|sx',
                 '常德|changde|cd',
                 '安乡|anxiang|ax',
                 '桃源|taoyuan|ty',
                 '汉寿|hanshou|hs',
                 '澧县|lixian|lx',
                 '临澧|linli|ll',
                 '石门|shimen|sm',
                 '津市|jinshi|js',
                 '益阳|yiyang|yy',
                 '赫山区|heshanqu|hsq',
                 '南县|nanxian|nx',
                 '桃江|taojiang|tj',
                 '安化|anhua|ah',
                 '沅江|yuanjiang|yj',
                 '娄底|loudi|ld',
                 '双峰|shuangfeng|sf',
                 '冷水江|lengshuijiang|lsj',
                 '新化|xinhua|xh',
                 '涟源|lianyuan|ly',
                 '邵阳|shaoyang|sy',
                 '隆回|longhui|lh',
                 '洞口|dongkou|dk',
                 '新邵|xinshao|xs',
                 '邵东|shaodong|sd',
                 '绥宁|suining|sn',
                 '新宁|xinning|xn',
                 '武冈|wugang|wg',
                 '城步|chengbu|cb',
                 '邵阳县|shaoyangxian|syx',
                 '岳阳|yueyang|yy',
                 '华容|huarong|hr',
                 '湘阴|xiangyin|xy',
                 '汨罗|miluo|ml',
                 '平江|pingjiang|pj',
                 '临湘|linxiang|lx',
                 '张家界|zhangjiajie|zjj',
                 '桑植|sangzhi|sz',
                 '慈利|cili|cl',
                 '武陵源|wulingyuan|wly',
                 '怀化|huaihua|hh',
                 '沅陵|yuanling|yl',
                 '辰溪|chenxi|cx',
                 '靖州|jingzhou|jz',
                 '会同|huitong|ht',
                 '通道|tongdao|td',
                 '麻阳|mayang|my',
                 '新晃|xinhuang|xh',
                 '芷江|zhijiang|zj',
                 '溆浦|xupu|xp',
                 '中方|zhongfang|zf',
                 '洪江|hongjiang|hj',
                 '永州|yongzhou|yz',
                 '祁阳|qiyang|qy',
                 '东安|dongan|da',
                 '双牌|shuangpai|sp',
                 '道县|daoxian|dx',
                 '宁远|ningyuan|ny',
                 '江永|jiangyong|jy',
                 '蓝山|lanshan|ls',
                 '新田|xintian|xt',
                 '江华|jianghua|jh',
                 '冷水滩|lengshuitan|lst',
                 '吉首|jishou|js',
                 '保靖|baojing|bj',
                 '永顺|yongshun|ys',
                 '古丈|guzhang|gz',
                 '凤凰|fenghuang|fh',
                 '泸溪|luxi|lx',
                 '龙山|longshan|ls',
                 '花垣|huayuan|hy',
                 '贵阳|guiyang|gy',
                 '白云|baiyun|by',
                 '花溪|huaxi|hx',
                 '乌当|wudang|wd',
                 '息烽|xifeng|xf',
                 '开阳|kaiyang|ky',
                 '修文|xiuwen|xw',
                 '清镇|qingzhen|qz',
                 '小河|xiaohe|xh',
                 '云岩|yunyan|yy',
                 '南明|nanming|nm',
                 '遵义|zunyi|zy',
                 '遵义县|zunyixian|zyx',
                 '仁怀|renhuai|rh',
                 '绥阳|suiyang|sy',
                 '湄潭|meitan|mt',
                 '凤冈|fenggang|fg',
                 '桐梓|tongzi|tz',
                 '赤水|chishui|cs',
                 '习水|xishui|xs',
                 '道真|daozhen|dz',
                 '正安|zhengan|za',
                 '务川|wuchuan|wc',
                 '余庆|yuqing|yq',
                 '汇川|huichuan|hc',
                 '红花岗|honghuagang|hhg',
                 '安顺|anshun|as',
                 '普定|puding|pd',
                 '镇宁|zhenning|zn',
                 '平坝|pingba|pb',
                 '紫云|ziyun|zy',
                 '关岭|guanling|gl',
                 '都匀|douyun|dy',
                 '贵定|guiding|gd',
                 '瓮安|wengan|wa',
                 '长顺|zhangshun|zs',
                 '福泉|fuquan|fq',
                 '惠水|huishui|hs',
                 '龙里|longli|ll',
                 '罗甸|luodian|ld',
                 '平塘|pingtang|pt',
                 '独山|dushan|ds',
                 '三都|sandou|sd',
                 '荔波|libo|lb',
                 '凯里|kaili|kl',
                 '岑巩|cengong|cg',
                 '施秉|shibing|sb',
                 '镇远|zhenyuan|zy',
                 '黄平|huangping|hp',
                 '麻江|majiang|mj',
                 '丹寨|danzhai|dz',
                 '三穗|sansui|ss',
                 '台江|taijiang|tj',
                 '剑河|jianhe|jh',
                 '雷山|leishan|ls',
                 '黎平|liping|lp',
                 '天柱|tianzhu|tz',
                 '锦屏|jinping|jp',
                 '榕江|rongjiang|rj',
                 '从江|congjiang|cj',
                 '铜仁|tongren|tr',
                 '江口|jiangkou|jk',
                 '玉屏|yuping|yp',
                 '万山|wanshan|ws',
                 '思南|sinan|sn',
                 '印江|yinjiang|yj',
                 '石阡|shiqian|sq',
                 '沿河|yanhe|yh',
                 '德江|dejiang|dj',
                 '松桃|songtao|st',
                 '毕节|bijie|bj',
                 '赫章|hezhang|hz',
                 '金沙|jinsha|js',
                 '威宁|weining|wn',
                 '大方|dafang|df',
                 '纳雍|nayong|ny',
                 '织金|zhijin|zj',
                 '黔西|qianxi|qx',
                 '水城|shuicheng|sc',
                 '六枝|liuzhi|lz',
                 '盘县|panxian|px',
                 '兴义|xingyi|xy',
                 '晴隆|qinglong|ql',
                 '兴仁|xingren|xr',
                 '贞丰|zhenfeng|zf',
                 '望谟|wangmo|wm',
                 '安龙|anlong|al',
                 '册亨|ceheng|ch',
                 '普安|puan|pa',
                 '闵行|minxing|mx',
                 '宝山|baoshan|bs',
                 '嘉定|jiading|jd',
                 '南汇|nanhui|nh',
                 '金山|jinshan|js',
                 '青浦|qingpu|qp',
                 '松江|songjiang|sj',
                 '奉贤|fengxian|fx',
                 '崇明|chongming|cm',
                 '徐家汇|xujiahui|xjh',
                 '浦东|pudong|pd',
                 '番禺|fanyu|fy',
                 '从化|conghua|ch',
                 '增城|zengcheng|zc',
                 '花都|huadou|hd',
                 '韶关|shaoguan|sg',
                 '乳源|ruyuan|ry',
                 '始兴|shixing|sx',
                 '翁源|wengyuan|wy',
                 '乐昌|lechang|lc',
                 '仁化|renhua|rh',
                 '南雄|nanxiong|nx',
                 '新丰|xinfeng|xf',
                 '曲江|qujiang|qj',
                 '浈江|zhenjiang|zj',
                 '武江|wujiang|wj',
                 '惠州|huizhou|hz',
                 '博罗|boluo|bl',
                 '惠阳|huiyang|hy',
                 '惠东|huidong|hd',
                 '龙门|longmen|lm',
                 '梅州|meizhou|mz',
                 '兴宁|xingning|xn',
                 '蕉岭|jiaoling|jl',
                 '大埔|dapu|dp',
                 '丰顺|fengshun|fs',
                 '平远|pingyuan|py',
                 '五华|wuhua|wh',
                 '梅县|meixian|mx',
                 '汕头|shantou|st',
                 '潮阳|chaoyang|cy',
                 '澄海|chenghai|ch',
                 '南澳|nanao|na',
                 '深圳|shenzhen|sz',
                 '珠海|zhuhai|zh',
                 '斗门|doumen|dm',
                 '金湾|jinwan|jw',
                 '佛山|foshan|fs',
                 '顺德|shunde|sd',
                 '三水|sanshui|ss',
                 '南海|nanhai|nh',
                 '高明|gaoming|gm',
                 '肇庆|zhaoqing|zq',
                 '广宁|guangning|gn',
                 '四会|sihui|sh',
                 '德庆|deqing|dq',
                 '怀集|huaiji|hj',
                 '封开|fengkai|fk',
                 '高要|gaoyao|gy',
                 '湛江|zhanjiang|zj',
                 '吴川|wuchuan|wc',
                 '雷州|leizhou|lz',
                 '徐闻|xuwen|xw',
                 '廉江|lianjiang|lj',
                 '赤坎|chikan|ck',
                 '遂溪|suixi|sx',
                 '坡头|potou|pt',
                 '霞山|xiashan|xs',
                 '麻章|mazhang|mz',
                 '江门|jiangmen|jm',
                 '开平|kaiping|kp',
                 '新会|xinhui|xh',
                 '恩平|enping|ep',
                 '台山|taishan|ts',
                 '蓬江|pengjiang|pj',
                 '鹤山|heshan|hs',
                 '江海|jianghai|jh',
                 '河源|heyuan|hy',
                 '紫金|zijin|zj',
                 '连平|lianping|lp',
                 '和平|heping|hp',
                 '龙川|longchuan|lc',
                 '东源|dongyuan|dy',
                 '清远|qingyuan|qy',
                 '连南|liannan|ln',
                 '连州|lianzhou|lz',
                 '连山|lianshan|ls',
                 '阳山|yangshan|ys',
                 '佛冈|fogang|fg',
                 '英德|yingde|yd',
                 '清新|qingxin|qx',
                 '云浮|yunfu|yf',
                 '罗定|luoding|ld',
                 '新兴|xinxing|xx',
                 '郁南|yunan|yn',
                 '云安|yunan|ya',
                 '潮州|chaozhou|cz',
                 '饶平|raoping|rp',
                 '潮安|chaoan|ca',
                 '东莞|dongguan|dg',
                 '中山|zhongshan|zs',
                 '阳江|yangjiang|yj',
                 '阳春|yangchun|yc',
                 '阳东|yangdong|yd',
                 '阳西|yangxi|yx',
                 '揭阳|jieyang|jy',
                 '揭西|jiexi|jx',
                 '普宁|puning|pn',
                 '惠来|huilai|hl',
                 '揭东|jiedong|jd',
                 '茂名|maoming|mm',
                 '高州|gaozhou|gz',
                 '化州|huazhou|hz',
                 '电白|dianbai|db',
                 '信宜|xinyi|xy',
                 '茂港|maogang|mg',
                 '汕尾|shanwei|sw',
                 '海丰|haifeng|hf',
                 '陆丰|lufeng|lf',
                 '陆河|luhe|lh',
                 '当雄|dangxiong|dx',
                 '尼木|nimu|nm',
                 '林周|linzhou|lz',
                 '堆龙德庆|duilongdeqing|dldq',
                 '曲水|qushui|qs',
                 '达孜|dazi|dz',
                 '墨竹工卡|mozhugongka|mzgk',
                 '日喀则|rikaze|rkz',
                 '拉孜|lazi|lz',
                 '南木林|nanmulin|nml',
                 '聂拉木|nielamu|nlm',
                 '定日|dingri|dr',
                 '江孜|jiangzi|jz',
                 '帕里|pali|pl',
                 '仲巴|zhongba|zb',
                 '萨嘎|saga|sg',
                 '吉隆|jilong|jl',
                 '昂仁|angren|ar',
                 '定结|dingjie|dj',
                 '萨迦|sajia|sj',
                 '谢通门|xietongmen|xtm',
                 '岗巴|gangba|gb',
                 '白朗|bailang|bl',
                 '亚东|yadong|yd',
                 '康马|kangma|km',
                 '仁布|renbu|rb',
                 '山南|shannan|sn',
                 '贡嘎|gongga|gg',
                 '札囊|zhanang|zn',
                 '加查|jiacha|jc',
                 '浪卡子|langkazi|lkz',
                 '错那|cuonei|cn',
                 '隆子|longzi|lz',
                 '泽当|zedang|zd',
                 '乃东|naidong|nd',
                 '桑日|sangri|sr',
                 '洛扎|luozha|lz',
                 '措美|cuomei|cm',
                 '琼结|qiongjie|qj',
                 '曲松|qusong|qs',
                 '林芝|linzhi|lz',
                 '波密|bomi|bm',
                 '米林|milin|ml',
                 '察隅|chayu|cy',
                 '工布江达|gongbujiangda|gbjd',
                 '朗县|langxian|lx',
                 '墨脱|motuo|mt',
                 '昌都|changdou|cd',
                 '丁青|dingqing|dq',
                 '边坝|bianba|bb',
                 '洛隆|luolong|ll',
                 '左贡|zuogong|zg',
                 '芒康|mangkang|mk',
                 '类乌齐|leiwuqi|lwq',
                 '八宿|basu|bs',
                 '江达|jiangda|jd',
                 '察雅|chaya|cy',
                 '贡觉|gongjue|gj',
                 '那曲|neiqu|nq',
                 '尼玛|nima|nm',
                 '嘉黎|jiali|jl',
                 '班戈|bange|bg',
                 '安多|anduo|ad',
                 '索县|suoxian|sx',
                 '聂荣|nierong|nr',
                 '巴青|baqing|bq',
                 '比如|biru|br',
                 '阿里|ali|al',
                 '改则|gaize|gz',
                 '申扎|shenzha|sz',
                 '狮泉河|shiquanhe|sqh',
                 '普兰|pulan|pl',
                 '札达|zhada|zd',
                 '噶尔|gaer|ge',
                 '日土|ritu|rt',
                 '革吉|geji|gj',
                 '措勤|cuoqin|cq',
                 '三亚|sanya|sy',
                 '东方|dongfang|df',
                 '临高|lingao|lg',
                 '澄迈|chengmai|cm',
                 '儋州|danzhou|dz',
                 '昌江|changjiang|cj',
                 '白沙|baisha|bs',
                 '琼中|qiongzhong|qz',
                 '定安|dingan|da',
                 '屯昌|tunchang|tc',
                 '琼海|qionghai|qh',
                 '文昌|wenchang|wc',
                 '保亭|baoting|bt',
                 '万宁|wanning|wn',
                 '陵水|lingshui|ls',
                 '西沙|xisha|xs',
                 '南沙岛|nanshadao|nsd',
                 '乐东|ledong|ld',
                 '五指山|wuzhishan|wzs',
                 '乌鲁木齐|wulumuqi|wlmq',
                 '小渠子|xiaoquzi|xqz',
                 '达坂城|dabancheng|dbc',
                 '乌鲁木齐牧试站|wulumuqimushizhan|wlmqmsz',
                 '天池|tianchi|tc',
                 '白杨沟|baiyanggou|byg',
                 '克拉玛依|kelamayi|klmy',
                 '乌尔禾|wuerhe|weh',
                 '白碱滩|baijiantan|bjt',
                 '石河子|shihezi|shz',
                 '炮台|paotai|pt',
                 '莫索湾|mosuowan|msw',
                 '昌吉|changji|cj',
                 '呼图壁|hutubi|htb',
                 '米泉|miquan|mq',
                 '阜康|fukang|fk',
                 '吉木萨尔|jimusaer|jmse',
                 '奇台|qitai|qt',
                 '玛纳斯|manasi|mns',
                 '木垒|mulei|ml',
                 '蔡家湖|caijiahu|cjh',
                 '吐鲁番|tulufan|tlf',
                 '托克逊|tuokexun|tkx',
                 '鄯善|shanshan|ss',
                 '库尔勒|kuerle|kel',
                 '轮台|luntai|lt',
                 '尉犁|weili|wl',
                 '若羌|ruoqiang|rq',
                 '且末|qiemo|qm',
                 '和静|hejing|hj',
                 '焉耆|yanqi|yq',
                 '和硕|heshuo|hs',
                 '巴音布鲁克|bayinbuluke|byblk',
                 '铁干里克|tieganlike|tglk',
                 '博湖|bohu|bh',
                 '塔中|tazhong|tz',
                 '巴仑台|baluntai|blt',
                 '阿拉尔|alaer|ale',
                 '阿克苏|akesu|aks',
                 '乌什|wushen|ws',
                 '温宿|wensu|ws',
                 '拜城|baicheng|bc',
                 '新和|xinhe|xh',
                 '沙雅|shaya|sy',
                 '库车|kuche|kc',
                 '柯坪|keping|kp',
                 '阿瓦提|awati|awt',
                 '喀什|kashen|ks',
                 '英吉沙|yingjisha|yjs',
                 '塔什库尔干|tashenkuergan|tskeg',
                 '麦盖提|maigaiti|mgt',
                 '莎车|shache|sc',
                 '叶城|yecheng|yc',
                 '泽普|zepu|zp',
                 '巴楚|bachu|bc',
                 '岳普湖|yuepuhu|yph',
                 '伽师|jiashi|js',
                 '疏附|shufu|sf',
                 '疏勒|shule|sl',
                 '伊宁|yining|yn',
                 '察布查尔|chabuchaer|cbce',
                 '尼勒克|nileke|nlk',
                 '伊宁县|yiningxian|ynx',
                 '巩留|gongliu|gl',
                 '新源|xinyuan|xy',
                 '昭苏|zhaosu|zs',
                 '特克斯|tekesi|tks',
                 '霍城|huocheng|hc',
                 '霍尔果斯|huoerguosi|hegs',
                 '奎屯|kuitun|kt',
                 '塔城|tacheng|tc',
                 '裕民|yumin|ym',
                 '额敏|emin|em',
                 '和布克赛尔|hebukesaier|hbkse',
                 '托里|tuoli|tl',
                 '乌苏|wusu|ws',
                 '沙湾|shawan|sw',
                 '哈密|hami|hm',
                 '巴里坤|balikun|blk',
                 '伊吾|yiwu|yw',
                 '和田|hetian|ht',
                 '皮山|pishan|ps',
                 '策勒|cele|cl',
                 '墨玉|moyu|my',
                 '洛浦|luopu|lp',
                 '民丰|minfeng|mf',
                 '于田|yutian|yt',
                 '阿勒泰|aletai|alt',
                 '哈巴河|habahe|hbh',
                 '吉木乃|jimunai|jmn',
                 '布尔津|buerjin|bej',
                 '福海|fuhai|fh',
                 '富蕴|fuyun|fy',
                 '青河|qinghe|qh',
                 '阿图什|atushen|ats',
                 '乌恰|wuqia|wq',
                 '阿克陶|aketao|akt',
                 '阿合奇|aheqi|ahq',
                 '博乐|bole|bl',
                 '温泉|wenquan|wq',
                 '精河|jinghe|jh',
                 '阿拉山口|alashankou|alsk',
                 '溧水|lishui|ls',
                 '高淳|gaochun|gc',
                 '江宁|jiangning|jn',
                 '六合|liuhe|lh',
                 '江浦|jiangpu|jp',
                 '浦口|pukou|pk',
                 '无锡|wuxi|wx',
                 '江阴|jiangyin|jy',
                 '宜兴|yixing|yx',
                 '锡山|xishan|xs',
                 '镇江|zhenjiang|zj',
                 '丹阳|danyang|dy',
                 '扬中|yangzhong|yz',
                 '句容|jurong|jr',
                 '丹徒|dantu|dt',
                 '苏州|suzhou|sz',
                 '常熟|changshu|cs',
                 '张家港|zhangjiagang|zjg',
                 '昆山|kunshan|ks',
                 '吴中|wuzhong|wz',
                 '吴江|wujiang|wj',
                 '太仓|taicang|tc',
                 '南通|nantong|nt',
                 '海安|haian|ha',
                 '如皋|rugao|rg',
                 '如东|rudong|rd',
                 '启东|qidong|qd',
                 '海门|haimen|hm',
                 '通州|tongzhou|tz',
                 '扬州|yangzhou|yz',
                 '宝应|baoying|by',
                 '仪征|yizheng|yz',
                 '高邮|gaoyou|gy',
                 '江都|jiangdou|jd',
                 '邗江|hanjiang|hj',
                 '盐城|yancheng|yc',
                 '响水|xiangshui|xs',
                 '滨海|binhai|bh',
                 '阜宁|funing|fn',
                 '射阳|sheyang|sy',
                 '建湖|jianhu|jh',
                 '东台|dongtai|dt',
                 '大丰|dafeng|df',
                 '盐都|yandou|yd',
                 '徐州|xuzhou|xz',
                 '铜山|tongshan|ts',
                 '丰县|fengxian|fx',
                 '沛县|peixian|px',
                 '邳州|pizhou|pz',
                 '睢宁|suining|sn',
                 '新沂|xinyi|xy',
                 '淮安|huaian|ha',
                 '金湖|jinhu|jh',
                 '盱眙|xuyi|xy',
                 '洪泽|hongze|hz',
                 '涟水|lianshui|ls',
                 '淮阴区|huaiyinqu|hyq',
                 '楚州|chuzhou|cz',
                 '连云港|lianyungang|lyg',
                 '东海|donghai|dh',
                 '赣榆|ganyu|gy',
                 '灌云|guanyun|gy',
                 '灌南|guannan|gn',
                 '常州|changzhou|cz',
                 '溧阳|liyang|ly',
                 '金坛|jintan|jt',
                 '武进|wujin|wj',
                 '泰州|taizhou|tz',
                 '兴化|xinghua|xh',
                 '泰兴|taixing|tx',
                 '姜堰|jiangyan|jy',
                 '靖江|jingjiang|jj',
                 '宿迁|suqian|sq',
                 '沭阳|shuyang|sy',
                 '泗阳|siyang|sy',
                 '泗洪|sihong|sh',
                 '宿豫|suyu|sy',
                 '澳门|aomen|am',
                 '氹仔岛|dangzidao|dzd',
                 '路环岛|luhuandao|lhd',
];

/* 正则表达式 筛选中文城市名、拼音、首字母 */

Vcity.regEx = /^([\u4E00-\u9FA5\uf900-\ufa2d]+)\|(\w+)\|(\w)\w*$/i;
Vcity.regExChiese = /([\u4E00-\u9FA5\uf900-\ufa2d]+)/;

/* *
 * 格式化城市数组为对象oCity，按照a-h,i-p,q-z,hot热门城市分组：
 * {HOT:{hot:[]},ABCDEFGH:{a:[1,2,3],b:[1,2,3]},IJKLMNOP:{i:[1.2.3],j:[1,2,3]},QRSTUVWXYZ:{}}
 * */

(function () {
    var citys = Vcity.allCity, match, letter,
            regEx = Vcity.regEx,
            reg2 = /^[a-h]$/i, reg3 = /^[i-p]$/i, reg4 = /^[q-z]$/i;
    if (!Vcity.oCity) {
        Vcity.oCity = {hot:{},ABCDEFGH:{}, IJKLMNOP:{}, QRSTUVWXYZ:{}};
        //console.log(citys.length);
        for (var i = 0, n = citys.length; i < n; i++) {
            if(!!citys[i]){
	        	match = regEx.exec(citys[i]);
	            letter = match[3].toUpperCase();
	            if (reg2.test(letter)) {
	                if (!Vcity.oCity.ABCDEFGH[letter]) Vcity.oCity.ABCDEFGH[letter] = [];
	                Vcity.oCity.ABCDEFGH[letter].push(match[1]);
	            } else if (reg3.test(letter)) {
	                if (!Vcity.oCity.IJKLMNOP[letter]) Vcity.oCity.IJKLMNOP[letter] = [];
	                Vcity.oCity.IJKLMNOP[letter].push(match[1]);
	            } else if (reg4.test(letter)) {
	                if (!Vcity.oCity.QRSTUVWXYZ[letter]) Vcity.oCity.QRSTUVWXYZ[letter] = [];
	                Vcity.oCity.QRSTUVWXYZ[letter].push(match[1]);
	            }
	            /* 热门城市 前16条 */
	            if(i<16){
	                if(!Vcity.oCity.hot['hot']) Vcity.oCity.hot['hot'] = [];
	                Vcity.oCity.hot['hot'].push(match[1]);
	            }
            }
        }
    }
})();
/* 城市HTML模板 */
Vcity._template = [
    '<p class="tip">热门城市(支持汉字/拼音)</p>',
    '<ul>',
    '<li class="on">热门</li>',
    '<li>A-H</li>',
    '<li>I-P</li>',
    '<li>Q-Z</li>',
    '</ul>'
];

/* *
 * 城市控件构造函数
 * @CitySelector
 * */

Vcity.CitySelector = function () {
    this.initialize.apply(this, arguments);
};

Vcity.CitySelector.prototype = {

    constructor:Vcity.CitySelector,

    /* 初始化 */

    initialize :function (options) {
        var input = options.input;
        this.input = Vcity._m.$('#'+ input);
        this.inputEvent();
    },

    /* *
     * @createWarp
     * 创建城市BOX HTML 框架
     * */

    createWarp:function(){
        var inputPos = Vcity._m.getPos(this.input);
        var div = this.rootDiv = document.createElement('div');
        var that = this;

        // 设置DIV阻止冒泡
        Vcity._m.on(this.rootDiv,'click',function(event){
            Vcity._m.stopPropagation(event);
        });

        // 设置点击文档隐藏弹出的城市选择框
        Vcity._m.on(document, 'click', function (event) {
            event = Vcity._m.getEvent(event);
            var target = Vcity._m.getTarget(event);
            if(target == that.input) return false;
            //console.log(target.className);
            if (that.cityBox)Vcity._m.addClass('hide', that.cityBox);
            if (that.ul)Vcity._m.addClass('hide', that.ul);
            if(that.myIframe)Vcity._m.addClass('hide',that.myIframe);
        });
        div.className = 'citySelector';
        div.style.position = 'absolute';
    	var left1=$(".Infobottom").offset().left;
    	var top1=$(".air").offset().top+30;
      div.style.left = left1 + 'px';
      div.style.top = top1 + 'px';
       
//        div.style.left = inputPos.left + 'px';
//        div.style.top = inputPos.bottom + 'px';
        div.style.zIndex = 999999;

        // 判断是否IE6，如果是IE6需要添加iframe才能遮住SELECT框
        var isIe = (document.all) ? true : false;
        var isIE6 = this.isIE6 = isIe && !window.XMLHttpRequest;
        if(isIE6){
            var myIframe = this.myIframe =  document.createElement('iframe');
            myIframe.frameborder = '0';
            myIframe.src = 'about:blank';
            myIframe.style.position = 'absolute';
            myIframe.style.zIndex = '-1';
            this.rootDiv.appendChild(this.myIframe);
        }

        var childdiv = this.cityBox = document.createElement('div');
        childdiv.className = 'cityBox';
        childdiv.id = 'cityBox';
        childdiv.innerHTML = Vcity._template.join('');
        var hotCity = this.hotCity =  document.createElement('div');
        hotCity.className = 'hotCity';
        childdiv.appendChild(hotCity);
        div.appendChild(childdiv);
        this.createHotCity();
    },

    /* *
     * @createHotCity
     * TAB下面DIV：hot,a-h,i-p,q-z 分类HTML生成，DOM操作
     * {HOT:{hot:[]},ABCDEFGH:{a:[1,2,3],b:[1,2,3]},IJKLMNOP:{},QRSTUVWXYZ:{}}
     **/

    createHotCity:function(){
        var odiv,odl,odt,odd,odda=[],str,key,ckey,sortKey,regEx = Vcity.regEx,
                oCity = Vcity.oCity;
        for(key in oCity){
            odiv = this[key] = document.createElement('div');
            // 先设置全部隐藏hide
            odiv.className = key + ' ' + 'cityTab hide';
            sortKey=[];
            for(ckey in oCity[key]){
                sortKey.push(ckey);
                // ckey按照ABCDEDG顺序排序
                sortKey.sort();
            }
            for(var j=0,k = sortKey.length;j<k;j++){
                odl = document.createElement('dl');
                odt = document.createElement('dt');
                odd = document.createElement('dd');
                odt.innerHTML = sortKey[j] == 'hot'?'&nbsp;':sortKey[j];
                odda = [];
                for(var i=0,n=oCity[key][sortKey[j]].length;i<n;i++){
                    //str = '<a href="#" onclick=cityClick("'+ oCity[key][sortKey[j]][i] + '")>' + oCity[key][sortKey[j]][i] + '</a>';
					//str = '<a href="javascript:void(0);" onclick="alert(&apos;'+ oCity[key][sortKey[j]][i] + '&apos;return false;)">' + oCity[key][sortKey[j]][i] + '</a>';
					str = '<a href="javascript:cityClick(\'' + oCity[key][sortKey[j]][i] + '\');void(0)">' + oCity[key][sortKey[j]][i] + '</a>';
                    odda.push(str);
                }
                odd.innerHTML = odda.join('');
                odl.appendChild(odt);
                odl.appendChild(odd);
                odiv.appendChild(odl);
            }

            // 移除热门城市的隐藏CSS
            Vcity._m.removeClass('hide',this.hot);
            this.hotCity.appendChild(odiv);
        }
        document.body.appendChild(this.rootDiv);
        /* IE6 */
        this.changeIframe();

        this.tabChange();
        this.linkEvent();
    },

    /* *
     *  tab按字母顺序切换
     *  @ tabChange
     * */

    tabChange:function(){
        var lis = Vcity._m.$('li',this.cityBox);
        var divs = Vcity._m.$('div',this.hotCity);
        var that = this;
        for(var i=0,n=lis.length;i<n;i++){
            lis[i].index = i;
            lis[i].onclick = function(){
                for(var j=0;j<n;j++){
                    Vcity._m.removeClass('on',lis[j]);
                    Vcity._m.addClass('hide',divs[j]);
                }
                Vcity._m.addClass('on',this);
                Vcity._m.removeClass('hide',divs[this.index]);
                /* IE6 改变TAB的时候 改变Iframe 大小*/
                that.changeIframe();
            };
        }
    },

    /* *
     * 城市LINK事件
     *  @linkEvent
     * */

    linkEvent:function(){
        var links = Vcity._m.$('a',this.hotCity);
        var that = this;
        for(var i=0,n=links.length;i<n;i++){
            links[i].onclick = function(){
                that.input.value = this.innerHTML;
                Vcity._m.addClass('hide',that.cityBox);
                /* 点击城市名的时候隐藏myIframe */
                Vcity._m.addClass('hide',that.myIframe);
            }
        }
    },

    /* *
     * INPUT城市输入框事件
     * @inputEvent
     * */

    inputEvent:function(){
        var that = this;
        Vcity._m.on(this.input,'click',function(event){
            event = event || window.event;
            if(!that.cityBox){
                that.createWarp();
            }else if(!!that.cityBox && Vcity._m.hasClass('hide',that.cityBox)){
                // slideul 不存在或者 slideul存在但是是隐藏的时候 两者不能共存
                if(!that.ul || (that.ul && Vcity._m.hasClass('hide',that.ul))){
                    Vcity._m.removeClass('hide',that.cityBox);

                    /* IE6 移除iframe 的hide 样式 */
                    //alert('click');
                    Vcity._m.removeClass('hide',that.myIframe);
                    that.changeIframe();
                }
            }
            stopProp(event);
        });
        Vcity._m.on(this.input,'focus',function(){
            that.input.select();
            if(that.input.value == '城市名') that.input.value = '';
        });
        Vcity._m.on(this.input,'blur',function(){
            if(that.input.value == '') that.input.value = '城市名';
        });
        Vcity._m.on(this.input,'keyup',function(event){
            event = event || window.event;
            var keycode = event.keyCode;
            Vcity._m.addClass('hide',that.cityBox);
            that.createUl();

            /* 移除iframe 的hide 样式 */
            Vcity._m.removeClass('hide',that.myIframe);

            // 下拉菜单显示的时候捕捉按键事件
            if(that.ul && !Vcity._m.hasClass('hide',that.ul) && !that.isEmpty){
                that.KeyboardEvent(event,keycode);
            }
        });
    },

    /* *
     * 生成下拉选择列表
     * @ createUl
     * */

    createUl:function () {
        //console.log('createUL');
        var str;
        var value = Vcity._m.trim(this.input.value);
        // 当value不等于空的时候执行
        if (value !== '') {
            var reg = new RegExp("^" + value + "|\\|" + value, 'gi');
            // 此处需设置中文输入法也可用onpropertychange
            var searchResult = [];
            for (var i = 0, n = Vcity.allCity.length; i < n; i++) {
                if (reg.test(Vcity.allCity[i])) {
                    var match = Vcity.regEx.exec(Vcity.allCity[i]);
                    if (searchResult.length !== 0) {
                        str = '<li><b class="cityname">' + match[1] + '</b><b class="cityspell">' + match[2] + '</b></li>';
                    } else {
                        str = '<li class="on"><b class="cityname">' + match[1] + '</b><b class="cityspell">' + match[2] + '</b></li>';
                    }
                    searchResult.push(str);
                }
            }
            this.isEmpty = false;
            // 如果搜索数据为空
            if (searchResult.length == 0) {
                this.isEmpty = true;
                str = '<li class="empty">对不起，没有找到数据 "<em>' + value + '</em>"</li>';
                searchResult.push(str);
            }
            // 如果slideul不存在则添加ul
            if (!this.ul) {
                var ul = this.ul = document.createElement('ul');
                ul.className = 'cityslide';
                this.rootDiv && this.rootDiv.appendChild(ul);
                // 记录按键次数，方向键
                this.count = 0;
            } else if (this.ul && Vcity._m.hasClass('hide', this.ul)) {
                this.count = 0;
                Vcity._m.removeClass('hide', this.ul);
            }
            this.ul.innerHTML = searchResult.join('');

            /* IE6 */
            this.changeIframe();

            // 绑定Li事件
            this.liEvent();
        }else{
            Vcity._m.addClass('hide',this.ul);
            Vcity._m.removeClass('hide',this.cityBox);

            Vcity._m.removeClass('hide',this.myIframe);

            this.changeIframe();
        }
    },

    /* IE6的改变遮罩SELECT 的 IFRAME尺寸大小 */
    changeIframe:function(){
        if(!this.isIE6)return;
        this.myIframe.style.width = this.rootDiv.offsetWidth + 'px';
        this.myIframe.style.height = this.rootDiv.offsetHeight + 'px';
    },

    /* *
     * 特定键盘事件，上、下、Enter键
     * @ KeyboardEvent
     * */

    KeyboardEvent:function(event,keycode){
        var lis = Vcity._m.$('li',this.ul);
        var len = lis.length;
        switch(keycode){
            case 40: //向下箭头↓
                this.count++;
                if(this.count > len-1) this.count = 0;
                for(var i=0;i<len;i++){
                    Vcity._m.removeClass('on',lis[i]);
                }
                Vcity._m.addClass('on',lis[this.count]);
                break;
            case 38: //向上箭头↑
                this.count--;
                if(this.count<0) this.count = len-1;
                for(i=0;i<len;i++){
                    Vcity._m.removeClass('on',lis[i]);
                }
                Vcity._m.addClass('on',lis[this.count]);
                break;
            case 13: // enter键
                this.input.value = Vcity.regExChiese.exec(lis[this.count].innerHTML)[0];
                Vcity._m.addClass('hide',this.ul);
                Vcity._m.addClass('hide',this.ul);
                /* IE6 */
                Vcity._m.addClass('hide',this.myIframe);
                break;
            default:
                break;
        }
    },

    /* *
     * 下拉列表的li事件
     * @ liEvent
     * */

    liEvent:function(){
        var that = this;
        var lis = Vcity._m.$('li',this.ul);
        for(var i = 0,n = lis.length;i < n;i++){
            Vcity._m.on(lis[i],'click',function(event){
                event = Vcity._m.getEvent(event);
                var target = Vcity._m.getTarget(event);
                that.input.value = Vcity.regExChiese.exec(target.innerHTML)[0];
                Vcity._m.addClass('hide',that.ul);
                /* IE6 下拉菜单点击事件 */
                Vcity._m.addClass('hide',that.myIframe);
                selfliCallback();//zengbanqing
            });

            Vcity._m.on(lis[i],'mouseover',function(event){
                event = Vcity._m.getEvent(event);
                var target = Vcity._m.getTarget(event);
                Vcity._m.addClass('on',target);
            });
            Vcity._m.on(lis[i],'mouseout',function(event){
                event = Vcity._m.getEvent(event);
                var target = Vcity._m.getTarget(event);
                Vcity._m.removeClass('on',target);
            })
        }
    }
};
var test=new Vcity.CitySelector({input:'citySelect'});
//var test2=new Vcity.CitySelector({input:'citySelect1'});