/*
 * Decompiled with CFR 0.152.
 */
package minechess.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import minechess.client.MineChessDrawBlockHighlightHandler;
import minechess.common.ItemPieceMover;
import minechess.common.MineChess;
import minechess.common.network.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;

public class PacketPieceSelectedUpdate
extends AbstractPacket {
    private List<int[]> renderPositions;
    private int pieceEntityID;
    private int renderHeight;

    public PacketPieceSelectedUpdate() {
    }

    public PacketPieceSelectedUpdate(List<int[]> renderPositions, int pieceEntityID, int renderHeight) {
        this.renderPositions = renderPositions;
        this.pieceEntityID = pieceEntityID;
        this.renderHeight = renderHeight;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeByte(this.renderPositions.size());
        for (int[] position : this.renderPositions) {
            buffer.writeInt(position[0]);
            buffer.writeInt(position[1]);
        }
        buffer.writeInt(this.pieceEntityID);
        buffer.writeInt(this.renderHeight);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.renderPositions = new ArrayList<int[]>();
        int listSize = buffer.readInt();
        for (int i = 0; i < listSize; ++i) {
            int[] move = new int[]{buffer.readInt(), buffer.readInt()};
            this.renderPositions.add(move);
        }
        this.pieceEntityID = buffer.readInt();
        this.renderHeight = buffer.readInt();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        MineChessDrawBlockHighlightHandler.pulse = 0;
        if (player.func_71045_bC().func_77973_b() == MineChess.itemPieceMover) {
            ItemPieceMover.setRenderTiles(this.renderPositions, this.renderHeight, player.func_71045_bC());
            ItemPieceMover.setEntitySelected(this.pieceEntityID, player.func_71045_bC());
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

