/*
 * Decompiled with CFR 0.152.
 */
package minechess.common.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import minechess.common.network.AbstractPacket;
import net.minecraft.world.World;

public abstract class LocationIntPacket
extends AbstractPacket {
    protected int x;
    protected int y;
    protected int z;

    public LocationIntPacket() {
    }

    public LocationIntPacket(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public NetworkRegistry.TargetPoint getTargetPoint(World world) {
        return this.getTargetPoint(world, 64.0);
    }

    public NetworkRegistry.TargetPoint getTargetPoint(World world, double updateDistance) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)this.x, (double)this.y, (double)this.z, updateDistance);
    }
}

