/*
 * Decompiled with CFR 0.152.
 */
package minechess.common.ai;

import java.util.List;
import minechess.common.EntityBaseChessPiece;
import minechess.common.EntityBishop;
import minechess.common.EntityKing;
import minechess.common.EntityKnight;
import minechess.common.EntityPawn;
import minechess.common.EntityQueen;
import minechess.common.EntityRook;
import minechess.common.ai.ChessMove;
import net.minecraft.nbt.NBTTagCompound;

public class ChessPosition {
    public static final int BLANK = 0;
    public static final int PAWN = 1;
    public static final int KNIGHT = 2;
    public static final int BISHOP = 3;
    public static final int ROOK = 4;
    public static final int QUEEN = 5;
    public static final int KING = 6;
    public int[] board = new int[80];
    boolean bWhiteKingMoved = false;
    boolean bBlackKingMoved = false;
    boolean bWhiteChecked = false;
    boolean bBlackChecked = false;
    int enPassantSquare = 0;
    private boolean isBlackTurn;

    public void makeMove(ChessMove move) {
        this.board[move.to] = this.board[move.from];
        this.board[move.from] = 0;
        if (move.to >= 70) {
            if (this.board[move.to] == 1) {
                this.board[move.to] = 5;
            }
        } else if (move.to < 8) {
            if (this.board[move.to] == -1) {
                this.board[move.to] = -5;
            }
        } else if (this.board[move.to] == 6 && !this.bWhiteKingMoved) {
            this.bWhiteKingMoved = true;
        } else if (this.board[move.to] == -6 && !this.bBlackKingMoved) {
            this.bBlackKingMoved = true;
        }
    }

    public ChessPosition(ChessPosition p) {
        System.arraycopy(p.board, 0, this.board, 0, 80);
        this.bWhiteKingMoved = p.bWhiteKingMoved;
        this.bBlackKingMoved = p.bBlackKingMoved;
        this.bWhiteChecked = p.bWhiteChecked;
        this.bBlackChecked = p.bBlackChecked;
        this.isBlackTurn = p.isBlackTurn;
    }

    public ChessPosition() {
    }

    public ChessPosition(EntityBaseChessPiece entityPiece) {
        List<EntityBaseChessPiece> pieces = entityPiece.getChessPieces(true);
        for (EntityBaseChessPiece piece : pieces) {
            int pieceValue = 0;
            if (piece instanceof EntityPawn) {
                pieceValue = 1;
            } else if (piece instanceof EntityBishop) {
                pieceValue = 3;
            } else if (piece instanceof EntityKnight) {
                pieceValue = 2;
            } else if (piece instanceof EntityRook) {
                pieceValue = 4;
            } else if (piece instanceof EntityKing) {
                pieceValue = 6;
                if (!piece.firstMove) {
                    if (piece.isBlack()) {
                        this.bBlackKingMoved = true;
                    } else {
                        this.bWhiteKingMoved = true;
                    }
                }
            } else if (piece instanceof EntityQueen) {
                pieceValue = 5;
            }
            if (piece.targetX + piece.targetZ * 10 < this.board.length) {
                this.board[piece.targetX + piece.targetZ * 10] = piece.isBlack() ? -pieceValue : pieceValue;
            }
            this.isBlackTurn = piece.isBlackTurn;
        }
        for (int i = 0; i < 8; ++i) {
            this.board[i * 10 + 8] = 7;
            this.board[i * 10 + 9] = 7;
        }
    }

    public void printBoard() {
        for (int i = 0; i < 80; ++i) {
            System.out.print("[" + this.board[i] + "] ");
            if (i % 10 != 9) continue;
            System.out.println();
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.board.length; ++i) {
            tag.func_74768_a("tile" + i, this.board[i]);
        }
        tag.func_74757_a("blackChecked", this.bBlackChecked);
        tag.func_74757_a("blackKingMoved", this.bBlackKingMoved);
        tag.func_74757_a("whiteChecked", this.bWhiteChecked);
        tag.func_74757_a("whiteKingMoved", this.bWhiteKingMoved);
        tag.func_74774_a("enPassantSquare", (byte)this.enPassantSquare);
        tag.func_74757_a("isBlackTurn", this.isBlackTurn);
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.board.length; ++i) {
            this.board[i] = tag.func_74762_e("tile" + i);
        }
        this.bBlackChecked = tag.func_74767_n("blackChecked");
        this.bBlackKingMoved = tag.func_74767_n("blackKingMoved");
        this.bWhiteChecked = tag.func_74767_n("whiteChecked");
        this.bWhiteKingMoved = tag.func_74767_n("whiteKingMoved");
        this.enPassantSquare = tag.func_74771_c("enPassantSquare");
        this.isBlackTurn = tag.func_74767_n("isBlackTurn");
    }

    public boolean isSame(ChessPosition compare) {
        for (int i = 0; i < this.board.length; ++i) {
            if (this.board[i] == compare.board[i]) continue;
            return false;
        }
        if (this.bBlackChecked != compare.bBlackChecked) {
            return false;
        }
        if (this.bBlackKingMoved != compare.bBlackKingMoved) {
            return false;
        }
        if (this.bWhiteChecked != compare.bWhiteChecked) {
            return false;
        }
        if (this.bWhiteKingMoved != compare.bWhiteKingMoved) {
            return false;
        }
        if (this.enPassantSquare != compare.enPassantSquare) {
            return false;
        }
        return this.isBlackTurn == compare.isBlackTurn;
    }

    public boolean hasActiveDifference(ChessPosition compare) {
        int thisPieceCount = 0;
        int comparePieceCount = 0;
        for (int i = 0; i < this.board.length; ++i) {
            if (this.board[i] == 1 && compare.board[i] != 1) {
                return true;
            }
            if (this.board[i] == -1 && compare.board[i] != -1) {
                return true;
            }
            if (this.board[i] != 0) {
                ++thisPieceCount;
            }
            if (compare.board[i] == 0) continue;
            ++comparePieceCount;
        }
        return thisPieceCount != comparePieceCount;
    }
}

