/*
 * Decompiled with CFR 0.152.
 */
package minechess.common;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import minechess.common.EntityBaseChessPiece;
import minechess.common.EntityBishop;
import minechess.common.EntityKing;
import minechess.common.EntityKnight;
import minechess.common.EntityPawn;
import minechess.common.EntityQueen;
import minechess.common.EntityRook;
import minechess.common.MineChess;
import minechess.common.MineChessUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderFlat;

public class WorldGeneratorMineChess
implements IWorldGenerator {
    private final String[][][] boards = new String[][][]{{{"bR", "  ", "  ", "  ", "  ", "bR", "  ", "  "}, {"bP", "  ", "  ", "  ", "  ", "  ", "bP", "bK"}, {"  ", "bP", "  ", "wR", "  ", "  ", "  ", "  "}, {"  ", "  ", "bN", "  ", "  ", "bP", "  ", "  "}, {"  ", "  ", "  ", "  ", "  ", "  ", "  ", "  "}, {"wP", "wB", "  ", "  ", "wR", "  ", "  ", "  "}, {"  ", "wP", "wP", "  ", "  ", "wP", "wP", "wP"}, {"  ", "  ", "  ", "  ", "  ", "  ", "wK", "  "}}, {{"bR", "  ", "bB", "  ", "bK", "bB", "  ", "bR"}, {"bP", "bP", "bQ", "bP", "  ", "bP", "bP", "bP"}, {"  ", "  ", "  ", "  ", "bP", "  ", "  ", "  "}, {"  ", "  ", "  ", "  ", "  ", "  ", "  ", "  "}, {"  ", "  ", "wB", "bN", "wP", "  ", "bN", "  "}, {"  ", "  ", "wN", "  ", "  ", "wN", "  ", "wP"}, {"wP", "wP", "  ", "  ", "  ", "wP", "wP", "  "}, {"wR", "  ", "wB", "wQ", "  ", "wR", "wK", "  "}}};
    private final int[] mateInTimes = new int[]{1, 2};
    private final boolean[] isComputerBlack = new boolean[]{true, false};

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!(chunkGenerator instanceof ChunkProviderFlat)) {
            switch (world.field_73011_w.field_76574_g) {
                case 0: {
                    this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                    break;
                }
                case -1: {
                    this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                    break;
                }
                case 1: {
                    this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                }
            }
        }
    }

    public void generateSurface(World world, Random rand, int chunkX, int chunkZ) {
        if (MineChess.configWorldgenPuzzleUnderground != 0 && rand.nextInt(MineChess.configWorldgenPuzzleUnderground) == 0) {
            for (int i = 0; i < 10; ++i) {
                int baseZ;
                int baseY;
                int baseX = chunkX + rand.nextInt(8);
                if (!this.collidingWithCave(world, baseX, baseY = rand.nextInt(30) + 20, baseZ = chunkZ + rand.nextInt(8))) continue;
                this.generateChessPuzzle(world, rand, baseX, baseY, baseZ);
                break;
            }
        }
    }

    public void generateNether(World world, Random rand, int chunkX, int chunkZ) {
    }

    public void generateEnd(World world, Random rand, int chunkX, int chunkZ) {
    }

    private void generateChessPuzzle(World world, Random rand, int baseX, int baseY, int baseZ) {
        this.fillWithMetadataBlocks(world, baseX - 1, baseY + 1, baseZ - 1, baseX + 8, baseY + 4, baseZ + 8, Blocks.field_150350_a, 0);
        this.fillWithMossyStone(world, baseX - 1, baseY, baseZ - 1, baseX + 8, baseY, baseZ + 8, rand);
        this.fillWithMossyStone(world, baseX - 2, baseY, baseZ - 2, baseX + 9, baseY + 4, baseZ - 2, rand);
        this.fillWithMossyStone(world, baseX - 2, baseY, baseZ + 9, baseX + 9, baseY + 4, baseZ + 9, rand);
        this.fillWithMossyStone(world, baseX - 2, baseY, baseZ - 2, baseX - 2, baseY + 4, baseZ + 9, rand);
        this.fillWithMossyStone(world, baseX + 9, baseY, baseZ - 2, baseX + 9, baseY + 4, baseZ + 9, rand);
        this.fillWithMossyStone(world, baseX - 2, baseY + 5, baseZ - 2, baseX + 9, baseY + 5, baseZ + 9, rand);
        world.func_147465_d(baseX + 2, baseY + 5, baseZ + 2, Blocks.field_150379_bu, 0, 2);
        world.func_147465_d(baseX + 5, baseY + 5, baseZ + 2, Blocks.field_150379_bu, 0, 2);
        world.func_147465_d(baseX + 5, baseY + 5, baseZ + 5, Blocks.field_150379_bu, 0, 2);
        world.func_147465_d(baseX + 2, baseY + 5, baseZ + 5, Blocks.field_150379_bu, 0, 2);
        world.func_147465_d(baseX + 2, baseY + 6, baseZ + 2, Blocks.field_150442_at, 13, 3);
        world.func_147465_d(baseX + 5, baseY + 6, baseZ + 2, Blocks.field_150442_at, 13, 3);
        world.func_147465_d(baseX + 5, baseY + 6, baseZ + 5, Blocks.field_150442_at, 13, 3);
        world.func_147465_d(baseX + 2, baseY + 6, baseZ + 5, Blocks.field_150442_at, 13, 3);
        MineChessUtils.generateChessBoard(world, baseX, baseY, baseZ);
        int randomPuzzle = rand.nextInt(2);
        for (int i = 0; i < 8; ++i) {
            block9: for (int j = 0; j < 8; ++j) {
                EntityBaseChessPiece chessPiece;
                String pieceString = this.boards[randomPuzzle][7 - j][7 - i];
                if (pieceString.equals("  ")) continue;
                switch (pieceString.charAt(1)) {
                    case 'K': {
                        chessPiece = new EntityKing(world);
                        break;
                    }
                    case 'Q': {
                        chessPiece = new EntityQueen(world);
                        break;
                    }
                    case 'N': {
                        chessPiece = new EntityKnight(world);
                        break;
                    }
                    case 'B': {
                        chessPiece = new EntityBishop(world);
                        break;
                    }
                    case 'R': {
                        chessPiece = new EntityRook(world);
                        break;
                    }
                    case 'P': {
                        chessPiece = new EntityPawn(world);
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                chessPiece.setIsBlack(pieceString.charAt(0) == 'b');
                chessPiece.computerPiece = pieceString.charAt(0) == 'b' == this.isComputerBlack[randomPuzzle];
                chessPiece.isBlackTurn = !this.isComputerBlack[randomPuzzle];
                chessPiece.func_70107_b((double)i + (double)baseX + 0.5, (double)baseY + 1.0, (double)j + (double)baseZ + 0.5);
                chessPiece.setTargetPosition(i, j);
                chessPiece.xOffset = baseX;
                chessPiece.zOffset = baseZ;
                chessPiece.mateInTimes = this.mateInTimes[randomPuzzle];
                world.func_72838_d((Entity)chessPiece);
            }
        }
    }

    private boolean collidingWithCave(World world, int baseX, int baseY, int baseZ) {
        for (int i = baseX; i <= baseX + 8; ++i) {
            for (int j = baseY; j <= baseY + 4; ++j) {
                for (int k = baseZ; k <= baseZ + 8; ++k) {
                    if (!world.func_147437_c(i, j, k)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void fillWithMetadataBlocks(World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block block, int metadata) {
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minY; j <= maxY; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    world.func_147465_d(i, j, k, block, metadata, 3);
                }
            }
        }
    }

    private void fillWithMossyStone(World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Random rand) {
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minY; j <= maxY; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    if (world.func_147437_c(i, j, k)) continue;
                    if (rand.nextInt(4) == 0) {
                        world.func_147465_d(i, j, k, Blocks.field_150347_e, 0, 2);
                        continue;
                    }
                    world.func_147465_d(i, j, k, Blocks.field_150341_Y, 0, 2);
                }
            }
        }
    }
}

