/*
 * Decompiled with CFR 0.152.
 */
package minechess.common;

import java.util.List;
import java.util.Random;
import minechess.common.AchievementHandler;
import minechess.common.EntityBaseChessPiece;
import minechess.common.MineChess;
import minechess.common.network.PacketAddChatMessage;
import minechess.common.network.PacketPlaySound;
import minechess.common.network.PacketSpawnParticle;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class MineChessUtils {
    public static int determineOrientation(EntityPlayer par4EntityPlayer) {
        return MathHelper.func_76128_c((double)(par4EntityPlayer.field_70177_z * 4.0f / 360.0f)) & 3;
    }

    public static void generateChessBoard(World world, int x, int y, int z) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                boolean even = (i + j) % 2 == 0;
                world.func_147465_d(i + x, y, j + z, Blocks.field_150325_L, even ? 0 : 15, 3);
            }
        }
    }

    public static void spawnParticle(String particleName, World world, double x, double y, double z, double velX, double velY, double velZ) {
        MineChess.packetPipeline.sendToAllAround(new PacketSpawnParticle(particleName, x, y, z, velX, velY, velZ), world);
    }

    public static void onPuzzleFail(World world, EntityPlayer player, EntityBaseChessPiece piece, int x, int y, int z, Random rand) {
        int randEffect = 0;
        while ((randEffect = rand.nextInt(4)) == 3 && player == null) {
        }
        switch (randEffect) {
            case 0: {
                for (int i = 0; i < 8; ++i) {
                    for (int j = 0; j < 8; ++j) {
                        world.func_147465_d(x + i, y - 2, z + j, (Block)Blocks.field_150480_ab, 1, 3);
                    }
                }
                if (player != null) {
                    AchievementHandler.giveAchievement(player, "puzzleFailFire");
                }
                return;
            }
            case 1: {
                MineChess.packetPipeline.sendToAllAround(new PacketPlaySound("ambient.cave.cave", x, y, z, 1.0f, 1.0f, true), world);
                int entityCount = 0;
                boolean firstCreeper = true;
                for (int i = 0; i < 50; ++i) {
                    int randY;
                    int randZ;
                    int randX = x + rand.nextInt(20) - 12;
                    if (randX >= x - 2 && randX <= x + 9) {
                        randX += 12;
                    }
                    if ((randZ = z + rand.nextInt(20) - 10) >= z - 2 && randZ <= z + 9) {
                        randZ += 12;
                    }
                    if (!world.func_147437_c(randX, randY = y + rand.nextInt(6) - 3, randZ) || !world.func_147437_c(randX, randY + 1, randZ)) continue;
                    EntityCreeper creeper = new EntityCreeper(world);
                    creeper.func_70107_b((double)randX + 0.5, (double)randY, (double)randZ + 0.5);
                    creeper.func_70784_b((Entity)player);
                    if (firstCreeper) {
                        creeper.func_70077_a(null);
                    }
                    firstCreeper = false;
                    world.func_72838_d((Entity)creeper);
                    if (++entityCount < 5) continue;
                    return;
                }
                if (player != null) {
                    AchievementHandler.giveAchievement(player, "puzzleFailCreepy");
                }
                return;
            }
            case 2: {
                List<EntityBaseChessPiece> pieces = piece.getChessPieces(false);
                for (EntityBaseChessPiece chessPiece : pieces) {
                    if (chessPiece.isBlack() == piece.isBlack()) continue;
                    chessPiece.turnToMobOnDeath = true;
                }
                if (player != null) {
                    AchievementHandler.giveAchievement(player, "puzzleFailTransform");
                }
                return;
            }
            case 3: {
                int potionAmount = 2 + rand.nextInt(3);
                for (int i = 0; i < potionAmount; ++i) {
                    Potion randomPotion;
                    do {
                        randomPotion = Potion.field_76425_a[rand.nextInt(20) + 1];
                    } while (!MineChessUtils.isPotionBadEffect(randomPotion.field_76415_H) || randomPotion == Potion.field_76433_i);
                    player.func_70690_d(new PotionEffect(randomPotion.field_76415_H, 200 + rand.nextInt(400)));
                }
                if (player != null) {
                    AchievementHandler.giveAchievement(player, "puzzleFailPotion");
                }
                return;
            }
        }
    }

    public static boolean isPotionBadEffect(int potionID) {
        switch (potionID) {
            case 2: 
            case 4: 
            case 9: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public static void sendUnlocalizedMessage(EntityPlayer player, String message) {
        MineChessUtils.sendUnlocalizedMessage(player, message, EnumChatFormatting.WHITE.toString());
    }

    public static void sendUnlocalizedMessage(EntityPlayer player, String message, String ... replacements) {
        MineChess.packetPipeline.sendTo(new PacketAddChatMessage(message, replacements), (EntityPlayerMP)player);
    }
}

