/*
 * Decompiled with CFR 0.152.
 */
package minechess.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import minechess.common.AchievementHandler;
import minechess.common.EntityBaseChessPiece;
import minechess.common.EntityRook;
import minechess.common.MineChess;
import minechess.common.MineChessUtils;
import minechess.common.ai.AIMain;
import minechess.common.ai.ChessPosition;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class EntityKing
extends EntityBaseChessPiece {
    private final List<EntityPlayer> playersInArea = new ArrayList<EntityPlayer>();
    public final List<ChessPosition> lastPositions = new ArrayList<ChessPosition>();
    private int listUpdateTicks = this.field_70146_Z.nextInt(60);
    private AIMain ai;
    public float lastPositionScore;

    public EntityKing(World par1World) {
        super(par1World);
    }

    @Override
    public Entity getMob() {
        EntityCreeper chargedCreeper = new EntityCreeper(this.field_70170_p);
        chargedCreeper.func_70077_a(null);
        return chargedCreeper;
    }

    @Override
    public List<int[]> getPossibleMoves() {
        ArrayList<int[]> moves = new ArrayList<int[]>();
        for (int i = this.targetX - 1; i <= this.targetX + 1; ++i) {
            for (int j = this.targetZ - 1; j <= this.targetZ + 1; ++j) {
                if (i < 0 || i >= 8 || j < 0 || j >= 8) continue;
                int[] move = new int[]{i, j};
                moves.add(move);
            }
        }
        if (this.firstMove) {
            List<EntityBaseChessPiece> pieces = this.getChessPieces(true);
            for (int i = 0; i < 2; ++i) {
                int[] castlingMove = new int[]{this.targetX - 2 + i * 4, this.targetZ};
                boolean unmovedRook = false;
                boolean piecesInBetween = false;
                for (int j = 0; j < pieces.size(); ++j) {
                    if (pieces.get(j) instanceof EntityRook && pieces.get((int)j).firstMove && pieces.get((int)j).targetX == i * 7 && pieces.get((int)j).targetZ == this.targetZ) {
                        unmovedRook = true;
                    }
                    if (pieces.get((int)j).targetX != i * 5 + 1 && pieces.get((int)j).targetX != i * 3 + 2 || pieces.get((int)j).targetZ != this.targetZ) continue;
                    piecesInBetween = true;
                }
                if (!unmovedRook || piecesInBetween) continue;
                moves.add(castlingMove);
            }
        }
        return moves;
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (!this.computerPiece || this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.ai != null && this.ai.bQuit) {
            this.ai = null;
        }
        if (this.field_70173_aa % 10 == 0 && this.ai == null && this.isBlack() == this.isBlackTurn && this.deathTimer < 0 && !this.isPieceCapturing()) {
            this.ai = new AIMain();
            this.ai.aiCaller.go(this);
        }
        if (this.mateInTimes < 0) {
            return;
        }
        ++this.listUpdateTicks;
        if (this.listUpdateTicks < 60) {
            return;
        }
        this.listUpdateTicks = 0;
        for (int i = 0; i < this.playersInArea.size(); ++i) {
            if (this.getNotSoNearbyPlayers().contains(this.playersInArea.get(i))) continue;
            this.playersInArea.remove(i);
        }
        List<EntityPlayer> playersNearby = this.getNearbyPlayers();
        for (int i = 0; i < playersNearby.size(); ++i) {
            EntityPlayer playerNearby = playersNearby.get(i);
            if (this.playersInArea.contains(playerNearby)) continue;
            this.playersInArea.add(playerNearby);
            AchievementHandler.giveAchievement(playerNearby, "enterArena");
            MineChessUtils.sendUnlocalizedMessage(playerNearby, "message.broadcast.puzzleObjective" + (this.isBlack() ? "Black" : "White"), EnumChatFormatting.BLUE.toString(), this.mateInTimes + "");
        }
    }

    public List<EntityPlayer> getNearbyPlayers() {
        AxisAlignedBB bbBox = AxisAlignedBB.func_72330_a((double)(this.xOffset - 1), (double)((int)this.field_70163_u - 1), (double)(this.zOffset - 1), (double)(this.xOffset + 8), (double)(this.field_70163_u + 2.0), (double)(this.zOffset + 8));
        return this.field_70170_p.func_72872_a(EntityPlayer.class, bbBox);
    }

    public List<EntityPlayer> getNotSoNearbyPlayers() {
        AxisAlignedBB bbBox = AxisAlignedBB.func_72330_a((double)(this.xOffset - 3), (double)((int)this.field_70163_u - 2), (double)(this.zOffset - 3), (double)(this.xOffset + 10), (double)(this.field_70163_u + 4.0), (double)(this.zOffset + 10));
        return this.field_70170_p.func_72872_a(EntityPlayer.class, bbBox);
    }

    @Override
    public void func_70106_y() {
        if (this.solvedPuzzle && !this.field_70170_p.field_72995_K && this.computerPiece && this.mateInTimes >= 0) {
            int chestX = this.xOffset + this.targetX;
            int chestY = (int)Math.floor(this.field_70163_u);
            int chestZ = this.zOffset + this.targetZ;
            for (int i = 0; i < 40; ++i) {
                MineChessUtils.spawnParticle("explode", this.field_70170_p, (double)chestX + 0.5, (double)chestY + 0.5, (double)chestZ + 0.5, this.field_70146_Z.nextDouble() / 5.0 - 0.1, this.field_70146_Z.nextDouble() / 5.0 - 0.1, this.field_70146_Z.nextDouble() / 5.0 - 0.1);
            }
            this.field_70170_p.func_147465_d(chestX, chestY, chestZ, (Block)Blocks.field_150486_ae, 0, 3);
            TileEntityChest chest = (TileEntityChest)this.field_70170_p.func_147438_o(chestX, chestY, chestZ);
            WeightedRandomChestContent.func_76293_a((Random)this.field_70146_Z, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"mineshaftCorridor", (Random)this.field_70146_Z), (IInventory)chest, (int)ChestGenHooks.getCount((String)"mineshaftCorridor", (Random)this.field_70146_Z));
            for (int i = 0; i < 50; ++i) {
                int slot = this.field_70146_Z.nextInt(chest.func_70302_i_());
                if (chest.func_70301_a(slot) != null) continue;
                chest.func_70299_a(slot, new ItemStack(MineChess.itemPieceMover, 1, 4));
                break;
            }
        }
        super.func_70106_y();
    }

    public boolean checkForDraw(boolean messagePlayer) {
        ChessPosition lastPos = null;
        if (this.lastPositions.size() > 1 && (lastPos = this.lastPositions.get(this.lastPositions.size() - 1)).hasActiveDifference(this.lastPositions.get(this.lastPositions.size() - 2))) {
            this.lastPositions.clear();
            this.lastPositions.add(lastPos);
        }
        if (this.lastPositions.size() >= 100) {
            this.sendChatToNearbyPlayers(null, "message.broadcast.inactiveDraw", EnumChatFormatting.GOLD.toString(), "" + this.lastPositions.size());
            return true;
        }
        if (lastPos != null) {
            int samePositionsFound = 0;
            for (ChessPosition testPos : this.lastPositions) {
                if (!testPos.isSame(lastPos)) continue;
                ++samePositionsFound;
            }
            if (samePositionsFound >= 3) {
                this.sendChatToNearbyPlayers(null, "message.broadcast.samePositionThrice", EnumChatFormatting.GOLD.toString(), "" + samePositionsFound);
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74776_a("lastScore", this.lastPositionScore);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.lastPositions.size(); ++i) {
            NBTTagCompound positionTag = new NBTTagCompound();
            positionTag.func_74774_a("turn", (byte)i);
            this.lastPositions.get(i).writeToNBT(positionTag);
            tagList.func_74742_a((NBTBase)positionTag);
        }
        tag.func_74782_a("lastPositions", (NBTBase)tagList);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.lastPositionScore = tag.func_74760_g("lastScore");
        this.lastPositions.clear();
        NBTTagList tagList = tag.func_150295_c("lastPositions", 10);
        this.lastPositions.addAll(Arrays.asList(new ChessPosition[tagList.func_74745_c()]));
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound positionTag = tagList.func_150305_b(i);
            byte turn = positionTag.func_74771_c("turn");
            if (turn < 0 || turn >= this.lastPositions.size()) continue;
            ChessPosition position = new ChessPosition();
            position.readFromNBT(positionTag);
            this.lastPositions.set(turn, position);
        }
    }
}

