/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Server;

import CustomOreGen.Server.ConfigOption;
import CustomOreGen.Util.CIStringMap;
import CustomOreGen.Util.Localization;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedHashMap;

public class ChoiceOption
extends ConfigOption {
    private String _value = null;
    private CIStringMap<String[]> _valueMap = new CIStringMap(new LinkedHashMap());

    public ChoiceOption(String name) {
        super(name);
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public boolean setValue(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String canonicalValue = this._valueMap.getCanonicalKey((String)value);
        if (canonicalValue == null) {
            return false;
        }
        this._value = canonicalValue;
        return true;
    }

    public void addPossibleValue(String value, String displayValue, String description) {
        if (value != null) {
            this._valueMap.put(value, new String[]{displayValue, description});
            if (this._value == null) {
                this._value = value;
            }
        }
    }

    public void removePossibleValue(String value) {
        if (value != null) {
            if (this._value == value) {
                this._value = this.nextPossibleValue();
                if (this._value == value) {
                    this._value = null;
                }
            }
            this._valueMap.remove(value);
        }
    }

    public String nextPossibleValue() {
        boolean found = false;
        String first = null;
        for (String s : this._valueMap.keySet()) {
            if (first == null) {
                first = s;
            }
            if (found) {
                return s;
            }
            if (!s.equals(this._value)) continue;
            found = true;
        }
        if (found) {
            return first;
        }
        return null;
    }

    public String getDisplayValue() {
        String[] display = this._valueMap.get(this._value);
        return display != null && display[0] != null ? display[0] : this._value;
    }

    public String getValueDescription() {
        String[] display = this._valueMap.get(this._value);
        return display == null ? null : display[1];
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedValueDescription() {
        return this.localize("description", this.getValueDescription());
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedDisplayValue() {
        return this.localize("displayValue", this.getDisplayValue());
    }

    @SideOnly(value=Side.CLIENT)
    private String localize(String key, String value) {
        return Localization.maybeLocalize(this.getName() + "." + this.getValue() + "." + key, value);
    }
}

