/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.IEntitySelector;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import oortcloud.hungryanimals.blocks.ModBlocks;
import oortcloud.hungryanimals.client.render.RenderBlockExcreta;
import oortcloud.hungryanimals.items.ModItems;
import oortcloud.hungryanimals.lib.References;
import oortcloud.hungryanimals.materials.ModMaterials;
import oortcloud.hungryanimals.potion.ModPotions;

public class BlockExcreta
extends BlockFalling {
    @SideOnly(value=Side.CLIENT)
    IIcon[] icons;
    private static int[] metaToManure = new int[]{1, 2, 3, 4, 0, 1, 2, 3, 0, 1, 2, 0, 1, 0, 0, 0};
    private static int[] metaToExcreta = new int[]{0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 4, 0, 0};
    public static final float hardnessConstant = 0.5f;
    public static final double defualt_fermetationProbability = 0.05;
    public static double fermetationProbability;
    public static final double defualt_erosionProbability = 0.025;
    public static double erosionProbability;
    public static final double defualt_fertilizationProbability = 0.2;
    public static double fertilizationProbability;
    public static final double defualt_diseaseProbability = 0.05;
    public static double diseaseProbability;
    public static final double diseaseRadius = 3.0;

    public BlockExcreta() {
        super(ModMaterials.excreta);
        this.func_149663_c(References.RESOURCESPREFIX + "blockexcreta");
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.setHarvestLevel("shovel", 0);
        this.func_149675_a(true);
        ModBlocks.register((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return BlockExcreta.getNumberOfManure(meta) == 0 ? this.field_149761_L : this.icons[3];
        }
        if (side == 1) {
            return BlockExcreta.getNumberOfExcreta(meta) == 0 ? this.icons[3] : this.field_149761_L;
        }
        return BlockExcreta.getNumberOfManure(meta) == 0 ? this.field_149761_L : this.icons[BlockExcreta.getNumberOfManure(meta) - 1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister icon) {
        this.icons = new IIcon[4];
        this.field_149761_L = icon.func_94245_a(ModBlocks.getUnwrappedUnlocalizedName(super.func_149739_a()) + "_" + "0");
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = icon.func_94245_a(ModBlocks.getUnwrappedUnlocalizedName(super.func_149739_a()) + "_" + (i + 1));
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        world.func_147452_c(x, y, z, (Block)this, 0, 1);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147452_c(x, y, z, (Block)this, 0, 1);
    }

    public boolean func_149696_a(World world, int x, int y, int z, int id, int value) {
        if (!world.field_72995_K) {
            this.func_149830_m(world, x, y, z);
            if (world.func_147439_a(x, y - 1, z) == this) {
                int metaTop = world.func_72805_g(x, y, z);
                int metaBot = world.func_72805_g(x, y - 1, z);
                if (BlockExcreta.getNumberOfExcreta(metaBot) + BlockExcreta.getNumberOfManure(metaBot) < 4) {
                    this.stackBlock(world, x, y - 1, z, metaTop, metaBot, true);
                }
            } else if (!world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a()) {
                world.func_147468_f(x, y - 1, z);
            } else if (world.func_147439_a(x, y + 1, z) == this) {
                int metaTop = world.func_72805_g(x, y + 1, z);
                int metaBot = world.func_72805_g(x, y, z);
                if (BlockExcreta.getNumberOfManure(metaTop) > 0) {
                    if (BlockExcreta.getNumberOfManure(metaBot) < 4) {
                        this.stackBlock(world, x, y, z, metaTop, metaBot, true);
                    }
                }
            }
        }
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int exc = BlockExcreta.getNumberOfExcreta(metadata);
        int man = BlockExcreta.getNumberOfManure(metadata);
        ret.add(new ItemStack(ItemBlock.func_150898_a((Block)this), exc));
        ret.add(new ItemStack(ModItems.manure, man));
        return ret;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return (float)(BlockExcreta.getNumberOfExcreta(meta) + BlockExcreta.getNumberOfManure(meta)) * 0.5f;
    }

    public int func_149645_b() {
        return RenderBlockExcreta.renderid;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149719_a(IBlockAccess block, int x, int y, int z) {
        int meta = block.func_72805_g(x, y, z);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.25f * (float)(BlockExcreta.getNumberOfExcreta(meta) + BlockExcreta.getNumberOfManure(meta)), 1.0f);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K) {
            this.fermentate(world, x, y, z, random);
            this.disease(world, x, y, z, random);
            this.dissolve(world, x, y, z, random);
        }
    }

    private void dissolve(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        int man = BlockExcreta.getNumberOfManure(meta);
        int exc = BlockExcreta.getNumberOfExcreta(meta);
        Block bottom = world.func_147439_a(x, y - 1, z);
        if (bottom == Blocks.field_150346_d || bottom == Blocks.field_150349_c || bottom == Blocks.field_150354_m) {
            if (random.nextDouble() < fertilizationProbability) {
                if (man > 0) {
                    world.func_72921_c(x, y, z, BlockExcreta.getMetaOfExcretaAndManure(exc, man - 1), 2);
                    world.func_147444_c(x, y, z, (Block)this);
                } else if (exc > 1) {
                    world.func_72921_c(x, y, z, BlockExcreta.getMetaOfExcretaAndManure(exc - 1, man), 2);
                    world.func_147444_c(x, y, z, (Block)this);
                } else {
                    world.func_147468_f(x, y, z);
                }
                if (bottom == Blocks.field_150354_m) {
                    world.func_147465_d(x, y - 1, z, Blocks.field_150346_d, 0, 2);
                } else if (bottom == Blocks.field_150346_d) {
                    world.func_147465_d(x, y - 1, z, (Block)Blocks.field_150349_c, 0, 2);
                } else {
                    world.func_147468_f(x, y, z);
                }
            }
        } else if (world.func_147437_c(x, y + 1, z)) {
            if (random.nextDouble() < erosionProbability) {
                if (exc > 0) {
                    world.func_72921_c(x, y, z, BlockExcreta.getMetaOfExcretaAndManure(exc - 1, man), 2);
                    world.func_147444_c(x, y, z, (Block)this);
                } else if (man > 1) {
                    world.func_72921_c(x, y, z, BlockExcreta.getMetaOfExcretaAndManure(exc, man - 1), 2);
                    world.func_147444_c(x, y, z, (Block)this);
                } else {
                    world.func_147468_f(x, y, z);
                }
            }
        }
    }

    private void disease(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        if (random.nextDouble() < diseaseProbability / 3.0 * (double)Math.max(0, BlockExcreta.getNumberOfExcreta(meta) - 1)) {
            IEntitySelector hungryAnimalSelector = new IEntitySelector(){

                public boolean func_82704_a(Entity entity) {
                    return entity.getExtendedProperties("extendedPropertiesHungryAnimal") != null;
                }
            };
            for (Object i : world.func_82733_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)((double)x - 3.0), (double)((double)y - 3.0), (double)((double)z - 3.0), (double)((double)(x + 1) + 3.0), (double)((double)(y + 1) + 3.0), (double)((double)(z + 1) + 3.0)), hungryAnimalSelector)) {
                ((EntityLiving)i).func_70690_d(new PotionEffect(ModPotions.potionDisease.field_76415_H, 24000, 1, false));
            }
        }
    }

    public int func_149660_a(World p_149660_1_, int p_149660_2_, int p_149660_3_, int p_149660_4_, int p_149660_5_, float p_149660_6_, float p_149660_7_, float p_149660_8_, int p_149660_9_) {
        return BlockExcreta.getMetaOfExcretaAndManure(1, 0);
    }

    private void fermentate(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        int exc = BlockExcreta.getNumberOfExcreta(meta);
        int man = BlockExcreta.getNumberOfManure(meta);
        int firstExc = exc;
        boolean flag = false;
        for (int i = 0; i < firstExc; ++i) {
            if (!(random.nextDouble() < fermetationProbability)) continue;
            world.func_72921_c(x, y, z, BlockExcreta.getMetaOfExcretaAndManure(--exc, ++man), 2);
            world.func_147444_c(x, y, z, (Block)this);
            flag = true;
        }
        if (flag) {
            if (world.func_147439_a(x + 1, y, z) == ModBlocks.excreta) {
                this.fermentate(world, x + 1, y, z, random);
            }
            if (world.func_147439_a(x, y + 1, z) == ModBlocks.excreta) {
                this.fermentate(world, x, y + 1, z, random);
            }
            if (world.func_147439_a(x, y, z + 1) == ModBlocks.excreta) {
                this.fermentate(world, x, y, z + 1, random);
            }
            if (world.func_147439_a(x - 1, y, z) == ModBlocks.excreta) {
                this.fermentate(world, x - 1, y, z, random);
            }
            if (world.func_147439_a(x, y - 1, z) == ModBlocks.excreta) {
                this.fermentate(world, x, y - 1, z, random);
            }
            if (world.func_147439_a(x, y, z - 1) == ModBlocks.excreta) {
                this.fermentate(world, x, y, z - 1, random);
            }
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityFallingBlock && ((EntityFallingBlock)entity).func_145805_f().equals((Object)this) && ((EntityFallingBlock)entity).field_145812_b > 1 && !entity.field_70128_L) {
            entity.func_70106_y();
            int metaBot = world.func_72805_g(x, y, z);
            int metaTop = ((EntityFallingBlock)entity).field_145814_a;
            this.stackBlock(world, x, y, z, metaTop, metaBot, false);
        } else {
            super.func_149670_a(world, x, y, z, entity);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float posX, float posY, float posZ) {
        int meta = world.func_72805_g(x, y, z);
        if (BlockExcreta.getNumberOfExcreta(meta) + BlockExcreta.getNumberOfManure(meta) >= 4) {
            return false;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b().equals(ItemBlock.func_150898_a((Block)this))) {
            if (!player.field_71075_bZ.field_75098_d) {
                --player.func_71045_bC().field_77994_a;
                if (player.func_71045_bC().field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            }
            world.func_72921_c(x, y, z, BlockExcreta.getMetaOfExcretaAndManure(BlockExcreta.getNumberOfExcreta(meta) + 1, BlockExcreta.getNumberOfManure(meta)), 2);
            world.func_147444_c(x, y, z, (Block)this);
            return true;
        }
        return false;
    }

    private void stackBlock(World world, int x, int y, int z, int metaTop, int metaBot, boolean deleteTopBlock) {
        int botExc = BlockExcreta.getNumberOfExcreta(metaBot);
        int botMan = BlockExcreta.getNumberOfManure(metaBot);
        int topExc = BlockExcreta.getNumberOfExcreta(metaTop);
        int topMan = BlockExcreta.getNumberOfManure(metaTop);
        if (botExc + botMan + topExc + topMan <= 4) {
            if (deleteTopBlock) {
                world.func_147468_f(x, y + 1, z);
            }
            world.func_72921_c(x, y, z, BlockExcreta.getMetaOfExcretaAndManure(botExc + topExc, botMan + topMan), 2);
            if (botExc + topExc != botExc || botMan + topMan != botMan) {
                world.func_147444_c(x, y, z, (Block)this);
            }
        } else if (botMan + topMan <= 4) {
            world.func_147465_d(x, y + 1, z, (Block)this, BlockExcreta.getMetaOfExcretaAndManure(botExc + botMan + topExc + topMan - 4, 0), 2);
            if (botExc + botMan + topExc + topMan - 4 != topExc || 0 != topMan) {
                world.func_147444_c(x, y + 1, z, (Block)this);
            }
            world.func_72921_c(x, y, z, BlockExcreta.getMetaOfExcretaAndManure(4 - botMan - topMan, botMan + topMan), 2);
            if (4 - botMan - topMan != botExc || botMan + topMan != botMan) {
                world.func_147444_c(x, y, z, (Block)this);
            }
        } else {
            world.func_147465_d(x, y + 1, z, (Block)this, BlockExcreta.getMetaOfExcretaAndManure(botExc + topExc, botMan + topMan - 4), 2);
            if (botExc + topExc != topExc || botMan + topMan - 4 != topMan) {
                world.func_147444_c(x, y + 1, z, (Block)this);
            }
            world.func_72921_c(x, y, z, BlockExcreta.getMetaOfExcretaAndManure(0, 4), 2);
            if (0 != botExc || 4 != botMan) {
                world.func_147444_c(x, y, z, (Block)this);
            }
        }
    }

    private void func_149830_m(World p_149830_1_, int p_149830_2_, int p_149830_3_, int p_149830_4_) {
        if (BlockExcreta.func_149831_e((World)p_149830_1_, (int)p_149830_2_, (int)(p_149830_3_ - 1), (int)p_149830_4_) && p_149830_3_ >= 0) {
            int b0 = 32;
            if (!field_149832_M && p_149830_1_.func_72904_c(p_149830_2_ - b0, p_149830_3_ - b0, p_149830_4_ - b0, p_149830_2_ + b0, p_149830_3_ + b0, p_149830_4_ + b0)) {
                if (!p_149830_1_.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(p_149830_1_, (double)((float)p_149830_2_ + 0.5f), (double)((float)p_149830_3_ + 0.5f), (double)((float)p_149830_4_ + 0.5f), (Block)this, p_149830_1_.func_72805_g(p_149830_2_, p_149830_3_, p_149830_4_));
                    this.func_149829_a(entityfallingblock);
                    p_149830_1_.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                p_149830_1_.func_147468_f(p_149830_2_, p_149830_3_, p_149830_4_);
                while (BlockExcreta.func_149831_e((World)p_149830_1_, (int)p_149830_2_, (int)(p_149830_3_ - 1), (int)p_149830_4_) && p_149830_3_ > 0) {
                    --p_149830_3_;
                }
                if (p_149830_3_ > 0) {
                    p_149830_1_.func_147449_b(p_149830_2_, p_149830_3_, p_149830_4_, (Block)this);
                }
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public static int getNumberOfManure(int meta) {
        return metaToManure[meta];
    }

    public static int getNumberOfExcreta(int meta) {
        return metaToExcreta[meta];
    }

    public static int getMetaOfExcretaAndManure(int exc, int man) {
        if (exc + man > 4 || exc + man <= 0) {
            return -1;
        }
        switch (exc) {
            case 0: {
                return man - 1;
            }
            case 1: {
                return man + 4;
            }
            case 2: {
                return man + 8;
            }
            case 3: {
                return man + 11;
            }
            case 4: {
                return man + 13;
            }
        }
        return 0;
    }
}

