/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.wildlife.util;

import com.draco18s.hardlib.HashUtils;
import com.draco18s.hardlib.api.internal.ChunkCoordTriplet;
import com.draco18s.wildlife.WildlifeBase;
import com.draco18s.wildlife.WildlifeEventHandler;
import com.draco18s.wildlife.util.Tree;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class TreeDataHooks {
    private static ConcurrentHashMap<ChunkCoordTriplet, ArrayList<Tree>> treeList = new ConcurrentHashMap();
    private static ConcurrentHashMap<ChunkCoordTriplet, Integer> chunksToScan = new ConcurrentHashMap();
    private static final int VERSION = 2;
    private static ArrayList<Block> logBlocks;
    private static Random rand;
    private static boolean bbb;
    public static int treeLifeMultiplier;
    public static int treeMaxAge;
    private static ArrayList<DeadTree> treesToKill;
    private static int treesKillThistick;
    private static int recursionDepth;

    public static void addChunkForScan(World world, int cx, int cz) {
        ChunkCoordTriplet key = new ChunkCoordTriplet(world.field_73011_w.field_76574_g, cx, 0, cz);
        chunksToScan.put(key, 0);
    }

    public static void readData(World world, int cx, int cz, NBTTagCompound data) {
        ChunkCoordTriplet key = new ChunkCoordTriplet(world.field_73011_w.field_76574_g, cx, 0, cz);
        if (data.func_74764_b("WildlifeTreeData")) {
            Tree t;
            NBTTagCompound snbt;
            int i;
            NBTTagCompound honbt = data.func_74775_l("WildlifeTreeData");
            ArrayList<Tree> value = new ArrayList<Tree>();
            int max = honbt.func_74762_e("numtrees");
            for (i = 0; i < max; ++i) {
                if (!honbt.func_74764_b("tree_" + i)) continue;
                snbt = (NBTTagCompound)honbt.func_74781_a("tree_" + i);
                t = new Tree(snbt.func_74762_e("x"), snbt.func_74762_e("y"), snbt.func_74762_e("z"), snbt.func_74762_e("age"));
                value.add(t);
            }
            if (value.size() > 0) {
                treeList.put(key, value);
            }
            if (honbt.func_74764_b("numdeadtrees")) {
                max = honbt.func_74762_e("numdeadtrees");
                for (i = 0; i < max; ++i) {
                    if (!honbt.func_74764_b("deadtree_" + i)) continue;
                    snbt = (NBTTagCompound)honbt.func_74781_a("deadtree_" + i);
                    t = new Tree(snbt.func_74762_e("x"), snbt.func_74762_e("y"), snbt.func_74762_e("z"), snbt.func_74762_e("age"));
                    int dim = snbt.func_74762_e("d");
                    DeadTree dt = new DeadTree(DimensionManager.getProvider((int)dim).field_76579_a, t);
                    if (treesToKill.contains(dt)) continue;
                    treesToKill.add(dt);
                }
            }
            if (honbt.func_74764_b("version")) {
                int v = honbt.func_74762_e("version");
                if (v < 2 && WildlifeEventHandler.trackTrees) {
                    WildlifeBase.logger.log(Level.INFO, "Chunk " + key + " has old tree data version number (" + v + "), current is " + 2 + ".  It will be rescanned for additional trees.  Chunks way out on the edge of the world may not save and cause this message to repeat next launch; do not be alarmed.");
                    chunksToScan.put(key, 0);
                }
            } else {
                WildlifeBase.logger.log(Level.INFO, "Chunk " + key + " is missing tree data version number.  This is likely because it has none, but it will be rescanned to make sure.  Chunks way out on the edge of the world may not save and cause this message to repeat next launch; do not be alarmed.");
                chunksToScan.put(key, 0);
            }
        }
    }

    public static void saveData(World world, int cx, int cz, NBTTagCompound data) {
        NBTTagCompound snbt;
        int i;
        ChunkCoordTriplet key = new ChunkCoordTriplet(world.field_73011_w.field_76574_g, cx, 0, cz);
        NBTTagCompound honbt = new NBTTagCompound();
        ArrayList<Tree> value = treeList.get(key);
        if (value != null) {
            i = 0;
            for (Tree t : value) {
                snbt = new NBTTagCompound();
                if (t.approximateAge > 10000) continue;
                snbt.func_74768_a("x", t.x);
                snbt.func_74768_a("y", t.y);
                snbt.func_74768_a("z", t.z);
                snbt.func_74768_a("age", t.approximateAge);
                honbt.func_74782_a("tree_" + i, (NBTBase)snbt);
                ++i;
            }
            honbt.func_74768_a("numtrees", i);
        }
        if (!world.func_72964_e((int)cx, (int)cz).field_76636_d) {
            treeList.remove(key);
        }
        if (treesToKill.size() > 0) {
            i = 0;
            for (DeadTree dt : treesToKill) {
                if (dt.world != world || ((DeadTree)dt).tree.x >> 4 != cx || ((DeadTree)dt).tree.z >> 4 != cz) continue;
                snbt = new NBTTagCompound();
                snbt.func_74768_a("x", ((DeadTree)dt).tree.x);
                snbt.func_74768_a("y", ((DeadTree)dt).tree.y);
                snbt.func_74768_a("z", ((DeadTree)dt).tree.z);
                snbt.func_74768_a("d", ((DeadTree)dt).world.field_73011_w.field_76574_g);
                snbt.func_74768_a("age", ((DeadTree)dt).tree.approximateAge);
                honbt.func_74782_a("deadtree_" + i, (NBTBase)snbt);
            }
            honbt.func_74768_a("numdeadtrees", i);
        }
        honbt.func_74768_a("version", 2);
        data.func_74782_a("WildlifeTreeData", (NBTBase)honbt);
    }

    public static void addTree(World world, int x, int y, int z, int age) {
        Tree t;
        Chunk chunk = world.func_72938_d(x, z);
        int cx = chunk.field_76635_g;
        int cz = chunk.field_76647_h;
        ChunkCoordTriplet key = new ChunkCoordTriplet(world.field_73011_w.field_76574_g, cx, 0, cz);
        ArrayList<Tree> treesl = treeList.get(key);
        if (treesl == null) {
            treesl = new ArrayList();
            treeList.put(key, treesl);
        }
        if (age < 0) {
            age = rand.nextInt(treeMaxAge);
        }
        if (treesl.indexOf(t = new Tree(x, y - 1, z, age)) == -1) {
            treesl.add(t);
        }
    }

    public static void ageTrees(World world) {
        if (logBlocks == null) {
            logBlocks = new ArrayList();
            logBlocks.add(Blocks.field_150364_r);
            logBlocks.add(Blocks.field_150363_s);
        }
        if (treesToKill.size() > 0) {
            ArrayList<DeadTree> deds = new ArrayList<DeadTree>();
            ListIterator<DeadTree> it = treesToKill.listIterator();
            while (treesKillThistick < 1500 && it.hasNext()) {
                DeadTree dt = it.next();
                TreeDataHooks.killTree(dt.world, dt.tree, it);
                deds.add(dt);
            }
            treesToKill.removeAll(deds);
        }
        if (!chunksToScan.isEmpty()) {
            Iterator itt = chunksToScan.keySet().iterator();
            while (itt.hasNext()) {
                ChunkCoordTriplet cht = (ChunkCoordTriplet)itt.next();
                if (cht.dimID != world.field_73011_w.field_76574_g) continue;
                Chunk ch = world.func_72964_e(cht.posX, cht.posZ);
                if (!ch.field_76636_d || !world.func_72873_a(cht.posX * 16, 0, cht.posZ * 16, 16)) continue;
                WildlifeBase.treeCounter.rescan(ch.field_76635_g, ch.field_76647_h, world);
                itt.remove();
            }
        }
        if (world.func_82737_E() % (long)treeLifeMultiplier > 0L) {
            return;
        }
        int numTrees = 0;
        treesKillThistick = 0;
        for (ChunkCoordTriplet cct : treeList.keySet()) {
            if (cct.dimID != world.field_73011_w.field_76574_g || !world.func_72873_a(cct.posX * 16, cct.posY, cct.posZ * 16, 32)) continue;
            ArrayList<Tree> list = treeList.get(cct);
            Iterator<Tree> it = list.iterator();
            while (it.hasNext()) {
                ++numTrees;
                Tree t = it.next();
                Block blo = world.func_147439_a(t.x, t.y + 1, t.z);
                if (blo == Blocks.field_150345_g) continue;
                if (logBlocks.indexOf(blo) == -1) {
                    it.remove();
                    continue;
                }
                ++t.approximateAge;
                if (t.approximateAge >= treeMaxAge) {
                    TreeDataHooks.killTree(world, t, null);
                    it.remove();
                }
                if (blo == Blocks.field_150364_r && world.func_72805_g(t.x, t.y + 1, t.z) == 3 && t.approximateAge % 2000 == 100 && t.approximateAge < 7000) {
                    if (rand.nextInt(4) == 0) {
                        TreeDataHooks.growPod(world, t, 4);
                    }
                    if (rand.nextInt(4) == 0) {
                        TreeDataHooks.growPod(world, t, 5);
                    }
                    if (rand.nextInt(4) == 0) {
                        TreeDataHooks.growPod(world, t, 6);
                    }
                    if (rand.nextInt(4) == 0) {
                        TreeDataHooks.growPod(world, t, 8);
                    }
                    if (rand.nextInt(4) == 0) {
                        TreeDataHooks.growPod(world, t, 10);
                    }
                    if (rand.nextInt(4) == 0) {
                        TreeDataHooks.growPod(world, t, 16);
                    }
                    if (rand.nextInt(4) == 0) {
                        TreeDataHooks.growPod(world, t, 24);
                    }
                    if (rand.nextInt(4) == 0) {
                        TreeDataHooks.growPod(world, t, 32);
                    }
                }
                blo = world.func_147439_a(t.x, t.y, t.z);
                if (!WildlifeEventHandler.doNativeTreeKill || blo == Blocks.field_150349_c || blo == Blocks.field_150346_d) continue;
                t.approximateAge = Math.max(treeMaxAge - 2, t.approximateAge);
            }
        }
    }

    private static void growPod(World world, Tree t, int offY) {
        if (world.func_147439_a(t.x, t.y + offY, t.z) != Blocks.field_150364_r) {
            return;
        }
        ForgeDirection d = ForgeDirection.VALID_DIRECTIONS[rand.nextInt(4) + 2];
        int m = -1;
        switch (d) {
            case NORTH: {
                m = 0;
                break;
            }
            case EAST: {
                m = 1;
                break;
            }
            case SOUTH: {
                m = 2;
                break;
            }
            case WEST: {
                m = 3;
                break;
            }
        }
        Block b = world.func_147439_a(t.x + d.offsetX, t.y + offY, t.z + d.offsetZ);
        if (b == Blocks.field_150350_a || b == Blocks.field_150395_bd) {
            world.func_147465_d(t.x + d.offsetX, t.y + offY, t.z + d.offsetZ, Blocks.field_150375_by, m, 3);
        } else if (b == Blocks.field_150364_r && world.func_72805_g(t.x + d.offsetX, t.y + offY, t.z + d.offsetZ) == 3 && ((b = world.func_147439_a(t.x + d.offsetX * 2, t.y + offY, t.z + d.offsetZ * 2)) == Blocks.field_150350_a || b == Blocks.field_150395_bd)) {
            world.func_147465_d(t.x + d.offsetX * 2, t.y + offY, t.z + d.offsetZ * 2, Blocks.field_150375_by, m, 3);
        }
    }

    public static void itemKillTree(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != world.func_147439_a(x, y - 1, z)) {
            Tree t = new Tree(x, y - 1, z, 0);
            TreeDataHooks.killTree(world, t, null);
        }
    }

    private static void killTree(World world, Tree t, ListIterator it) {
        recursionDepth = 0;
        TreeDataHooks.killTreeDo(world, t, it);
    }

    private static void killTreeDo(World world, Tree t, ListIterator it) {
        if (treesKillThistick < 2000 && ++recursionDepth < 35) {
            TreeDataHooks.killTreeDo_do(world, t, it);
        } else {
            DeadTree ded = new DeadTree(world, t);
            if (it == null && treesToKill.indexOf(ded) == -1) {
                treesToKill.add(ded);
            } else if (treesToKill.indexOf(ded) == -1) {
                it.add(ded);
            }
        }
        --recursionDepth;
    }

    private static void killTreeDo_do(World world, Tree t, ListIterator it) {
        DeadTree ded;
        Tree ttt;
        int oz;
        int ox;
        int y;
        for (y = t.y + 1; y < 255 && logBlocks.indexOf(world.func_147439_a(t.x, y, t.z)) >= 0; ++y) {
            world.func_147449_b(t.x, y, t.z, WildlifeBase.rottingWood);
            ++treesKillThistick;
            for (ox = -1; ox <= 1; ++ox) {
                for (oz = -1; oz <= 1; ++oz) {
                    if (ox == 0 && oz == 0 || logBlocks.indexOf(world.func_147439_a(t.x + ox, y, t.z + oz)) < 0 || logBlocks.indexOf(world.func_147439_a(t.x + ox, y - 1, t.z + oz)) != -1) continue;
                    ttt = new Tree(t.x + ox, y - 1, t.z + oz, t.approximateAge);
                    ded = new DeadTree(world, ttt);
                    if (it == null && treesToKill.indexOf(ded) == -1) {
                        treesToKill.add(ded);
                        continue;
                    }
                    if (treesToKill.indexOf(ded) != -1) continue;
                    it.add(ded);
                }
            }
        }
        for (ox = -1; ox <= 1; ++ox) {
            for (oz = -1; oz <= 1; ++oz) {
                if (ox == 0 && oz == 0 || logBlocks.indexOf(world.func_147439_a(t.x + ox, y, t.z + oz)) < 0 || logBlocks.indexOf(world.func_147439_a(t.x + ox, y - 1, t.z + oz)) != -1) continue;
                ttt = new Tree(t.x + ox, y - 1, t.z + oz, t.approximateAge);
                ded = new DeadTree(world, ttt);
                if (it == null && treesToKill.indexOf(ded) == -1) {
                    treesToKill.add(ded);
                    continue;
                }
                if (treesToKill.indexOf(ded) != -1) continue;
                it.add(ded);
            }
        }
    }

    public static void printChunkInfo(EntityPlayer p, Chunk chunk) {
        ChunkCoordTriplet cct = new ChunkCoordTriplet(chunk.field_76637_e.field_73011_w.field_76574_g, chunk.field_76635_g, 0, chunk.field_76647_h);
        ArrayList<Tree> treesHere = treeList.get(cct);
        ChatComponentText chat = new ChatComponentText("Trees in chunk " + cct);
        p.func_145747_a((IChatComponent)chat);
        if (treesHere != null && treesHere.size() > 0) {
            for (Tree t : treesHere) {
                chat = new ChatComponentText("   " + t);
                p.func_145747_a((IChatComponent)chat);
            }
        } else {
            chat = new ChatComponentText("   [None]");
            p.func_145747_a((IChatComponent)chat);
        }
    }

    static {
        rand = new Random();
        bbb = false;
        treesToKill = new ArrayList();
    }

    private static class DeadTree {
        private Tree tree;
        private World world;

        private DeadTree(World w, Tree t) {
            this.tree = t;
            this.world = w;
        }

        public int hashCode() {
            int h = HashUtils.firstTerm((int)23);
            h = HashUtils.hash((int)h, (int)((int)this.world.func_72905_C()));
            h = HashUtils.hash((int)h, (int)this.tree.x);
            h = HashUtils.hash((int)h, (int)this.tree.y);
            h = HashUtils.hash((int)h, (int)this.tree.z);
            return h;
        }

        public boolean equals(Object o) {
            if (o instanceof DeadTree) {
                DeadTree ot = (DeadTree)o;
                return this.tree.x == ot.tree.x && this.tree.y == ot.tree.y && this.tree.z == ot.tree.z && this.world == ot.world;
            }
            return false;
        }
    }
}

