/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.wildlife.util;

import com.draco18s.wildlife.WildlifeEventHandler;
import com.draco18s.wildlife.util.TreeDataHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TreeCountGenerator {
    private List<Block> logBlockList = new ArrayList<Block>();
    private List<Block> dirtBlockList = new ArrayList<Block>();

    public TreeCountGenerator() {
        this.logBlockList.add(Blocks.field_150364_r);
        this.logBlockList.add(Blocks.field_150363_s);
        this.dirtBlockList.add(Blocks.field_150346_d);
        this.dirtBlockList.add((Block)Blocks.field_150349_c);
    }

    public void addLogType(Block b) {
        this.logBlockList.add(b);
    }

    public void addDirtType(Block b) {
        this.dirtBlockList.add(b);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = world.field_73011_w.func_76557_i() / 2; y < world.field_73011_w.func_76557_i() + 150; ++y) {
                    Block b = chunk.func_150810_a(x, y, z);
                    if (this.logBlockList.indexOf(b) < 0) continue;
                    Block b2 = chunk.func_150810_a(x, y - 1, z);
                    if (WildlifeEventHandler.doNativeTreeKill && b2 != Blocks.field_150350_a) {
                        if (x > 0 && x < 15 && z > 0 && z < 15) {
                            if (b2 == chunk.func_150810_a(x + 1, y - 1, z) || b2 == chunk.func_150810_a(x - 1, y - 1, z) || b2 == chunk.func_150810_a(x, y - 1, z + 1) || b2 == chunk.func_150810_a(x, y - 1, z - 1)) {
                                b2 = Blocks.field_150346_d;
                            }
                        } else if (b2 == world.func_147439_a(x + 1, y - 1, z) || b2 == world.func_147439_a(x - 1, y - 1, z) || b2 == world.func_147439_a(x, y - 1, z + 1) || b2 == world.func_147439_a(x, y - 1, z - 1)) {
                            b2 = Blocks.field_150346_d;
                        }
                    }
                    if (this.dirtBlockList.indexOf(b2) < 0) continue;
                    if (x > 0 && x < 15 && z > 0 && z < 15) {
                        if (chunk.func_150810_a(x + 1, y, z + 1) == Blocks.field_150458_ak || chunk.func_150810_a(x - 1, y, z - 1) == Blocks.field_150458_ak || chunk.func_150810_a(x + 1, y, z - 1) == Blocks.field_150458_ak || chunk.func_150810_a(x - 1, y, z + 1) == Blocks.field_150458_ak) continue;
                        TreeDataHooks.addTree(world, chunkX * 16 + x, y, chunkZ * 16 + z, -1);
                        continue;
                    }
                    if (world.func_147439_a(chunkX * 16 + x + 1, y, chunkZ * 16 + z + 1) == Blocks.field_150458_ak || world.func_147439_a(chunkX * 16 + x - 1, y, chunkZ * 16 + z - 1) == Blocks.field_150458_ak || world.func_147439_a(chunkX * 16 + x + 1, y, chunkZ * 16 + z - 1) == Blocks.field_150458_ak || world.func_147439_a(chunkX * 16 + x - 1, y, chunkZ * 16 + z + 1) == Blocks.field_150458_ak) continue;
                    TreeDataHooks.addTree(world, chunkX * 16 + x, y, chunkZ * 16 + z, -1);
                }
            }
        }
    }

    public void rescan(int chunkX, int chunkZ, World world) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = world.field_73011_w.func_76557_i() / 2; y < world.field_73011_w.func_76557_i() + 150; ++y) {
                    Block b = chunk.func_150810_a(x, y, z);
                    if (this.logBlockList.indexOf(b) < 0) continue;
                    Block b2 = chunk.func_150810_a(x, y - 1, z);
                    if (WildlifeEventHandler.doNativeTreeKill && b2 != Blocks.field_150350_a && this.logBlockList.indexOf(b2) == -1) {
                        b2 = Blocks.field_150346_d;
                    }
                    if (b2 != Blocks.field_150346_d && b2 != Blocks.field_150349_c) continue;
                    if (x > 0 && x < 15 && z > 0 && z < 15) {
                        if (chunk.func_150810_a(x + 1, y, z + 1) == Blocks.field_150458_ak || chunk.func_150810_a(x - 1, y, z - 1) == Blocks.field_150458_ak || chunk.func_150810_a(x + 1, y, z - 1) == Blocks.field_150458_ak || chunk.func_150810_a(x - 1, y, z + 1) == Blocks.field_150458_ak) continue;
                        TreeDataHooks.addTree(world, chunkX * 16 + x, y, chunkZ * 16 + z, -1);
                        continue;
                    }
                    if (world.func_147439_a(chunkX * 16 + x + 1, y, chunkZ * 16 + z + 1) == Blocks.field_150458_ak || world.func_147439_a(chunkX * 16 + x - 1, y, chunkZ * 16 + z - 1) == Blocks.field_150458_ak || world.func_147439_a(chunkX * 16 + x + 1, y, chunkZ * 16 + z - 1) == Blocks.field_150458_ak || world.func_147439_a(chunkX * 16 + x - 1, y, chunkZ * 16 + z + 1) == Blocks.field_150458_ak) continue;
                    TreeDataHooks.addTree(world, chunkX * 16 + x, y, chunkZ * 16 + z, -1);
                }
            }
        }
    }
}

