/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.wildlife.util;

import com.draco18s.hardlib.api.interfaces.IAnimals;
import com.draco18s.wildlife.WildlifeBase;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class AnimalUtil
implements IAnimals {
    public static int animalMaxAge;
    public static int grassFrequency;
    public static int noFoodAgeAmount;
    public static int animalGlobalAgeRate;
    private HashMap<Class<? extends EntityAnimal>, Integer> ageRates = new HashMap();
    private ArrayList<Class<? extends EntityAnimal>> herbivores = new ArrayList();
    private ArrayList<Class<? extends EntityAnimal>> immortals = new ArrayList();
    private ImmutableSet<ClassPath.ClassInfo> classesInPassive;

    public AnimalUtil() {
        ClassLoader classloader = ClassLoader.getSystemClassLoader();
        try {
            ClassPath p = ClassPath.from((ClassLoader)classloader);
            this.classesInPassive = p.getTopLevelClasses("net.minecraft.entity.passive");
        }
        catch (IOException e) {
            this.classesInPassive = null;
        }
    }

    public void addHerbivore(Class<? extends EntityAnimal> animal) {
        this.herbivores.add(animal);
    }

    public boolean isHerbivore(Class<? extends EntityAnimal> animal) {
        return this.herbivores.contains(animal);
    }

    public void addUnaging(Class<? extends EntityAnimal> animal) {
        this.immortals.add(animal);
    }

    public boolean isUnaging(Class<? extends EntityAnimal> animal) {
        return this.immortals.contains(animal);
    }

    public void addAgeSpeed(Class<? extends EntityAnimal> animal, int rate) {
        this.ageRates.put(animal, rate);
    }

    public int getAgeSpeed(Class<? extends EntityAnimal> animal) {
        if (this.ageRates.containsKey(animal)) {
            return this.ageRates.get(animal);
        }
        return 2;
    }

    public void parseConfig(Configuration config) {
        animalGlobalAgeRate = config.getInt("GlobalAgeRate", "ANIMALS", 1, 0, 10, "This is a global aging rate.  It causes animals to age more quickly or not at all.\n");
        Property listOfAnimals = config.get("ANIMALS", "AcceleratedAging", new String[]{"Chicken"}, "List of animals with special age scaling.\nAnimal is looked up by class name, capitalize first letter.\nYou must pass a fully qualified class name for mod animals (JD Gui can help locate that).\nDefault age for all unspecified animals is 2.\n");
        String[] list = listOfAnimals.getStringList();
        config.getInt("AgeFactorChicken", "ANIMALS", 3, 0, 100, "Lower's Chickens maximum age by this factor (maxAge = defaultMaxAge / ageFactor).\n");
        grassFrequency = config.getInt("HerbivoreEatFrequency", "ANIMALS", 3000, 100, 20000, "How often herbivores will kill a block of grass or leaves, in ticks, reducing food supply.\n");
        noFoodAgeAmount = config.getInt("HerbivoreStarveFactor", "ANIMALS", 50, 10, 2000, "How much 'older' herbivores get when there is no food nearby, in ticks.\n");
        for (String s : list) {
            if (s.indexOf(".") >= 0) {
                String[] st = s.split("\\.");
                String s2 = st[st.length - 1];
                int speed = config.getInt("AgeFactor" + s2, "ANIMALS", 2, 0, 100, "Lower's " + s2 + " maximum age by this factor (maxAge = defaultMaxAge / ageFactor).\n");
                try {
                    Class<?> clz = Class.forName(s);
                    this.addAgeSpeed(clz, speed);
                }
                catch (Exception e) {
                    ImmutableSet classes;
                    WildlifeBase.logger.log(Level.ERROR, "No mod entity found for " + s);
                    ClassLoader classloader = ClassLoader.getSystemClassLoader();
                    String st2 = "";
                    for (int si = 0; si < st.length - 1; ++si) {
                        st2 = st2 + st[si];
                        if (si == st.length - 2) continue;
                        st2 = st2 + ".";
                    }
                    try {
                        ClassPath p = ClassPath.from((ClassLoader)classloader);
                        classes = p.getTopLevelClasses(st2);
                    }
                    catch (IOException e2) {
                        classes = null;
                    }
                    if (classes != null) {
                        for (ClassPath.ClassInfo info : classes) {
                            String i = info.getSimpleName().substring(6);
                            int ld = AnimalUtil.LevenshteinDistance(s, s.length(), i, i.length());
                            if (ld > Math.max(i.length() / 3, 5)) continue;
                            WildlifeBase.logger.log(Level.INFO, "Did you perhaps mean '" + i + "'?");
                        }
                        continue;
                    }
                    WildlifeBase.logger.log(Level.INFO, "Unable to get top level class names for " + st2 + ", check your spelling.");
                }
            }
            int speed = config.getInt("AgeFactor" + s, "ANIMALS", 2, 0, 100, "Lower's " + s + " maximum age by this factor (maxAge = defaultMaxAge / ageFactor).\n");
            try {
                Class<?> clz = Class.forName("net.minecraft.entity.passive.Entity" + s);
                this.addAgeSpeed(clz, speed);
            }
            catch (ClassNotFoundException e) {
                WildlifeBase.logger.log(Level.ERROR, "No entity found for " + s);
                if (this.classesInPassive == null) continue;
                for (ClassPath.ClassInfo info : this.classesInPassive) {
                    String i = info.getSimpleName().substring(6);
                    int ld = AnimalUtil.LevenshteinDistance(s, s.length(), i, i.length());
                    if (ld > Math.max(i.length() / 3, 5)) continue;
                    WildlifeBase.logger.log(Level.INFO, "Did you perhaps mean '" + i + "'?");
                }
            }
        }
        listOfAnimals = config.get("ANIMALS", "AnimalIsHerbivore", new String[0], "List of mod-added animals which should be treated as herbivores.\nYou must use fully qualified names.\nNote that some animals may extend from vanilla classes; these will already be handled.\n");
        for (String s : list = listOfAnimals.getStringList()) {
            if (s.indexOf(".") < 0) continue;
            try {
                Class<?> clz = Class.forName(s);
                this.addHerbivore(clz);
            }
            catch (Exception e) {
                WildlifeBase.logger.log(Level.ERROR, "No mod entity found for " + s);
            }
        }
        config.addCustomCategoryComment("ANIMALS", "Fully qualified class names include the full package declaration; e.g. com.draco18s.wildlife.entity.EntityGoat\nString lists have 1 entry per line with no commas. Eg:\n    S:AcceleratedAging <\n        Chicken\n        com.draco18s.wildlife.entity.EntityGoat\n     >");
        config.save();
    }

    private static int LevenshteinDistance(String s, int len_s, String t, int len_t) {
        int cost = -1;
        if (len_s == 0) {
            return len_t;
        }
        if (len_t == 0) {
            return len_s;
        }
        cost = s.charAt(len_s - 1) == t.charAt(len_t - 1) ? 0 : 1;
        return AnimalUtil.minimum(AnimalUtil.LevenshteinDistance(s, len_s - 1, t, len_t) + 1, AnimalUtil.LevenshteinDistance(s, len_s, t, len_t - 1) + 1, AnimalUtil.LevenshteinDistance(s, len_s - 1, t, len_t - 1) + cost);
    }

    private static int minimum(int i, int j, int k) {
        int a = Math.min(i, j);
        int b = Math.min(j, k);
        return Math.min(a, b);
    }
}

