/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.wildlife.item;

import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.internal.CropWeatherOffsets;
import com.draco18s.wildlife.WildlifeEventHandler;
import com.draco18s.wildlife.client.ClientProxy;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class ItemRainMeter
extends Item {
    public ItemRainMeter() {
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77655_b("rainmeter");
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconReg) {
        this.field_77791_bV = ClientProxy.rainmeter;
        for (int f = 0; f < 8; ++f) {
            ClientProxy.rainmeterNBT[f] = iconReg.func_94245_a("wildlife:humid_" + f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return ClientProxy.rainmeter;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        if (stack.field_77990_d != null) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            int dimID = world.field_73011_w.field_76574_g;
            long lwt = WildlifeEventHandler.getLastWorldTime(dimID);
            stack.field_77990_d.func_74772_a("updateTime", lwt);
            int n = 0;
            int x = (int)Minecraft.func_71410_x().field_71439_g.field_70165_t;
            int y = (int)Minecraft.func_71410_x().field_71439_g.field_70163_u;
            int z = (int)Minecraft.func_71410_x().field_71439_g.field_70161_v;
            BiomeGenBase bio = world.func_72807_a(x, z);
            float r = bio.field_76751_G;
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                r += WildlifeEventHandler.getSeasonRain(lwt) * 0.333f;
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) != world.func_72874_g(x, z) > y) {
                r = (r + 1.0f) / 2.0f;
            }
            CropWeatherOffsets offs = HardLibAPI.cropManager.getCropOffsets(Block.func_149729_e((int)stack.field_77990_d.func_74762_e("blockID")));
            if (offs.rainTimeOffset != 0) {
                r = r - WildlifeEventHandler.getSeasonRain(lwt) + WildlifeEventHandler.getSeasonRain(lwt + (long)offs.rainTimeOffset);
            }
            n = Math.round(((r += offs.rainFlat) - 0.575f) * 8.0f);
            n = 7 - Math.max(Math.min(n, 7), 0);
            stack.field_77990_d.func_74768_a("saved", n);
            return ClientProxy.rainmeterNBT[n];
        }
        return this.func_77617_a(0);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer p, World world, int x, int y, int z, int side, float hitx, float hity, float hitz) {
        Block b = p.field_70170_p.func_147439_a(x, y, z);
        if (HardLibAPI.cropManager.isCropBlock(b)) {
            NBTTagCompound tag = stack.field_77990_d;
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74768_a("blockID", Block.func_149682_b((Block)b));
            tag.func_74772_a("updateTime", -1000L);
            Item item = Item.func_150898_a((Block)b);
            if (b == Blocks.field_150464_aj) {
                item = Items.field_151015_O;
            }
            if (b == Blocks.field_150393_bb) {
                item = Item.func_150898_a((Block)Blocks.field_150423_aK);
            }
            if (b == Blocks.field_150394_bc) {
                item = Item.func_150898_a((Block)Blocks.field_150440_ba);
            }
            tag.func_74778_a("linkedCropName", StatCollector.func_74838_a((String)(item.func_77658_a() + ".name")));
            stack.field_77990_d = tag;
        } else {
            stack.field_77990_d = null;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        NBTTagCompound tag = stack.field_77990_d;
        if (tag != null) {
            tooltip.add(EnumChatFormatting.ITALIC + "Linked Crop: " + tag.func_74779_i("linkedCropName"));
            tooltip.add("Right click to unlink.");
        } else {
            tooltip.add("Right click on a crop to link.");
        }
    }
}

