/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.wildlife.entity.ai;

import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.wildlife.entity.EntityGoat;
import com.draco18s.wildlife.entity.ai.EntityAgeTracker;
import com.draco18s.wildlife.util.AnimalUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class EntityAIAging
extends EntityAIBase {
    private EntityAnimal entity;
    private Random rand;
    private Class species;
    private EntityAgeTracker age;

    public EntityAIAging(Random random, EntityAnimal ent, Class spec, EntityAgeTracker ageTracker) {
        this.rand = random;
        this.entity = ent;
        this.species = spec;
        this.age = ageTracker;
        this.age.ageFactor = HardLibAPI.animalManager.getAgeSpeed(ent.getClass());
    }

    public boolean func_75250_a() {
        return true;
    }

    public void func_75246_d() {
        if (this.age.deathAge <= 0) {
            this.age.entityAge = this.entity.getEntityData().func_74762_e("AnimalAge");
            this.age.deathAge = this.entity.getEntityData().func_74762_e("AnimalDeathAge");
            if (this.age.deathAge <= 0) {
                if (HardLibAPI.animalManager.isUnaging(this.entity.getClass())) {
                    this.age.entityAge = (int)((float)AnimalUtil.animalMaxAge * 2.5f) + 1000;
                    this.age.deathAge = this.age.entityAge * 5;
                } else {
                    this.age.entityAge = this.entity.func_70631_g_() ? 0 : 48000 + this.rand.nextInt(120000);
                    this.age.deathAge = (AnimalUtil.animalMaxAge + this.rand.nextInt(60000)) / this.age.ageFactor;
                }
            }
        }
        if (HardLibAPI.animalManager.isUnaging(this.entity.getClass())) {
            return;
        }
        this.age.entityAge += AnimalUtil.animalGlobalAgeRate;
        if (this.age.entityAge % 100 == 0) {
            this.entity.getEntityData().func_74768_a("AnimalAge", this.age.entityAge);
            this.entity.getEntityData().func_74768_a("AnimalDeathAge", this.age.deathAge);
        }
        if (this.age.entityAge > this.age.deathAge && this.entity.field_70172_ad <= 0) {
            this.entity.func_70097_a(DamageSource.field_82727_n, 0.5f);
            if (this.age.entityAge > this.age.deathAge + 1000 * this.age.ageFactor) {
                this.entity.func_70097_a(DamageSource.field_82727_n, 1.5f);
            }
            if (this.age.entityAge > this.age.deathAge + 10000 * this.age.ageFactor) {
                this.entity.func_70097_a(DamageSource.field_82727_n, 15.0f);
            }
        } else if (this.age.entityAge % 150 == 0) {
            List ents = this.entity.field_70170_p.func_72872_a(this.species, this.getAABB(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v));
            if (!this.entity.func_70880_s() && this.entity.func_70874_b() == 0) {
                if (ents.size() <= 5 && this.rand.nextInt(200) == 0) {
                    this.entity.func_146082_f(null);
                } else if (ents.size() <= 12 && this.rand.nextInt(450) == 0) {
                    this.entity.func_146082_f(null);
                } else if (this.rand.nextInt(600) == 0) {
                    this.entity.func_146082_f(null);
                }
            }
            if (ents.size() > 20) {
                this.age.deathAge = this.entity.func_70631_g_() ? (this.age.deathAge -= 2 * (ents.size() - 20)) : (this.age.deathAge -= 15 * (ents.size() - 20));
            }
            if (HardLibAPI.animalManager.isHerbivore(this.entity.getClass())) {
                Block b;
                boolean grassNear = false;
                Vec3 close = Vec3.func_72443_a((double)0.0, (double)-10.0, (double)0.0);
                Vec3 here = Vec3.func_72443_a((double)0.0, (double)-10.0, (double)0.0);
                Vec3 animpos = Vec3.func_72443_a((double)((int)this.entity.field_70165_t), (double)((int)this.entity.field_70163_u), (double)((int)this.entity.field_70161_v));
                int d = this.entity instanceof EntityGoat ? 9 : 3;
                int e = this.entity instanceof EntityGoat ? 4 : 2;
                for (int ox = (int)this.entity.field_70165_t - d; ox <= (int)this.entity.field_70165_t + d; ++ox) {
                    for (int oz = (int)this.entity.field_70161_v - d; oz <= (int)this.entity.field_70161_v + d; ++oz) {
                        for (int oy = (int)this.entity.field_70163_u - e; oy <= (int)this.entity.field_70163_u + e; ++oy) {
                            b = this.entity.field_70170_p.func_147439_a(ox, oy, oz);
                            if (b == Blocks.field_150349_c) {
                                here.field_72450_a = ox;
                                here.field_72448_b = oy;
                                here.field_72449_c = oz;
                                if (!(this.entity instanceof EntityGoat) || here.func_72438_d(animpos) < 5.0) {
                                    grassNear = true;
                                    if (here.func_72438_d(animpos) <= close.func_72438_d(animpos)) {
                                        close.field_72450_a = ox;
                                        close.field_72448_b = oy;
                                        close.field_72449_c = oz;
                                    }
                                }
                            }
                            if (this.entity instanceof EntityGoat) {
                                if (b == Blocks.field_150330_I || b == Blocks.field_150434_aF) {
                                    grassNear = true;
                                }
                                if (b == Blocks.field_150362_t || b == Blocks.field_150361_u) {
                                    grassNear = true;
                                    if (animpos.field_72448_b - (double)oy >= -2.0) {
                                        close.field_72450_a = ox;
                                        close.field_72448_b = oy;
                                        close.field_72449_c = oz;
                                    }
                                }
                            } else if (b == Blocks.field_150362_t || b == Blocks.field_150361_u) {
                                here.field_72450_a = ox;
                                here.field_72448_b = oy;
                                here.field_72449_c = oz;
                                grassNear = true;
                                if (here.func_72438_d(animpos) < close.func_72438_d(animpos)) {
                                    close.field_72450_a = ox;
                                    close.field_72448_b = oy;
                                    close.field_72449_c = oz;
                                }
                            }
                            if (!(this.entity instanceof EntityMooshroom) || b != Blocks.field_150391_bh) continue;
                            grassNear = true;
                            here.field_72450_a = ox;
                            here.field_72448_b = oy;
                            here.field_72449_c = oz;
                            if (!(here.func_72438_d(animpos) < close.func_72438_d(animpos))) continue;
                            close.field_72450_a = ox;
                            close.field_72448_b = oy;
                            close.field_72449_c = oz;
                        }
                    }
                }
                if (!grassNear) {
                    this.age.deathAge -= AnimalUtil.noFoodAgeAmount;
                } else {
                    this.entity.func_70691_i(1.0f);
                    if (this.age.entityAge % AnimalUtil.grassFrequency == 0 && close.field_72448_b >= 0.0) {
                        b = this.entity.field_70170_p.func_147439_a((int)close.field_72450_a, (int)close.field_72448_b, (int)close.field_72449_c);
                        if (b == Blocks.field_150362_t || b == Blocks.field_150361_u) {
                            this.entity.field_70170_p.func_147449_b((int)close.field_72450_a, (int)close.field_72448_b, (int)close.field_72449_c, Blocks.field_150350_a);
                        } else {
                            this.entity.field_70170_p.func_147449_b((int)close.field_72450_a, (int)close.field_72448_b, (int)close.field_72449_c, Blocks.field_150346_d);
                        }
                    }
                }
            }
        }
        EntityPlayer player = this.entity.field_70170_p.func_72890_a((Entity)this.entity, 32.0);
        if (this.entity.func_70880_s()) {
            List ents;
            if (player == null && this.rand.nextInt(100) == 0 && (ents = this.entity.field_70170_p.func_72872_a(this.species, this.getAABB(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v))).size() > 0) {
                EntityAnimal mate = null;
                for (Object obj : ents) {
                    EntityAnimal anim;
                    if (obj == this.entity || (anim = (EntityAnimal)obj) == this.entity || mate != null || !anim.func_70880_s()) continue;
                    mate = anim;
                }
                if (mate != null) {
                    this.procreate();
                    mate.func_70875_t();
                }
            }
        } else if (this.entity.func_70638_az() == null) {
            List ents;
            if (this.rand.nextInt(200) == 0 && (ents = this.entity.field_70170_p.func_72872_a(this.species, this.getAABB(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v))).size() > 0) {
                EntityAnimal animal = (EntityAnimal)ents.get(this.rand.nextInt(ents.size()));
                this.entity.func_70784_b((Entity)animal);
            }
        } else {
            EntityAnimal animal = (EntityAnimal)this.entity.func_70638_az();
            double dx = this.entity.field_70165_t - animal.field_70165_t;
            double dy = this.entity.field_70163_u - animal.field_70163_u;
            double dz = this.entity.field_70161_v - animal.field_70161_v;
            dx *= dx;
            if ((dx += (dy *= dy) + (dz *= dz)) < 100.0) {
                this.entity.func_70784_b(null);
            }
        }
    }

    private void procreate() {
        EntityAgeable entityageable = this.entity.func_90011_a((EntityAgeable)this.entity);
        if (entityageable != null) {
            this.entity.func_70873_a(6000);
            this.entity.func_70873_a(6000);
            this.entity.func_70875_t();
            entityageable.func_70873_a(-24000);
            entityageable.func_70012_b(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, this.entity.field_70177_z, this.entity.field_70125_A);
            for (int i = 0; i < 7; ++i) {
                double d0 = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                this.entity.field_70170_p.func_72869_a("heart", this.entity.field_70165_t + (double)(this.rand.nextFloat() * this.entity.field_70130_N * 2.0f) - (double)this.entity.field_70130_N, this.entity.field_70163_u + 0.5 + (double)(this.rand.nextFloat() * this.entity.field_70131_O), this.entity.field_70161_v + (double)(this.rand.nextFloat() * this.entity.field_70130_N * 2.0f) - (double)this.entity.field_70130_N, d0, d1, d2);
            }
            this.entity.field_70170_p.func_72838_d((Entity)entityageable);
        }
    }

    private AxisAlignedBB getAABB(double x, double y, double z) {
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0)).func_72314_b(48.0, 16.0, 48.0);
    }
}

