/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.wildlife;

import com.draco18s.hardlib.CogConfig;
import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.interfaces.IAutoPlanter;
import com.draco18s.hardlib.api.internal.CropWeatherOffsets;
import com.draco18s.wildlife.CommonProxy;
import com.draco18s.wildlife.CropManager;
import com.draco18s.wildlife.WildlifeEventHandler;
import com.draco18s.wildlife.block.BlockCropWeeds;
import com.draco18s.wildlife.block.BlockCropWinterWheat;
import com.draco18s.wildlife.block.BlockRottingWood;
import com.draco18s.wildlife.block.BlockSnowyTallGrass;
import com.draco18s.wildlife.block.BlockTanningRack;
import com.draco18s.wildlife.entity.EntityGoat;
import com.draco18s.wildlife.entity.EntityLizard;
import com.draco18s.wildlife.entity.TileEntityGrassSnow;
import com.draco18s.wildlife.entity.TileEntityTanner;
import com.draco18s.wildlife.entity.ai.EntityAIGetAttackableTarget;
import com.draco18s.wildlife.integration.IntegrationForestry;
import com.draco18s.wildlife.integration.IntegrationGany;
import com.draco18s.wildlife.integration.IntegrationTwilightForest;
import com.draco18s.wildlife.item.AchievementIcons;
import com.draco18s.wildlife.item.ItemBlockRottingWood;
import com.draco18s.wildlife.item.ItemDendricide;
import com.draco18s.wildlife.item.ItemDendrometer;
import com.draco18s.wildlife.item.ItemRainMeter;
import com.draco18s.wildlife.item.ItemThermometer;
import com.draco18s.wildlife.item.ItemVitometer;
import com.draco18s.wildlife.item.ItemWinterWheatSeeds;
import com.draco18s.wildlife.util.AnimalUtil;
import com.draco18s.wildlife.util.BlockUtils;
import com.draco18s.wildlife.util.StatsAchievements;
import com.draco18s.wildlife.util.TreeCountGenerator;
import com.draco18s.wildlife.util.TreeDataHooks;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="HarderWildlife", name="HarderWildlife", version="1.7.0a", dependencies="required-after:HardLib@[1.7,]")
public class WildlifeBase {
    @Mod.Instance(value="HarderWildlife")
    public static WildlifeBase instance;
    public static Configuration config;
    public static TreeCountGenerator treeCounter;
    public static Block rottingWood;
    public static Block winterWheat;
    public static Block snowyGrass;
    public static Block weeds;
    public static Block blockTanner;
    public static Item winterWheatSeeds;
    public static Item thermometer;
    public static Item rainmeter;
    public static Item rawChevon;
    public static Item cookedChevon;
    public static Item dendrometer;
    public static Item dendricide;
    public static Item vitometer;
    public static Item itemRawLeather;
    public static Item itemAchievementIcons;
    @SidedProxy(clientSide="com.draco18s.wildlife.client.ClientProxy", serverSide="com.draco18s.wildlife.CommonProxy")
    public static CommonProxy proxy;
    public static Random rand;
    private static boolean yearDebug;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String name;
        logger = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        WildlifeEventHandler.autoSaplings = config.getBoolean("autoPlantSaplings", "PLANTS", true, "Enables/disables auto-replanting of saplings, cactus, mushrooms, netherwart, and reeds.\nRequried for automated tree death.\nKind of buggy and imperfect, feel free to disable as its largely a 'nice touch' feature.\n");
        WildlifeEventHandler.trackTrees = config.getBoolean("trackTrees", "PLANTS", true, "Enables/disables tree tracking, which is required for automated tree death.\nWill look for trees during worldgen and add autoplanted saplings to the tree list.\n");
        TreeDataHooks.treeLifeMultiplier = config.getInt("treeAgeSpeed", "PLANTS", 100, 1, 10000, "Determines how quickly trees die off.  Larger values mean a longer life.\n10 means that trees live on average 1 hour at default max age.\n");
        TreeDataHooks.treeMaxAge = config.getInt("treeMaxAge", "PLANTS", 10000, 100, 1000000, "How old trees can get before dying, in ticks.  This is effectively multiplied by the treeAgeSpeed.\nNote: setting this below 3000 will cause some trees to die imediately after growing.\n");
        HardLibAPI.cropManager = new CropManager();
        HardLibAPI.plantManager = new BlockUtils();
        HardLibAPI.animalManager = new AnimalUtil();
        HardLibAPI.animalManager.addHerbivore(EntityHorse.class);
        HardLibAPI.animalManager.addHerbivore(EntityPig.class);
        HardLibAPI.animalManager.addHerbivore(EntityCow.class);
        HardLibAPI.animalManager.addHerbivore(EntitySheep.class);
        HardLibAPI.animalManager.addHerbivore(EntityGoat.class);
        HardLibAPI.animalManager.addHerbivore(EntityChicken.class);
        HardLibAPI.animalManager.addHerbivore(EntityMooshroom.class);
        HardLibAPI.plantManager.registerBlockType(Blocks.field_150345_g, IAutoPlanter.BlockType.SAPLING);
        HardLibAPI.plantManager.registerBlockType(Blocks.field_150434_aF, IAutoPlanter.BlockType.CACTUS);
        HardLibAPI.plantManager.registerBlockType((Block)Blocks.field_150338_P, IAutoPlanter.BlockType.MUSHROOM);
        HardLibAPI.plantManager.registerBlockType((Block)Blocks.field_150337_Q, IAutoPlanter.BlockType.MUSHROOM);
        HardLibAPI.plantManager.registerBlockType(Blocks.field_150388_bm, IAutoPlanter.BlockType.NETHERSTALK);
        HardLibAPI.plantManager.registerBlockType(Blocks.field_150436_aH, IAutoPlanter.BlockType.REEDS);
        WildlifeEventHandler.weekLength = 2 * config.getInt("moonPhaseTime", "SEASONS", 2, 1, 32, "How many Minecraft-Days it takes the moon to change phase (\"1 week\").\n1 is vanilla, 1 or 2 is good for SSP, 8+ is good for SMP.  Effects year length.\n");
        WildlifeEventHandler.yearLength = (long)WildlifeEventHandler.weekLength * 768000L;
        yearDebug = config.getBoolean("yearDebugEnable", "SEASONS", false, "If enabled, the week and year lengths are 1/10th of normal.\nIf enabled, the moon could change phase multiple times per night!");
        if (yearDebug) {
            WildlifeEventHandler.yearLength /= 10L;
        }
        logger.log(Level.INFO, "Year length: " + WildlifeEventHandler.yearLength + " (" + WildlifeEventHandler.yearLength / 24000L + " MC days)");
        WildlifeEventHandler.doSnowMelt = config.getBoolean("EnableSnowAccumulation", "SEASONS", true, "Allows snow to pile up when it snows and melt away again.");
        WildlifeEventHandler.doSlowCrops = config.getBoolean("EnableCropSlowing", "CROPS", true, "Enables or disables the slowdown of crop growth.\nIf enabled, base probability is 10% as frequent as vanilla (ten times slower).\nNote: please disable Gany's Surface's snow accumulation, if it is\ninstalled (mine results in a smoother variation between blocks).\n");
        WildlifeEventHandler.doBiomeCrops = config.getBoolean("EnableCropSlowingByBiome", "CROPS", true, "Enables or disables the crop growth based on biome information (which is effected by seasons,\nif enabled and ignored if slow crops is disabled). Most (vanilla) biomes have some semblance of a\ngrowing season, though it will be harder to grow food in the cold and dry biomes. Growing plants\ninside uses an effective temperature halfway closer to the ideal value.  For extreme biomes\nthis might be required!\nIf disabled, base slowdown probability is used instead.\n");
        WildlifeEventHandler.cropsWorst = config.getInt("SlowByBiomeLowerBound", "CROPS", 16, 8, 96, "Configures the worst possible growth rate for biome based crop growth.\nIn the worst possible conditions, the chance that crops will grow will not drop\nbelow 100/(value + 10) %\nGenerally speaking this occurs in the frozen biomes during the winter, most notably Cold Taiga.\nThere should be no need for this value to exceed 16 for any biome other than Cold Taiga (50+)\nand Cold Beach (20+).\n");
        rottingWood = new BlockRottingWood();
        winterWheat = new BlockCropWinterWheat();
        weeds = new BlockCropWeeds();
        winterWheatSeeds = new ItemWinterWheatSeeds(winterWheat, Blocks.field_150458_ak);
        thermometer = new ItemThermometer();
        rainmeter = new ItemRainMeter();
        snowyGrass = new BlockSnowyTallGrass();
        blockTanner = new BlockTanningRack();
        rawChevon = new ItemFood(2, 0.3f, true).func_77655_b("chevonRaw").func_111206_d("wildlife:chevon_raw");
        cookedChevon = new ItemFood(6, 0.8f, true).func_77655_b("chevonCooked").func_111206_d("wildlife:chevon_cooked");
        dendrometer = new ItemDendrometer();
        dendricide = new ItemDendricide();
        vitometer = new ItemVitometer();
        itemRawLeather = new Item().func_111206_d("wildlife:leather").func_77637_a(CreativeTabs.field_78035_l).func_77655_b("rawLeather");
        AnimalUtil.animalMaxAge = config.getInt("animalMaxAge", "ANIMALS", 24000, 5000, 2000000, "Maximum age of animals, in seconds.\nNote: Animals may have an accelerated aging rate, this value is the general-case value.\n") * 40;
        ((AnimalUtil)HardLibAPI.animalManager).parseConfig(config);
        WildlifeEventHandler.doRawLeather = config.getBoolean("doRawLeather", "ANIMALS", true, "Raw leather (rawhide) requires curing on a tanning rack before it can be used.\n");
        WildlifeEventHandler.doNativeTreeKill = config.getBoolean("secialTreeKill", "PLANTS", false, "Instantly kill any tree that is growing on non-standard materials.\n");
        GameRegistry.registerBlock((Block)rottingWood, ItemBlockRottingWood.class, (String)"logRotting");
        GameRegistry.registerBlock((Block)winterWheat, (String)"winterWheat");
        GameRegistry.registerBlock((Block)snowyGrass, (String)"snowyTallGrass");
        GameRegistry.registerBlock((Block)weeds, (String)"weeds");
        GameRegistry.registerItem((Item)winterWheatSeeds, (String)"winterWheatSeeds");
        GameRegistry.registerItem((Item)thermometer, (String)"thermometer");
        GameRegistry.registerItem((Item)rainmeter, (String)"rainmeter");
        GameRegistry.registerItem((Item)rawChevon, (String)"chevonRaw");
        GameRegistry.registerItem((Item)cookedChevon, (String)"chevonCooked");
        GameRegistry.registerItem((Item)dendrometer, (String)"dendrometer");
        GameRegistry.registerItem((Item)dendricide, (String)"dendricide");
        if (WildlifeEventHandler.doRawLeather) {
            GameRegistry.registerBlock((Block)blockTanner, (String)"machine_tanner");
            GameRegistry.registerItem((Item)itemRawLeather, (String)"rawLeather");
            GameRegistry.registerTileEntity(TileEntityTanner.class, (String)"tanning_rack");
        }
        GameRegistry.registerItem((Item)vitometer, (String)"vitometer");
        GameRegistry.registerTileEntity(TileEntityGrassSnow.class, (String)"grassy_snow");
        int n = EntityRegistry.findGlobalUniqueEntityId();
        int goatID = config.get("ANIMALS", "Goat ID", n, "Entity ID for goats").getInt();
        if (n > goatID) {
            name = (String)EntityList.field_75626_c.get((Class)EntityList.field_75623_d.get(goatID));
            event.getModLog().fatal("Entity Goat ID overlaps with " + name + ".  Change whichever is newer to at least " + n + " and less than 256.");
        }
        EntityRegistry.registerGlobalEntityID(EntityGoat.class, (String)"Goat", (int)goatID, (int)0xCBCBCB, (int)0x322D23);
        n = EntityRegistry.findGlobalUniqueEntityId();
        goatID = config.get("ANIMALS", "Lizard ID", n, "Entity ID for lizards").getInt();
        if (n > goatID) {
            name = (String)EntityList.field_75626_c.get((Class)EntityList.field_75623_d.get(goatID));
            event.getModLog().fatal("Entity Lizard ID overlaps with " + name + ".  Change whichever is newer to at least " + n + " and less than 256.");
        }
        EntityRegistry.registerGlobalEntityID(EntityLizard.class, (String)"Lizard", (int)goatID, (int)9858641, (int)7426877);
        BiomeGenBase[] biomes = BiomeGenBase.func_150565_n();
        BiomeGenBase.SpawnListEntry goatSpawn = new BiomeGenBase.SpawnListEntry(EntityGoat.class, 4, 4, 4);
        ArrayList<BiomeGenBase> lizBios = new ArrayList<BiomeGenBase>();
        for (int i = 0; i < biomes.length; ++i) {
            if (biomes[i] == null) continue;
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomes[i], (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
                biomes[i].func_76747_a(EnumCreatureType.creature).add(goatSpawn);
                lizBios.add(biomes[i]);
                continue;
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomes[i], (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
                biomes[i].func_76747_a(EnumCreatureType.creature).add(goatSpawn);
                continue;
            }
            if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biomes[i], (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || !BiomeDictionary.isBiomeOfType((BiomeGenBase)biomes[i], (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) continue;
            lizBios.add(biomes[i]);
        }
        BiomeGenBase[] a = new BiomeGenBase[lizBios.size()];
        EntityRegistry.addSpawn(EntityLizard.class, (int)8, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])lizBios.toArray(a));
        itemAchievementIcons = new AchievementIcons();
        GameRegistry.registerItem((Item)itemAchievementIcons, (String)"itemAchievementIcons");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        treeCounter = new TreeCountGenerator();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.draco18s.wildlife.integration.WailaIntegration.callbackRegister");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Class<BiomeGenBase> clz;
        StatsAchievements.addCoreAchievements();
        proxy.registerEvents();
        proxy.registerRenderers();
        CogConfig.unpackConfigs();
        config.save();
        Blocks.field_150480_ab.setFireInfo(rottingWood, 1, 10);
        if (HardLibAPI.recipeManager != null) {
            ItemStack rawOreIn = new ItemStack(Blocks.field_150345_g, 9, Short.MAX_VALUE);
            HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(rottingWood, 1, 12));
        }
        ItemStack glass = new ItemStack(Blocks.field_150410_aZ);
        if (OreDictionary.getOres((String)"nuggetIron").size() > 0) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(rainmeter), new Object[]{"ggg", "gig", "ggg", Character.valueOf('g'), glass, Character.valueOf('i'), "nuggetGold"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(thermometer), new Object[]{"ggg", "gig", "ggg", Character.valueOf('g'), glass, Character.valueOf('i'), "nuggetIron"}));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(rainmeter), new Object[]{"ggg", "gig", "ggg", Character.valueOf('g'), glass, Character.valueOf('i'), "ingotGold"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(thermometer), new Object[]{"ggg", "gig", "ggg", Character.valueOf('g'), glass, Character.valueOf('i'), "ingotIron"}));
        }
        GameRegistry.addSmelting((Item)rawChevon, (ItemStack)new ItemStack(cookedChevon), (float)0.35f);
        if (WildlifeEventHandler.doRawLeather) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockTanner), new Object[]{"sss", "sts", "s s", Character.valueOf('s'), "stickWood", Character.valueOf('t'), Items.field_151007_F}));
        }
        try {
            WildlifeEventHandler.doYearCycle = config.getBoolean("doSeasons", "SEASONS", true, "Toggle for whether or not seasonal variation in weather should occur.");
            Class<Object> clz2 = Class.forName("com.draco18s.hardlibcore.asm.HardLibPatcher");
            clz2.getDeclaredField("moonPhaseTime").setLong(null, 12000L * (long)WildlifeEventHandler.weekLength / (long)(yearDebug ? 10 : 1));
            clz2 = BiomeGenBase.class;
            WildlifeEventHandler.rains = clz2.getDeclaredField("field_76765_S");
            WildlifeEventHandler.rains.setAccessible(true);
            WildlifeEventHandler.snows = clz2.getDeclaredField("field_76766_R");
            WildlifeEventHandler.snows.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            try {
                clz = BiomeGenBase.class;
                WildlifeEventHandler.rains = clz.getDeclaredField("enableRain");
                WildlifeEventHandler.rains.setAccessible(true);
                WildlifeEventHandler.snows = clz.getDeclaredField("enableSnow");
                WildlifeEventHandler.snows.setAccessible(true);
            }
            catch (Exception e2) {
                WildlifeEventHandler.doYearCycle = false;
                logger.log(Level.WARN, "Reflection error: Failed to modify moon phase time. Seasons will be disabled.");
            }
        }
        catch (Exception e) {
            WildlifeEventHandler.doYearCycle = false;
            logger.log(Level.WARN, "Reflection error: Failed to modify moon phase time. Seasons will be disabled.");
        }
        Class[] cArg = new Class[]{Boolean.TYPE, Integer.TYPE};
        try {
            clz = EntityLivingBase.class;
            EntityAIGetAttackableTarget.dropItems = clz.getDeclaredMethod("func_70628_a", cArg);
            EntityAIGetAttackableTarget.dropItems.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            Class<EntityLivingBase> clz3 = EntityLivingBase.class;
            try {
                EntityAIGetAttackableTarget.dropItems = clz3.getDeclaredMethod("dropFewItems", cArg);
                EntityAIGetAttackableTarget.dropItems.setAccessible(true);
            }
            catch (Exception e2) {
                System.out.println("Failed to modify dropFewItems!" + e2);
            }
        }
        catch (SecurityException e) {
            System.out.println("Failed to modify dropFewItems! " + e);
        }
        CropWeatherOffsets off = new CropWeatherOffsets(0.0f, 0.0f, (int)(WildlifeEventHandler.yearLength / 2L), 0);
        HardLibAPI.cropManager.putCropWeather(Blocks.field_150393_bb, off);
        off = new CropWeatherOffsets(0.0f, 0.0f, 0, 0);
        HardLibAPI.cropManager.putCropWeather(Blocks.field_150464_aj, off);
        off = new CropWeatherOffsets(0.8f, 0.2f, 0, 0);
        HardLibAPI.cropManager.putCropWeather(winterWheat, off);
        off = new CropWeatherOffsets(-0.4f, 0.0f, 0, 0);
        HardLibAPI.cropManager.putCropWeather(Blocks.field_150394_bc, off);
        off = new CropWeatherOffsets(0.7f, 0.0f, 0, 0);
        HardLibAPI.cropManager.putCropWeather(Blocks.field_150469_bN, off);
        off = new CropWeatherOffsets(0.1f, 0.2f, 0, 0);
        HardLibAPI.cropManager.putCropWeather(Blocks.field_150459_bM, off);
        off = new CropWeatherOffsets(0.0f, 0.4f, 0, 0);
        HardLibAPI.cropManager.putCropWeather(winterWheat, off);
        if (Loader.isModLoaded((String)"ganysnether")) {
            IntegrationGany.registerNetherCrops();
        }
        if (Loader.isModLoaded((String)"ganyssurface")) {
            IntegrationGany.registerSurfaceCrops();
        }
        if (Loader.isModLoaded((String)"Forestry")) {
            IntegrationForestry.registerForestryTrees();
        }
        if (Loader.isModLoaded((String)"TwilightForest")) {
            IntegrationTwilightForest.registerAnimals();
        }
    }

    static {
        rand = new Random();
    }
}

