/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsEditBox;
import net.minecraft.realms.RealmsScreen;
import org.lwjgl.input.Keyboard;

public class BackupLinkScreen
extends RealmsScreen {
    private final RealmsScreen lastScreen;
    private final String downloadLink;
    private RealmsEditBox linkBox;
    private String[] desc;
    private RealmsButton copyButton;

    public BackupLinkScreen(RealmsScreen lastScreen, String downloadLink) {
        this.lastScreen = lastScreen;
        this.downloadLink = downloadLink;
    }

    public void tick() {
        this.linkBox.tick();
    }

    public void init() {
        String description = BackupLinkScreen.getLocalizedString((String)"mco.backuplink.text");
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : this.fontSplit(description, this.width() - 30)) {
            lines.add(line);
        }
        this.desc = lines.toArray(new String[0]);
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.copyButton = BackupLinkScreen.newButton((int)0, (int)(this.width() / 2 - 100), (int)(this.height() / 4 + 96 + 12), (String)BackupLinkScreen.getLocalizedString((String)"mco.backuplink.copybutton"));
        this.buttonsAdd(this.copyButton);
        this.buttonsAdd(BackupLinkScreen.newButton((int)1, (int)(this.width() / 2 - 100), (int)(this.height() / 4 + 120 + 12), (String)BackupLinkScreen.getLocalizedString((String)"gui.back")));
        this.linkBox = this.newEditBox(this.width() / 2 - 100, 116, 200, 20);
        this.linkBox.setMaxLength(500);
        this.linkBox.setFocus(true);
        this.linkBox.setValue(this.downloadLink);
        this.linkBox.setIsEditable(false);
        this.linkBox.moveCursorToStart();
        this.copyToClipboard();
    }

    private void copyToClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(this.downloadLink), null);
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 1) {
            this.backButtonClicked();
        } else if (button.id() == 0) {
            this.copyToClipboard();
        }
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 1) {
            this.backButtonClicked();
        } else if (eventKey == 28 || eventKey == 156) {
            this.buttonClicked(this.copyButton);
        }
        this.linkBox.keyPressed(ch, eventKey);
    }

    private void backButtonClicked() {
        Realms.setScreen((RealmsScreen)this.lastScreen);
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        super.mouseClicked(x, y, buttonNum);
        this.linkBox.mouseClicked(x, y, buttonNum);
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(BackupLinkScreen.getLocalizedString((String)"mco.backuplink.title"), this.width() / 2, 20, 0xFFFFFF);
        int y = 50;
        for (String line : this.desc) {
            this.drawCenteredString(line, this.width() / 2, y, 0x808080);
            y += this.fontLineHeight();
        }
        this.linkBox.render();
        super.render(xm, ym, a);
    }
}

