/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import com.mojang.realmsclient.dto.Backup;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import org.lwjgl.input.Keyboard;

public class BackupInfoScreen
extends RealmsScreen {
    private final RealmsScreen lastScreen;
    private final int BUTTON_BACK_ID = 0;
    private final Backup backup;
    String[] difficulties = new String[]{BackupInfoScreen.getLocalizedString((String)"options.difficulty.peaceful"), BackupInfoScreen.getLocalizedString((String)"options.difficulty.easy"), BackupInfoScreen.getLocalizedString((String)"options.difficulty.normal"), BackupInfoScreen.getLocalizedString((String)"options.difficulty.hard")};
    String[] gameModes = new String[]{BackupInfoScreen.getLocalizedString((String)"selectWorld.gameMode.survival"), BackupInfoScreen.getLocalizedString((String)"selectWorld.gameMode.creative"), BackupInfoScreen.getLocalizedString((String)"selectWorld.gameMode.adventure")};

    public BackupInfoScreen(RealmsScreen lastScreen, Backup backup) {
        this.lastScreen = lastScreen;
        this.backup = backup;
    }

    public void tick() {
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsAdd(BackupInfoScreen.newButton((int)0, (int)(this.width() / 2 - 100), (int)(this.height() / 4 + 120 + 12), (String)BackupInfoScreen.getLocalizedString((String)"gui.back")));
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 0) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 1) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        int y = 17;
        this.drawCenteredString("Changes from last backup", this.width() / 2, 10, 0xFFFFFF);
        y += 30;
        for (String key : this.backup.changeList.keySet()) {
            this.drawString(key, this.width() / 2 - 100, y, 0xFFFFFF);
            String metadataValue = this.backup.changeList.get(key);
            this.drawString(this.checkForSpecificMetadata(key, metadataValue), this.width() / 2 - 100, y += 12, 0xA0A0A0);
            y += 14;
        }
        super.render(xm, ym, a);
    }

    private String checkForSpecificMetadata(String key, String value) {
        String k = key.toLowerCase();
        if (k.contains("game") && k.contains("mode")) {
            return this.gameModeMetadata(value);
        }
        if (k.contains("game") && k.contains("difficulty")) {
            return this.gameDifficultyMetadata(value);
        }
        return value;
    }

    private String gameDifficultyMetadata(String value) {
        try {
            return this.difficulties[Integer.parseInt(value)];
        }
        catch (Exception e) {
            return "UNKNOWN";
        }
    }

    private String gameModeMetadata(String value) {
        try {
            return this.gameModes[Integer.parseInt(value)];
        }
        catch (Exception e) {
            return "UNKNOWN";
        }
    }
}

