/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.util;

import com.draco18s.hardlib.api.internal.ChunkCoordTriplet;
import com.draco18s.ores.OresBase;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;

public class OreDataHooks {
    private static final int VERSION = 2;
    private static ConcurrentHashMap<ChunkCoordTriplet, HashMap<String, Integer>> graphs = new ConcurrentHashMap();

    public static void putOreData(World world, int x, int y, int z, Block b, int count) {
        ChunkCoordTriplet key = new ChunkCoordTriplet(world.field_73011_w.field_76574_g, x, y, z);
        HashMap<String, Integer> value = graphs.get(key);
        if (value == null) {
            value = new HashMap();
        }
        value.put(b.func_149739_a(), count);
        graphs.put(key, value);
    }

    public static int getOreData(World world, int x, int y, int z, Block b) {
        ChunkCoordTriplet key;
        HashMap<String, Integer> map;
        Chunk c = world.func_72938_d(x, z);
        x = c.field_76635_g;
        z = c.field_76647_h;
        if ((map = graphs.get(key = new ChunkCoordTriplet(world.field_73011_w.field_76574_g, x, y -= y % 8, z))) == null || !map.containsKey(b.func_149739_a())) {
            OresBase.oreCounter.generate(null, x, z, world);
            map = graphs.get(key);
            if (map == null || !map.containsKey(b.func_149739_a())) {
                return 0;
            }
        }
        boolean flag = true;
        for (int q : map.values()) {
            if (q <= 0) continue;
            flag = false;
        }
        if (flag) {
            OresBase.oreCounter.generate(null, x, z, world);
            map.put("fake_ore_count", 1);
        }
        map = graphs.get(key);
        return map.get(b.func_149739_a());
    }

    public static void subOreData(World world, int x, int y, int z, Block b, int amount) {
        x = Math.round((float)x / 16.0f);
        y -= y % 8;
        z = Math.round((float)z / 16.0f);
        int k = 0;
        do {
            ChunkCoordTriplet key;
            HashMap<String, Integer> map;
            if ((map = graphs.get(key = new ChunkCoordTriplet(world.field_73011_w.field_76574_g, x, y - 8 * k, z))) == null || !map.containsKey(b.func_149739_a())) continue;
            int mm = Math.min(map.get(b.func_149739_a()), amount);
            int n = Math.max(map.get(b.func_149739_a()) - amount, 0);
            if (n == 0) {
                n = -1;
            }
            map.put(b.func_149739_a(), n);
            amount -= mm;
        } while (++k < 2 && amount > 0);
    }

    public static void readData(World world, int x, int z, NBTTagCompound nbt) {
        if (nbt.func_74764_b("HardOreData")) {
            NBTTagCompound honbt = nbt.func_74775_l("HardOreData");
            for (int y = 0; y < 256; y += 16) {
                if (!honbt.func_74764_b("slice_" + y)) continue;
                ChunkCoordTriplet key = new ChunkCoordTriplet(world.field_73011_w.field_76574_g, x, y, z);
                HashMap<String, Integer> value = new HashMap<String, Integer>();
                NBTTagCompound snbt = (NBTTagCompound)honbt.func_74781_a("slice_" + y);
                boolean flag = true;
                int i = 0;
                while (flag) {
                    if (snbt.func_74764_b("name_" + i)) {
                        String n = snbt.func_74779_i("name_" + i);
                        value.put(n, snbt.func_74762_e(n));
                    } else {
                        flag = false;
                    }
                    ++i;
                }
                graphs.put(key, value);
            }
        } else {
            ChunkCoordTriplet key = new ChunkCoordTriplet(world.field_73011_w.field_76574_g, x, 0, z);
            OresBase.logger.log(Level.INFO, "Chunk " + key + " is missing ore data, it will be rescanned.  Chunks way out on the edge of the world may not save and cause this message to repeat next launch; do not be alarmed.");
            OresBase.oreCounter.generate(null, x, z, world);
        }
    }

    public static void saveData(World world, int x, int z, NBTTagCompound nbt) {
        NBTTagCompound honbt = new NBTTagCompound();
        for (int y = 0; y < 256; y += 16) {
            ChunkCoordTriplet key = new ChunkCoordTriplet(world.field_73011_w.field_76574_g, x, y, z);
            HashMap<String, Integer> value = graphs.get(key);
            if (value != null) {
                NBTTagCompound snbt = new NBTTagCompound();
                int i = 0;
                for (String k : value.keySet()) {
                    snbt.func_74768_a(k, value.get(k).intValue());
                    snbt.func_74778_a("name_" + i, k);
                    ++i;
                }
                honbt.func_74782_a("slice_" + y, (NBTBase)snbt);
            }
            if (world.func_72964_e((int)x, (int)z).field_76636_d) continue;
            graphs.remove(key);
        }
        honbt.func_74768_a("version", 2);
        nbt.func_74782_a("HardOreData", (NBTBase)honbt);
    }
}

