/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.recipes.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.draco18s.hardlib.api.HardLibAPI;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ProcessorNEI
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Pressure Packager";
    }

    public String getOverlayIdentifier() {
        return "processor";
    }

    public String getGuiTexture() {
        return "ores:textures/gui/sifter.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if ((outputId.equals("item") || outputId.equals("processor")) && results.length > 0) {
            this.loadCraftingRecipes((ItemStack)results[0]);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        ItemStack ingredient = HardLibAPI.recipeManager.getProcessorRecipeInput(result);
        if (ingredient != null && !ItemStack.func_77989_b((ItemStack)ingredient, (ItemStack)result)) {
            CachedProcessorRecipe recipe = new CachedProcessorRecipe(ingredient);
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        this.loadUsageRecipes((ItemStack)ingredients[0]);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ItemStack output = HardLibAPI.recipeManager.getProcessorResult(ingredient, false);
        if (output != null && !ItemStack.func_77989_b((ItemStack)ingredient, (ItemStack)output)) {
            CachedProcessorRecipe recipe = new CachedProcessorRecipe(ingredient);
            this.arecipes.add(recipe);
        }
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(74, 20, 176, 0, 17, 24, 40, 1);
    }

    public class CachedProcessorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private PositionedStack ingredient;
        private PositionedStack stack;

        public CachedProcessorRecipe(Object _ingredient) {
            super((TemplateRecipeHandler)ProcessorNEI.this);
            if (_ingredient instanceof ItemStack) {
                ItemStack ingred = (ItemStack)_ingredient;
                ingred.field_77994_a = HardLibAPI.recipeManager.getProcessorAmount(ingred);
                this.ingredient = new PositionedStack((Object)ingred, 66, 2);
                this.stack = new PositionedStack((Object)HardLibAPI.recipeManager.getProcessorResult((ItemStack)_ingredient, false), 75, 47);
            } else if (_ingredient instanceof String) {
                ArrayList list = OreDictionary.getOres((String)((String)_ingredient));
                if (list.size() > 0) {
                    for (ItemStack s : list) {
                        s.field_77994_a = 64;
                        s.field_77994_a = HardLibAPI.recipeManager.getProcessorAmount(s);
                    }
                    this.ingredient = new PositionedStack((Object)list, 66, 2);
                    this.stack = new PositionedStack((Object)HardLibAPI.recipeManager.getProcessorResult((ItemStack)_ingredient, false), 75, 47);
                }
            } else {
                this.ingredient = null;
            }
        }

        public PositionedStack getIngredient() {
            return this.ingredient;
        }

        public PositionedStack getResult() {
            return this.stack;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CachedProcessorRecipe)) {
                return false;
            }
            CachedProcessorRecipe other = (CachedProcessorRecipe)((Object)obj);
            if (this.ingredient == null ? other.ingredient != null : (this.ingredient.item == null ? other.ingredient.item != null : !ItemStack.func_77989_b((ItemStack)this.ingredient.item, (ItemStack)other.ingredient.item))) {
                return false;
            }
            return !(this.stack == null ? other.stack != null : (this.stack.item == null ? other.stack.item != null : !ItemStack.func_77989_b((ItemStack)this.stack.item, (ItemStack)other.stack.item)));
        }
    }
}

