/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.recipes;

import com.draco18s.ores.OresBase;
import com.draco18s.ores.util.EnumOreType;
import cpw.mods.fml.common.event.FMLInterModComms;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ThermalExpansionHelper {
    public static void addTERecipes() {
        int i;
        ItemStack rawOreIn = new ItemStack(OresBase.oreChunks, 1, EnumOreType.IRON.value);
        ItemStack dustOut = new ItemStack(OresBase.smallDusts, 3, EnumOreType.IRON.value);
        ItemStack dustOther = (ItemStack)OreDictionary.getOres((String)"dustNickel").get(0);
        ThermalExpansionHelper.addPulverizerRecipe(500, rawOreIn, dustOut, dustOther, 10);
        rawOreIn.func_77964_b(EnumOreType.GOLD.value);
        dustOut.func_77964_b(EnumOreType.GOLD.value);
        dustOther = (ItemStack)OreDictionary.getOres((String)"crystalCinnabar").get(0);
        ThermalExpansionHelper.addPulverizerRecipe(500, rawOreIn, dustOut, dustOther, 10);
        rawOreIn.func_77964_b(EnumOreType.COPPER.value);
        dustOut.func_77964_b(EnumOreType.GOLD.value);
        dustOther = (ItemStack)OreDictionary.getOres((String)"dustCopper").get(0);
        ThermalExpansionHelper.addPulverizerRecipe(500, rawOreIn, dustOther, dustOut, 10);
        rawOreIn.func_77964_b(EnumOreType.TIN.value);
        dustOut.func_77964_b(EnumOreType.IRON.value);
        dustOther = (ItemStack)OreDictionary.getOres((String)"dustTin").get(0);
        ThermalExpansionHelper.addPulverizerRecipe(500, rawOreIn, dustOther, dustOut, 10);
        rawOreIn = new ItemStack(OresBase.oreIron);
        ItemStack nuggetOut = new ItemStack(OresBase.oreChunks, 1, EnumOreType.IRON.value);
        for (i = 0; i < 15; ++i) {
            rawOreIn.func_77964_b(i);
            nuggetOut.field_77994_a = i + i / 5 * 2;
            ThermalExpansionHelper.addPulverizerRecipe(1000, rawOreIn, nuggetOut);
        }
        rawOreIn = new ItemStack(OresBase.oreGold);
        nuggetOut = new ItemStack(OresBase.oreChunks, 1, EnumOreType.GOLD.value);
        for (i = 0; i < 15; ++i) {
            rawOreIn.func_77964_b(i);
            nuggetOut.field_77994_a = i + i / 5 * 2;
            ThermalExpansionHelper.addPulverizerRecipe(1000, rawOreIn, nuggetOut);
        }
        rawOreIn = new ItemStack(OresBase.oreDiamond);
        nuggetOut = new ItemStack(OresBase.oreChunks, 1, EnumOreType.DIAMOND.value);
        for (i = 0; i < 15; ++i) {
            rawOreIn.func_77964_b(i);
            nuggetOut.field_77994_a = (int)Math.ceil((float)i / 3.0f) + i / 5;
            ThermalExpansionHelper.addPulverizerRecipe(1000, rawOreIn, nuggetOut);
        }
        rawOreIn = new ItemStack(OresBase.oreTin);
        nuggetOut = new ItemStack(OresBase.oreChunks, 1, EnumOreType.TIN.value);
        for (i = 0; i < 15; ++i) {
            rawOreIn.func_77964_b(i);
            nuggetOut.field_77994_a = i + i / 5 * 2;
            ThermalExpansionHelper.addPulverizerRecipe(1000, rawOreIn, nuggetOut);
        }
        rawOreIn = new ItemStack(OresBase.oreCopper);
        nuggetOut = new ItemStack(OresBase.oreChunks, 1, EnumOreType.COPPER.value);
        for (i = 0; i < 15; ++i) {
            rawOreIn.func_77964_b(i);
            nuggetOut.field_77994_a = i + i / 5 * 2;
            ThermalExpansionHelper.addPulverizerRecipe(1000, rawOreIn, nuggetOut);
        }
    }

    public static void addFurnaceRecipe(int energy, ItemStack input, ItemStack output) {
        if (input == null || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        output.func_77955_b(toSend.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"FurnaceRecipe", (NBTTagCompound)toSend);
    }

    public static void removeFurnaceRecipe(ItemStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"RemoveFurnaceRecipe", (NBTTagCompound)toSend);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        ThermalExpansionHelper.addPulverizerRecipe(energy, input, primaryOutput, null, 0);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addPulverizerRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input == null || primaryOutput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
        if (secondaryOutput != null) {
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
        }
        input.func_77955_b(toSend.func_74775_l("input"));
        primaryOutput.func_77955_b(toSend.func_74775_l("primaryOutput"));
        if (secondaryOutput != null) {
            secondaryOutput.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            toSend.func_74768_a("secondaryChance", secondaryChance);
        }
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"PulverizerRecipe", (NBTTagCompound)toSend);
    }

    public static void removePulverizerRecipe(ItemStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"RemovePulverizerRecipe", (NBTTagCompound)toSend);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        ThermalExpansionHelper.addSawmillRecipe(energy, input, primaryOutput, null, 0);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addSawmillRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input == null || primaryOutput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
        if (secondaryOutput != null) {
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
        }
        input.func_77955_b(toSend.func_74775_l("input"));
        primaryOutput.func_77955_b(toSend.func_74775_l("primaryOutput"));
        if (secondaryOutput != null) {
            secondaryOutput.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            toSend.func_74768_a("secondaryChance", secondaryChance);
        }
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SawmillRecipe", (NBTTagCompound)toSend);
    }

    public static void removeSawmillRecipe(ItemStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"RemoveSawmillRecipe", (NBTTagCompound)toSend);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        ThermalExpansionHelper.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryInput == null || secondaryInput == null || primaryOutput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("primaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("secondaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
        if (secondaryOutput != null) {
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
        }
        primaryInput.func_77955_b(toSend.func_74775_l("primaryInput"));
        secondaryInput.func_77955_b(toSend.func_74775_l("secondaryInput"));
        primaryOutput.func_77955_b(toSend.func_74775_l("primaryOutput"));
        if (secondaryOutput != null) {
            secondaryOutput.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            toSend.func_74768_a("secondaryChance", secondaryChance);
        }
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SmelterRecipe", (NBTTagCompound)toSend);
    }

    public static void removeSmelterRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput == null || secondaryInput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("primaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("secondaryInput", (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l("primaryInput"));
        secondaryInput.func_77955_b(toSend.func_74775_l("secondaryInput"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"RemoveSmelterRecipe", (NBTTagCompound)toSend);
    }

    public static void addSmelterBlastOre(String oreType) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a("oreType", oreType);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SmelterBlastOreType", (NBTTagCompound)toSend);
    }

    public static void addCrucibleRecipe(int energy, ItemStack input, FluidStack output) {
        if (input == null || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        output.writeToNBT(toSend.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"CrucibleRecipe", (NBTTagCompound)toSend);
    }

    public static void removeCrucibleRecipe(ItemStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"RemoveCrucibleRecipe", (NBTTagCompound)toSend);
    }

    public static void addTransposerFill(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        if (input == null || output == null || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        output.func_77955_b(toSend.func_74775_l("output"));
        toSend.func_74757_a("reversible", reversible);
        fluid.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"TransposerFillRecipe", (NBTTagCompound)toSend);
    }

    public static void addTransposerExtract(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
        if (input == null || output == null || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        output.func_77955_b(toSend.func_74775_l("output"));
        toSend.func_74757_a("reversible", reversible);
        toSend.func_74768_a("chance", chance);
        fluid.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"TransposerExtractRecipe", (NBTTagCompound)toSend);
    }

    public static void removeTransposerFill(ItemStack input, FluidStack fluid) {
        if (input == null || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        fluid.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"RemoveTransposerFillRecipe", (NBTTagCompound)toSend);
    }

    public static void removeTransposerExtract(ItemStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"RemoveTransposerExtractRecipe", (NBTTagCompound)toSend);
    }

    public static void addChargerRecipe(int energy, ItemStack input, ItemStack output) {
        if (input == null || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        output.func_77955_b(toSend.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"ChargerRecipe", (NBTTagCompound)toSend);
    }

    public static void removeChargerRecipe(ItemStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"RemoveChargerRecipe", (NBTTagCompound)toSend);
    }

    public static void addInsolatorRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        ThermalExpansionHelper.addInsolatorRecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0);
    }

    public static void addInsolatorRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addInsolatorRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static void addInsolatorRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryInput == null || secondaryInput == null || primaryOutput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("primaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("secondaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
        if (secondaryOutput != null) {
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
        }
        primaryInput.func_77955_b(toSend.func_74775_l("primaryInput"));
        secondaryInput.func_77955_b(toSend.func_74775_l("secondaryInput"));
        primaryOutput.func_77955_b(toSend.func_74775_l("primaryOutput"));
        if (secondaryOutput != null) {
            secondaryOutput.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            toSend.func_74768_a("secondaryChance", secondaryChance);
        }
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"InsolatorRecipe", (NBTTagCompound)toSend);
    }

    public static void removeInsolatorRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput == null || secondaryInput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("primaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("secondaryInput", (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l("primaryInput"));
        secondaryInput.func_77955_b(toSend.func_74775_l("secondaryInput"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"RemoveInsolatorRecipe", (NBTTagCompound)toSend);
    }

    public static void addMagmaticFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a("fluidName", fluidName);
        toSend.func_74768_a("energy", energy);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"MagmaticFuel", (NBTTagCompound)toSend);
    }

    public static void addCompressionFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a("fluidName", fluidName);
        toSend.func_74768_a("energy", energy);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"CompressionFuel", (NBTTagCompound)toSend);
    }

    public static void addReactantFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a("fluidName", fluidName);
        toSend.func_74768_a("energy", energy);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"ReactantFuel", (NBTTagCompound)toSend);
    }

    public static void addCoolant(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a("fluidName", fluidName);
        toSend.func_74768_a("energy", energy);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"Coolant", (NBTTagCompound)toSend);
    }
}

