/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.recipes;

import com.draco18s.hardlib.api.interfaces.IHardRecipes;
import com.draco18s.hardlib.api.internal.OreFlowerData;
import com.draco18s.ores.entities.TileEntityMillstone;
import com.draco18s.ores.entities.TileEntityOreProcessor;
import com.draco18s.ores.entities.TileEntitySifter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class RecipeManager
implements IHardRecipes {
    private static Map sifterRecipes = new HashMap();
    private static Map millRecipes = new HashMap();
    private static Map processorRecipes = new HashMap();
    private static List<Block> sluiceRecipes = new ArrayList<Block>();
    private static Map<Block, OreFlowerData> oreList = new HashMap<Block, OreFlowerData>();

    public void addSiftRecipe(ItemStack input, ItemStack output) {
        this.addSiftRecipe(input, output, true);
    }

    public void addSiftRecipe(ItemStack input, ItemStack output, boolean registerOutput) {
        sifterRecipes.put(input.func_77946_l(), output.func_77946_l());
        if (registerOutput && input != output) {
            output = output.func_77946_l();
            output.field_77994_a = 1;
            sifterRecipes.put(output, output);
        }
    }

    public void addProcessorRecipe(ItemStack input, ItemStack output) {
        processorRecipes.put(input.func_77946_l(), output.func_77946_l());
    }

    public void addMillRecipe(ItemStack input, ItemStack output) {
        millRecipes.put(input.func_77946_l(), output.func_77946_l());
    }

    public void addSluiceRecipe(Block output) {
        sluiceRecipes.add(output);
    }

    public void addOreFlowerData(Block ore, OreFlowerData data) {
        oreList.put(ore, data);
    }

    public boolean isSluiceSetFull() {
        return sluiceRecipes.size() > 4;
    }

    public int getSiftAmount(ItemStack key) {
        Map.Entry entry;
        Iterator iterator = sifterRecipes.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0;
        } while (!this.areSame(key, (ItemStack)(entry = iterator.next()).getKey(), true));
        return ((ItemStack)entry.getKey()).field_77994_a;
    }

    public ItemStack getSiftRecipeInput(ItemStack value) {
        Map.Entry entry;
        Iterator iterator = sifterRecipes.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.areSame(value, (ItemStack)(entry = iterator.next()).getValue(), false) || this.areSame((ItemStack)entry.getValue(), (ItemStack)entry.getKey(), false));
        return ((ItemStack)entry.getKey()).func_77946_l();
    }

    public ItemStack getSiftResult(ItemStack key, boolean checkSize) {
        Map.Entry entry;
        Iterator iterator = sifterRecipes.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.areSame(key, (ItemStack)(entry = iterator.next()).getKey(), checkSize));
        return (ItemStack)entry.getValue();
    }

    private boolean areSame(ItemStack input, ItemStack against, boolean size) {
        if (input == null || against == null) {
            return false;
        }
        return !(against.func_77973_b() != input.func_77973_b() || against.func_77960_j() != Short.MAX_VALUE && against.func_77960_j() != input.func_77960_j() || size && input.field_77994_a < against.field_77994_a);
    }

    public ItemStack getMillResult(ItemStack key) {
        Map.Entry entry;
        Iterator iterator = millRecipes.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.areSame(key, (ItemStack)(entry = iterator.next()).getKey(), false));
        return (ItemStack)entry.getValue();
    }

    public int getProcessorAmount(ItemStack key) {
        Map.Entry entry;
        Iterator iterator = processorRecipes.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0;
        } while (!this.areSame(key, (ItemStack)(entry = iterator.next()).getKey(), true));
        return ((ItemStack)entry.getKey()).field_77994_a;
    }

    public ItemStack getProcessorRecipeInput(ItemStack value) {
        Map.Entry entry;
        Iterator iterator = processorRecipes.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.areSame(value, (ItemStack)(entry = iterator.next()).getValue(), false) || this.areSame((ItemStack)entry.getValue(), (ItemStack)entry.getKey(), false));
        return ((ItemStack)entry.getKey()).func_77946_l();
    }

    public ItemStack getProcessorResult(ItemStack key, boolean checkSize) {
        Map.Entry entry;
        Iterator iterator = processorRecipes.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.areSame(key, (ItemStack)(entry = iterator.next()).getKey(), checkSize));
        return (ItemStack)entry.getValue();
    }

    public boolean canInsert(TileEntity device, ItemStack stack) {
        if (device instanceof TileEntityMillstone) {
            return this.getMillResult(stack) != null;
        }
        if (device instanceof TileEntitySifter) {
            return this.getSiftResult(stack, false) != null;
        }
        if (device instanceof TileEntityOreProcessor) {
            return this.getProcessorResult(stack, false) != null;
        }
        return false;
    }

    public Block getRandomSluiceResult(Random rand) {
        return sluiceRecipes.get(rand.nextInt(sluiceRecipes.size()));
    }

    public Map<Block, OreFlowerData> getOreList() {
        return oreList;
    }

    public Block getRandomSluiceResult(Random rand, Item item) {
        Block b;
        do {
            b = this.getRandomSluiceResult(rand);
        } while (item == Item.func_150898_a((Block)Blocks.field_150354_m) && b == Blocks.field_150351_n);
        return b;
    }

    public ArrayList<ItemStack> getMillRecipeInput(ItemStack value) {
        Iterator iterator = millRecipes.entrySet().iterator();
        ArrayList<ItemStack> allInputs = new ArrayList<ItemStack>();
        do {
            if (!iterator.hasNext()) {
                return allInputs;
            }
            Map.Entry entry = iterator.next();
            if (!this.areSame(value, (ItemStack)entry.getValue(), false) || this.areSame((ItemStack)entry.getValue(), (ItemStack)entry.getKey(), false)) continue;
            allInputs.add((ItemStack)entry.getKey());
        } while (iterator.hasNext());
        return allInputs;
    }
}

