/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.entities;

import com.draco18s.hardlib.api.interfaces.IMechanicalPowerUser;
import com.draco18s.ores.entities.TileEntityWindvane;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;

public class TileEntityWindmill
extends TileEntity {
    private int coreX = 999;
    private int coreY = 999;
    private int coreZ = 999;
    private int millX = 999;
    private int millY = 999;
    private int millZ = 999;
    private int[][] lightArray = new int[10][5];
    private boolean buildLight = false;
    private int powerAmt;

    public void func_145845_h() {
        IMechanicalPowerUser te;
        if (!this.field_145850_b.field_72995_K && this.field_145848_d >= this.field_145850_b.field_73011_w.func_76557_i() - 4 && this.coreX == this.field_145851_c && this.coreY == this.field_145848_d && this.coreZ == this.field_145849_e && this.millY != 999 && (te = (IMechanicalPowerUser)this.field_145850_b.func_147438_o(this.millX, this.millY, this.millZ)) != null) {
            int p;
            if (!this.buildLight) {
                this.buildLight = true;
                this.checkAirVolumeFull(this.field_145851_c - this.millX, this.field_145848_d, this.field_145849_e - this.millZ);
            }
            if (this.powerAmt != (p = this.checkAirVolume(this.field_145851_c - this.millX, this.field_145848_d, this.field_145849_e - this.millZ))) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.powerAmt = p;
            }
            if (p > te.minimumTorque()) {
                te.setPowerLevel(te.powerScale(p - te.minimumTorque()));
            } else {
                te.setPowerLevel(0.0f);
            }
        }
    }

    private int checkAirVolume(int x, int y, int z) {
        if (this.field_145850_b.field_72995_K) {
            return 750;
        }
        x = (int)Math.signum(x);
        z = (int)Math.signum(z);
        Random rand = new Random();
        int i = rand.nextInt(10);
        int k = rand.nextInt(5);
        this.lightArray[i][k] = this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c + i * x + (k - 2) * z, this.field_145848_d - 2, this.field_145849_e + i * z + (k - 2) * x);
        int lightTot = 0;
        int lowest = 99;
        for (i = 0; i < 10; ++i) {
            for (k = 0; k < 5; ++k) {
                lightTot += this.lightArray[i][k];
                if (this.lightArray[i][k] >= lowest) continue;
                lowest = this.lightArray[i][k];
            }
        }
        return lightTot;
    }

    private void checkAirVolumeFull(int x, int y, int z) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        x = (int)Math.signum(x);
        z = (int)Math.signum(z);
        for (int i = 0; i < 10; ++i) {
            for (int k = 0; k < 5; ++k) {
                this.lightArray[i][k] = this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c + i * x + (k - 2) * z, this.field_145848_d - 2, this.field_145849_e + i * z + (k - 2) * x);
            }
        }
    }

    public void recheckCore() {
        this.field_145850_b.func_147464_a(this.coreX, this.coreY, this.coreZ, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1);
    }

    public void setCore(int x, int y, int z) {
        this.coreX = x;
        this.coreY = y;
        this.coreZ = z;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
    }

    public void setMill(int x, int y, int z) {
        this.millX = x;
        this.millY = y;
        this.millZ = z;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
    }

    public void func_145839_a(NBTTagCompound tc) {
        super.func_145839_a(tc);
        this.coreX = tc.func_74762_e("coreX");
        this.coreY = tc.func_74762_e("coreY");
        this.coreZ = tc.func_74762_e("coreZ");
        this.millX = tc.func_74762_e("millX");
        this.millY = tc.func_74762_e("millY");
        this.millZ = tc.func_74762_e("millZ");
        this.powerAmt = tc.func_74762_e("airflow");
    }

    public void func_145841_b(NBTTagCompound tc) {
        super.func_145841_b(tc);
        tc.func_74768_a("coreX", this.coreX);
        tc.func_74768_a("coreY", this.coreY);
        tc.func_74768_a("coreZ", this.coreZ);
        tc.func_74768_a("millX", this.millX);
        tc.func_74768_a("millY", this.millY);
        tc.func_74768_a("millZ", this.millZ);
        tc.func_74768_a("airflow", this.powerAmt);
    }

    public void invalidatePowerStatus() {
        Object te;
        if (this.millY != 999 && (te = (IMechanicalPowerUser)this.field_145850_b.func_147438_o(this.millX, this.millY, this.millZ)) != null) {
            te.setPowerLevel(0.0f);
        }
        if (this.coreY != 999 && (this.coreX != this.field_145851_c || this.coreY != this.field_145848_d || this.coreZ != this.field_145849_e) && (te = (TileEntityWindmill)this.field_145850_b.func_147438_o(this.coreX, this.coreY, this.coreZ)) != null) {
            ((TileEntityWindmill)((Object)te)).recheckCore();
        }
    }

    public String getModelTexture() {
        if (this instanceof TileEntityWindvane) {
            return "ores:textures/entities/windvane.png";
        }
        if (this.getAxelPosition() == 3) {
            return "ores:textures/entities/gears.png";
        }
        return "ores:textures/entities/axel.png";
    }

    public float getOffsetX() {
        if (this instanceof TileEntityWindvane && this.field_145851_c != this.coreX && this.coreY != 999) {
            return 0.25f;
        }
        return 0.5f;
    }

    public float getOffsetY() {
        if (this instanceof TileEntityWindvane && this.field_145848_d == this.coreY) {
            return 0.0f;
        }
        return -0.5f;
    }

    public float getOffsetZ() {
        if (this instanceof TileEntityWindvane) {
            if (this.field_145851_c != this.coreX) {
                return 0.5f;
            }
            if (this.field_145851_c == this.coreX && this.field_145849_e != this.coreZ) {
                return 0.0f;
            }
            if (this.field_145849_e == this.millZ) {
                return 0.25f;
            }
        }
        return 0.5f;
    }

    public float getRotationX() {
        if (this instanceof TileEntityWindvane && this.field_145848_d == this.coreY) {
            return 1.5707964f;
        }
        return 0.0f;
    }

    public float getRotationY() {
        if (this instanceof TileEntityWindvane) {
            if (this.field_145851_c != this.coreX && this.coreY != 999) {
                return 1.5707964f;
            }
            if (this.field_145851_c == this.coreX && this.field_145849_e != this.coreZ) {
                return 0.0f;
            }
            if (this.field_145849_e == this.millZ) {
                return -1.5707964f;
            }
        }
        if (this.coreY != 999 && this.getAxelPosition() == 3) {
            if (this.field_145849_e - this.coreZ > 0) {
                return -1.0f;
            }
            if (this.field_145849_e - this.coreZ < 0) {
                return 0.0f;
            }
            if (this.field_145851_c - this.coreX > 0) {
                return 1.0f;
            }
            if (this.field_145851_c - this.coreX < 0) {
                return 2.0f;
            }
        } else if (this.coreY != 999 && Math.abs(this.field_145849_e - this.coreZ) == 0 && Math.abs(this.field_145849_e - this.millZ) == 0) {
            return -1.5707964f;
        }
        return 0.0f;
    }

    public float getRotationZ() {
        return 0.0f;
    }

    public int getAxelPosition() {
        return Math.abs(this.field_145851_c - this.coreX) + Math.abs(this.field_145849_e - this.coreZ);
    }

    public int getPower() {
        if (this.coreX == this.field_145851_c && this.coreY == this.field_145848_d && this.coreZ == this.field_145849_e) {
            return this.powerAmt;
        }
        TileEntityWindmill te = (TileEntityWindmill)this.field_145850_b.func_147438_o(this.coreX, this.coreY, this.coreZ);
        if (te != null) {
            return te.getPower();
        }
        return 0;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public static float powerScale(TileEntity tileEntity, int pow) {
        TileEntityWindmill te = (TileEntityWindmill)tileEntity;
        IMechanicalPowerUser tg = (IMechanicalPowerUser)te.field_145850_b.func_147438_o(te.millX, te.millY, te.millZ);
        return tg.powerScale(pow - tg.minimumTorque());
    }

    public static String displayString(TileEntity tileEntity) {
        TileEntityWindmill te = (TileEntityWindmill)tileEntity;
        IMechanicalPowerUser tg = (IMechanicalPowerUser)te.field_145850_b.func_147438_o(te.millX, te.millY, te.millZ);
        return tg.getActionString();
    }
}

