/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.client;

import com.draco18s.ores.OresBase;
import com.draco18s.ores.entities.TileEntitySluiceBottom;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;

public class SimpleBlockRendererSluice
implements ISimpleBlockRenderingHandler {
    private int renderID;
    float incval = 0.1101f;

    public SimpleBlockRendererSluice(int rid) {
        this.renderID = rid;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntitySluiceBottom ts = (TileEntitySluiceBottom)world.func_147438_o(x, y, z);
        if (OresBase.proxy.renderPass == 0) {
            this.renderBase(world, x, y, z, block, modelId, renderer);
        } else if (ts.renderWater) {
            this.renderWaterStream(world, x, y, z, block, modelId, renderer, ts);
        } else {
            this.renderNothing(world, x, y, z, block, modelId, renderer);
        }
        return true;
    }

    private void renderNothing(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int l = Blocks.field_150344_f.func_149720_d(world, x, y, z);
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        renderer.field_147855_j = 1.0;
        renderer.func_147757_a(Blocks.field_150344_f.func_149691_a(0, 0));
        renderer.func_147808_b(Blocks.field_150344_f, x, y - 1, z, f, f1, f2);
        renderer.func_147757_a(null);
    }

    private void renderBase(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int l = Blocks.field_150344_f.func_149720_d(world, x, y, z);
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        renderer.field_147857_k = 0.125;
        renderer.field_147837_f = true;
        renderer.func_147757_a(Blocks.field_150344_f.func_149691_a(0, 0));
        renderer.func_147808_b(Blocks.field_150344_f, x, y, z, f, f1, f2);
        renderer.func_147757_a(null);
        renderer.field_147837_f = false;
    }

    private void renderWaterStream(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer, TileEntitySluiceBottom ts) {
        int m = world.func_72805_g(x, y, z);
        int meta = ts.getWaterAmount();
        Tessellator tessellator = Tessellator.field_78398_a;
        Material material = Material.field_151586_h;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.001f;
        IIcon iicon = BlockLiquid.func_149803_e((String)"water_flow");
        int l = block.func_149720_d(world, x, y, z);
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        int xx = 0;
        int zz = 0;
        switch (m & 3) {
            case 0: {
                int mm;
                d3 = (float)meta * this.incval + 0.002f;
                d4 = (float)meta * this.incval + 0.002f;
                TileEntitySluiceBottom te = (TileEntitySluiceBottom)world.func_147438_o(x, y, z - 1);
                if (te != null) {
                    mm = te.getWaterAmount();
                    d2 = (float)mm * this.incval + 0.002f;
                    d5 = (float)mm * this.incval + 0.002f;
                } else {
                    d2 = 0.125;
                    d5 = 0.125;
                }
                zz = -1;
                break;
            }
            case 1: {
                int mm;
                d2 = (float)meta * this.incval + 0.002f;
                d5 = (float)meta * this.incval + 0.002f;
                TileEntitySluiceBottom te = (TileEntitySluiceBottom)world.func_147438_o(x, y, z + 1);
                if (te != null) {
                    mm = te.getWaterAmount();
                    d3 = (float)mm * this.incval + 0.002f;
                    d4 = (float)mm * this.incval + 0.002f;
                } else {
                    d3 = 0.125;
                    d4 = 0.125;
                }
                zz = 1;
                break;
            }
            case 2: {
                int mm;
                d5 = (float)meta * this.incval + 0.002f;
                d4 = (float)meta * this.incval + 0.002f;
                TileEntitySluiceBottom te = (TileEntitySluiceBottom)world.func_147438_o(x - 1, y, z);
                if (te != null) {
                    mm = te.getWaterAmount();
                    d2 = (float)mm * this.incval + 0.002f;
                    d3 = (float)mm * this.incval + 0.002f;
                } else {
                    d2 = 0.125;
                    d3 = 0.125;
                }
                xx = -1;
                break;
            }
            case 3: {
                int mm;
                d3 = (float)meta * this.incval + 0.002f;
                d2 = (float)meta * this.incval + 0.002f;
                TileEntitySluiceBottom te = (TileEntitySluiceBottom)world.func_147438_o(x + 1, y, z);
                if (te != null) {
                    mm = te.getWaterAmount();
                    d4 = (float)mm * this.incval + 0.002f;
                    d5 = (float)mm * this.incval + 0.002f;
                } else {
                    d4 = 0.125;
                    d5 = 0.125;
                }
                xx = 1;
            }
        }
        d2 = Math.max(0.125, d2);
        d3 = Math.max(0.125, d3);
        d4 = Math.max(0.125, d4);
        d5 = Math.max(0.125, d5);
        float f7 = (float)(Math.atan2(zz, xx) - 1.5707963267948966);
        float f4 = 0.7f;
        float f9 = MathHelper.func_76126_a((float)f7) * 0.25f;
        float f10 = MathHelper.func_76134_b((float)f7) * 0.25f;
        float f11 = 8.0f;
        double d7 = iicon.func_94214_a((double)(8.0f + (-f10 - f9) * 16.0f));
        double d14 = iicon.func_94207_b((double)(8.0f + (-f10 + f9) * 16.0f));
        double d8 = iicon.func_94214_a((double)(8.0f + (-f10 + f9) * 16.0f));
        double d16 = iicon.func_94207_b((double)(8.0f + (f10 + f9) * 16.0f));
        double d10 = iicon.func_94214_a((double)(8.0f + (f10 + f9) * 16.0f));
        double d18 = iicon.func_94207_b((double)(8.0f + (f10 - f9) * 16.0f));
        double d12 = iicon.func_94214_a((double)(8.0f + (f10 - f9) * 16.0f));
        double d20 = iicon.func_94207_b((double)(8.0f + (-f10 - f9) * 16.0f));
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        tessellator.func_78369_a(f, f1, f2, 1.0f);
        tessellator.func_78374_a((double)(x + 0), (double)y + d2, (double)(z + 0), d7, d14);
        tessellator.func_78374_a((double)(x + 0), (double)y + d3, (double)(z + 1), d8, d16);
        tessellator.func_78374_a((double)(x + 1), (double)y + d4, (double)(z + 1), d10, d18);
        tessellator.func_78374_a((double)(x + 1), (double)y + d5, (double)(z + 0), d12, d20);
        tessellator.func_78374_a((double)(x + 0), (double)y + d2, (double)(z + 0), d7, d14);
        tessellator.func_78374_a((double)(x + 1), (double)y + d5, (double)(z + 0), d12, d20);
        tessellator.func_78374_a((double)(x + 1), (double)y + d4, (double)(z + 1), d10, d18);
        tessellator.func_78374_a((double)(x + 0), (double)y + d3, (double)(z + 1), d8, d16);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return this.renderID;
    }

    public float getLiquidHeight(IBlockAccess world, int x, int y, int z, Material mat) {
        int l = 0;
        float f = 0.0f;
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = x - (i1 & 1);
            int k1 = z - (i1 >> 1 & 1);
            if (world.func_147439_a(j1, y + 1, k1).func_149688_o() == mat) {
                return 1.0f;
            }
            Block b = world.func_147439_a(j1, y, k1);
            Material material1 = b.func_149688_o();
            if (material1 == mat) {
                int l1 = world.func_72805_g(j1, y, k1);
                if (l1 >= 8 || l1 == 0) {
                    f += BlockLiquid.func_149801_b((int)l1) * 10.0f;
                    l += 10;
                }
                f += BlockLiquid.func_149801_b((int)l1);
                ++l;
                continue;
            }
            if (material1.func_76220_a()) continue;
            f += 1.0f;
            ++l;
        }
        return 1.0f - f / (float)l;
    }

    public IIcon getBlockIcon(Block p_147793_1_, IBlockAccess p_147793_2_, int p_147793_3_, int p_147793_4_, int p_147793_5_, int p_147793_6_) {
        return this.getIconSafe(p_147793_1_.func_149673_e(p_147793_2_, p_147793_3_, p_147793_4_, p_147793_5_, p_147793_6_));
    }

    public IIcon getBlockIconFromSideAndMetadata(Block p_147787_1_, int p_147787_2_, int p_147787_3_) {
        return this.getIconSafe(p_147787_1_.func_149691_a(p_147787_2_, p_147787_3_));
    }

    public IIcon getBlockIconFromSide(Block p_147777_1_, int p_147777_2_) {
        return this.getIconSafe(p_147777_1_.func_149733_h(p_147777_2_));
    }

    public IIcon getBlockIcon(Block p_147745_1_) {
        return this.getIconSafe(p_147745_1_.func_149733_h(1));
    }

    public IIcon getIconSafe(IIcon p_147758_1_) {
        if (p_147758_1_ == null) {
            p_147758_1_ = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return p_147758_1_;
    }
}

