/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.block;

import com.draco18s.ores.OresBase;
import com.draco18s.ores.entities.TileEntitySluice;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSluice
extends BlockContainer {
    public BlockSluice() {
        super(Material.field_151593_r);
        this.func_149663_c("sluice");
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 1);
        this.func_149752_b(2.0f);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149658_d("minecraft:planks_birch");
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntitySluice();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setMeta(world, x, y, z);
    }

    private void setMeta(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block block = world.func_147439_a(x, y, z - 1);
            Block block1 = world.func_147439_a(x, y, z + 1);
            Block block2 = world.func_147439_a(x - 1, y, z);
            Block block3 = world.func_147439_a(x + 1, y, z);
            int b0 = 3;
            if (block.func_149730_j() && !block1.func_149730_j()) {
                b0 = 3;
            }
            if (block1.func_149730_j() && !block.func_149730_j()) {
                b0 = 2;
            }
            if (block2.func_149730_j() && !block3.func_149730_j()) {
                b0 = 5;
            }
            if (block3.func_149730_j() && !block2.func_149730_j()) {
                b0 = 4;
            }
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            tileEntity.field_145847_g = b0;
            world.func_72921_c(x, y, z, b0, 3);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        this.dropItems(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, par6);
    }

    private void dropItems(World world, int x, int y, int z) {
        float factor;
        EntityItem entityItem;
        float rz;
        float ry;
        float rx;
        Random rand = new Random();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        TileEntitySluice ts = (TileEntitySluice)tileEntity;
        ts.setNoWater();
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            rx = rand.nextFloat() * 0.8f + 0.1f;
            ry = rand.nextFloat() * 0.8f + 0.1f;
            rz = rand.nextFloat() * 0.8f + 0.1f;
            entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
        for (int q = ts.getDirt() / 5; q > 0; q -= 64) {
            int s = Math.min(q, 64);
            rx = rand.nextFloat() * 0.8f + 0.1f;
            ry = rand.nextFloat() * 0.8f + 0.1f;
            rz = rand.nextFloat() * 0.8f + 0.1f;
            entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(Blocks.field_150351_n, s));
            factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)OresBase.instance, 1, world, x, y, z);
        return true;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int p_149736_5_) {
        TileEntitySluice ts = (TileEntitySluice)world.func_147438_o(x, y, z);
        if (world.func_72864_z(x, y, z)) {
            if (ts.canFilter()) {
                return Container.func_94526_b((IInventory)ts);
            }
            return 15;
        }
        int d = ts.getDirt();
        if (d <= 640) {
            return d / 80;
        }
        if (d <= 1280) {
            return (d -= 640) / 160 + 8;
        }
        if (d <= 5120) {
            return (d -= 640) / 1920 + 12;
        }
        return 15;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        super.func_149695_a(world, x, y, z, b);
        if (!this.func_149742_c(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z).isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.UP);
    }
}

