/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores;

import CustomOreGen.Util.CogOreGenEvent;
import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.internal.OreFlowerData;
import com.draco18s.ores.OresBase;
import com.draco18s.ores.recipes.ChiselIntegration;
import com.draco18s.ores.recipes.GanyIntegration;
import com.draco18s.ores.util.EnumOreType;
import com.draco18s.ores.util.OreDataHooks;
import com.draco18s.ores.util.StatsAchievements;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AchievementEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.oredict.OreDictionary;

public class OresEventHandler {
    public static boolean poopBonemealFlowers = false;

    @SubscribeEvent
    public void bonemeal(BonemealEvent event) {
        if (!event.world.field_72995_K && event.block == Blocks.field_150349_c && (event.entityPlayer != null || poopBonemealFlowers)) {
            Map list = HardLibAPI.recipeManager.getOreList();
            for (Block b : list.keySet()) {
                int count = OreDataHooks.getOreData(event.world, event.x, event.y, event.z, b) + OreDataHooks.getOreData(event.world, event.x, event.y - 8, event.z, b) + OreDataHooks.getOreData(event.world, event.x, event.y - 16, event.z, b) + OreDataHooks.getOreData(event.world, event.x, event.y - 24, event.z, b);
                if (count <= 0) continue;
                count = (int)Math.min(Math.round(Math.log(count)), 10L);
                OreFlowerData entry = (OreFlowerData)list.get(b);
                if (count >= entry.highConcentrationThreshold && event.entityPlayer != null) {
                    OresBase.scatterFlowers(event.world, event.x, event.y, event.z, entry.flower, entry.metadata, 0, 1, 7);
                }
                while (--count >= 0) {
                    if (!OresBase.rand.nextBoolean() || event.entityPlayer == null && OresBase.rand.nextInt(128) != 0) continue;
                    OresBase.scatterFlowers(event.world, event.x, event.y, event.z, entry.flower, entry.metadata, 0, 1, 7);
                }
                if (event.entityPlayer == null) continue;
                event.entityPlayer.func_71064_a((StatBase)StatsAchievements.prospecting, 1);
            }
        }
    }

    @SubscribeEvent
    public void onPickup(PlayerEvent.ItemPickupEvent event) {
        ItemStack s;
        Item item = event.pickedUp.func_92059_d().func_77973_b();
        if (item == OresBase.oreChunks && event.pickedUp.func_92059_d().func_77960_j() == EnumOreType.LIMONITE.value) {
            event.player.func_71064_a((StatBase)StatsAchievements.mineLimonite, 1);
        }
        if (item == OresBase.oreChunks && event.pickedUp.func_92059_d().func_77960_j() == EnumOreType.IRON.value) {
            event.player.func_71064_a((StatBase)StatsAchievements.acquireIronChunk, 1);
        }
        if (item == Item.func_150898_a((Block)OresBase.blockOreFlowers) || item == Item.func_150898_a((Block)OresBase.blockOreFlowers2)) {
            event.player.func_71064_a((StatBase)StatsAchievements.oreFlowers, 1);
        }
        if (item == Item.func_150898_a((Block)OresBase.blockMill)) {
            event.player.func_71064_a((StatBase)StatsAchievements.craftMill, 1);
        }
        if (item == OresBase.oreChunks && event.pickedUp.func_92059_d().func_77960_j() == EnumOreType.DIAMOND.value) {
            event.player.func_71064_a((StatBase)AchievementList.field_76019_w, 1);
        }
        if (StatsAchievements.mineDiorite != null) {
            Block b = ChiselIntegration.getDioriteBlock();
            if (b != null && item == Item.func_150898_a((Block)b)) {
                event.player.func_71064_a((StatBase)StatsAchievements.mineDiorite, 1);
            }
            if ((b = GanyIntegration.getDioriteBlock()) != null && item == Item.func_150898_a((Block)b)) {
                event.player.func_71064_a((StatBase)StatsAchievements.mineDiorite, 1);
            }
        }
        if ((s = HardLibAPI.recipeManager.getSiftResult(event.pickedUp.func_92059_d(), false)) != null) {
            event.player.func_71064_a((StatBase)StatsAchievements.grindOre, 1);
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemTool tool;
        Item item = event.crafting.func_77973_b();
        if (item == Items.field_151042_j && event.player instanceof EntityPlayerMP && ((EntityPlayerMP)event.player).func_147099_x().func_77442_b(AchievementList.field_76016_k)) {
            event.player.func_71064_a((StatBase)StatsAchievements.fakeIronBar, 1);
            event.player.func_71064_a((StatBase)AchievementList.field_76016_k, 1);
        }
        if (item == Item.func_150898_a((Block)OresBase.blockSluice)) {
            event.player.func_71064_a((StatBase)StatsAchievements.craftSluice, 1);
        }
        if (item == Item.func_150898_a((Block)OresBase.blockSifter)) {
            event.player.func_71064_a((StatBase)StatsAchievements.craftSifter, 1);
        }
        if (item == Item.func_150898_a((Block)OresBase.blockMill)) {
            event.player.func_71064_a((StatBase)StatsAchievements.craftMill, 1);
        }
        if (item instanceof ItemTool && (tool = (ItemTool)item).func_77861_e().equals(OresBase.toolMaterialDiamondStud.name())) {
            event.player.func_71064_a((StatBase)StatsAchievements.craftDiamondStud, 1);
        }
        if (item instanceof ItemHoe && (tool = (ItemHoe)item).func_77842_f().equals(OresBase.toolMaterialDiamondStud.name())) {
            event.player.func_71064_a((StatBase)StatsAchievements.craftDiamondStud, 1);
        }
        ArrayList items = OreDictionary.getOres((String)"nuggetIron");
        boolean isNugget = false;
        for (ItemStack s : items) {
            isNugget |= OreDictionary.itemMatches((ItemStack)s, (ItemStack)event.crafting, (boolean)false);
        }
        if (isNugget) {
            event.player.func_71064_a((StatBase)StatsAchievements.acquireNuggets, 1);
        }
    }

    @SubscribeEvent
    public void onSmelting(PlayerEvent.ItemSmeltedEvent event) {
        Item item = event.smelting.func_77973_b();
        if (item == OresBase.oreChunks && event.smelting.func_77960_j() == EnumOreType.IRON.value) {
            event.player.func_71064_a((StatBase)StatsAchievements.acquireIronChunk, 1);
        }
        if (item == Items.field_151042_j && event.player instanceof EntityPlayerMP && ((EntityPlayerMP)event.player).func_147099_x().func_77442_b(AchievementList.field_76016_k)) {
            event.player.func_71064_a((StatBase)StatsAchievements.fakeIronBar, 1);
            event.player.func_71064_a((StatBase)AchievementList.field_76016_k, 1);
        }
        ArrayList items = OreDictionary.getOres((String)"nuggetIron");
        boolean isNugget = false;
        for (ItemStack s : items) {
            isNugget |= OreDictionary.itemMatches((ItemStack)s, (ItemStack)event.smelting, (boolean)false);
        }
        if (isNugget) {
            event.player.func_71064_a((StatBase)StatsAchievements.acquireNuggets, 1);
        }
    }

    @SubscribeEvent
    public void onAchievement(AchievementEvent event) {
        if (event.achievement == AchievementList.field_76016_k) {
            if (event.entityPlayer instanceof EntityPlayerMP && ((EntityPlayerMP)event.entityPlayer).func_147099_x().func_77442_b(StatsAchievements.fakeIronBar)) {
                event.entityPlayer.func_71064_a((StatBase)StatsAchievements.fakeIronBar, 1);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDrop(LivingDropsEvent event) {
        if (event.entity instanceof EntityIronGolem) {
            int count = 0;
            for (EntityItem b : event.drops) {
                if (b.func_92059_d().func_77973_b() != Items.field_151042_j) continue;
                event.drops.remove(b);
                ++count;
            }
            if (event.source != DamageSource.field_76371_c && event.source != DamageSource.field_76370_b && event.source != DamageSource.field_76368_d && event.source != DamageSource.field_76372_a) {
                event.drops.add(new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, new ItemStack(OresBase.nuggetIron, count * 2)));
            }
        }
    }

    @SubscribeEvent
    public void chunkGen(CogOreGenEvent event) {
        if (event.world.field_72995_K || event.world.field_73011_w.field_76574_g == Integer.MIN_VALUE) {
            return;
        }
        Chunk c = event.world.func_72938_d(event.worldX, event.worldZ);
        int cx = c.field_76635_g;
        int cz = c.field_76647_h;
        OresBase.oreCounter.generate(null, cx, cz, event.world);
    }

    @SubscribeEvent
    public void chunkLoad(ChunkDataEvent.Load event) {
        if (!event.world.field_72995_K) {
            OreDataHooks.readData(event.world, event.getChunk().field_76635_g, event.getChunk().field_76647_h, event.getData());
        }
    }

    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        if (!event.world.field_72995_K) {
            OreDataHooks.saveData(event.world, event.getChunk().field_76635_g, event.getChunk().field_76647_h, event.getData());
        }
    }
}

