/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores;

import com.draco18s.hardlib.CogConfig;
import com.draco18s.hardlib.RecipesUtil;
import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.internal.OreFlowerData;
import com.draco18s.ores.CommonProxy;
import com.draco18s.ores.GuiHandler;
import com.draco18s.ores.block.BlockAxle;
import com.draco18s.ores.block.BlockDummyOre;
import com.draco18s.ores.block.BlockMillstone;
import com.draco18s.ores.block.BlockOreFlower;
import com.draco18s.ores.block.BlockOreFlower2;
import com.draco18s.ores.block.BlockOreProcessor;
import com.draco18s.ores.block.BlockSifter;
import com.draco18s.ores.block.BlockSluice;
import com.draco18s.ores.block.BlockSluiceBottom;
import com.draco18s.ores.block.BlockWindvane;
import com.draco18s.ores.block.ores.BlockLimonite;
import com.draco18s.ores.block.ores.BlockOreCopper;
import com.draco18s.ores.block.ores.BlockOreDiamond;
import com.draco18s.ores.block.ores.BlockOreGold;
import com.draco18s.ores.block.ores.BlockOreIron;
import com.draco18s.ores.block.ores.BlockOreLead;
import com.draco18s.ores.block.ores.BlockOreNickel;
import com.draco18s.ores.block.ores.BlockOreRedstone;
import com.draco18s.ores.block.ores.BlockOreSilver;
import com.draco18s.ores.block.ores.BlockOreTin;
import com.draco18s.ores.block.ores.BlockOreUranium;
import com.draco18s.ores.entities.TileEntityMillstone;
import com.draco18s.ores.entities.TileEntityOreProcessor;
import com.draco18s.ores.entities.TileEntitySifter;
import com.draco18s.ores.entities.TileEntitySluice;
import com.draco18s.ores.entities.TileEntitySluiceBottom;
import com.draco18s.ores.entities.TileEntityWindmill;
import com.draco18s.ores.entities.TileEntityWindvane;
import com.draco18s.ores.item.AchievementIcons;
import com.draco18s.ores.item.ItemBlockOre;
import com.draco18s.ores.item.ItemBlockOreFlower;
import com.draco18s.ores.item.ItemBlockOreFlower2;
import com.draco18s.ores.item.ItemCrushOre;
import com.draco18s.ores.item.ItemDiamondStudAxe;
import com.draco18s.ores.item.ItemDiamondStudHoe;
import com.draco18s.ores.item.ItemDiamondStudPickaxe;
import com.draco18s.ores.item.ItemDiamondStudShovel;
import com.draco18s.ores.item.ItemOreDustLarge;
import com.draco18s.ores.item.ItemOreDustSmall;
import com.draco18s.ores.item.ItemRawOre;
import com.draco18s.ores.recipes.ChiselIntegration;
import com.draco18s.ores.recipes.GanyIntegration;
import com.draco18s.ores.recipes.IC2Integration;
import com.draco18s.ores.recipes.MekanismIntegration;
import com.draco18s.ores.recipes.MetallurgyIntegration;
import com.draco18s.ores.recipes.RecipeManager;
import com.draco18s.ores.recipes.RotaryIntegration;
import com.draco18s.ores.recipes.ThermalExpansionHelper;
import com.draco18s.ores.util.EnumOreType;
import com.draco18s.ores.util.OreCountGenerator;
import com.draco18s.ores.util.StatsAchievements;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Logger;

@Mod(modid="HarderOres", name="HarderOres", version="1.7.0a", dependencies="required-after:HardLib@[1.7,]")
public class OresBase {
    public static Block oreLimonite;
    public static Block oreIron;
    public static Block oreGold;
    public static Block oreDiamond;
    public static Block oreRedstone;
    public static Block oreTin;
    public static Block oreCopper;
    public static Block oreLead;
    public static Block oreUranium;
    public static Block oreSilver;
    public static Block oreNickel;
    public static Block dummyOreIron;
    public static Block dummyOreGold;
    public static Block dummyOreDiamond;
    public static Block dummyOreTin;
    public static Block dummyOreCopper;
    public static Block dummyOreLead;
    public static Block dummyOreUranium;
    public static Block dummyOreSilver;
    public static Block dummyOreNickel;
    public static Block blockSifter;
    public static Block blockMill;
    public static Block blockVane;
    public static Block blockAxle;
    public static Block blockSluice;
    public static Block blockProcessor;
    public static Block blockOreFlowers;
    public static Block blockOreFlowers2;
    public static Item oreChunks;
    public static Item nuggetIron;
    public static Item smallDusts;
    public static Item largeDusts;
    public static Item smallCrushed;
    public static Item diaStudPick;
    public static Item diaStudAxe;
    public static Item diaStudShovel;
    public static Item diaStudHoe;
    public static Item itemAchievementIcons;
    public static Material materialSluiceBox;
    public static Material materialGas;
    public static Item.ToolMaterial toolMaterialDiamondStud;
    @Mod.Instance(value="HarderOres")
    public static OresBase instance;
    public static Configuration config;
    public static boolean sluiceVersion;
    @SidedProxy(clientSide="com.draco18s.ores.client.ClientProxy", serverSide="com.draco18s.ores.CommonProxy")
    public static CommonProxy proxy;
    public static Random rand;
    public static OreCountGenerator oreCounter;
    public static Logger logger;
    private int extraOres = 0;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        HardLibAPI.recipeManager = new RecipeManager();
        logger = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        oreLimonite = new BlockLimonite();
        GameRegistry.registerBlock((Block)oreLimonite, (String)"ore_limonite");
        oreIron = new BlockOreIron();
        GameRegistry.registerBlock((Block)oreIron, ItemBlockOre.class, (String)"ore_iron");
        oreGold = new BlockOreGold();
        GameRegistry.registerBlock((Block)oreGold, ItemBlockOre.class, (String)"ore_gold");
        oreDiamond = new BlockOreDiamond();
        GameRegistry.registerBlock((Block)oreDiamond, ItemBlockOre.class, (String)"ore_diamond");
        oreRedstone = new BlockOreRedstone();
        GameRegistry.registerBlock((Block)oreRedstone, ItemBlockOre.class, (String)"ore_redstone");
        oreTin = new BlockOreTin();
        GameRegistry.registerBlock((Block)oreTin, ItemBlockOre.class, (String)"ore_tin");
        oreCopper = new BlockOreCopper();
        GameRegistry.registerBlock((Block)oreCopper, ItemBlockOre.class, (String)"ore_copper");
        oreLead = new BlockOreLead();
        GameRegistry.registerBlock((Block)oreLead, ItemBlockOre.class, (String)"ore_lead");
        oreUranium = new BlockOreUranium();
        GameRegistry.registerBlock((Block)oreUranium, ItemBlockOre.class, (String)"ore_uranium");
        oreSilver = new BlockOreSilver();
        GameRegistry.registerBlock((Block)oreSilver, ItemBlockOre.class, (String)"ore_silver");
        oreNickel = new BlockOreNickel();
        GameRegistry.registerBlock((Block)oreNickel, ItemBlockOre.class, (String)"ore_nickel");
        if (Loader.isModLoaded((String)"RotaryCraft")) {
            dummyOreIron = new BlockDummyOre(EnumOreType.IRON);
            dummyOreGold = new BlockDummyOre(EnumOreType.GOLD);
            GameRegistry.registerBlock((Block)dummyOreIron, (String)"dummyOreIron");
            GameRegistry.registerBlock((Block)dummyOreGold, (String)"dummyOreGold");
            OreDictionary.registerOre((String)"oreIron", (ItemStack)new ItemStack(dummyOreIron));
            OreDictionary.registerOre((String)"oreGold", (ItemStack)new ItemStack(dummyOreGold));
            GameRegistry.addSmelting((Block)dummyOreIron, (ItemStack)new ItemStack(Items.field_151042_j), (float)this.extraOres);
            GameRegistry.addSmelting((Block)dummyOreGold, (ItemStack)new ItemStack(Items.field_151043_k), (float)this.extraOres);
        }
        blockOreFlowers = new BlockOreFlower();
        GameRegistry.registerBlock((Block)blockOreFlowers, ItemBlockOreFlower.class, (String)"ore_flowers");
        blockOreFlowers2 = new BlockOreFlower2();
        GameRegistry.registerBlock((Block)blockOreFlowers2, ItemBlockOreFlower2.class, (String)"ore_flowers2");
        blockSifter = new BlockSifter();
        GameRegistry.registerBlock((Block)blockSifter, (String)"machine_sifter");
        blockProcessor = new BlockOreProcessor();
        GameRegistry.registerBlock((Block)blockProcessor, (String)"machine_processor");
        blockMill = new BlockMillstone();
        GameRegistry.registerBlock((Block)blockMill, (String)"machine_millstone");
        blockVane = new BlockWindvane();
        GameRegistry.registerBlock((Block)blockVane, (String)"machine_windvane");
        blockAxle = new BlockAxle();
        GameRegistry.registerBlock((Block)blockAxle, (String)"machine_axle");
        config.addCustomCategoryComment("SLUICE", "Various settings for the sluice.");
        config.get("SLUICE", "canFind...", false, "These setting indicate if the sluice can filter for the given mineral. Relative weights are handled\ninternally. Even if all settings are false, gravel can still be filtered to flint.");
        sluiceVersion = config.getBoolean("useContainerSluice", "SLUICE", false, "The Container-Sluice holds items, has a GUI, and supports comparator output. Non-container-sluice\nuses faux water flow mechanics, item entities, does not store items, and does not support the\ncomparator.");
        if (sluiceVersion) {
            blockSluice = new BlockSluice();
            GameRegistry.registerBlock((Block)blockSluice, (String)"machine_sluice");
        } else {
            blockSluice = new BlockSluiceBottom();
            GameRegistry.registerBlock((Block)blockSluice, (String)"machine_sluice");
        }
        config.save();
        GameRegistry.registerTileEntity(TileEntitySifter.class, (String)"ores.sifter");
        GameRegistry.registerTileEntity(TileEntityOreProcessor.class, (String)"ores.processor");
        GameRegistry.registerTileEntity(TileEntityMillstone.class, (String)"ores.millstone");
        GameRegistry.registerTileEntity(TileEntityWindmill.class, (String)"ores.windmill");
        GameRegistry.registerTileEntity(TileEntityWindvane.class, (String)"ores.windvane");
        if (sluiceVersion) {
            GameRegistry.registerTileEntity(TileEntitySluice.class, (String)"ores.sluice");
        } else {
            GameRegistry.registerTileEntity(TileEntitySluiceBottom.class, (String)"ores.sluice");
        }
        oreChunks = new ItemRawOre();
        GameRegistry.registerItem((Item)oreChunks, (String)"ore_chunk");
        nuggetIron = new Item().func_77655_b("iron_nugget").func_77637_a(CreativeTabs.field_78035_l).func_111206_d("ores:iron_nugget");
        GameRegistry.registerItem((Item)nuggetIron, (String)"iron_nugget");
        smallDusts = new ItemOreDustSmall();
        GameRegistry.registerItem((Item)smallDusts, (String)"smallDust");
        largeDusts = new ItemOreDustLarge();
        GameRegistry.registerItem((Item)largeDusts, (String)"largeDust");
        if (Loader.isModLoaded((String)"IC2")) {
            smallCrushed = new ItemCrushOre();
            GameRegistry.registerItem((Item)smallCrushed, (String)"smallCrusedOre");
        }
        toolMaterialDiamondStud = EnumHelper.addToolMaterial((String)"DIAMOND_STUD", (int)3, (int)750, (float)7.0f, (float)2.0f, (int)5);
        OresBase.toolMaterialDiamondStud.customCraftingMaterial = oreChunks;
        diaStudPick = new ItemDiamondStudPickaxe(toolMaterialDiamondStud);
        diaStudAxe = new ItemDiamondStudAxe(toolMaterialDiamondStud);
        diaStudShovel = new ItemDiamondStudShovel(toolMaterialDiamondStud);
        diaStudHoe = new ItemDiamondStudHoe(toolMaterialDiamondStud);
        GameRegistry.registerItem((Item)diaStudPick, (String)"diam_stud_pickaxe");
        GameRegistry.registerItem((Item)diaStudAxe, (String)"diam_stud_axe");
        GameRegistry.registerItem((Item)diaStudHoe, (String)"diam_stud_hoe");
        GameRegistry.registerItem((Item)diaStudShovel, (String)"diam_stud_shovel");
        itemAchievementIcons = new AchievementIcons();
        GameRegistry.registerItem((Item)itemAchievementIcons, (String)"itemAchievementIcons");
        oreCounter = new OreCountGenerator();
        CogConfig.addCogModule((String)"HarderVanillaOres.xml");
        CogConfig.addCogModule((String)"HarderExtraOres.xml");
        CogConfig.addCogModule((String)"HarderLimonite.xml");
        FMLInterModComms.sendMessage((String)"HarderUnderground", (String)"RR-underground-support", (ItemStack)new ItemStack(oreIron));
        FMLInterModComms.sendMessage((String)"HarderUnderground", (String)"RR-underground-support", (ItemStack)new ItemStack(oreGold));
        FMLInterModComms.sendMessage((String)"HarderUnderground", (String)"RR-underground-support", (ItemStack)new ItemStack(oreDiamond));
        FMLInterModComms.sendMessage((String)"HarderUnderground", (String)"RR-underground-support", (ItemStack)new ItemStack(oreRedstone));
        FMLInterModComms.sendMessage((String)"HarderUnderground", (String)"RR-underground-isPartialBlock", (ItemStack)new ItemStack(blockSluice));
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerRenderers();
        ItemStack rawOreIn = new ItemStack(oreChunks);
        ItemStack nuggetOut = new ItemStack(oreChunks);
        rawOreIn.func_77964_b(EnumOreType.LIMONITE.value);
        GameRegistry.addSmelting((ItemStack)rawOreIn, (ItemStack)nuggetOut, (float)0.1f);
        rawOreIn = new ItemStack(oreChunks);
        nuggetOut = new ItemStack(nuggetIron);
        rawOreIn.func_77964_b(EnumOreType.IRON.value);
        GameRegistry.addSmelting((ItemStack)rawOreIn, (ItemStack)nuggetOut, (float)0.1f);
        rawOreIn = new ItemStack(oreChunks);
        nuggetOut = new ItemStack(Items.field_151074_bl);
        rawOreIn.func_77964_b(EnumOreType.GOLD.value);
        GameRegistry.addSmelting((ItemStack)rawOreIn, (ItemStack)nuggetOut, (float)0.1f);
        rawOreIn = new ItemStack(smallDusts);
        nuggetOut = new ItemStack(nuggetIron);
        rawOreIn.func_77964_b(EnumOreType.IRON.value);
        GameRegistry.addSmelting((ItemStack)rawOreIn, (ItemStack)nuggetOut, (float)0.1f);
        rawOreIn = new ItemStack(smallDusts);
        nuggetOut = new ItemStack(Items.field_151074_bl);
        rawOreIn.func_77964_b(EnumOreType.GOLD.value);
        GameRegistry.addSmelting((ItemStack)rawOreIn, (ItemStack)nuggetOut, (float)0.1f);
        rawOreIn = new ItemStack(largeDusts);
        nuggetOut = new ItemStack(Items.field_151042_j);
        rawOreIn.func_77964_b(EnumOreType.IRON.value);
        GameRegistry.addSmelting((ItemStack)rawOreIn, (ItemStack)nuggetOut, (float)0.1f);
        rawOreIn = new ItemStack(largeDusts);
        nuggetOut = new ItemStack(Items.field_151043_k);
        rawOreIn.func_77964_b(EnumOreType.GOLD.value);
        GameRegistry.addSmelting((ItemStack)rawOreIn, (ItemStack)nuggetOut, (float)0.1f);
        rawOreIn = new ItemStack(oreRedstone);
        nuggetOut = new ItemStack(Items.field_151137_ax);
        GameRegistry.addSmelting((ItemStack)rawOreIn, (ItemStack)nuggetOut, (float)0.7f);
        OreDictionary.registerOre((String)"dustIron", (ItemStack)new ItemStack(largeDusts, 1, EnumOreType.IRON.value));
        OreDictionary.registerOre((String)"dustGold", (ItemStack)new ItemStack(largeDusts, 1, EnumOreType.GOLD.value));
        OreDictionary.registerOre((String)"dustFlour", (ItemStack)new ItemStack(largeDusts, 1, EnumOreType.FLOUR.value));
        OreDictionary.registerOre((String)"dustTinyIron", (ItemStack)new ItemStack(smallDusts, 1, EnumOreType.IRON.value));
        OreDictionary.registerOre((String)"dustTinyGold", (ItemStack)new ItemStack(smallDusts, 1, EnumOreType.GOLD.value));
        OreDictionary.registerOre((String)"dustTinyFlour", (ItemStack)new ItemStack(smallDusts, 1, EnumOreType.FLOUR.value));
        OreDictionary.registerOre((String)"dustTinySugar", (ItemStack)new ItemStack(smallDusts, 1, EnumOreType.SUGAR.value));
        OreDictionary.registerOre((String)"dustTinySilver", (ItemStack)new ItemStack(smallDusts, 1, EnumOreType.SILVER.value));
        OreDictionary.registerOre((String)"dustTinyNickel", (ItemStack)new ItemStack(smallDusts, 1, EnumOreType.NICKEL.value));
        OreDictionary.registerOre((String)"nuggetIron", (ItemStack)new ItemStack(nuggetIron));
        OreDictionary.registerOre((String)"chunkLimonite", (ItemStack)new ItemStack(oreChunks, 1, EnumOreType.LIMONITE.value));
        OreDictionary.registerOre((String)"chunkIron", (ItemStack)new ItemStack(oreChunks, 1, EnumOreType.IRON.value));
        OreDictionary.registerOre((String)"chunkGold", (ItemStack)new ItemStack(oreChunks, 1, EnumOreType.GOLD.value));
        OreDictionary.registerOre((String)"chunkDiamond", (ItemStack)new ItemStack(oreChunks, 1, EnumOreType.DIAMOND.value));
        OreDictionary.registerOre((String)"chunkTin", (ItemStack)new ItemStack(oreChunks, 1, EnumOreType.TIN.value));
        OreDictionary.registerOre((String)"chunkCopper", (ItemStack)new ItemStack(oreChunks, 1, EnumOreType.COPPER.value));
        OreDictionary.registerOre((String)"chunkLead", (ItemStack)new ItemStack(oreChunks, 1, EnumOreType.LEAD.value));
        OreDictionary.registerOre((String)"chunkUranium", (ItemStack)new ItemStack(oreChunks, 1, EnumOreType.URANIUM.value));
        OreDictionary.registerOre((String)"chunkSilver", (ItemStack)new ItemStack(oreChunks, 1, EnumOreType.SILVER.value));
        OreDictionary.registerOre((String)"chunkNickel", (ItemStack)new ItemStack(oreChunks, 1, EnumOreType.NICKEL.value));
        OreDictionary.registerOre((String)"oreIronHard", (ItemStack)new ItemStack(oreIron, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"oreGoldHard", (ItemStack)new ItemStack(oreGold, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"oreDiamondHard", (ItemStack)new ItemStack(oreDiamond, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"oreTinHard", (ItemStack)new ItemStack(oreTin, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"oreCopperHard", (ItemStack)new ItemStack(oreCopper, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"oreLeadHard", (ItemStack)new ItemStack(oreLead, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"oreUraniumHard", (ItemStack)new ItemStack(oreUranium, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"oreSilverHard", (ItemStack)new ItemStack(oreSilver, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"oreNickelHard", (ItemStack)new ItemStack(oreNickel, 1, Short.MAX_VALUE));
        rawOreIn = new ItemStack(oreChunks);
        rawOreIn.func_77964_b(EnumOreType.DIAMOND.value);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151045_i), (Object[])new Object[]{rawOreIn, rawOreIn, rawOreIn, rawOreIn, rawOreIn, rawOreIn, rawOreIn, rawOreIn, rawOreIn});
        String oreIn = "nuggetIron";
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151042_j), new Object[]{oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(nuggetIron, 9), new Object[]{Items.field_151042_j}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150411_aY), new Object[]{"iii", "iii", Character.valueOf('i'), oreIn}));
        oreIn = "dustTinyIron";
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(largeDusts, 1, EnumOreType.IRON.value), new Object[]{oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn}));
        oreIn = "dustTinyGold";
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(largeDusts, 1, EnumOreType.GOLD.value), new Object[]{oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn}));
        oreIn = "dustTinyFlour";
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(largeDusts, 1, EnumOreType.FLOUR.value), new Object[]{oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn}));
        oreIn = "dustTinySugar";
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151102_aT), new Object[]{oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn}));
        oreIn = "slabWood";
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockSluice, 2), new Object[]{"sss", "ppp", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('p'), oreIn}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMill, 9), new Object[]{true, new Object[]{"SSS", "SWS", "SSS", Character.valueOf('S'), "stone", Character.valueOf('W'), "logWood"}}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockSifter), new Object[]{true, new Object[]{"PBP", "PbP", Character.valueOf('b'), Items.field_151133_ar, Character.valueOf('P'), "plankWood", Character.valueOf('B'), Blocks.field_150411_aY}}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockVane, 2), new Object[]{true, new Object[]{"SW", "SW", "SW", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('W'), Blocks.field_150325_L}}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockAxle, 2), new Object[]{true, new Object[]{"WWW", Character.valueOf('W'), "logWood"}}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockProcessor), new Object[]{"sps", "i i", "iii", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('s'), "stone", Character.valueOf('p'), Blocks.field_150331_J}));
        rawOreIn = new ItemStack(Items.field_151137_ax, 9);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150451_bX));
        rawOreIn = new ItemStack(Items.field_151015_O, 9);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150407_cf));
        rawOreIn = new ItemStack(Items.field_151126_ay, 4);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150433_aE));
        rawOreIn = new ItemStack(Items.field_151042_j, 9);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150339_S));
        rawOreIn = new ItemStack(Items.field_151043_k, 9);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150340_R));
        rawOreIn = new ItemStack(Items.field_151119_aD, 4);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150435_aG));
        rawOreIn = new ItemStack(Items.field_151128_bU, 4);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150371_ca));
        rawOreIn = new ItemStack((Block)Blocks.field_150354_m, 4);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150322_A));
        rawOreIn = new ItemStack(Items.field_151044_h, 9);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150402_ci));
        rawOreIn = new ItemStack(Blocks.field_150432_aD, 9);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150403_cj));
        rawOreIn = new ItemStack(Blocks.field_150433_aE, 9);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150432_aD));
        rawOreIn = new ItemStack(Items.field_151100_aR, 9, 9);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150368_y));
        rawOreIn = new ItemStack(Items.field_151127_ba, 9);
        HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(Blocks.field_150440_ba));
        oreIn = "ingotIron";
        rawOreIn = new ItemStack(oreChunks);
        rawOreIn.func_77964_b(EnumOreType.DIAMOND.value);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(diaStudPick), new Object[]{true, new Object[]{"dId", " s ", " s ", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('I'), oreIn, Character.valueOf('d'), rawOreIn}}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(diaStudAxe), new Object[]{true, new Object[]{"dI ", "Is ", " s ", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('I'), oreIn, Character.valueOf('d'), rawOreIn}}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(diaStudShovel), new Object[]{true, new Object[]{" d ", " I ", " s ", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('I'), oreIn, Character.valueOf('d'), rawOreIn}}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(diaStudHoe), new Object[]{true, new Object[]{"dI ", " s ", " s ", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('I'), oreIn, Character.valueOf('d'), rawOreIn}}));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        rawOreIn = new ItemStack(smallDusts, 8);
        nuggetOut = new ItemStack(largeDusts, 1);
        rawOreIn.func_77964_b(EnumOreType.IRON.value);
        nuggetOut.func_77964_b(EnumOreType.IRON.value);
        HardLibAPI.recipeManager.addSiftRecipe(rawOreIn, nuggetOut);
        if (dummyOreIron != null) {
            rawOreIn.field_77994_a = 9;
            HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(dummyOreIron));
        }
        rawOreIn.func_77964_b(EnumOreType.GOLD.value);
        nuggetOut.func_77964_b(EnumOreType.GOLD.value);
        HardLibAPI.recipeManager.addSiftRecipe(rawOreIn, nuggetOut);
        if (dummyOreGold != null) {
            rawOreIn.field_77994_a = 9;
            HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(dummyOreGold));
        }
        rawOreIn.func_77964_b(EnumOreType.FLOUR.value);
        nuggetOut.func_77964_b(EnumOreType.FLOUR.value);
        HardLibAPI.recipeManager.addSiftRecipe(rawOreIn, nuggetOut);
        rawOreIn.func_77964_b(EnumOreType.SUGAR.value);
        nuggetOut = new ItemStack(Items.field_151102_aT);
        HardLibAPI.recipeManager.addSiftRecipe(rawOreIn, nuggetOut);
        rawOreIn = new ItemStack(oreChunks);
        nuggetOut = new ItemStack(smallDusts, 2);
        rawOreIn.func_77964_b(EnumOreType.IRON.value);
        nuggetOut.func_77964_b(EnumOreType.IRON.value);
        HardLibAPI.recipeManager.addMillRecipe(rawOreIn, nuggetOut);
        rawOreIn.func_77964_b(EnumOreType.GOLD.value);
        nuggetOut.func_77964_b(EnumOreType.GOLD.value);
        HardLibAPI.recipeManager.addMillRecipe(rawOreIn, nuggetOut);
        config.addCustomCategoryComment("MILLING", "Enable (hard mode) these to remove vanilla recipes for items and instead require the millstone. In general,\neasy means the millstone doubles resources, while hard is near-vanilla.");
        boolean hardOption = config.getBoolean("flourRequireMilling", "MILLING", false, "");
        oreIn = "dustFlour";
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151106_aX, 8), new Object[]{"wcw", Character.valueOf('w'), oreIn, Character.valueOf('c'), new ItemStack(Items.field_151100_aR, 1, 3)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151105_aU), new Object[]{"mmm", "ses", "www", Character.valueOf('w'), oreIn, Character.valueOf('s'), Items.field_151102_aT, Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('m'), Items.field_151117_aB}));
        if (hardOption) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151025_P, 3), new Object[]{"www", Character.valueOf('w'), oreIn}));
            RecipesUtil.RemoveRecipe((Item)Items.field_151025_P, (int)1, (int)0, (String)"Hard Ores");
            RecipesUtil.RemoveRecipe((Item)Items.field_151106_aX, (int)8, (int)0, (String)"Hard Ores");
            RecipesUtil.RemoveRecipe((Item)Items.field_151105_aU, (int)1, (int)0, (String)"Hard Ores");
            rawOreIn = new ItemStack(Items.field_151015_O);
            nuggetOut = new ItemStack(smallDusts, 4);
            nuggetOut.func_77964_b(EnumOreType.FLOUR.value);
            HardLibAPI.recipeManager.addMillRecipe(rawOreIn, nuggetOut);
            rawOreIn = new ItemStack(Items.field_151014_N);
            nuggetOut = new ItemStack(smallDusts, 1);
            nuggetOut.func_77964_b(EnumOreType.FLOUR.value);
            HardLibAPI.recipeManager.addMillRecipe(rawOreIn, nuggetOut);
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151025_P), new Object[]{"www", Character.valueOf('w'), oreIn}));
            rawOreIn = new ItemStack(Items.field_151015_O);
            nuggetOut = new ItemStack(smallDusts, 18);
            nuggetOut.func_77964_b(EnumOreType.FLOUR.value);
            HardLibAPI.recipeManager.addMillRecipe(rawOreIn, nuggetOut);
            rawOreIn = new ItemStack(Items.field_151014_N);
            nuggetOut = new ItemStack(smallDusts, 2);
            nuggetOut.func_77964_b(EnumOreType.FLOUR.value);
            HardLibAPI.recipeManager.addMillRecipe(rawOreIn, nuggetOut);
        }
        hardOption = config.getBoolean("sugarRequireMilling", "MILLING", false, "If enabled, sugarcane cannot be crafted into sugar");
        int sugarMulti = config.getInt("sugarMillingMultiplier", "MILLING", 6, 1, 12, "Sugar is a easy-to-get resource and rare-to-use, so it may be desirable to reduce the production.\nOutput of milling sugar (in tiny piles) is this value in hard-milling and 2x this value in\neasy-milling.\nVanilla Equivalence is 9.");
        if (hardOption) {
            RecipesUtil.RemoveRecipe((Item)Items.field_151102_aT, (int)1, (int)0, (String)"Hard Ores");
            rawOreIn = new ItemStack(Items.field_151120_aE);
            nuggetOut = new ItemStack(smallDusts, sugarMulti);
            nuggetOut.func_77964_b(EnumOreType.SUGAR.value);
            HardLibAPI.recipeManager.addMillRecipe(rawOreIn, nuggetOut);
        } else {
            rawOreIn = new ItemStack(Items.field_151120_aE);
            nuggetOut = new ItemStack(smallDusts, 2 * sugarMulti);
            nuggetOut.func_77964_b(EnumOreType.SUGAR.value);
            HardLibAPI.recipeManager.addMillRecipe(rawOreIn, nuggetOut);
        }
        hardOption = config.getBoolean("bonemealRequireMilling", "MILLING", false, "");
        if (hardOption) {
            RecipesUtil.RemoveRecipe((Item)Items.field_151100_aR, (int)3, (int)15, (String)"Hard Ores");
            rawOreIn = new ItemStack(Items.field_151103_aS);
            nuggetOut = new ItemStack(Items.field_151100_aR, 2, 15);
            HardLibAPI.recipeManager.addMillRecipe(rawOreIn, nuggetOut);
        } else {
            rawOreIn = new ItemStack(Items.field_151103_aS);
            nuggetOut = new ItemStack(Items.field_151100_aR, 4, 15);
            HardLibAPI.recipeManager.addMillRecipe(rawOreIn, nuggetOut);
        }
        config.save();
        rawOreIn = new ItemStack(Items.field_151100_aR, 1, 15);
        HardLibAPI.recipeManager.addSiftRecipe(rawOreIn, rawOreIn, false);
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.draco18s.ores.recipes.WailaIntegration.callbackRegister");
        if (Loader.isModLoaded((String)"IC2")) {
            StatsAchievements.addIC2Achievements();
            IC2Integration.registerAPIRecipes();
            this.addTin();
            this.addCopper();
            this.addLead();
            this.addUranium();
            HardLibAPI.recipeManager.addSluiceRecipe(Blocks.field_150351_n);
            HardLibAPI.recipeManager.addSluiceRecipe(Blocks.field_150351_n);
            HardLibAPI.recipeManager.addSluiceRecipe(null);
        }
        if (Loader.isModLoaded((String)"ThermalExpansion")) {
            this.addTin();
            this.addCopper();
            this.addSilver();
            this.addNickel();
            HardLibAPI.recipeManager.addSluiceRecipe(Blocks.field_150351_n);
            HardLibAPI.recipeManager.addSluiceRecipe(Blocks.field_150351_n);
            HardLibAPI.recipeManager.addSluiceRecipe(null);
            ThermalExpansionHelper.addTERecipes();
        }
        if (Loader.isModLoaded((String)"Metallurgy")) {
            this.addTin();
            this.addCopper();
            this.addSilver();
            HardLibAPI.recipeManager.addSluiceRecipe(Blocks.field_150351_n);
            HardLibAPI.recipeManager.addSluiceRecipe(null);
            MetallurgyIntegration.addMetallurgyRecipes();
        }
        if (Loader.isModLoaded((String)"Mekanism")) {
            this.addTin();
            this.addCopper();
            HardLibAPI.recipeManager.addSluiceRecipe(Blocks.field_150351_n);
            HardLibAPI.recipeManager.addSluiceRecipe(null);
            MekanismIntegration.addMekanismRecipies();
        }
        if (Loader.isModLoaded((String)"RotaryCraft")) {
            RotaryIntegration.registerAPIRecipes();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        StatsAchievements.addCoreAchievements();
        OreFlowerData data = new OreFlowerData(blockOreFlowers, EnumOreType.IRON.value, 7);
        HardLibAPI.recipeManager.addOreFlowerData(oreIron, data);
        data = new OreFlowerData(blockOreFlowers, EnumOreType.GOLD.value, 6);
        HardLibAPI.recipeManager.addOreFlowerData(oreGold, data);
        data = new OreFlowerData(blockOreFlowers, EnumOreType.DIAMOND.value, 5);
        HardLibAPI.recipeManager.addOreFlowerData(oreDiamond, data);
        data = new OreFlowerData(blockOreFlowers, EnumOreType.REDSTONE.value, 999);
        HardLibAPI.recipeManager.addOreFlowerData(oreRedstone, data);
        data = new OreFlowerData(blockOreFlowers, EnumOreType.TIN.value, 6);
        HardLibAPI.recipeManager.addOreFlowerData(oreTin, data);
        data = new OreFlowerData(blockOreFlowers, EnumOreType.COPPER.value, 6);
        HardLibAPI.recipeManager.addOreFlowerData(oreCopper, data);
        data = new OreFlowerData(blockOreFlowers, EnumOreType.LEAD.value, 5);
        HardLibAPI.recipeManager.addOreFlowerData(oreLead, data);
        data = new OreFlowerData(blockOreFlowers, EnumOreType.URANIUM.value, 4);
        HardLibAPI.recipeManager.addOreFlowerData(oreUranium, data);
        data = new OreFlowerData(blockOreFlowers2, EnumOreType.SILVER.value, 5);
        HardLibAPI.recipeManager.addOreFlowerData(oreSilver, data);
        data = new OreFlowerData(blockOreFlowers2, EnumOreType.NICKEL.value, 5);
        HardLibAPI.recipeManager.addOreFlowerData(oreNickel, data);
        if (config.get("SLUICE", "canFindIron", true).getBoolean()) {
            HardLibAPI.recipeManager.addSluiceRecipe(oreIron);
            HardLibAPI.recipeManager.addSluiceRecipe(oreIron);
            HardLibAPI.recipeManager.addSluiceRecipe(oreIron);
        }
        if (config.get("SLUICE", "canFindGold", true).getBoolean()) {
            HardLibAPI.recipeManager.addSluiceRecipe(oreGold);
            HardLibAPI.recipeManager.addSluiceRecipe(oreGold);
            HardLibAPI.recipeManager.addSluiceRecipe(oreGold);
        }
        if (config.get("SLUICE", "canFindDiamond", false).getBoolean()) {
            HardLibAPI.recipeManager.addSluiceRecipe(oreDiamond);
        }
        if (config.get("SLUICE", "canFindRedstone", true).getBoolean()) {
            HardLibAPI.recipeManager.addSluiceRecipe(oreRedstone);
            HardLibAPI.recipeManager.addSluiceRecipe(oreRedstone);
        }
        HardLibAPI.recipeManager.addSluiceRecipe(Blocks.field_150351_n);
        HardLibAPI.recipeManager.addSluiceRecipe(null);
        boolean p = config.getBoolean("useDioriteStoneTools", "GENERAL", true, "If Gany's Surface or Chisel is installed and this is true, cobblestone cannot be used to create stone tools,\ninstead diorite is used. This prolongs the life of wood tools so it isn't \"make a wood pickaxe to\nmine 3 stone and upgrade.\"");
        if (Loader.isModLoaded((String)"ganyssurface") && p) {
            GanyIntegration.registerAPIRecipes();
            StatsAchievements.addGanyAchievements();
        }
        if (Loader.isModLoaded((String)"chisel") && p) {
            ChiselIntegration.registerAPIRecipes();
            StatsAchievements.addChiselAchievements();
        }
        if (!HardLibAPI.recipeManager.isSluiceSetFull()) {
            HardLibAPI.recipeManager.addSluiceRecipe(Blocks.field_150351_n);
            HardLibAPI.recipeManager.addSluiceRecipe(Blocks.field_150351_n);
            HardLibAPI.recipeManager.addSluiceRecipe(null);
        }
        proxy.registerEventHandlers();
        CogConfig.unpackDefaultConfig();
        CogConfig.unpackConfigs();
        config.save();
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            if (imcMessage.key.equalsIgnoreCase("RR-special-stone-update-gany")) {
                if (!imcMessage.isItemStackMessage()) continue;
                GanyIntegration.setAlternateBlock(Block.func_149634_a((Item)imcMessage.getItemStackValue().func_77973_b()));
                continue;
            }
            if (!imcMessage.key.equalsIgnoreCase("RR-special-stone-update-chisel") || !imcMessage.isItemStackMessage()) continue;
            ChiselIntegration.setAlternateBlock(Block.func_149634_a((Item)imcMessage.getItemStackValue().func_77973_b()));
        }
    }

    private void addTin() {
        if ((this.extraOres & 1) == 0) {
            if (config.get("SLUICE", "canFindTin", true).getBoolean()) {
                HardLibAPI.recipeManager.addSluiceRecipe(oreTin);
                HardLibAPI.recipeManager.addSluiceRecipe(oreTin);
                HardLibAPI.recipeManager.addSluiceRecipe(oreTin);
            }
            ItemStack rawOreIn = new ItemStack(oreChunks, 1, EnumOreType.TIN.value);
            ArrayList stk = OreDictionary.getOres((String)"dustTin");
            ArrayList tstk = OreDictionary.getOres((String)"dustTinyTin");
            ArrayList nstk = OreDictionary.getOres((String)"nuggetTin");
            if (stk.size() > 0 && tstk.size() > 0) {
                String oreIn = "dustTinyTin";
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe((ItemStack)stk.get(0), new Object[]{oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn}));
                ItemStack instk = (ItemStack)tstk.get(0);
                if (nstk.size() > 0) {
                    GameRegistry.addSmelting((ItemStack)instk, (ItemStack)((ItemStack)nstk.get(0)), (float)0.1f);
                }
                instk.field_77994_a = 2;
                HardLibAPI.recipeManager.addMillRecipe(rawOreIn, instk);
                instk.field_77994_a = 8;
                HardLibAPI.recipeManager.addSiftRecipe(instk, (ItemStack)stk.get(0));
            }
            dummyOreTin = new BlockDummyOre(EnumOreType.TIN);
            GameRegistry.registerBlock((Block)dummyOreTin, (String)"dummyOreTin");
            OreDictionary.registerOre((String)"oreTin", (ItemStack)new ItemStack(dummyOreTin));
            rawOreIn.field_77994_a = 9;
            HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(dummyOreTin));
            this.extraOres |= 1;
        }
    }

    private void addCopper() {
        if ((this.extraOres & 2) == 0) {
            if (config.get("SLUICE", "canFindCopper", true).getBoolean()) {
                HardLibAPI.recipeManager.addSluiceRecipe(oreCopper);
                HardLibAPI.recipeManager.addSluiceRecipe(oreCopper);
                HardLibAPI.recipeManager.addSluiceRecipe(oreCopper);
            }
            ItemStack rawOreIn = new ItemStack(oreChunks, 1, EnumOreType.COPPER.value);
            ArrayList stk = OreDictionary.getOres((String)"dustCopper");
            ArrayList tstk = OreDictionary.getOres((String)"dustTinyCopper");
            ArrayList nstk = OreDictionary.getOres((String)"nuggetCopper");
            if (stk.size() > 0 && tstk.size() > 0) {
                String oreIn = "dustTinyCopper";
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe((ItemStack)stk.get(0), new Object[]{oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn}));
                ItemStack instk = (ItemStack)tstk.get(0);
                if (nstk.size() > 0) {
                    GameRegistry.addSmelting((ItemStack)instk, (ItemStack)((ItemStack)nstk.get(0)), (float)0.1f);
                }
                instk.field_77994_a = 2;
                HardLibAPI.recipeManager.addMillRecipe(rawOreIn, instk);
                instk.field_77994_a = 8;
                HardLibAPI.recipeManager.addSiftRecipe(instk, (ItemStack)stk.get(0));
            }
            dummyOreCopper = new BlockDummyOre(EnumOreType.COPPER);
            GameRegistry.registerBlock((Block)dummyOreCopper, (String)"dummyOreCopper");
            OreDictionary.registerOre((String)"oreCopper", (ItemStack)new ItemStack(dummyOreCopper));
            rawOreIn.field_77994_a = 9;
            HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(dummyOreCopper));
            this.extraOres |= 2;
        }
    }

    private void addLead() {
        if ((this.extraOres & 4) == 0) {
            if (config.get("SLUICE", "canFindLead", true).getBoolean()) {
                HardLibAPI.recipeManager.addSluiceRecipe(oreLead);
                HardLibAPI.recipeManager.addSluiceRecipe(oreLead);
            }
            ItemStack rawOreIn = new ItemStack(oreChunks, 1, EnumOreType.LEAD.value);
            ArrayList stk = OreDictionary.getOres((String)"dustLead");
            ArrayList tstk = OreDictionary.getOres((String)"dustTinyLead");
            ArrayList nstk = OreDictionary.getOres((String)"nuggetLead");
            if (stk.size() > 0 && tstk.size() > 0) {
                String oreIn = "dustTinyLead";
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe((ItemStack)stk.get(0), new Object[]{oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn}));
                ItemStack instk = (ItemStack)tstk.get(0);
                if (nstk.size() > 0) {
                    GameRegistry.addSmelting((ItemStack)instk, (ItemStack)((ItemStack)nstk.get(0)), (float)0.1f);
                }
                instk.field_77994_a = 2;
                HardLibAPI.recipeManager.addMillRecipe(rawOreIn, instk);
                instk.field_77994_a = 8;
                HardLibAPI.recipeManager.addSiftRecipe(instk, (ItemStack)stk.get(0));
            }
            dummyOreLead = new BlockDummyOre(EnumOreType.LEAD);
            GameRegistry.registerBlock((Block)dummyOreLead, (String)"dummyOreLead");
            OreDictionary.registerOre((String)"oreLead", (ItemStack)new ItemStack(dummyOreLead));
            rawOreIn.field_77994_a = 9;
            HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(dummyOreLead));
            this.extraOres |= 4;
        }
    }

    private void addUranium() {
        if ((this.extraOres & 8) == 0) {
            if (config.get("SLUICE", "canFindUranium", false).getBoolean() && (this.extraOres & 8) == 0) {
                HardLibAPI.recipeManager.addSluiceRecipe(oreUranium);
            }
            dummyOreUranium = new BlockDummyOre(EnumOreType.URANIUM);
            GameRegistry.registerBlock((Block)dummyOreUranium, (String)"dummyOreUranium");
            OreDictionary.registerOre((String)"oreUranium", (ItemStack)new ItemStack(dummyOreUranium));
            ItemStack rawOreIn = new ItemStack(oreChunks, 9, EnumOreType.SILVER.value);
            HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(dummyOreUranium));
            this.extraOres |= 8;
        }
    }

    private void addSilver() {
        if ((this.extraOres & 0x10) == 0) {
            if (config.get("SLUICE", "canFindSilver", true).getBoolean()) {
                HardLibAPI.recipeManager.addSluiceRecipe(oreSilver);
            }
            ItemStack rawOreIn = new ItemStack(oreChunks, 1, EnumOreType.SILVER.value);
            ArrayList stk = OreDictionary.getOres((String)"dustSilver");
            ArrayList tstk = OreDictionary.getOres((String)"dustTinySilver");
            ArrayList nstk = OreDictionary.getOres((String)"nuggetSilver");
            if (stk.size() > 0 && tstk.size() > 0) {
                String oreIn = "dustTinySilver";
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe((ItemStack)stk.get(0), new Object[]{oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn}));
                ItemStack instk = (ItemStack)tstk.get(0);
                if (nstk.size() > 0) {
                    GameRegistry.addSmelting((ItemStack)instk, (ItemStack)((ItemStack)nstk.get(0)), (float)0.1f);
                }
                instk.field_77994_a = 2;
                HardLibAPI.recipeManager.addMillRecipe(rawOreIn, instk);
                instk.field_77994_a = 8;
                HardLibAPI.recipeManager.addSiftRecipe(instk, (ItemStack)stk.get(0));
            }
            dummyOreSilver = new BlockDummyOre(EnumOreType.SILVER);
            GameRegistry.registerBlock((Block)dummyOreSilver, (String)"dummyOreSilver");
            OreDictionary.registerOre((String)"oreSilver", (ItemStack)new ItemStack(dummyOreSilver));
            rawOreIn.field_77994_a = 9;
            HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(dummyOreSilver));
            this.extraOres |= 0x10;
        }
    }

    private void addNickel() {
        if ((this.extraOres & 0x20) == 0) {
            if (config.get("SLUICE", "canFindNickel", true).getBoolean()) {
                HardLibAPI.recipeManager.addSluiceRecipe(oreNickel);
            }
            ItemStack rawOreIn = new ItemStack(oreChunks, 1, EnumOreType.NICKEL.value);
            ArrayList stk = OreDictionary.getOres((String)"dustNickel");
            ArrayList tstk = OreDictionary.getOres((String)"dustTinyNickel");
            ArrayList nstk = OreDictionary.getOres((String)"nuggetNickel");
            if (stk.size() > 0 && tstk.size() > 0) {
                String oreIn = "dustTinyNickel";
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe((ItemStack)stk.get(0), new Object[]{oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn, oreIn}));
                ItemStack instk = (ItemStack)tstk.get(0);
                if (nstk.size() > 0) {
                    GameRegistry.addSmelting((ItemStack)instk, (ItemStack)((ItemStack)nstk.get(0)), (float)0.1f);
                }
                instk.field_77994_a = 2;
                HardLibAPI.recipeManager.addMillRecipe(rawOreIn, instk);
                instk.field_77994_a = 8;
                HardLibAPI.recipeManager.addSiftRecipe(instk, (ItemStack)stk.get(0));
            }
            dummyOreNickel = new BlockDummyOre(EnumOreType.NICKEL);
            GameRegistry.registerBlock((Block)dummyOreNickel, (String)"dummyOreNickel");
            OreDictionary.registerOre((String)"oreNickel", (ItemStack)new ItemStack(dummyOreNickel));
            rawOreIn.field_77994_a = 9;
            HardLibAPI.recipeManager.addProcessorRecipe(rawOreIn, new ItemStack(dummyOreNickel));
            this.extraOres |= 0x20;
        }
    }

    public static void scatterFlowers(World world, int x, int y, int z, Block b, int meta, int radius, int num, int clusterRadius) {
        boolean replaceLeaves;
        Random r = new Random();
        float[] u = OresBase.RandomInUnitCircle(r);
        boolean bl = replaceLeaves = num > 1;
        for (int fails = 0; num > 0 && fails < 20; ++fails) {
            int j = x + r.nextInt(clusterRadius) - clusterRadius / 2 + Math.round(u[0] * (float)radius);
            int k = y - 5;
            int l = z + r.nextInt(clusterRadius) - clusterRadius / 2 + Math.round(u[1] * (float)radius);
            int f = 0;
            while (f + k <= y + 5) {
                Block ba = world.func_147439_a(j, f + k + 1, l);
                if (world.func_147439_a(j, f + k, l) == Blocks.field_150349_c && (ba == Blocks.field_150350_a || ba == Blocks.field_150431_aC || ba.func_149688_o() == Material.field_151585_k || ba.func_149688_o() == Material.field_151577_b || ba.func_149688_o() == Material.field_151582_l || replaceLeaves && ba.func_149688_o() == Material.field_151584_j)) {
                    world.func_147465_d(j, f + k + 1, l, b, meta, 3);
                    if (meta == EnumOreType.GOLD.value && r.nextInt(8) == 0) {
                        world.func_147465_d(j, f + k + 1, l, b, meta | 8, 3);
                    }
                    if (meta == EnumOreType.REDSTONE.value && r.nextInt(3) == 0 && world.func_147439_a(j, f + k + 2, l) == Blocks.field_150350_a) {
                        world.func_147465_d(j, f + k + 1, l, b, meta | 8, 3);
                        world.func_147465_d(j, f + k + 2, l, b, meta, 3);
                    }
                    if (meta == EnumOreType.TIN.value && r.nextInt(3) == 0 && world.func_147439_a(j, f + k + 2, l) == Blocks.field_150350_a) {
                        world.func_147465_d(j, f + k + 1, l, b, meta | 8, 3);
                        world.func_147465_d(j, f + k + 2, l, b, meta, 3);
                    }
                    --num;
                    k = 100;
                }
                ++f;
            }
        }
    }

    public static float[] RandomInUnitCircle(Random rn) {
        float t = (float)Math.PI * (2.0f * rn.nextFloat());
        float u = rn.nextFloat() + rn.nextFloat();
        float r = u > 1.0f ? 2.0f - u : u;
        return new float[]{r * (float)Math.cos(t), r * (float)Math.sin(t)};
    }

    static {
        materialSluiceBox = new Material(MapColor.field_151663_o);
        materialGas = new MaterialLiquid(MapColor.field_151660_b);
        rand = new Random();
    }
}

