/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hardlibcore.asm;

import com.draco18s.hardlibcore.asm.ASMHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class HardLibPatcher
implements IClassTransformer {
    private Type RANDOM_TYPE = Type.getType((String)"Ljava/util/Random;");
    private Type BLOCK_TYPE = Type.getType((String)"Lnet/minecraft/block/Block;");
    private Type WORLD_TYPE = Type.getType((String)"Lnet/minecraft/world/World;");
    private Type PLAYER_TYPE = Type.getType((String)"Lnet/minecraft/entity/player/EntityPlayer;");
    private Type ANIMAL_TYPE = Type.getType((String)"Lnet/minecraft/entity/passive/EntityAnimal;");
    private static Random rand = new Random();
    public static long moonPhaseTime = 24000L;
    public static Block unstableStoneBlock;
    private static Constructor blockConstr;
    private static Constructor animalConstr;
    private static Field evField;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.block.BlockSnow")) {
            return this.transformSnow(bytes, "BlockSnow");
        }
        if (transformedName.equals("net.minecraft.block.BlockIce")) {
            return this.transformSnow(bytes, "BlockIce");
        }
        if (transformedName.equals("net.minecraft.block.BlockCrops")) {
            return this.transformCrops(bytes);
        }
        if (transformedName.equals("net.minecraft.entity.passive.EntityAnimal")) {
            return this.transformAnimals(bytes);
        }
        if (transformedName.equals("net.minecraft.world.WorldProvider")) {
            return this.transformWorldProvider(bytes);
        }
        if (transformedName.equals("net.minecraft.block.BlockStem")) {
            return this.transformStem(bytes);
        }
        if (transformedName.equals("net.minecraft.block.BlockFalling")) {
            return this.transformSnow(bytes, "BlockFalling");
        }
        if (transformedName.equals("net.minecraft.block.BlockSilverfish")) {
            return this.transformMonsterEgg(bytes);
        }
        return bytes;
    }

    private byte[] transformMonsterEgg(byte[] bytes) {
        ClassNode classNode = ASMHelper.createClassNode(bytes);
        this.patchMonsterEgg(classNode);
        return ASMHelper.makeBytes(classNode, 3);
    }

    private byte[] transformBlockFalling(byte[] bytes, String name) {
        ClassNode classNode = ASMHelper.createClassNode(bytes);
        this.patchSnow(classNode, name);
        return ASMHelper.makeBytes(classNode, 3);
    }

    private byte[] transformSnow(byte[] bytes, String name) {
        ClassNode classNode = ASMHelper.createClassNode(bytes);
        this.patchSnow(classNode, name);
        return ASMHelper.makeBytes(classNode, 3);
    }

    private byte[] transformWorldProvider(byte[] bytes) {
        ClassNode classNode = ASMHelper.createClassNode(bytes);
        this.patchWorldProvider(classNode);
        return ASMHelper.makeBytes(classNode, 3);
    }

    private byte[] transformAnimals(byte[] bytes) {
        ClassNode classNode = ASMHelper.createClassNode(bytes);
        this.patchEntityAnimal(classNode);
        return ASMHelper.makeBytes(classNode, 3);
    }

    private byte[] transformCrops(byte[] bytes) {
        ClassNode classNode = ASMHelper.createClassNode(bytes);
        this.patchBlockCrops(classNode);
        return ASMHelper.makeBytes(classNode, 3);
    }

    private byte[] transformStem(byte[] bytes) {
        ClassNode classNode = ASMHelper.createClassNode(bytes);
        this.patchBlockStem(classNode);
        return ASMHelper.makeBytes(classNode, 3);
    }

    private void patchMonsterEgg(ClassNode classNode) {
        System.out.println("==Patching BlockSilverfish==");
        MethodNode method = ASMHelper.findMethod(classNode, "func_150196_a", "func_150196_a", Type.BOOLEAN_TYPE, this.BLOCK_TYPE);
        InsnList patch = new InsnList();
        AbstractInsnNode absNode = ASMHelper.findFirst(165, method.instructions);
        LabelNode lbl = ((JumpInsnNode)absNode).label;
        FieldInsnNode fiNode = new FieldInsnNode(178, "com/draco18s/hardlibcore/asm/HardLibPatcher", "unstableStoneBlock", this.BLOCK_TYPE.getDescriptor());
        patch.add((AbstractInsnNode)new VarInsnNode(25, 0));
        patch.add((AbstractInsnNode)fiNode);
        patch.add((AbstractInsnNode)new JumpInsnNode(165, lbl));
        method.instructions.insert(absNode, patch);
    }

    private void patchSnow(ClassNode classNode, String name) {
        System.out.println("==Patching " + name + "==");
        MethodNode method = ASMHelper.findMethod(classNode, "func_149674_a", "updateTick", Type.VOID_TYPE, this.WORLD_TYPE, Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, this.RANDOM_TYPE);
        InsnList patch = new InsnList();
        AbstractInsnNode absNode = ASMHelper.findLast(177, method.instructions);
        patch.add((AbstractInsnNode)new VarInsnNode(25, 1));
        patch.add((AbstractInsnNode)new VarInsnNode(21, 2));
        patch.add((AbstractInsnNode)new VarInsnNode(21, 3));
        patch.add((AbstractInsnNode)new VarInsnNode(21, 4));
        patch.add((AbstractInsnNode)new MethodInsnNode(184, "com/draco18s/hardlibcore/asm/HardLibPatcher", "snowMeltByTemp", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{this.WORLD_TYPE, Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE})));
        method.instructions.insertBefore(absNode, patch);
    }

    private void patchWorldProvider(ClassNode classNode) {
        System.out.println("==Patching WorldProvider==");
        MethodNode method = ASMHelper.findMethod(classNode, "func_76559_b", "getMoonPhase", Type.INT_TYPE, Type.LONG_TYPE);
        InsnList patch = new InsnList();
        AbstractInsnNode absNode = ASMHelper.findFirst(18, method.instructions);
        LdcInsnNode ldc = (LdcInsnNode)absNode;
        ldc.cst = moonPhaseTime;
    }

    private void patchEntityAnimal(ClassNode classNode) {
        MethodNode method = ASMHelper.findMethod(classNode, "func_146082_f", Type.VOID_TYPE, this.PLAYER_TYPE);
        AbstractInsnNode absNode = ASMHelper.findFirst(17, method.instructions);
        if (absNode != null) {
            System.out.println("==Patching EntityAnimal==");
            InsnList patch = new InsnList();
            patch.add((AbstractInsnNode)new InsnNode(89));
            patch.add((AbstractInsnNode)new VarInsnNode(25, 1));
            patch.add((AbstractInsnNode)new MethodInsnNode(184, "com/draco18s/hardlibcore/asm/HardLibPatcher", "animalLoveMode", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{this.ANIMAL_TYPE, this.PLAYER_TYPE})));
            patch.add((AbstractInsnNode)new InsnNode(89));
            LabelNode label = new LabelNode();
            patch.add((AbstractInsnNode)new JumpInsnNode(154, label));
            patch.add((AbstractInsnNode)new InsnNode(177));
            patch.add((AbstractInsnNode)label);
            method.instructions.insertBefore(absNode, patch);
            method.instructions.remove(absNode);
        }
    }

    private void patchBlockStem(ClassNode classNode) {
        System.out.println("==Patching BlockStem==");
        MethodNode method = ASMHelper.findMethod(classNode, "func_149674_a", "updateTick", Type.VOID_TYPE, this.WORLD_TYPE, Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, this.RANDOM_TYPE);
        InsnList patch = new InsnList();
        patch.add((AbstractInsnNode)new VarInsnNode(25, 1));
        patch.add((AbstractInsnNode)new VarInsnNode(21, 2));
        patch.add((AbstractInsnNode)new VarInsnNode(21, 3));
        patch.add((AbstractInsnNode)new VarInsnNode(21, 4));
        patch.add((AbstractInsnNode)new MethodInsnNode(184, "com/draco18s/hardlibcore/asm/HardLibPatcher", "cropSkipGrowth", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{this.WORLD_TYPE, Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE})));
        LabelNode label = new LabelNode();
        patch.add((AbstractInsnNode)new JumpInsnNode(153, label));
        patch.add((AbstractInsnNode)new InsnNode(177));
        patch.add((AbstractInsnNode)label);
        AbstractInsnNode absNode = ASMHelper.findFirst(183, method.instructions);
        method.instructions.insert(absNode, patch);
        method = ASMHelper.findMethod(classNode, "func_149874_m", Type.VOID_TYPE, this.WORLD_TYPE, Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE);
        absNode = ASMHelper.findFirst(182, method.instructions);
        absNode = absNode.getNext().getNext().getNext();
        patch = new InsnList();
        patch.add((AbstractInsnNode)new InsnNode(4));
        patch.add((AbstractInsnNode)new InsnNode(6));
        method.instructions.insertBefore(absNode, patch);
        method.instructions.remove(absNode.getNext());
        method.instructions.remove(absNode);
    }

    private void patchBlockCrops(ClassNode classNode) {
        System.out.println("==Patching BlockCrops==");
        MethodNode method = ASMHelper.findMethod(classNode, "func_149674_a", "updateTick", Type.VOID_TYPE, this.WORLD_TYPE, Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, this.RANDOM_TYPE);
        InsnList patch = new InsnList();
        patch.add((AbstractInsnNode)new VarInsnNode(25, 1));
        patch.add((AbstractInsnNode)new VarInsnNode(21, 2));
        patch.add((AbstractInsnNode)new VarInsnNode(21, 3));
        patch.add((AbstractInsnNode)new VarInsnNode(21, 4));
        patch.add((AbstractInsnNode)new MethodInsnNode(184, "com/draco18s/hardlibcore/asm/HardLibPatcher", "cropSkipGrowth", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{this.WORLD_TYPE, Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE})));
        LabelNode label = new LabelNode();
        patch.add((AbstractInsnNode)new JumpInsnNode(153, label));
        patch.add((AbstractInsnNode)new InsnNode(177));
        patch.add((AbstractInsnNode)label);
        AbstractInsnNode absNode = ASMHelper.findFirst(183, method.instructions);
        method.instructions.insert(absNode, patch);
        method = ASMHelper.findMethod(classNode, "func_149863_m", Type.VOID_TYPE, this.WORLD_TYPE, Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE);
        absNode = ASMHelper.findFirst(182, method.instructions);
        absNode = absNode.getNext().getNext().getNext();
        patch = new InsnList();
        patch.add((AbstractInsnNode)new InsnNode(4));
        patch.add((AbstractInsnNode)new InsnNode(6));
        method.instructions.insertBefore(absNode, patch);
        method.instructions.remove(absNode.getNext());
        method.instructions.remove(absNode);
    }

    public static int animalLoveMode(EntityAnimal anim, EntityPlayer player) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, NoSuchFieldException, SecurityException {
        if (animalConstr == null) {
            Class<?> cls = Class.forName("com.draco18s.hardlib.events.EntityAnimalInteractEvent$AnimalLoveEvent");
            animalConstr = cls.getConstructors()[0];
            evField = cls.getField("loveTime");
        }
        if (player == null) {
            return 600;
        }
        Event ev = (Event)animalConstr.newInstance(player, anim.getClass(), 600);
        MinecraftForge.EVENT_BUS.post(ev);
        return evField.getInt(ev);
    }

    public static void snowMeltByTemp(World world, int x, int y, int z) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        if (blockConstr == null) {
            Constructor<?>[] allConstructors;
            Class<?> cls = Class.forName("com.draco18s.hardlib.events.SpecialBlockEvent$BlockUpdateEvent");
            for (Constructor<?> ctor : allConstructors = cls.getDeclaredConstructors()) {
                Class<?>[] pType = ctor.getParameterTypes();
                if (pType.length != 7) continue;
                blockConstr = ctor;
            }
        }
        BiomeGenBase bio = world.func_72807_a(x, z);
        Event ev = (Event)blockConstr.newInstance(world, x, y, z, world.func_72805_g(x, y, z), world.func_147439_a(x, y, z), bio);
        MinecraftForge.EVENT_BUS.post(ev);
    }

    public static int cropSkipGrowth(World world, int x, int y, int z) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        if (blockConstr == null) {
            Class<?> cls = Class.forName("com.draco18s.hardlib.events.SpecialBlockEvent$BlockUpdateEvent");
            blockConstr = cls.getConstructors()[0];
        }
        BiomeGenBase bio = world.func_72807_a(x, z);
        Event ev = (Event)blockConstr.newInstance(world, x, y, z, world.func_72805_g(x, y, z), world.func_147439_a(x, y, z), bio);
        if (MinecraftForge.EVENT_BUS.post(ev)) {
            return 1;
        }
        return 0;
    }
}

