/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hardlibcore.asm;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.FMLLog;
import java.util.ListIterator;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMHelper {
    private static final BiMap<String, Integer> opCodes = HashBiMap.create((int)166);

    private ASMHelper() {
    }

    public static ClassNode createClassNode(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode(262144);
        reader.accept((ClassVisitor)classNode, 8);
        FMLLog.log((String)"S1LIB", (Level)Level.TRACE, (String)"Beginning to patch %s", (Object[])new Object[]{classNode.name});
        return classNode;
    }

    public static byte[] makeBytes(ClassNode classNode) {
        return ASMHelper.makeBytes(classNode, 2);
    }

    public static byte[] makeBytes(ClassNode classNode, int flags) {
        ClassWriter writer = new ClassWriter(flags);
        classNode.accept((ClassVisitor)writer);
        FMLLog.log((String)"S1LIB", (Level)Level.TRACE, (String)"Completed patching %s", (Object[])new Object[]{classNode.name});
        return writer.toByteArray();
    }

    public static MethodNode findMethod(ClassNode clazz, String obf, String deobf, Type returnType, Type ... argumentTypes) {
        String desc = Type.getMethodDescriptor((Type)returnType, (Type[])argumentTypes);
        for (MethodNode node : clazz.methods) {
            if (!node.name.equals(obf) && !node.name.equals(deobf) || !node.desc.equals(desc)) continue;
            return node;
        }
        return null;
    }

    public static MethodNode findMethod(ClassNode clazz, String name, Type returnType, Type ... argumentTypes) {
        String desc = Type.getMethodDescriptor((Type)returnType, (Type[])argumentTypes);
        for (MethodNode node : clazz.methods) {
            if (node.name.equals(name) && node.desc.equals(desc)) {
                return node;
            }
            if (!node.name.equals(name)) continue;
            System.out.println("Did you mean '" + node.desc + "' instead of '" + desc + "'?");
        }
        return null;
    }

    public static MethodNode findConstructor(ClassNode clazz, Type ... argumentTypes) {
        return ASMHelper.findMethod(clazz, "<init>", Type.VOID_TYPE, argumentTypes);
    }

    public static AbstractInsnNode findFirst(int opcode, InsnList instructions) {
        for (AbstractInsnNode node : instructions) {
            if (node.getOpcode() != opcode) continue;
            return node;
        }
        return null;
    }

    public static AbstractInsnNode findLast(int opcode, InsnList instructions) {
        ListIterator it = instructions.iterator();
        AbstractInsnNode last = null;
        while (it.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            if (node.getOpcode() != opcode) continue;
            last = node;
        }
        return last;
    }

    public static void printOpcodes(MethodNode method) {
        if (method == null) {
            System.out.println("Method was null!");
            return;
        }
        for (AbstractInsnNode node : method.instructions) {
            JumpInsnNode jmp;
            InvokeDynamicInsnNode dyn;
            System.out.println(ASMHelper.getOpcode(node.getOpcode()));
            if (node instanceof InvokeDynamicInsnNode) {
                dyn = (InvokeDynamicInsnNode)node;
                System.out.println("  -->" + dyn.name);
                continue;
            }
            if (node instanceof MethodInsnNode) {
                dyn = (MethodInsnNode)node;
                System.out.println("  -->" + dyn.name);
                continue;
            }
            if (node instanceof IntInsnNode) {
                dyn = (IntInsnNode)node;
                System.out.println("  -->" + dyn.operand);
                continue;
            }
            if (node instanceof FieldInsnNode) {
                FieldInsnNode fi = (FieldInsnNode)node;
                System.out.println("  -->" + fi.desc);
                System.out.println("  -->" + fi.name);
                System.out.println("  -->" + fi.owner);
                continue;
            }
            if (node instanceof JumpInsnNode) {
                jmp = (JumpInsnNode)node;
                System.out.println("  -->" + jmp.label);
                continue;
            }
            if (node instanceof LabelNode) {
                jmp = (LabelNode)node;
                System.out.println("  ==>" + jmp.toString());
                continue;
            }
            if (node.getOpcode() == -1) {
                System.out.println("  :" + node.getType());
                continue;
            }
            if (node.getOpcode() != 25 && node.getOpcode() != 21) continue;
            VarInsnNode va = (VarInsnNode)node;
            System.out.println("  :" + va.var);
        }
    }

    public static String getOpcode(int opcode) {
        String s = (String)opCodes.inverse().get((Object)opcode);
        if (s == null) {
            s = opcode + "";
        }
        return s;
    }

    public static int getOpcodeFromString(String string) {
        Integer opCode = (Integer)opCodes.get((Object)string);
        if (opCode == null) {
            opCode = ASMHelper.intParseSafe(string);
        }
        return opCode != null ? opCode : 0;
    }

    public static Integer intParseSafe(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static {
        opCodes.put((Object)"NOP", (Object)0);
        opCodes.put((Object)"ACONST_NULL", (Object)1);
        opCodes.put((Object)"ICONST_M1", (Object)2);
        opCodes.put((Object)"ICONST_0", (Object)3);
        opCodes.put((Object)"ICONST_1", (Object)4);
        opCodes.put((Object)"ICONST_2", (Object)5);
        opCodes.put((Object)"ICONST_3", (Object)6);
        opCodes.put((Object)"ICONST_4", (Object)7);
        opCodes.put((Object)"ICONST_5", (Object)8);
        opCodes.put((Object)"LCONST_0", (Object)9);
        opCodes.put((Object)"LCONST_1", (Object)10);
        opCodes.put((Object)"FCONST_0", (Object)11);
        opCodes.put((Object)"FCONST_1", (Object)12);
        opCodes.put((Object)"FCONST_2", (Object)13);
        opCodes.put((Object)"DCONST_0", (Object)14);
        opCodes.put((Object)"DCONST_1", (Object)15);
        opCodes.put((Object)"BIPUSH", (Object)16);
        opCodes.put((Object)"SIPUSH", (Object)17);
        opCodes.put((Object)"LDC", (Object)18);
        opCodes.put((Object)"ILOAD", (Object)21);
        opCodes.put((Object)"LLOAD", (Object)22);
        opCodes.put((Object)"FLOAD", (Object)23);
        opCodes.put((Object)"DLOAD", (Object)24);
        opCodes.put((Object)"ALOAD", (Object)25);
        opCodes.put((Object)"IALOAD", (Object)46);
        opCodes.put((Object)"LALOAD", (Object)47);
        opCodes.put((Object)"FALOAD", (Object)48);
        opCodes.put((Object)"DALOAD", (Object)49);
        opCodes.put((Object)"AALOAD", (Object)50);
        opCodes.put((Object)"BALOAD", (Object)51);
        opCodes.put((Object)"CALOAD", (Object)52);
        opCodes.put((Object)"SALOAD", (Object)53);
        opCodes.put((Object)"ISTORE", (Object)54);
        opCodes.put((Object)"LSTORE", (Object)55);
        opCodes.put((Object)"FSTORE", (Object)56);
        opCodes.put((Object)"DSTORE", (Object)57);
        opCodes.put((Object)"ASTORE", (Object)58);
        opCodes.put((Object)"IASTORE", (Object)79);
        opCodes.put((Object)"LASTORE", (Object)80);
        opCodes.put((Object)"FASTORE", (Object)81);
        opCodes.put((Object)"DASTORE", (Object)82);
        opCodes.put((Object)"AASTORE", (Object)83);
        opCodes.put((Object)"BASTORE", (Object)84);
        opCodes.put((Object)"CASTORE", (Object)85);
        opCodes.put((Object)"SASTORE", (Object)86);
        opCodes.put((Object)"POP", (Object)87);
        opCodes.put((Object)"POP2", (Object)88);
        opCodes.put((Object)"DUP", (Object)89);
        opCodes.put((Object)"DUP_X1", (Object)90);
        opCodes.put((Object)"DUP_X2", (Object)91);
        opCodes.put((Object)"DUP2", (Object)92);
        opCodes.put((Object)"DUP2_X1", (Object)93);
        opCodes.put((Object)"DUP2_X2", (Object)94);
        opCodes.put((Object)"SWAP", (Object)95);
        opCodes.put((Object)"IADD", (Object)96);
        opCodes.put((Object)"LADD", (Object)97);
        opCodes.put((Object)"FADD", (Object)98);
        opCodes.put((Object)"DADD", (Object)99);
        opCodes.put((Object)"ISUB", (Object)100);
        opCodes.put((Object)"LSUB", (Object)101);
        opCodes.put((Object)"FSUB", (Object)102);
        opCodes.put((Object)"DSUB", (Object)103);
        opCodes.put((Object)"IMUL", (Object)104);
        opCodes.put((Object)"LMUL", (Object)105);
        opCodes.put((Object)"FMUL", (Object)106);
        opCodes.put((Object)"DMUL", (Object)107);
        opCodes.put((Object)"IDIV", (Object)108);
        opCodes.put((Object)"LDIV", (Object)109);
        opCodes.put((Object)"FDIV", (Object)110);
        opCodes.put((Object)"DDIV", (Object)111);
        opCodes.put((Object)"IREM", (Object)112);
        opCodes.put((Object)"LREM", (Object)113);
        opCodes.put((Object)"FREM", (Object)114);
        opCodes.put((Object)"DREM", (Object)115);
        opCodes.put((Object)"INEG", (Object)116);
        opCodes.put((Object)"LNEG", (Object)117);
        opCodes.put((Object)"FNEG", (Object)118);
        opCodes.put((Object)"DNEG", (Object)119);
        opCodes.put((Object)"ISHL", (Object)120);
        opCodes.put((Object)"LSHL", (Object)121);
        opCodes.put((Object)"ISHR", (Object)122);
        opCodes.put((Object)"LSHR", (Object)123);
        opCodes.put((Object)"IUSHR", (Object)124);
        opCodes.put((Object)"LUSHR", (Object)125);
        opCodes.put((Object)"IAND", (Object)126);
        opCodes.put((Object)"LAND", (Object)127);
        opCodes.put((Object)"IOR", (Object)128);
        opCodes.put((Object)"LOR", (Object)129);
        opCodes.put((Object)"IXOR", (Object)130);
        opCodes.put((Object)"LXOR", (Object)131);
        opCodes.put((Object)"IINC", (Object)132);
        opCodes.put((Object)"I2L", (Object)133);
        opCodes.put((Object)"I2F", (Object)134);
        opCodes.put((Object)"I2D", (Object)135);
        opCodes.put((Object)"L2I", (Object)136);
        opCodes.put((Object)"L2F", (Object)137);
        opCodes.put((Object)"L2D", (Object)138);
        opCodes.put((Object)"F2I", (Object)139);
        opCodes.put((Object)"F2L", (Object)140);
        opCodes.put((Object)"F2D", (Object)141);
        opCodes.put((Object)"D2I", (Object)142);
        opCodes.put((Object)"D2L", (Object)143);
        opCodes.put((Object)"D2F", (Object)144);
        opCodes.put((Object)"I2B", (Object)145);
        opCodes.put((Object)"I2C", (Object)146);
        opCodes.put((Object)"I2S", (Object)147);
        opCodes.put((Object)"LCMP", (Object)148);
        opCodes.put((Object)"FCMPL", (Object)149);
        opCodes.put((Object)"FCMPG", (Object)150);
        opCodes.put((Object)"DCMPL", (Object)151);
        opCodes.put((Object)"DCMPG", (Object)152);
        opCodes.put((Object)"IFEQ", (Object)153);
        opCodes.put((Object)"IFNE", (Object)154);
        opCodes.put((Object)"IFLT", (Object)155);
        opCodes.put((Object)"IFGE", (Object)156);
        opCodes.put((Object)"IFGT", (Object)157);
        opCodes.put((Object)"IFLE", (Object)158);
        opCodes.put((Object)"IF_ICMPEQ", (Object)159);
        opCodes.put((Object)"IF_ICMPNE", (Object)160);
        opCodes.put((Object)"IF_ICMPLT", (Object)161);
        opCodes.put((Object)"IF_ICMPGE", (Object)162);
        opCodes.put((Object)"IF_ICMPGT", (Object)163);
        opCodes.put((Object)"IF_ICMPLE", (Object)164);
        opCodes.put((Object)"IF_ACMPEQ", (Object)165);
        opCodes.put((Object)"IF_ACMPNE", (Object)166);
        opCodes.put((Object)"GOTO", (Object)167);
        opCodes.put((Object)"JSR", (Object)168);
        opCodes.put((Object)"RET", (Object)169);
        opCodes.put((Object)"TABLESWITCH", (Object)170);
        opCodes.put((Object)"LOOKUPSWITCH", (Object)171);
        opCodes.put((Object)"IRETURN", (Object)172);
        opCodes.put((Object)"LRETURN", (Object)173);
        opCodes.put((Object)"FRETURN", (Object)174);
        opCodes.put((Object)"DRETURN", (Object)175);
        opCodes.put((Object)"ARETURN", (Object)176);
        opCodes.put((Object)"RETURN", (Object)177);
        opCodes.put((Object)"GETSTATIC", (Object)178);
        opCodes.put((Object)"PUTSTATIC", (Object)179);
        opCodes.put((Object)"GETFIELD", (Object)180);
        opCodes.put((Object)"PUTFIELD", (Object)181);
        opCodes.put((Object)"INVOKEVIRTUAL", (Object)182);
        opCodes.put((Object)"INVOKESPECIAL", (Object)183);
        opCodes.put((Object)"INVOKESTATIC", (Object)184);
        opCodes.put((Object)"INVOKEINTERFACE", (Object)185);
        opCodes.put((Object)"INVOKEDYNAMIC", (Object)186);
        opCodes.put((Object)"NEW", (Object)187);
        opCodes.put((Object)"NEWARRAY", (Object)188);
        opCodes.put((Object)"ANEWARRAY", (Object)189);
        opCodes.put((Object)"ARRAYLENGTH", (Object)190);
        opCodes.put((Object)"ATHROW", (Object)191);
        opCodes.put((Object)"CHECKCAST", (Object)192);
        opCodes.put((Object)"INSTANCEOF", (Object)193);
        opCodes.put((Object)"MONITORENTER", (Object)194);
        opCodes.put((Object)"MONITOREXIT", (Object)195);
        opCodes.put((Object)"MULTIANEWARRAY", (Object)197);
        opCodes.put((Object)"IFNULL", (Object)198);
        opCodes.put((Object)"IFNONNULL", (Object)199);
    }
}

