/*
 * Decompiled with CFR 0.152.
 */
package mca.api.villagers;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class VillagerEntryMCA {
    private final List<String> skinsMale = new ArrayList<String>();
    private final List<String> skinsFemale = new ArrayList<String>();
    public final int professionId;
    public final boolean useDefaultTexture;
    public final String professionName;
    public final String texturesLocation;
    public final String modId;
    private boolean useLocalizedForm;

    public VillagerEntryMCA(int professionId, String professionName, String texturesLocation, String modId) {
        this.professionId = professionId;
        this.professionName = professionName;
        this.texturesLocation = texturesLocation;
        this.modId = modId;
        this.useLocalizedForm = false;
        this.useDefaultTexture = this.texturesLocation.equals("/assets/mca/textures/api/skins/");
    }

    public boolean isLocalized() {
        return this.useLocalizedForm;
    }

    public void setIsLocalized(boolean value) {
        this.useLocalizedForm = value;
    }

    public boolean isDefaultTextureUsed() {
        return this.useDefaultTexture;
    }

    public String getLocalizedProfessionID() {
        if (this.professionId == -1) {
            return "profession.playerchild";
        }
        return "profession." + this.professionName.toLowerCase();
    }

    public String getUnlocalizedProfessionName() {
        return this.professionName;
    }

    public String getTexturesLocation() {
        return this.texturesLocation;
    }

    public void addMaleSkin(String skinLocation) {
        this.skinsMale.add(skinLocation);
    }

    public void addFemaleSkin(String skinLocation) {
        this.skinsFemale.add(skinLocation);
    }

    public String getRandomMaleSkin() {
        return this.skinsMale.get(new Random().nextInt(this.skinsMale.size()));
    }

    public String getRandomFemaleSkin() {
        return this.skinsFemale.get(new Random().nextInt(this.skinsFemale.size()));
    }

    public List<String> getMaleSkinsList() {
        return this.skinsMale;
    }

    public List<String> getFemaleSkinsList() {
        return this.skinsFemale;
    }

    public String getModId() {
        return this.modId;
    }
}

