/*
 * Decompiled with CFR 0.152.
 */
package mca.api.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mca.api.villagers.AbstractVillagerPlugin;
import mca.api.villagers.VillagerEntryMCA;

public final class VillagerRegistryMCA {
    private static Map<Integer, VillagerEntryMCA> registeredVillagersMap = new HashMap<Integer, VillagerEntryMCA>();
    private static List<AbstractVillagerPlugin> registeredVillagerPlugins = new ArrayList<AbstractVillagerPlugin>();

    private VillagerRegistryMCA() {
    }

    public static void registerVillagerPlugin(AbstractVillagerPlugin pluginObject) {
        registeredVillagerPlugins.add(pluginObject);
    }

    public static void registerVillagerType(int professionId, String professionName) {
        VillagerRegistryMCA.registerVillagerType(professionId, professionName, "/assets/mca/textures/api/skins/", "mca", null);
    }

    public static void registerVillagerType(int professionId, String professionName, String textureLocation, String modId) {
        VillagerRegistryMCA.registerVillagerType(professionId, professionName, textureLocation, modId, null);
    }

    public static void registerVillagerType(int professionId, String professionName, Class registeringClass) {
        VillagerRegistryMCA.registerVillagerType(professionId, professionName, "/assets/mca/textures/skins/", "mca", registeringClass);
    }

    private static void registerVillagerType(int professionId, String professionName, String textureLocation, String modId, Class registeringClass) {
        if (registeredVillagersMap.containsKey(professionId)) {
            throw new IllegalArgumentException("Villager ID #" + professionId + " is already registered as \"" + professionName + "\"");
        }
        if (registeringClass == null) {
            if (professionId >= -1 && professionId <= 7) {
                throw new IllegalArgumentException("Villager IDs -1 through 7 are reserved for Minecraft Comes Alive.");
            }
            registeredVillagersMap.put(professionId, new VillagerEntryMCA(professionId, professionName, textureLocation, modId));
        } else if (registeringClass.getSimpleName().equals("MCA")) {
            VillagerEntryMCA entry = new VillagerEntryMCA(professionId, professionName, "/assets/mca/textures/skins/", "mca");
            entry.setIsLocalized(true);
            registeredVillagersMap.put(professionId, entry);
        } else {
            if (professionId >= -1 && professionId <= 7) {
                throw new IllegalArgumentException("Villager IDs -1 through 7 are reserved for Minecraft Comes Alive.");
            }
            registeredVillagersMap.put(professionId, new VillagerEntryMCA(professionId, professionName, textureLocation, modId));
        }
    }

    public static VillagerEntryMCA getRegisteredVillagerEntry(int professionId) {
        return registeredVillagersMap.get(professionId);
    }

    public static int getNumberOfRegisteredVillagers() {
        return registeredVillagersMap.size();
    }

    public static Map<Integer, VillagerEntryMCA> getRegisteredVillagersMap() {
        return registeredVillagersMap;
    }

    public static List<AbstractVillagerPlugin> getRegisteredVillagerPlugins() {
        return registeredVillagerPlugins;
    }

    public static VillagerEntryMCA getRandomVillagerEntry() {
        int index = new Random().nextInt(registeredVillagersMap.values().toArray().length);
        return registeredVillagersMap.get(registeredVillagersMap.keySet().toArray()[index]);
    }
}

