/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.robots;

import buildcraft.api.core.BlockIndex;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ResourceId {
    public BlockIndex index = new BlockIndex();
    public ForgeDirection side = ForgeDirection.UNKNOWN;
    public int localId = 0;

    protected ResourceId() {
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ResourceId compareId = (ResourceId)obj;
        return this.index.equals(compareId.index) && this.side == compareId.side && this.localId == compareId.localId;
    }

    public int hashCode() {
        return (this.index != null ? this.index.hashCode() : 0) * 37 + (this.side != null ? this.side.ordinal() : 0) * 37 + this.localId;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound indexNBT = new NBTTagCompound();
        this.index.writeTo(indexNBT);
        nbt.func_74782_a("index", (NBTBase)indexNBT);
        nbt.func_74774_a("side", (byte)this.side.ordinal());
        nbt.func_74768_a("localId", this.localId);
        nbt.func_74778_a("class", this.getClass().getCanonicalName());
    }

    protected void readFromNBT(NBTTagCompound nbt) {
        this.index = new BlockIndex(nbt.func_74775_l("index"));
        this.side = ForgeDirection.values()[nbt.func_74771_c("side")];
        this.localId = nbt.func_74762_e("localId");
    }

    public static ResourceId load(NBTTagCompound nbt) {
        try {
            Class<?> clas = Class.forName(nbt.func_74779_i("class"));
            ResourceId id = (ResourceId)clas.newInstance();
            id.readFromNBT(nbt);
            return id;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public void taken(long robotId) {
    }

    public void released(long robotId) {
    }
}

