/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.folk;

import ashjack.simukraftreloaded.common.Relationship;
import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.common.jobs.JobBaker;
import ashjack.simukraftreloaded.common.jobs.JobBrickMaker;
import ashjack.simukraftreloaded.common.jobs.JobBuilder;
import ashjack.simukraftreloaded.common.jobs.JobBuildersMerchant;
import ashjack.simukraftreloaded.common.jobs.JobBurgersFryCook;
import ashjack.simukraftreloaded.common.jobs.JobBurgersManager;
import ashjack.simukraftreloaded.common.jobs.JobBurgersWaiter;
import ashjack.simukraftreloaded.common.jobs.JobButcher;
import ashjack.simukraftreloaded.common.jobs.JobCheesemaker;
import ashjack.simukraftreloaded.common.jobs.JobCourier;
import ashjack.simukraftreloaded.common.jobs.JobCropFarmer;
import ashjack.simukraftreloaded.common.jobs.JobDairyFarmer;
import ashjack.simukraftreloaded.common.jobs.JobEggFarmer;
import ashjack.simukraftreloaded.common.jobs.JobFisherman;
import ashjack.simukraftreloaded.common.jobs.JobGlassMaker;
import ashjack.simukraftreloaded.common.jobs.JobGrocer;
import ashjack.simukraftreloaded.common.jobs.JobLivestockFarmer;
import ashjack.simukraftreloaded.common.jobs.JobLumberjack;
import ashjack.simukraftreloaded.common.jobs.JobMiner;
import ashjack.simukraftreloaded.common.jobs.JobShepherd;
import ashjack.simukraftreloaded.common.jobs.JobSoldier;
import ashjack.simukraftreloaded.common.jobs.JobTerraformer;
import ashjack.simukraftreloaded.core.ModSimukraft;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedConfig;
import ashjack.simukraftreloaded.entity.EntityFolk;
import ashjack.simukraftreloaded.folk.traits.Trait;
import ashjack.simukraftreloaded.folk.traits.Traits;
import ashjack.simukraftreloaded.packets.client.UpdateFolkPositionMessage;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class FolkData
implements Serializable {
    private static final long serialVersionUID = -2617939828256928361L;
    public CommonProxy.V3 employedAt = null;
    public Job.Vocation vocation = null;
    public transient Job theirJob = null;
    public String name = "";
    public int age = 18;
    public int gender = 0;
    public int skinnumber = 1;
    public String trait1 = "";
    public String trait2 = "";
    public String trait3 = "";
    public String trait4 = "";
    public int levelFood = 10;
    public int levelFun = 10;
    public int levelSocial = 10;
    public int levelEnvironment = 10;
    public float levelBuilder = 1.0f;
    public float levelMiner = 1.0f;
    public float levelSoldier = 1.0f;
    public FolkAction action = FolkAction.WANDER;
    public FolkAction actionArrival = null;
    public Boolean stayPut = false;
    public CommonProxy.V3 destination = null;
    public CommonProxy.V3 location = null;
    public String statusText = "\u95f2\u901b";
    public String status1 = "";
    public String status2 = "";
    public String status3 = "";
    public String status4 = "";
    public String funStatus = "";
    public String socialStatus = "";
    public String environmentStatus = "";
    public float pregnancyStage = 0.0f;
    public transient boolean isWorking = false;
    public boolean greetedToday = false;
    public static transient long anyFolkLastSpoke = 0L;
    public Building theBuilding = null;
    public JobTerraformer.TerraformerType terraformerType = null;
    public int terraformerRadius = 1;
    public transient ArrayList<ItemStack> inventory = new ArrayList();
    public transient EntityFolk theEntity = null;
    public transient Long timeStartedGotoing = 0L;
    public transient GotoMethod gotoMethod = null;
    private transient long timeSinceLastSave = 0L;
    private transient long timeSinceLastStatusUpdate = 0L;
    private transient long timeSinceLastMinute = 0L;
    public transient CommonProxy.V3 beamingTo = null;
    private transient FolkData hangingWith = null;
    private transient int talkCounter = 0;
    public transient float matingStage = -1.0f;
    private transient int entityId;

    public FolkData() {
    }

    public void hasLoaded() {
        String voc = "none";
        String vocat = "";
        if (this.vocation != null && this.employedAt != null) {
            voc = this.vocation.toString();
            vocat = this.employedAt.toString();
        }
        if (this.employedAt == null) {
            this.vocation = null;
        }
        if (this.vocation == null) {
            this.employedAt = null;
        }
        if (this.levelMiner < 1.0f) {
            this.levelMiner = 1.0f;
        }
        if (this.levelBuilder < 1.0f) {
            this.levelBuilder = 1.0f;
        }
        if (this.levelSoldier < 1.0f) {
            this.levelSoldier = 1.0f;
        }
        try {
            SimukraftReloaded.log.info("FolkData: hasLoaded() " + this.name + " (" + voc + ") at " + vocat + " location= " + this.location.toString() + "  " + SimukraftReloaded.theFolks.size() + " folks in total");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.inventory = new ArrayList();
        this.setTheirJob(this.vocation);
        this.respawnEntity((World)MinecraftServer.func_71276_C().func_71218_a(this.location.theDimension));
        SimukraftReloaded.theFolks.add(this);
    }

    public FolkData(World theWorld) {
        Random rand = new Random();
        this.gender = rand.nextInt(2);
        this.name = FolkData.generateName(this.gender, false, "");
        this.age = 18;
        this.skinnumber = this.gender == 0 ? rand.nextInt(63) + 1 : rand.nextInt(58) + 1;
        this.location = this.getLocationCloseToPlayer();
        if (this.location == null) {
            return;
        }
        this.generateTraits();
        this.respawnEntity(theWorld);
        SimukraftReloaded.theFolks.add(this);
        SimukraftReloaded.sendChat(this.name + " \u6765\u5230\u6b64\u5730\u533a\u3002");
    }

    public FolkData(World theWorld, FolkData mother, FolkData father) {
        EntityClientPlayerMP p;
        Random rand = new Random();
        String surname = "\u672a\u77e5";
        this.generateTraits();
        if (father != null) {
            surname = father.name.substring(father.name.indexOf(" ") + 1).trim();
        } else if (mother != null) {
            surname = mother.name.substring(mother.name.indexOf(" ") + 1).trim();
        }
        this.gender = rand.nextInt(2);
        this.name = FolkData.generateName(this.gender, true, surname) + " " + surname;
        this.age = 0;
        this.skinnumber = this.gender == 0 ? rand.nextInt(63) + 1 : rand.nextInt(58) + 1;
        if (mother.getHome() != null) {
            mother.getHome().tennants.add(this.name);
        }
        mother.updateLocationFromEntity();
        World mworld = null;
        if (mother.isSpawned()) {
            mworld = mother.theEntity.field_70170_p;
        }
        this.location = Job.findAdjacentSpace(mother.location, mworld);
        this.respawnEntity(theWorld);
        SimukraftReloaded.theFolks.add(this);
        SimukraftReloaded.sendChat(this.name + " \u521a\u521a\u8bde\u751f\uff01");
        World world = ModSimukraft.proxy.getClientWorld();
        if (world != null && (p = Minecraft.func_71410_x().field_71439_g) != null) {
            ModSimukraft.proxy.getClientWorld().func_72980_b(p.field_70165_t, p.field_70163_u, p.field_70161_v, "ashjacksimukraftreloaded:birth", 1.0f, 1.0f, false);
        }
        Relationship.setupBloodRelationships(this, father, mother);
        try {
            this.levelBuilder = (float)Math.floor(father.levelBuilder / 2.0f) + (float)Math.floor(mother.levelBuilder / 2.0f);
            if (this.levelBuilder > 10.0f) {
                this.levelBuilder = 10.0f;
            }
            this.levelMiner = (float)Math.floor(father.levelMiner / 2.0f) + (float)Math.floor(mother.levelMiner / 2.0f);
            if (this.levelMiner > 10.0f) {
                this.levelMiner = 10.0f;
            }
            this.levelSoldier = (float)Math.floor(father.levelSoldier / 2.0f) + (float)Math.floor(mother.levelSoldier / 2.0f);
            if (this.levelSoldier > 10.0f) {
                this.levelSoldier = 10.0f;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void updateLocationFromEntity() {
        if (this.isSpawned()) {
            this.location = new CommonProxy.V3(this.theEntity.field_70165_t, this.theEntity.field_70163_u, this.theEntity.field_70161_v, this.location.theDimension);
        }
    }

    public void respawnEntity(World world) {
        if (world == null) {
            return;
        }
        if (this.beamingTo != null) {
            return;
        }
        if (this.theEntity != null && !this.theEntity.field_70128_L) {
            return;
        }
        if (this.getDistanceToPlayer() < 50) {
            this.theEntity = new EntityFolk(world);
            this.theEntity.func_70012_b(this.location.x, this.location.y, this.location.z, 0.0f, 0.0f);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)this.theEntity);
            }
            this.entityId = this.theEntity.func_145782_y();
            SimukraftReloaded.log.info("FolkData:repawnEntity() " + this.name + " at " + this.location.toString() + " in dim " + this.location.theDimension + " ENTITY:" + this.theEntity.func_145782_y());
        }
    }

    public static void triggerAllUpdates() {
        for (int f = 0; f < SimukraftReloaded.theFolks.size(); ++f) {
            FolkData fd = SimukraftReloaded.theFolks.get(f);
            fd.onUpdate();
        }
    }

    public void serverToClientLocationUpdate(CommonProxy.V3 newLocation) {
        this.location = newLocation.clone();
        if (this.theEntity != null) {
            newLocation.x = Math.floor(newLocation.x) + 0.5;
            newLocation.z = Math.floor(newLocation.z) + 0.5;
            this.theEntity.field_70165_t = newLocation.x;
            this.theEntity.field_70163_u = newLocation.y;
            this.theEntity.field_70161_v = newLocation.z;
        }
    }

    public void onUpdate() {
        Random rand = new Random();
        Long now = System.currentTimeMillis();
        if (now - this.timeSinceLastMinute > 60000L) {
            FolkData mother;
            long t;
            if (!(this.statusText.contains("\u6df7") || this.statusText.startsWith("\u8d2d\u7269") || this.statusText.contains("Visiting") || this.statusText.contains("\u5165\u4f4f") || this.statusText.contains("\u653e\u677e") || this.levelFun <= 1 || this.isWorking)) {
                --this.levelFun;
            }
            if (this.isWorking && this.levelFun > 1) {
                --this.levelFun;
            }
            if (this.getHome() == null && this.timeSinceLastMinute > 0L) {
                this.getHomeForHomeless();
            }
            if (!this.statusText.contains("\u6df7") && this.levelSocial > 1) {
                --this.levelSocial;
            }
            if ((t = MinecraftServer.func_71276_C().field_71305_c[0].func_72820_D() % 24000L) < 2000L && this.pregnancyStage >= 1.0f) {
                for (Building build : SimukraftReloaded.theBuildings) {
                    if (build == null || build.primaryXYZ == null || !build.displayName.contains("\u8bca\u6240") || this.destination != null || build.blockSpecial.isEmpty()) continue;
                    CommonProxy.V3 bed = build.blockSpecial.get(0);
                    this.gotoXYZ(bed, null);
                    SimukraftReloaded.sendChat(this.name + " \u5373\u5c06\u6709\u4e00\u4e2a\u5b69\u5b50\uff0c\u5979\u6b63\u5728\u53bb\u8bca\u6240\uff01");
                }
                this.action = FolkAction.HAVINGBABY;
            } else if (t > 2000L && this.pregnancyStage >= 1.0f) {
                this.statusText = "\u521a\u751f\u4e86\u4e2a\u5b69\u5b50";
                this.pregnancyStage = 0.0f;
                FolkData male = Relationship.isFolkLivingWithSomeone(this, true);
                new FolkData((World)MinecraftServer.func_71276_C().func_71218_a(0), this, male);
            }
            if (this.action == FolkAction.ATHOME || this.action == FolkAction.STAYINGHOME) {
                this.updateLocationFromEntity();
                try {
                    CommonProxy.V3 liveAt = null;
                    if (this.getHome().livingXYZ != null) {
                        liveAt = this.getHome().livingXYZ.clone();
                    }
                    if (liveAt == null) {
                        liveAt = this.getHome().primaryXYZ.clone();
                    }
                    if (this.location.getDistanceTo(liveAt) > 5 && this.destination == null || this.location.theDimension != this.getHome().primaryXYZ.theDimension) {
                        this.actionArrival = this.action;
                        if (liveAt != null) {
                            this.gotoXYZ(liveAt, GotoMethod.WALK);
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("\u4e0d\u91cd\u8981\u5f02\u5e38\u7684 Sim-U-Kraft:");
                    e.printStackTrace();
                }
            }
            boolean gotWanderPoint = false;
            if (this.action == FolkAction.WANDER && this.isSpawned() && this.employedAt == null && this.age >= 18 && !this.statusText.contains("baby")) {
                for (int i = 0; i < SimukraftReloaded.theBuildings.size(); ++i) {
                    Building b = SimukraftReloaded.theBuildings.get(rand.nextInt(SimukraftReloaded.theBuildings.size()));
                    double dist = this.location.getDistanceTo(b.primaryXYZ);
                    if (b.type.contentEquals("commercial") && dist < 40.0) {
                        boolean hasShopKeeper = false;
                        for (int f = 0; f < SimukraftReloaded.theFolks.size(); ++f) {
                            FolkData keeper = SimukraftReloaded.theFolks.get(f);
                            if (keeper.employedAt == null || !keeper.employedAt.isSameCoordsAs(b.primaryXYZ, true, true)) continue;
                            hasShopKeeper = true;
                            break;
                        }
                        if (!hasShopKeeper) continue;
                        SimukraftReloaded.log.info("FolkData:onUpdate() " + this.name + "\u5728\u95f2\u901b" + b.displayName + " " + dist + " \u8857\u533a\u3002");
                        this.gotoXYZ(b.primaryXYZ, GotoMethod.WALK);
                        this.destination.doNotTimeout = true;
                        this.statusText = "\u6b63\u5728\u8d2d\u7269" + b.displayName;
                        gotWanderPoint = true;
                        if (this.hangingWith == null) break;
                        this.hangingWith.statusText = "\u95f2\u901b";
                        this.hangingWith.hangingWith = null;
                        this.hangingWith = null;
                        break;
                    }
                    if (b.type.contentEquals("industrial") && dist < 40.0 && !b.displayName.toLowerCase().contains("farm")) {
                        try {
                            SimukraftReloaded.log.info("FolkData: onUpdate() " + this.name + "\u5728\u95f2\u901b" + b.displayName + " " + dist + " \u8857\u533a\u3002");
                            this.gotoXYZ(b.primaryXYZ, GotoMethod.WALK);
                            this.destination.doNotTimeout = true;
                            this.statusText = "\u53c2\u89c2" + b.displayName;
                            gotWanderPoint = true;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (this.hangingWith == null) break;
                        this.hangingWith.statusText = "\u95f2\u901b";
                        this.hangingWith.hangingWith = null;
                        this.hangingWith = null;
                        break;
                    }
                    if (!b.type.contentEquals("residential") || !(dist < 40.0) || this.hangingWith != null || b.tennants == null || b.tennants.size() <= 0) continue;
                    FolkData resy = FolkData.getFolkByName(b.tennants.get(0));
                    try {
                        if (resy.name.contentEquals(this.name) || resy.hangingWith != null || resy.action != FolkAction.WANDER && resy.action != FolkAction.STAYINGHOME) continue;
                        SimukraftReloaded.log.info("FolkData:onUpdate() " + this.name + "\u5728\u95f2\u901b" + b.displayName + " " + dist + " \u8857\u533a\u3002");
                        this.gotoXYZ(b.primaryXYZ, GotoMethod.WALK);
                        gotWanderPoint = true;
                        this.statusText = "\u95f2\u901b\u4e0e" + resy.name;
                        resy.gotoXYZ(b.primaryXYZ, GotoMethod.WALK);
                        if (this.destination != null) {
                            this.destination.doNotTimeout = true;
                        }
                        resy.statusText = "\u95f2\u901b\u4e0e" + this.name;
                        this.hangingWith = resy;
                        resy.hangingWith = this;
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!gotWanderPoint) {
                    int xo = rand.nextInt(60) - 30;
                    int zo = rand.nextInt(60) - 30;
                    CommonProxy.V3 wanderTo = new CommonProxy.V3(this.location.x + (double)xo, this.location.y, this.location.z + (double)zo, this.location.theDimension);
                    WorldServer world = MinecraftServer.func_71276_C().func_71218_a(this.location.theDimension);
                    while (world.func_147439_a(wanderTo.x.intValue(), wanderTo.y.intValue(), wanderTo.z.intValue()) != null && wanderTo.y < 255.0) {
                        CommonProxy.V3 v3 = wanderTo;
                        Double e = v3.y;
                        Double d = v3.y = Double.valueOf(v3.y + 1.0);
                    }
                    SimukraftReloaded.log.info("FolkData:onUpdate() WANDER COMMAND FOR " + this.name + " to " + wanderTo.toString());
                    this.gotoXYZ(wanderTo, GotoMethod.WALK);
                    if (this.destination != null) {
                        this.destination.doNotTimeout = true;
                    }
                    this.statusText = "\u95f2\u901b";
                    this.stayPut = false;
                }
            } else if (this.action == FolkAction.WANDER && this.isSpawned() && this.age < 18 && (mother = Relationship.getMotherOf(this)) != null) {
                this.gotoXYZ(mother.location, null);
            }
            if (this.hangingWith != null && !this.hangingWith.statusText.contains(this.name)) {
                this.hangingWith = null;
                this.statusText = "\u95f2\u901b";
            }
            if (!SimukraftReloaded.isDayTime() && Relationship.isFolkLivingWithSomeone(this) && this.matingStage < 0.0f) {
                this.tryForBaby();
            }
            this.timeSinceLastMinute = now - (long)rand.nextInt(20000);
        }
        if (now - this.timeSinceLastStatusUpdate > 1000L) {
            int range;
            if (this.trait1 == "" || this.trait2 == "" || this.trait3 == "" || this.trait4 == "") {
                this.generateTraits();
            }
            this.updateStatusLines();
            if (this.statusText.contentEquals("\u53bb\u627e\u6211\u7684\u65b0\u5de5\u4f5c......")) {
                this.stayPut = false;
            }
            if (!this.isSpawned()) {
                range = this.getDistanceToPlayer();
                if (range < 50) {
                    this.respawnEntity((World)MinecraftServer.func_71276_C().func_71218_a(this.location.theDimension));
                }
            } else {
                this.theEntity.field_71093_bK = this.location.theDimension;
                this.updateLocationFromEntity();
                range = this.getDistanceToPlayer();
                if (range >= 50 && this.theEntity != null) {
                    SimukraftReloaded.log.info("FolkData: onSecTasks - Manually Despawned " + this.name + " \u56e0\u4e3a\u5b83\u4eec\u662f" + range + " \u8857\u533a");
                    this.theEntity.func_70106_y();
                }
            }
            if (SimukraftReloaded.isDayTime() && this.employedAt != null && this.action != FolkAction.ONWAYTOWORK && this.action != FolkAction.ATWORK && this.pregnancyStage == 0.0f) {
                SimukraftReloaded.log.info("FolkData: " + this.name + " \u53bb\u5de5\u4f5c");
                this.statusText = "\u51c6\u5907\u53bb\u4e0a\u73ed";
                this.action = FolkAction.ONWAYTOWORK;
                this.gotoXYZ(this.employedAt, null);
                return;
            }
            if (this.pregnancyStage > 0.0f && this.employedAt != null && SimukraftReloaded.isDayTime()) {
                this.statusText = "\u4f11\u4ea7\u5047";
            }
            if (SimukraftReloaded.isDayTime() && this.employedAt != null && this.action != FolkAction.ATWORK && this.destination == null && this.pregnancyStage == 0.0f) {
                CommonProxy.V3 temp;
                this.statusText = "\u51c6\u5907\u53bb\u4e0a\u73ed";
                this.action = FolkAction.ONWAYTOWORK;
                SimukraftReloaded.log.warning("FolkData:onUpdate() " + this.name + "\u4ecd\u5728\u4e0a\u73ed");
                this.updateLocationFromEntity();
                CommonProxy.V3 v3 = temp = this.employedAt.clone();
                v3.x = v3.x + 5.0;
                this.gotoXYZ(temp, GotoMethod.SHIFT);
                this.gotoXYZ(this.employedAt, null);
                return;
            }
            if (this.action == FolkAction.ONWAYTOWORK) {
                this.statusText = "\u51c6\u5907\u53bb\u4e0a\u73ed";
                this.stayPut = false;
                if (this.destination == null) {
                    this.gotoXYZ(this.employedAt, null);
                }
            }
            if (this.action == FolkAction.STAYINGHOME && this.hangingWith == null) {
                this.statusText = "\u5446\u5728\u5bb6\u91cc";
                this.stayPut = true;
            }
            if (SimukraftReloaded.isDayTime() && this.statusText.contains("for a baby")) {
                this.statusText = "\u95f2\u901b";
                this.action = FolkAction.WANDER;
            }
            if (this.action == FolkAction.HAVINGBABY) {
                this.statusText = this.pregnancyStage < 1.0f ? "\u521a\u751f\u4e86\u4e2a\u5b69\u5b50" : "\u6709\u4e00\u4e2a\u5b69\u5b50\uff01";
            }
            if (SimukraftReloaded.isDayTime() && this.employedAt == null && this.action == FolkAction.ATHOME) {
                this.isWorking = false;
                if (new Random().nextInt(4) == 1) {
                    this.statusText = "Staying Home";
                    this.action = FolkAction.STAYINGHOME;
                } else {
                    this.statusText = "\u95f2\u901b";
                    this.action = FolkAction.WANDER;
                }
            }
            if (this.action == FolkAction.STAYINGHOME && this.employedAt != null) {
                this.action = FolkAction.WANDER;
            }
            boolean isSoldier = false;
            if (this.vocation != null && this.vocation == Job.Vocation.SOLDIER) {
                isSoldier = true;
            }
            if (!SimukraftReloaded.isDayTime() && !isSoldier) {
                this.action = FolkAction.WANDER;
                this.isWorking = false;
                if (this.getHome() == null) {
                    this.statusText = "\u95f2\u901b";
                    this.stayPut = false;
                } else {
                    if (this.gotoMethod == GotoMethod.WALK) {
                        this.updateLocationFromEntity();
                    }
                    CommonProxy.V3 liveAt = null;
                    try {
                        liveAt = this.getHome().livingXYZ.clone();
                        if (liveAt == null) {
                            liveAt = this.getHome().primaryXYZ.clone();
                        }
                    }
                    catch (Exception e) {
                        SimukraftReloaded.log.warning(this.name + " has no liveAt");
                    }
                    if (liveAt != null) {
                        int dist = this.location.getDistanceTo(liveAt);
                        if (dist > 1 && this.destination == null) {
                            this.stayPut = false;
                            this.gotoXYZ(liveAt, null);
                            this.action = FolkAction.GOINGHOME;
                            this.statusText = "Going Home";
                            this.isWorking = false;
                        }
                        if (dist <= 1 && !this.statusText.contains("baby")) {
                            this.stayPut = true;
                            this.action = FolkAction.ATHOME;
                            this.statusText = "\u5728\u5bb6\u653e\u677e";
                            this.isWorking = false;
                        }
                    }
                }
            } else {
                this.stayPut = false;
            }
            if (this.action == FolkAction.WANDER) {
                this.stayPut = false;
            }
            int about10 = rand.nextInt(10000) + 10000;
            if (System.currentTimeMillis() - this.timeSinceLastSave > (long)about10) {
                Side side = FMLCommonHandler.instance().getEffectiveSide();
                if (side == Side.SERVER) {
                    ModSimukraft.network.sendToServer((IMessage)new UpdateFolkPositionMessage(this.location.toString() + ";" + this.name));
                    this.saveThisFolk();
                }
                if (this.statusText.contains("\u6df7") && this.levelSocial < 10) {
                    ++this.levelSocial;
                }
                if (this.statusText.contains("Visiting") || this.statusText.contains("\u6df7") || this.statusText.contains("\u5165\u4f4f") || this.statusText.contains("\u653e\u677e") || this.statusText.contains("\u8d2d\u7269") && this.levelFun < 10) {
                    ++this.levelFun;
                }
                this.timeSinceLastSave = System.currentTimeMillis();
            }
            if ((this.statusText.startsWith("\u95f2\u901b\u4e0e") || this.statusText.startsWith("\u6b63\u5728\u8d2d\u7269")) && this.destination == null && this.theEntity != null) {
                ++this.talkCounter;
                if (this.talkCounter == 12) {
                    if (SimukraftReloadedConfig.configFolkTalking) {
                        int ch = rand.nextInt(26) + 97;
                        String letter = "ashjacksimukraftreloaded:blarg" + Character.toString((char)ch);
                        ModSimukraft.proxy.getClientWorld().func_72980_b(this.location.x.doubleValue(), this.location.y.doubleValue(), this.location.z.doubleValue(), letter, 1.0f, 1.0f, false);
                    }
                    this.talkCounter = 0;
                    if (this.hangingWith != null) {
                        Relationship.meddleWithRelationship(this, this.hangingWith);
                    }
                }
            }
            if (this.matingStage >= 0.0f && this.matingStage < 1.0f && this.gender == 1 && this.pregnancyStage == 0.0f) {
                if (SimukraftReloaded.isDayTime()) {
                    this.matingStage = -1.0f;
                } else {
                    FolkData male = Relationship.isFolkLivingWithSomeone(this, true);
                    if (male != null) {
                        this.matingStage += 0.02f;
                        if (this.isSpawned()) {
                            WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
                            double d0 = rand.nextDouble() * 0.5;
                            double d1 = rand.nextDouble() * 0.5;
                            double d2 = rand.nextDouble() * 0.5;
                            theWorld.func_72869_a("heart", this.theEntity.field_70165_t, this.theEntity.field_70163_u + 2.1, this.theEntity.field_70161_v, d0, d1, d2);
                            male.updateLocationFromEntity();
                            if ((double)this.matingStage < 0.15) {
                                this.gotoXYZ(male.location, GotoMethod.SHIFT);
                            }
                            theWorld.func_72869_a("heart", male.location.x.doubleValue(), male.location.y + 2.1, male.location.z.doubleValue(), d0, d1, d2);
                            this.statusText = "\u5c1d\u8bd5\u556a\u556a\u556a\u751f\u4e00\u4e2a\u5b9d\u5b9d";
                            male.statusText = "\u5c1d\u8bd5\u556a\u556a\u556a\u751f\u4e00\u4e2a\u5b9d\u5b9d";
                            male.stayPut = true;
                        }
                    }
                }
            } else if (this.matingStage >= 1.0f && this.matingStage < 1.1f) {
                this.matingStage = 1.1f;
                int chance = rand.nextInt(7);
                SimukraftReloaded.log.info("FolkData: Finished Trying for baby - chance=" + chance);
                FolkData male = Relationship.isFolkLivingWithSomeone(this, true);
                this.statusText = "\u5728\u5bb6\u653e\u677e";
                male.statusText = "\u5728\u5bb6\u653e\u677e";
                if (chance == 1 && this.age < 45) {
                    EntityClientPlayerMP p;
                    World world;
                    this.pregnancyStage = 0.1f;
                    SimukraftReloaded.sendChat("\u597d\u6d88\u606f\uff01" + this.name + " and " + male.name + " \u60f3\u8981\u4e00\u4e2a\u5b9d\u5b9d\uff01");
                    if (this.isSpawned()) {
                        this.theEntity.func_70637_d(true);
                    }
                    if (male.isSpawned()) {
                        male.theEntity.func_70637_d(true);
                    }
                    if ((world = ModSimukraft.proxy.getClientWorld()) != null && (p = Minecraft.func_71410_x().field_71439_g) != null) {
                        ModSimukraft.proxy.getClientWorld().func_72980_b(p.field_70165_t, p.field_70163_u, p.field_70161_v, "ashjacksimukraftreloaded:pregnant", 1.0f, 1.0f, false);
                    }
                }
            }
            this.timeSinceLastStatusUpdate = now;
        }
        if (this.beamingTo != null) {
            this.doBeaming();
        }
        if (this.theirJob != null) {
            this.theirJob.onUpdate();
        }
    }

    private void tryForBaby() {
        if (this.gender == 1 && this.pregnancyStage == 0.0f) {
            FolkData malePartner = Relationship.isFolkLivingWithSomeone(this, true);
            if (malePartner != null && this.action == FolkAction.ATHOME && malePartner.action == FolkAction.ATHOME) {
                this.matingStage = 0.0f;
                if (malePartner.isSpawned()) {
                    this.gotoXYZ(new CommonProxy.V3(malePartner.theEntity.field_70165_t, malePartner.theEntity.field_70163_u, malePartner.theEntity.field_70161_v, malePartner.theEntity.field_71093_bK), GotoMethod.WALK);
                }
            }
        } else {
            this.matingStage = -1.0f;
        }
    }

    private void getHomeForHomeless() {
        if (this.action == FolkAction.WANDER) {
            Building.loadAllBuildings();
            for (int b = 0; b < SimukraftReloaded.theBuildings.size(); ++b) {
                Building building = SimukraftReloaded.theBuildings.get(b);
                if (building.tennants.size() != 0 || !building.buildingComplete || !building.type.contentEquals("residential")) continue;
                building.tennants.add(this.name);
                this.action = FolkAction.GOINGHOME;
                this.actionArrival = FolkAction.STAYINGHOME;
                if (building.livingXYZ != null) {
                    this.gotoXYZ(building.livingXYZ, null);
                } else {
                    this.gotoXYZ(building.primaryXYZ, null);
                }
                SimukraftReloaded.states.saveStates();
                SimukraftReloaded.sendChat(this.name + "\u6b63\u5728\u6b65\u5165\u81ea\u5df1\u7684" + building.displayNameWithoutPK);
                this.statusText = "\u642c\u8fdb\u4e86\u6211\u7684" + building.displayNameWithoutPK;
                Building.saveAllBuildings();
                break;
            }
        }
    }

    private void updateStatusLines() {
        if (this.vocation == null) {
            this.status1 = "\u5931\u4e1a";
        } else {
            try {
                this.status1 = this.vocation.toString();
            }
            catch (Exception e) {
                this.status1 = "";
            }
        }
        Random rand = new Random();
        this.status2 = this.getHome() != null ? "\u6709\u623f\u5b50" : "\u65e0\u5bb6\u53ef\u5f52";
        this.status3 = !Relationship.isFolkLivingWithSomeone(this) ? "\u5355\u8eab" : "\u548c\u522b\u4eba\u4e00\u8d77\u751f\u6d3b";
        this.status4 = this.levelFood == 10 ? "\u5403\u5f97\u9971\u9971" : (this.levelFood > 5 ? "\u6709\u70b9\u997f\u4e86" : (this.levelFood > 1 ? "\u633a\u997f" : "\u997f\u6781\u4e86\uff01"));
        this.funStatus = this.levelFun == 10 ? "\u5177\u6709\u7206\u70b8\u6027\uff01" : (this.levelFun > 7 ? "\u4eab\u53d7\u81ea\u5df1\u7684" : (this.levelFun > 4 ? "\u65e0\u804a" : "\u5f3a\u8c03"));
        this.socialStatus = this.levelSocial == 10 ? "\u6709\u8da3\u7684\u73a9\u7b11\uff01" : (this.levelSocial > 7 ? "\u5728\u793e\u4f1a\u4e0a\u5c65\u884c" : (this.levelSocial > 4 ? "\u5b64\u72ec" : (this.levelSocial > 2 ? "\u5f88\u5b64\u72ec" : "\u8981\u75af\u4e86")));
        this.environmentStatus = this.levelEnvironment == 10 ? "\u5468\u8fb9\u73af\u5883\u4f18\u7f8e" : (this.levelEnvironment > 7 ? "\u5468\u8fb9\u73af\u5883\u4e0d\u9519" : (this.levelEnvironment > 4 ? "\u5468\u8fb9\u73af\u5883\u5dee" : "\u5468\u8fb9\u73af\u5883\u592a\u53ef\u6015\u60f9"));
    }

    public boolean isSpawned() {
        if (this.theEntity == null) {
            try {
                this.theEntity = FolkData.getFolkByName((String)this.name).theEntity;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.theEntity == null) {
            return false;
        }
        return !this.theEntity.field_70128_L;
    }

    public int getDistanceToPlayer() {
        EntityPlayer p = FolkData.getClosestPlayer(this.location);
        if (p == null) {
            return 9999;
        }
        CommonProxy.V3 pv = new CommonProxy.V3(p.field_70165_t, p.field_70163_u, p.field_70161_v, this.location.theDimension);
        return this.location.getDistanceTo(pv);
    }

    public CommonProxy.V3 getLocationCloseToPlayer() {
        CommonProxy.V3 ret;
        EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
        try {
            ret = new CommonProxy.V3(p.field_70165_t, 5.0, p.field_70161_v, p.field_71093_bK);
        }
        catch (Exception e) {
            SimukraftReloaded.log.warning("getLocationCloseToPlayer: player was null, returned null V3");
            return new CommonProxy.V3(0.0, 5.0, 0.0, 0);
        }
        boolean found = false;
        Block bid = null;
        try {
            for (int go = 30; go > 1; --go) {
                ret = new CommonProxy.V3(p.field_70165_t, 5.0, p.field_70161_v + (double)go, p.field_71093_bK);
                while (!found) {
                    bid = p.field_70170_p.func_147439_a(ret.x.intValue(), ret.y.intValue(), ret.z.intValue());
                    if ((p.field_70170_p.func_72937_j(ret.x.intValue(), ret.y.intValue(), ret.z.intValue()) || p.field_71093_bK != 0) && bid != Blocks.field_150362_t && bid == null) {
                        found = true;
                    }
                    CommonProxy.V3 v3 = ret;
                    Double d = v3.y;
                    Double d2 = v3.y = Double.valueOf(v3.y + 1.0);
                    if (!(ret.y > 200.0)) continue;
                }
                if (!found) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!found) {
            return new CommonProxy.V3(0.0, 5.0, 0.0, 0);
        }
        return ret;
    }

    public static EntityPlayer getClosestPlayer(CommonProxy.V3 location) {
        try {
            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(location.theDimension);
            EntityPlayer ret = world.func_72977_a(location.x.doubleValue(), location.y.doubleValue(), location.z.doubleValue(), 60.0);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String generateName(int gender, boolean firstNameOnly, String lastNameOptional) {
        Random randomGenerator = new Random();
        String firstName = "";
        String lastName = "";
        FolkData test = null;
        for (int go = 0; go < 200; ++go) {
            int i;
            if (gender == 0) {
                i = randomGenerator.nextInt(SimukraftReloadedConfig.configMaleNames.length);
                firstName = SimukraftReloadedConfig.configMaleNames[i].trim();
            } else {
                i = randomGenerator.nextInt(SimukraftReloadedConfig.configFemaleNames.length);
                firstName = SimukraftReloadedConfig.configFemaleNames[i].trim();
            }
            i = randomGenerator.nextInt(SimukraftReloadedConfig.configSurnames.length);
            lastName = lastName.contentEquals("") ? SimukraftReloadedConfig.configSurnames[i].trim() : lastNameOptional;
            test = FolkData.getFolkByName(firstName + " " + lastName);
            if (test == null) break;
        }
        if (test != null) {
            lastName = lastName + " II";
        }
        if (!firstNameOnly) {
            return firstName + " " + lastName;
        }
        return firstName;
    }

    public void selfFire() {
        SimukraftReloaded.log.info("FolkData: selfFire() " + this.name);
        this.isWorking = false;
        if (this.inventory.size() > 0) {
            int count = 0;
            for (int inv = 0; inv < this.inventory.size(); ++inv) {
                ItemStack is = this.inventory.get(inv);
                if (is == null) continue;
                if (this.theEntity != null) {
                    try {
                        this.theEntity.func_70099_a(is, is.field_77994_a);
                    }
                    catch (Exception e) {}
                } else {
                    try {
                        FolkData.getClosestPlayer(this.location).func_70099_a(is, (float)is.field_77994_a);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                count += is.field_77994_a;
            }
            if (count > 0) {
                SimukraftReloaded.sendChat(this.name + " has dropped " + count + " items from their inventory");
            }
        }
        this.inventory.clear();
        if (this.theEntity != null) {
            this.theEntity.field_70733_aJ = 0.0f;
            this.theEntity.func_70661_as().func_75499_g();
        }
        this.employedAt = null;
        if (this.vocation == Job.Vocation.BUILDER) {
            this.theBuilding = null;
        }
        this.vocation = null;
        this.theirJob = null;
        this.action = FolkAction.WANDER;
        this.statusText = "\u95f2\u901b";
        this.stayPut = false;
        this.saveThisFolk();
    }

    public void gotoXYZ(CommonProxy.V3 whereTo, GotoMethod methodOfTravel) {
        if (whereTo == null) {
            return;
        }
        this.stayPut = false;
        this.destination = whereTo.clone();
        if (this.destination == null) {
            return;
        }
        this.destination.doNotTimeout = false;
        int dist = this.location.getDistanceTo(whereTo);
        if (!this.isSpawned()) {
            methodOfTravel = null;
        }
        if (methodOfTravel == null) {
            CommonProxy.V3 playpos = null;
            try {
                EntityPlayer pl = FolkData.getClosestPlayer(this.location);
                if (pl == null || this.location.theDimension != this.destination.theDimension) {
                    dist = 999;
                } else {
                    playpos = new CommonProxy.V3(pl.field_70165_t, pl.field_70163_u, pl.field_70161_v, pl.field_71093_bK);
                }
            }
            catch (Exception e) {
                dist = 999;
            }
            if (dist < 40) {
                this.gotoMethod = GotoMethod.WALK;
            }
            if (!this.isSpawned() || dist >= 40) {
                this.gotoMethod = GotoMethod.BEAM;
            }
            if (playpos != null) {
                if (this.location.getDistanceTo(playpos) >= 40 && whereTo.getDistanceTo(playpos) >= 40) {
                    this.gotoMethod = GotoMethod.SHIFT;
                }
                try {
                    if (this.location.theDimension != Minecraft.func_71410_x().field_71439_g.field_71093_bK && this.destination.theDimension != Minecraft.func_71410_x().field_71439_g.field_71093_bK) {
                        this.gotoMethod = GotoMethod.SHIFT;
                    }
                }
                catch (Exception e) {
                    this.gotoMethod = GotoMethod.SHIFT;
                }
            }
            if (methodOfTravel == null) {
                methodOfTravel = GotoMethod.SHIFT;
            }
        } else {
            this.gotoMethod = methodOfTravel;
        }
        try {
            SimukraftReloaded.log.info("FolkData: GOTOXYZ() for " + this.name + " to " + whereTo.toString() + " - Method:" + this.gotoMethod.toString() + " DIM:" + whereTo.theDimension);
        }
        catch (Exception e) {
            SimukraftReloaded.log.info("FolkData: GOTOXYZ() for " + this.name + " - NULL whereTo");
            return;
        }
        if (this.destination == null) {
            return;
        }
        if (this.gotoMethod == GotoMethod.SHIFT) {
            int xxx = this.destination.x.intValue();
            int zzz = this.destination.z.intValue();
            this.destination.x = (double)xxx + 0.5;
            this.destination.z = (double)zzz + 0.5;
            if (this.theEntity != null) {
                this.theEntity.field_70165_t = this.destination.x;
                this.theEntity.field_70163_u = this.destination.y;
                this.theEntity.field_70161_v = this.destination.z;
                try {
                    if (this.location.theDimension != this.destination.theDimension) {
                        this.theEntity.func_71027_c(this.destination.theDimension);
                        this.theEntity.field_71093_bK = this.destination.theDimension;
                        this.location.theDimension = this.destination.theDimension;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.location = this.destination.clone();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.destination = null;
        } else if (this.gotoMethod == GotoMethod.BEAM) {
            this.timeStartedGotoing = System.currentTimeMillis();
            this.beamMeTo(whereTo);
        } else if (this.gotoMethod == GotoMethod.WALK) {
            this.stayPut = false;
            this.timeStartedGotoing = System.currentTimeMillis();
            if (this.theEntity != null) {
                this.theEntity.gotPath = false;
            }
        }
    }

    public void beamMeTo(CommonProxy.V3 whereToIn) {
        this.stayPut = true;
        this.updateLocationFromEntity();
        if (this.beamingTo != null) {
            SimukraftReloaded.log.warning("FolkData:beamMeTo() already beaming " + this.name);
            return;
        }
        if (whereToIn == null) {
            SimukraftReloaded.log.warning("FolkData: beamMeTo() whereTo was NULL, cancelled beaming");
            return;
        }
        this.timeStartedGotoing = System.currentTimeMillis();
        CommonProxy.V3 whereTo = whereToIn.clone();
        WorldServer destWorld = MinecraftServer.func_71276_C().func_71218_a(whereTo.theDimension);
        for (int y = 0; y < 200; ++y) {
            Block id1 = destWorld.func_147439_a(whereTo.x.intValue(), whereTo.y.intValue(), whereTo.z.intValue());
            Block id2 = destWorld.func_147439_a(whereTo.x.intValue(), whereTo.y.intValue() + 1, whereTo.z.intValue());
            if (id1 == null && id2 == null) break;
            CommonProxy.V3 v3 = whereTo;
            Double d = v3.y;
            Double d2 = v3.y = Double.valueOf(v3.y + 1.0);
        }
        try {
            int xxx = whereTo.x.intValue();
            whereTo.x = (double)xxx + 0.5;
            xxx = whereTo.z.intValue();
            whereTo.z = (double)xxx + 0.5;
            CommonProxy.V3 v3 = whereTo;
            v3.y = v3.y - 199.0;
        }
        catch (Exception e) {
            return;
        }
        this.destination = whereTo.clone();
        SimukraftReloaded.log.info("FolkData: BeamMeTo() for " + this.name + " to " + whereTo.toString() + " Dim:" + whereTo.theDimension);
        this.stayPut = true;
        if (this.isSpawned()) {
            this.theEntity.func_70661_as().func_75499_g();
        }
        try {
            if (ModSimukraft.proxy.getClientWorld() != null) {
                // empty if block
            }
            this.beamingTo = whereTo.clone();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void doBeaming() {
        try {
            if (System.currentTimeMillis() - this.timeStartedGotoing > 4000L || this.beamingTo == null) {
                if (this.theEntity != null) {
                    this.theEntity.func_70634_a(this.beamingTo.x, this.beamingTo.y + 1.0, this.beamingTo.z);
                    if (this.theEntity.field_71093_bK != this.beamingTo.theDimension) {
                        this.theEntity.func_71027_c(this.beamingTo.theDimension);
                        this.theEntity.field_71093_bK = this.beamingTo.theDimension;
                        this.location.theDimension = this.beamingTo.theDimension;
                    }
                }
                SimukraftReloaded.log.info("FolkData: doBeaming() complete for " + this.name + " to " + this.beamingTo.toString() + " (dim " + this.beamingTo.theDimension + ")");
                this.location = this.beamingTo.clone();
                this.destination = null;
                this.beamingTo = null;
                this.respawnEntity((World)MinecraftServer.func_71276_C().func_71218_a(this.location.theDimension));
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.destination = null;
            this.beamingTo = null;
            return;
        }
        Random random = new Random();
        Double d4 = ((double)random.nextFloat() - 2.0) * 2.0;
        this.stayPut = true;
        WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
        for (int p = 0; p < 10; ++p) {
            try {
                if (!SimukraftReloadedConfig.configDisableBeamEffect) {
                    theWorld.func_72869_a("portal", this.location.x + random.nextDouble() - 0.5, this.location.y - 1.0, this.location.z + random.nextDouble() - 0.5, 0.0, -d4.doubleValue(), 0.0);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (SimukraftReloadedConfig.configDisableBeamEffect) continue;
                theWorld.func_72869_a("portal", this.beamingTo.x + random.nextDouble() - 0.5, this.beamingTo.y - 1.0, this.beamingTo.z + random.nextDouble() - 0.5, 0.0, -d4.doubleValue(), 0.0);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void loadAndSpawnFolks() {
        SimukraftReloaded.theFolks.clear();
        File folksFolder = new File(SimukraftReloaded.getSavesDataFolder() + "folks" + File.separator);
        if (!folksFolder.exists()) {
            folksFolder.mkdirs();
        }
        boolean useNewFormat = false;
        for (File f : folksFolder.listFiles()) {
            if (!f.getName().endsWith(".sk2")) continue;
            useNewFormat = true;
            break;
        }
        if (useNewFormat) {
            for (File f : folksFolder.listFiles()) {
                if (!f.getName().endsWith(".sk2")) continue;
                ArrayList<String> strings = SimukraftReloaded.loadSK2(f.getAbsoluteFile().toString());
                FolkData folkd = new FolkData();
                for (String line : strings) {
                    if (!line.contains("|")) continue;
                    int m1 = line.indexOf("|");
                    String name = line.substring(0, m1);
                    String value = line.substring(m1 + 1);
                    try {
                        if (name.contentEquals("employedat")) {
                            if (value.contentEquals("null")) continue;
                            folkd.employedAt = new CommonProxy.V3(value);
                            continue;
                        }
                        if (name.contentEquals("vocation")) {
                            if (value.contentEquals("null")) continue;
                            folkd.vocation = Job.Vocation.valueOf(value);
                            continue;
                        }
                        if (name.contentEquals("name")) {
                            folkd.name = value;
                            continue;
                        }
                        if (name.contentEquals("age")) {
                            folkd.age = Integer.parseInt(value);
                            continue;
                        }
                        if (name.contentEquals("gender")) {
                            folkd.gender = Integer.parseInt(value);
                            continue;
                        }
                        if (name.contentEquals("skin")) {
                            folkd.skinnumber = Integer.parseInt(value);
                            continue;
                        }
                        if (name.contentEquals("levelfood")) {
                            folkd.levelFood = Integer.parseInt(value);
                            continue;
                        }
                        if (name.contentEquals("trait1")) {
                            folkd.trait1 = value;
                            continue;
                        }
                        if (name.contentEquals("trait2")) {
                            folkd.trait2 = value;
                            continue;
                        }
                        if (name.contentEquals("trait3")) {
                            folkd.trait3 = value;
                            continue;
                        }
                        if (name.contentEquals("trait4")) {
                            folkd.trait4 = value;
                            continue;
                        }
                        if (name.contentEquals("levelbuilder")) {
                            folkd.levelBuilder = Float.parseFloat(value);
                            continue;
                        }
                        if (name.contentEquals("levelminer")) {
                            folkd.levelMiner = Float.parseFloat(value);
                            continue;
                        }
                        if (name.contentEquals("levelsoldier")) {
                            folkd.levelSoldier = Float.parseFloat(value);
                            continue;
                        }
                        if (name.contentEquals("stayput")) {
                            folkd.stayPut = Boolean.parseBoolean(value);
                            continue;
                        }
                        if (name.contentEquals("location")) {
                            folkd.location = new CommonProxy.V3(value);
                            continue;
                        }
                        if (name.contentEquals("pregnancy")) {
                            folkd.pregnancyStage = Float.parseFloat(value);
                            continue;
                        }
                        if (name.contentEquals("building")) {
                            if (value.contentEquals("null")) continue;
                            int m2 = value.indexOf("|");
                            int m3 = value.indexOf("||");
                            String fn = value.substring(0, m2);
                            String type = value.substring(m2 + 1, m3);
                            String dir = value.substring(m3 + 2);
                            folkd.theBuilding = Building.getBuildingForFolk(fn, type);
                            folkd.theBuilding.buildDirection = dir;
                            continue;
                        }
                        if (name.contentEquals("terraformtype")) {
                            if (value.contentEquals("null")) continue;
                            folkd.terraformerType = JobTerraformer.TerraformerType.valueOf(value);
                            continue;
                        }
                        if (!name.contentEquals("terraformradius")) continue;
                        folkd.terraformerRadius = Integer.parseInt(value);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (folkd == null) continue;
                SimukraftReloaded.log.info("FolkData: loadAndSpawnFolks() Loaded " + folkd.name + " using new file system");
                folkd.hasLoaded();
            }
        } else {
            for (File f : folksFolder.listFiles()) {
                if (!f.getName().endsWith(".suk")) continue;
                FolkData folkd = (FolkData)ModSimukraft.proxy.loadObject(f.getAbsoluteFile().toString());
                if (folkd != null) {
                    folkd.hasLoaded();
                    continue;
                }
                f.delete();
            }
        }
    }

    public void saveThisFolk() {
        Side side;
        String folder = SimukraftReloaded.getSavesDataFolder() + "folks" + File.separator;
        File f = new File(folder);
        if (!f.exists()) {
            f.mkdirs();
        }
        if ((side = FMLCommonHandler.instance().getEffectiveSide()) == Side.SERVER) {
            ArrayList<String> strings = new ArrayList<String>();
            if (this.employedAt == null) {
                strings.add("employedat|null");
            } else {
                strings.add("employedat|" + this.employedAt.toString());
            }
            if (this.vocation == null) {
                strings.add("vocation|null");
            } else {
                strings.add("vocation|" + this.vocation.name());
            }
            strings.add("name|" + this.name);
            strings.add("age|" + this.age);
            strings.add("gender|" + this.gender);
            strings.add("skin|" + this.skinnumber);
            strings.add("trait1|" + this.trait1);
            strings.add("trait2|" + this.trait2);
            strings.add("trait3|" + this.trait3);
            strings.add("trait4|" + this.trait4);
            strings.add("levelfood|" + this.levelFood);
            strings.add("levelbuilder|" + this.levelBuilder);
            strings.add("levelminer|" + this.levelMiner);
            strings.add("levelsoldier|" + this.levelSoldier);
            strings.add("stayput|" + this.stayPut.toString());
            strings.add("location|" + this.location.toString());
            strings.add("pregnancy|" + this.pregnancyStage);
            if (this.theBuilding == null) {
                strings.add("building|null");
            } else {
                strings.add("building|" + this.theBuilding.displayName + ".txt|" + this.theBuilding.type + "||" + this.theBuilding.buildDirection);
            }
            if (this.terraformerType == null) {
                strings.add("terraformtype|null");
            } else {
                strings.add("terraformtype|" + this.terraformerType.name());
            }
            strings.add("terraformradius|" + this.terraformerRadius);
            if (!this.name.contentEquals("")) {
                SimukraftReloaded.saveSK2(folder + this.name + ".sk2", strings);
            }
        }
    }

    public Building getHome() {
        for (int b = 0; b < SimukraftReloaded.theBuildings.size(); ++b) {
            Building home = SimukraftReloaded.theBuildings.get(b);
            for (int t = 0; t < home.tennants.size(); ++t) {
                String tennant = home.tennants.get(t);
                if (!tennant.contentEquals(this.name)) continue;
                return home;
            }
        }
        return null;
    }

    public static void generateNewFolk(World world) {
        ArrayList fds = FolkData.getFolkHomeless();
        if (fds.size() == 0 && SimukraftReloaded.theFolks.size() < SimukraftReloadedConfig.configPopulationLimit) {
            new FolkData(world);
        }
    }

    public static FolkData getFolkByName(String name) {
        FolkData f = null;
        for (int x = 0; x < SimukraftReloaded.theFolks.size(); ++x) {
            f = SimukraftReloaded.theFolks.get(x);
            if (!f.name.contentEquals(name)) continue;
            return f;
        }
        return null;
    }

    public static FolkData getFolkByLocation(CommonProxy.V3 loc) {
        FolkData f = null;
        for (int x = 0; x < SimukraftReloaded.theFolks.size(); ++x) {
            f = SimukraftReloaded.theFolks.get(x);
            if (!f.location.isSameCoordsAs(loc, true, false)) continue;
            return f;
        }
        return null;
    }

    public static FolkData getFolkByEmployedAt(CommonProxy.V3 employedAt) {
        FolkData f = null;
        for (int x = 0; x < SimukraftReloaded.theFolks.size(); ++x) {
            f = SimukraftReloaded.theFolks.get(x);
            if (f.employedAt == null || !f.employedAt.isSameCoordsAs(employedAt, true, false)) continue;
            return f;
        }
        return null;
    }

    public static ArrayList<FolkData> getFolksByEmployedAt(CommonProxy.V3 v) {
        ArrayList<FolkData> ret = new ArrayList<FolkData>();
        for (int x = 0; x < SimukraftReloaded.theFolks.size(); ++x) {
            FolkData f = SimukraftReloaded.theFolks.get(x);
            if (f.employedAt == null || !f.employedAt.isSameCoordsAs(v, true, false)) continue;
            ret.add(f);
        }
        return ret;
    }

    public static ArrayList getFolkUnemployed(boolean showEmployed) {
        ArrayList<FolkData> f = new ArrayList<FolkData>();
        for (int x = 0; x < SimukraftReloaded.theFolks.size(); ++x) {
            FolkData folk = SimukraftReloaded.theFolks.get(x);
            if (showEmployed) {
                if (folk.employedAt == null) continue;
                f.add(folk);
                continue;
            }
            if (folk.employedAt != null || folk.age <= 17 || folk.pregnancyStage != 0.0f) continue;
            f.add(folk);
        }
        return f;
    }

    public static ArrayList getFolkHomeless() {
        ArrayList<FolkData> f = new ArrayList<FolkData>();
        for (int x = 0; x < SimukraftReloaded.theFolks.size(); ++x) {
            FolkData folk = SimukraftReloaded.theFolks.get(x);
            if (folk.getHome() != null) continue;
            f.add(folk);
        }
        return f;
    }

    public static FolkData getFolkDataByEntityId(int id) {
        for (int i = 0; i < SimukraftReloaded.theFolks.size(); ++i) {
            FolkData fd = SimukraftReloaded.theFolks.get(i);
            if (fd.theEntity == null || fd.theEntity.func_145782_y() != id) continue;
            return fd;
        }
        return null;
    }

    public void eventDied(DamageSource d) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        SimukraftReloaded.log.info("eventDied in FolkData fired on " + side.toString() + " side");
        String oldJob = "";
        if (this.vocation != null) {
            oldJob = " (" + this.vocation.toString() + ")";
        }
        this.employedAt = null;
        this.vocation = null;
        String deathBy = "";
        if (d == DamageSource.field_76367_g) {
            deathBy = "(death by cactus... the worst kind.) ";
        }
        if (d == DamageSource.field_76369_e) {
            deathBy = "(drowned) ";
        }
        if (d == DamageSource.field_76377_j) {
            deathBy = "(Natural causes/old age) ";
        }
        if (d == DamageSource.field_76372_a) {
            deathBy = "(Spontanious combustion) ";
        }
        if (d == DamageSource.field_76371_c) {
            deathBy = "(while walking on lava) ";
        }
        if (d == DamageSource.field_76370_b) {
            deathBy = "(Burned alive!) ";
        }
        if (d == DamageSource.field_76380_i) {
            deathBy = "(Fell out of the world!) ";
        }
        if (d == DamageSource.field_76366_f) {
            deathBy = "(starvation, Build farms, bakeries and grocery stores!) ";
        }
        if (d == DamageSource.field_76379_h) {
            deathBy = "(Fell off a cliff, or were they pushed?!)";
        }
        if (d == DamageSource.field_76368_d) {
            deathBy = "(Buried alive under gravel/sand)";
        }
        if (deathBy.contentEquals("")) {
            Random r = new Random();
            int ded = r.nextInt(6);
            if (ded == 0) {
                deathBy = "(Electrocuted while in bath) ";
            } else if (ded == 1) {
                deathBy = "(Tripped on roller-skate on stairs) ";
            } else if (ded == 2) {
                deathBy = "(Trampled by cows) ";
            } else if (ded == 3) {
                deathBy = "(Ran over by minecart) ";
            } else if (ded == 4) {
                deathBy = "(Slipped on banana skin) ";
            } else if (ded == 5) {
                deathBy = "(killed by Notch) ";
            }
        }
        String only = "";
        only = this.age < 80 ? "They were only " + this.age + " years old." : "They were " + this.age + " years old, oh well, they had a good long life!";
        SimukraftReloaded.sendChat(this.name + oldJob + " has just died! " + deathBy + only);
        this.action = FolkAction.WANDER;
        int i = 0;
        for (int fn = 0; fn < SimukraftReloaded.theFolks.size(); ++fn) {
            FolkData fo = SimukraftReloaded.theFolks.get(fn);
            if (!fo.name.contentEquals(this.name)) continue;
            i = fn;
            break;
        }
        this.evictThem();
        try {
            for (int q = 0; q < SimukraftReloaded.theRelationships.size(); ++q) {
                try {
                    Relationship rel = SimukraftReloaded.theRelationships.get(q);
                    if (!rel.folk1.name.contentEquals(this.name) && !rel.folk2.name.contentEquals(this.name)) continue;
                    String fn = rel.folk1.name.replaceAll(" ", "") + rel.folk2.name.replaceAll(" ", "");
                    File f = new File(SimukraftReloaded.getSavesDataFolder() + "Relationships" + File.separator + fn + ".sk2");
                    f.delete();
                    SimukraftReloaded.theRelationships.remove(q);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            File f = new File(SimukraftReloaded.getSavesDataFolder() + "folks" + File.separator + this.name + ".sk2");
            f.delete();
            if (i >= 0 && i < SimukraftReloaded.theFolks.size()) {
                SimukraftReloaded.theFolks.remove(i);
            }
        }
        catch (Exception e) {
            SimukraftReloaded.log.warning("FolkData: eventDied() " + e.toString());
        }
    }

    public void evictThem() {
        if (this.getHome() != null) {
            for (int b = 0; b < SimukraftReloaded.theBuildings.size(); ++b) {
                Building building = SimukraftReloaded.theBuildings.get(b);
                if (building == null || this.getHome() == null || !building.primaryXYZ.isSameCoordsAs(this.getHome().primaryXYZ, true, false)) continue;
                building.removeTennant(this.name);
            }
        }
    }

    public void setTheirJob(Job.Vocation vocation) {
        if (vocation == null) {
            return;
        }
        this.vocation = vocation;
        if (this.vocation == Job.Vocation.BUILDER) {
            this.theirJob = new JobBuilder(this);
        } else if (this.vocation == Job.Vocation.BAKER) {
            this.theirJob = new JobBaker(this);
        } else if (this.vocation == Job.Vocation.BUTCHER) {
            this.theirJob = new JobButcher(this);
        } else if (this.vocation == Job.Vocation.CATTLEFARMER) {
            this.theirJob = new JobLivestockFarmer(this);
        } else if (this.vocation == Job.Vocation.CHICKENFARMER) {
            this.theirJob = new JobLivestockFarmer(this);
        } else if (this.vocation == Job.Vocation.COURIER) {
            this.theirJob = new JobCourier(this);
        } else if (this.vocation == Job.Vocation.CROPFARMER) {
            this.theirJob = new JobCropFarmer(this);
        } else if (this.vocation == Job.Vocation.GLASSMAKER) {
            this.theirJob = new JobGlassMaker(this);
        } else if (this.vocation == Job.Vocation.BRICKMAKER) {
            this.theirJob = new JobBrickMaker(this);
        } else if (this.vocation == Job.Vocation.GROCER) {
            this.theirJob = new JobGrocer(this);
        } else if (this.vocation == Job.Vocation.LUMBERJACK) {
            this.theirJob = new JobLumberjack(this);
        } else if (this.vocation == Job.Vocation.MERCHANT) {
            this.theirJob = new JobBuildersMerchant(this);
        } else if (this.vocation == Job.Vocation.MINER) {
            this.theirJob = new JobMiner(this);
        } else if (this.vocation == Job.Vocation.PIGFARMER) {
            this.theirJob = new JobLivestockFarmer(this);
        } else if (this.vocation == Job.Vocation.SHEPHERD) {
            this.theirJob = new JobShepherd(this);
        } else if (this.vocation == Job.Vocation.SOLDIER) {
            this.theirJob = new JobSoldier(this);
        } else if (this.vocation == Job.Vocation.TERRAFORMER) {
            this.theirJob = new JobTerraformer(this);
        } else if (this.vocation == Job.Vocation.FISHERMAN) {
            this.theirJob = new JobFisherman(this);
        } else if (this.vocation != Job.Vocation.PATHBUILDER) {
            if (this.vocation == Job.Vocation.DAIRYFARMER) {
                this.theirJob = new JobDairyFarmer(this);
            } else if (this.vocation == Job.Vocation.CHEESEMAKER) {
                this.theirJob = new JobCheesemaker(this);
            } else if (this.vocation == Job.Vocation.BURGERSMANAGER) {
                this.theirJob = new JobBurgersManager(this);
            } else if (this.vocation == Job.Vocation.BURGERSFRYCOOK) {
                this.theirJob = new JobBurgersFryCook(this);
            } else if (this.vocation == Job.Vocation.BURGERSWAITER) {
                this.theirJob = new JobBurgersWaiter(this);
            } else if (this.vocation == Job.Vocation.EGGFARMER) {
                this.theirJob = new JobEggFarmer(this);
            }
        }
        this.theirJob.resetJob();
        this.theirJob.step = 1;
    }

    public void generateTraits() {
        Random rand = new Random();
        this.trait1 = Traits.traitList[rand.nextInt((int)(Traits.traitList.length - 1))].traitName;
        this.trait2 = Traits.traitList[rand.nextInt((int)(Traits.traitList.length - 1))].traitName;
        while (this.trait2 == this.trait1 || this.traitHasOpposite(this.trait2)) {
            this.trait2 = Traits.traitList[rand.nextInt((int)(Traits.traitList.length - 1))].traitName;
        }
        this.trait3 = Traits.traitList[rand.nextInt((int)(Traits.traitList.length - 1))].traitName;
        while (this.trait3 == this.trait2 || this.trait3 == this.trait1 || this.traitHasOpposite(this.trait3)) {
            this.trait3 = Traits.traitList[rand.nextInt((int)(Traits.traitList.length - 1))].traitName;
        }
        this.trait4 = Traits.traitList[rand.nextInt((int)(Traits.traitList.length - 1))].traitName;
        while (this.trait4 == this.trait1 || this.trait4 == this.trait2 || this.trait4 == this.trait3 || this.traitHasOpposite(this.trait4)) {
            this.trait4 = Traits.traitList[rand.nextInt((int)(Traits.traitList.length - 1))].traitName;
        }
    }

    public boolean traitHasOpposite(String trait) {
        return Trait.getTraitFromName((String)trait).traitOpposite != null && trait.contains(Trait.getTraitFromName((String)trait).traitOpposite.traitName);
    }

    public static enum FolkAction {
        ONWAYTOWORK,
        ATWORK,
        WANDER,
        ATHOME,
        GOINGHOME,
        STAYINGHOME,
        HAVINGBABY;


        public String toString() {
            String ret = "\u65e0\u6240\u4e8b\u4e8b";
            if (this == WANDER) {
                ret = "\u95f2\u901b";
            } else if (this == ATWORK) {
                ret = "\u5728\u5de5\u4f5c";
            } else if (this == ONWAYTOWORK) {
                ret = "\u5728\u53bb\u4e0a\u73ed\u7684\u8def\u4e0a";
            } else if (this == ATHOME) {
                ret = "\u5728\u5bb6\u4f11\u606f";
            } else if (this == GOINGHOME) {
                ret = "\u8981\u56de\u5bb6\u4e86";
            } else if (this == STAYINGHOME) {
                ret = "\u5446\u5728\u5bb6\u91cc";
            } else if (this == HAVINGBABY) {
                ret = "\u6709\u4e00\u4e2a\u5b69\u5b50";
            }
            return ret;
        }
    }

    public static enum GotoMethod {
        WALK,
        BEAM,
        SHIFT;


        public String toString() {
            if (this == BEAM) {
                return "Beaming";
            }
            if (this == SHIFT) {
                return "Shifting";
            }
            if (this == WALK) {
                return "Walking";
            }
            return "";
        }
    }
}

