/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.entity;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.ModSimukraft;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedBlocks;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityConBox
extends Entity {
    public float boxYaw = 0.0f;
    public int textColor = 0xAFFFAF;
    public FolkData theFolk = null;
    private Long lastCheck = 0L;
    private EntityPlayer closestPlayer;

    public EntityConBox(World par1World) {
        super(par1World);
        this.field_70145_X = true;
        this.field_70158_ak = true;
        if (!ModSimukraft.proxy.ranStartup) {
            SimukraftReloaded.log.info("EntityConBox: Killed system spawned ConBox");
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        if (System.currentTimeMillis() - this.lastCheck > 10000L) {
            ArrayList<CommonProxy.V3> conblocks;
            if (this.theFolk != null && this.theFolk.theBuilding == null) {
                SimukraftReloaded.log.info("EntityConBox: Removing conBox as building is done");
                this.spawnExplosionParticle(this);
                this.func_70106_y();
            }
            if ((conblocks = Job.findClosestBlocks(new CommonProxy.V3(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_71093_bK), SimukraftReloadedBlocks.buildingConstructor, 5)).size() < 1) {
                this.func_70106_y();
            }
            this.lastCheck = System.currentTimeMillis();
        }
        this.boxYaw += 1.0f;
        super.func_70071_h_();
    }

    public static FolkData getFolk(CommonProxy.V3 where) {
        CommonProxy.V3 con = Job.findClosestBlockType(where, SimukraftReloadedBlocks.buildingConstructor, 6, false);
        FolkData ret = null;
        for (int f = 0; f < SimukraftReloaded.theFolks.size(); ++f) {
            FolkData fd = SimukraftReloaded.theFolks.get(f);
            if (fd.employedAt == null || !fd.employedAt.isSameCoordsAs(where, true, false)) continue;
            SimukraftReloaded.log.info("EntityConBox: found folk " + fd.name);
            ret = fd;
            break;
        }
        return ret;
    }

    private void spawnExplosionParticle(Entity ent) {
        Random rand = new Random();
        for (int var1 = 0; var1 < 20; ++var1) {
            double var2 = rand.nextGaussian() * 0.02;
            double var4 = rand.nextGaussian() * 0.02;
            double var6 = rand.nextGaussian() * 0.02;
            double var8 = 10.0;
            try {
                ModSimukraft.proxy.getClientWorld().func_72869_a("explode", ent.field_70165_t + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0 - var2 * var8, ent.field_70163_u + (double)(rand.nextFloat() * 1.0f) - var4 * var8, ent.field_70161_v + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0 - var6 * var8, var2, var4, var6);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    protected void func_70037_a(NBTTagCompound var1) {
    }

    protected void func_70014_b(NBTTagCompound var1) {
    }
}

