/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.core.registry;

import ashjack.simukraftreloaded.blocks.functionality.FarmingBox;
import ashjack.simukraftreloaded.blocks.functionality.MiningBox;
import ashjack.simukraftreloaded.client.Gui.other.GuiRunMod;
import ashjack.simukraftreloaded.common.CourierTask;
import ashjack.simukraftreloaded.common.GameStates;
import ashjack.simukraftreloaded.common.PricesForBlocks;
import ashjack.simukraftreloaded.common.Relationship;
import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.common.jobs.JobSoldier;
import ashjack.simukraftreloaded.core.ModSimukraft;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.game.GameMode;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedBlocks;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class SimukraftReloaded {
    public static Logger log = Logger.getLogger("Sim-U-Kraft Reloaded");
    public static String currentSavePath = "";
    public static ArrayList<FolkData> theFolks = new ArrayList();
    public static ArrayList<Building> theBuildings = new ArrayList();
    public static ArrayList<CourierTask> theCourierTasks = new ArrayList();
    public static ArrayList<CommonProxy.V3> theCourierPoints = new ArrayList();
    public static ArrayList<MiningBox> theMiningBoxes = new ArrayList();
    public static ArrayList<FarmingBox> theFarmingBoxes = new ArrayList();
    public static ArrayList<Relationship> theRelationships = new ArrayList();
    public static GameStates states = new GameStates();
    public static ArrayList<CommonProxy.Commodity> theCommodities = new ArrayList();
    public static FarmingBox farmToUpgrade = null;
    public static int farmToUpgradeCounter = 0;
    private static ArrayList<CommonProxy.V3> farmToUpgradePoints = null;
    public static boolean isDay = true;
    public static ArrayList<CommonProxy.V3> demolishBlocks = new ArrayList();
    public static World demolishWorld = null;
    private static GuiRunMod runModui = null;
    int highest = 0;
    int m1 = 0;
    protected static final String[] dow = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};

    public static void resetAndLoadNewWorld() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        log.info("RESETTING and loading world on " + side.toString() + " SIDE");
        theBuildings.clear();
        theCourierPoints.clear();
        theCourierTasks.clear();
        theMiningBoxes.clear();
        theFarmingBoxes.clear();
        theFolks.clear();
        theRelationships.clear();
        File f = new File(SimukraftReloaded.getSavesDataFolder() + "settings.sk2");
        if (!f.exists()) {
            f = new File(SimukraftReloaded.getSavesDataFolder() + "settings.suk");
        }
        if (f.exists()) {
            states.loadStates();
            try {
                GameMode.setGameModeFromNumber(SimukraftReloaded.states.gameModeNumber);
            }
            catch (Exception e) {
                GameMode.setGameModeFromNumber(0);
            }
        } else {
            states = new GameStates();
            states.saveStates();
        }
        if (states == null) {
            new File(SimukraftReloaded.getSavesDataFolder() + "settings.sk2").delete();
            states = new GameStates();
            states.saveStates();
            SimukraftReloaded.sendChat("\u60a8\u7684Sim-U-Kraft\u8bbe\u7f6e\u6587\u4ef6\u5df2\u635f\u574f\uff0c\u4e0d\u5f97\u4e0d\u751f\u6210\u4e00\u4e2a\u65b0\u7684");
        }
        if (SimukraftReloaded.states.gameModeNumber == -1) {
            if (runModui == null) {
                GuiRunMod runModui = new GuiRunMod();
                Minecraft.func_71410_x().func_147108_a((GuiScreen)runModui);
            }
            return;
        }
        if (SimukraftReloaded.states.gameModeNumber >= 0) {
            System.out.println("\u542f\u52a8\u5df2\u8fd0\u884c");
            ModSimukraft.proxy.ranStartup = true;
        }
        SimukraftReloaded.sendChat("\u6b22\u8fce\u6765\u5230 \u6a21\u62df\u57ce\u5e02(Sim-U-Kraft)\u91cd\u88c5\u4e0a\u9635 1.0.2a  By KyLin\u9ed8\u5bd2\u6c49\u5316");
        theFolks.clear();
        Building.initialiseAllBuildings();
        Building.loadAllBuildings();
        CourierTask.loadCourierTasksAndPoints();
        MiningBox.loadMiningBoxes();
        FarmingBox.loadFarmingBoxes();
        FolkData.loadAndSpawnFolks();
        Relationship.loadRelationships();
        SimukraftReloaded.updateCheck();
        isDay = SimukraftReloaded.isDayTime();
        Building.checkTennants();
        ModSimukraft.proxy.ranStartup = true;
    }

    public static void sendChat(String theText) {
        for (WorldServer w : MinecraftServer.func_71276_C().field_71305_c) {
            if (w.field_72995_K) continue;
            for (int i = 0; i < w.field_73010_i.size(); ++i) {
                EntityPlayer p = (EntityPlayer)w.field_73010_i.get(i);
                p.func_146105_b((IChatComponent)new ChatComponentText(theText));
            }
        }
    }

    public static String getSavesDataFolder() {
        String worldname = MinecraftServer.func_71276_C().func_71270_I();
        String strmc = new File(".").getAbsolutePath();
        strmc = strmc.substring(0, strmc.length() - 1);
        File test = new File(strmc + "saves");
        String ret = "";
        if (test.exists()) {
            ret = new File(strmc + File.separator + "saves" + File.separator + worldname + File.separator + "simukraft" + File.separator).getAbsolutePath() + File.separator;
        } else {
            strmc = strmc + worldname + File.separator + "simukraft" + File.separator;
            ret = new File(strmc).getAbsolutePath();
        }
        File f = new File(ret);
        if (!f.exists()) {
            f.mkdirs();
        }
        return ret;
    }

    public static String getSimukraftFolder() {
        try {
            String strmc = new File(".").getAbsolutePath();
            strmc = strmc.substring(0, strmc.length() - 1);
            return new File(strmc + File.separator + "mods" + File.separator + "Simukraft").getAbsolutePath();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean isDayTime() {
        return MinecraftServer.func_71276_C().field_71305_c[0].func_72912_H().func_76073_f() % 24000L <= 11999L;
    }

    public static String displayMoney(float moneyin) {
        DecimalFormat myFormatter = new DecimalFormat("#,##0.00");
        String output = myFormatter.format(moneyin);
        return output;
    }

    public static void updateCheck() {
    }

    public void ThreadUpdate() {
        this.start();
    }

    public void start() {
        try {
            String newbs;
            Thread.sleep(15000L);
            File check = new File(SimukraftReloaded.getSimukraftFolder() + "/buildings/");
            if (!check.exists()) {
                SimukraftReloaded.sendChat(SimukraftReloaded.getSimukraftFolder() + "/buildings/  folder is missing, Sim-U-Kraft is not correctly installed, please copy the simukraft folder AND the zip file.");
                return;
            }
            String baseURL = "https://dl.dropboxusercontent.com/u/255688822/Sim-U-Kraft%20Reloaded/versions.txt";
            String ver = this.downloadFile(baseURL, SimukraftReloaded.getSimukraftFolder() + File.separator + "simukraft.txt");
            if (ver != null && !(ver = ver.trim()).contentEquals("")) {
                if (!"1.0.2a".contentEquals(ver)) {
                    // empty if block
                }
                Long now = System.currentTimeMillis();
                SimukraftReloaded.states.lastUpdateCheck = now;
                states.saveStates();
            }
            int high = this.getHighestPKID("residential");
            int o = this.getHighestPKID("other");
            if (o > high) {
                high = o;
            }
            if ((newbs = this.downloadFile(baseURL + "backend.php?cmd=getnew&n=" + high + "&i=" + this.getTheirId() + "&v=" + "1.0.2a", SimukraftReloaded.getSimukraftFolder() + File.separator + "simukraft.txt")).length() == 0) {
                return;
            }
            String[] items = newbs.split("!END");
            for (int i = 0; i < items.length - 1; ++i) {
                String local;
                String[] fields = items[i].split("!F");
                String url = baseURL + "catalogue/PKID" + fields[0] + "-" + fields[1] + ".txt";
                String ret = this.downloadFile(url, local = SimukraftReloaded.getSimukraftFolder() + "/buildings/" + fields[3] + "/PKID" + fields[0] + "-" + fields[1] + ".txt");
                if (ret.contentEquals("")) continue;
                url = baseURL + "backend.php?cmd=got&pk=" + fields[0];
                this.downloadFile(url, SimukraftReloaded.getSimukraftFolder() + File.separator + "cache.txt");
                SimukraftReloaded.sendChat("Sim-U-Kraft: Downloaded new building - '" + fields[1] + "' by " + fields[2] + " (" + fields[3] + ")");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getTheirId() {
        return null;
    }

    public int getHighestPKID(String type) {
        File actual = new File(SimukraftReloaded.getSimukraftFolder() + File.separator + "buildings" + File.separator + type + File.separator);
        for (File f : actual.listFiles()) {
            String id;
            if (!f.getName().startsWith("PKID")) continue;
            this.m1 = f.getName().indexOf("-");
            if (this.m1 <= 0 || Integer.parseInt(id = f.getName().substring(4, this.m1)) <= this.highest) continue;
            this.highest = Integer.parseInt(id);
        }
        return this.highest;
    }

    public String downloadFile(String url, String localFile) {
        String ret = "";
        log.info("Downloading file " + url);
        url = url.replace(" ", "%20");
        try {
            BufferedInputStream in = new BufferedInputStream(new URL(url).openStream());
            FileOutputStream fos = new FileOutputStream(localFile);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
            byte[] data = new byte[4096];
            int x = 0;
            while ((x = in.read(data, 0, 4096)) >= 0) {
                bout.write(data, 0, x);
            }
            bout.flush();
            ret = new String(data);
            bout.close();
            in.close();
        }
        catch (Exception e) {
            ret = "";
            e.printStackTrace();
        }
        return ret;
    }

    public static void dayTransitionHandler() {
        if (SimukraftReloaded.isDayTime() && !isDay) {
            EntityClientPlayerMP p;
            isDay = true;
            log.info("Night to day transition");
            World world = ModSimukraft.proxy.getClientWorld();
            if (world != null && (p = Minecraft.func_71410_x().field_71439_g) != null) {
                ModSimukraft.proxy.getClientWorld().func_72980_b(p.field_70165_t, p.field_70163_u, p.field_70161_v, "ashjacksimukraftreloaded:rooster", 1.0f, 1.0f, false);
            }
            ++SimukraftReloaded.states.dayOfWeek;
            if (SimukraftReloaded.states.dayOfWeek > 6) {
                SimukraftReloaded.states.dayOfWeek = 0;
                int homeless = 0;
                for (FolkData f : theFolks) {
                    if (f.getHome() != null) continue;
                    ++homeless;
                }
                if (homeless > 1) {
                    SimukraftReloaded.sendChat("\u6709\u66f4\u591a\u7684\u5c45\u4f4f\u9700\u6c42\uff0c\u4f60\u6709" + homeless + " \u5e02\u6c11\u6ca1\u6709\u4e00\u4e2a\u5bb6\u3002");
                }
            }
            SimukraftReloaded.evolveFolks();
            if (theFolks.size() > 1) {
                int f1;
                Random rand = new Random();
                int f2 = f1 = rand.nextInt(theFolks.size());
                while (f2 == f1) {
                    f2 = rand.nextInt(theFolks.size());
                }
                FolkData folk1 = theFolks.get(f1);
                FolkData folk2 = theFolks.get(f2);
                Relationship.meddleWithRelationship(folk1, folk2);
            }
        }
        if (!SimukraftReloaded.isDayTime() && isDay) {
            isDay = false;
            log.info("\u6e21\u8fc7\u4e00\u665a");
            if (theFolks.size() > 1) {
                int f1;
                Random rand = new Random();
                int f2 = f1 = rand.nextInt(theFolks.size());
                while (f2 == f1) {
                    f2 = rand.nextInt(theFolks.size());
                }
                FolkData folk1 = theFolks.get(f1);
                FolkData folk2 = theFolks.get(f2);
                Relationship.meddleWithRelationship(folk1, folk2);
            }
            for (FolkData folk : theFolks) {
                folk.destination = null;
                if (folk.theEntity == null) continue;
                folk.theEntity.func_70661_as().func_75499_g();
            }
        }
    }

    private static void evolveFolks() {
        FolkData folk;
        if (theFolks.size() <= 0) {
            return;
        }
        Random rand = new Random();
        log.info("evolving folks");
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                float totalRent = 0.0f;
                float totalCorpTax = 0.0f;
                if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                    for (int b = 0; b < theBuildings.size(); ++b) {
                        Building building = theBuildings.get(b);
                        if (!building.type.contentEquals("residential") || building.tennants.size() <= 0) continue;
                        if (building.rent == null || building.rent.floatValue() == 0.0f) {
                            building.rent = Float.valueOf(1.0f);
                        }
                        log.info("\u5927\u53a6\u79df\u91d1" + building.displayNameWithoutPK + ": " + building.rent + "(" + building.blocksInBuilding + ")");
                        totalRent += building.rent.floatValue();
                    }
                }
                if (totalRent > 0.0f) {
                    SimukraftReloaded.sendChat("\u6536\u96c6" + SimukraftReloaded.displayMoney(totalRent) + " Sim-u-credits\u4eca\u5929\u7684\u79df\u91d1\u3002 By KyLin\u9ed8\u5bd2\u6c49\u5316");
                    SimukraftReloaded.sendChat("\u6536\u96c6" + SimukraftReloaded.displayMoney(totalCorpTax) + " Sim-u-credits \u4eca\u5929\u4f01\u4e1a\u7684\u7a0e\u3002");
                    SimukraftReloaded.states.credits += totalRent;
                    SimukraftReloaded.states.credits += totalCorpTax;
                    EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
                    if (p != null) {
                        ModSimukraft.proxy.getClientWorld().func_72980_b(p.field_70165_t, p.field_70163_u, p.field_70161_v, "ashjacksimukraftreloaded:cash", 1.0f, 1.0f, false);
                    }
                } else if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                    SimukraftReloaded.sendChat("\u4eca\u5929\u6ca1\u6536\u96c6\u5230\u79df\u91d1\uff0c\u4f60\u5e94\u8be5\u8058\u8bf7\u4e00\u4e2a\u5efa\u7b51\u5e08\u5efa\u9020\u4f4f\u5b85\u3002");
                }
            }
        });
        t.start();
        for (int f = 0; f < theFolks.size(); ++f) {
            int currentAge;
            folk = theFolks.get(f);
            folk.greetedToday = false;
            folk.matingStage = -1.0f;
            if (folk.pregnancyStage > 0.0f) {
                folk.pregnancyStage += 0.1f;
            }
            if ((currentAge = folk.age++) >= 18) {
                if (SimukraftReloaded.states.dayOfWeek == 6) {
                    // empty if block
                }
            } else if (SimukraftReloaded.states.dayOfWeek == 3 || SimukraftReloaded.states.dayOfWeek == 6) {
                ++folk.age;
                if (currentAge == 17 && folk.age == 18) {
                    folk.evictThem();
                    SimukraftReloaded.sendChat(folk.name + " \u5df2\u7ecf18\u5c81\u4e86\uff0c\u4ed6\u4eec\u5c06\u5f00\u59cb\u5bfb\u627e\u623f\u5b50\uff0c\u4f60\u73b0\u5728\u53ef\u4ee5\u96c7\u4f63\u4ed6\u4eec\u3002");
                }
            }
            if (folk.age <= 110 || rand.nextInt(10) != 5) continue;
            SimukraftReloaded.sendChat(folk.name + "\u8001\u4e86\uff0c\u611f\u89c9\u4e0d\u662f\u5f88\u597d\u2026\u2026\u54e6\u4e0d\uff01");
            folk.eventDied(DamageSource.field_76377_j);
        }
        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
            int f;
            int fl = rand.nextInt(theFolks.size());
            for (f = 0; f < theFolks.size(); ++f) {
                folk = theFolks.get(f);
                if (f != fl) continue;
                --folk.levelFood;
                if (folk.levelFood != 0) continue;
                SimukraftReloaded.sendChat(folk.name + " is VERY hungry, you should build a farm, grocery, bakery or throw some food at them.");
            }
            for (f = 0; f < theFolks.size(); ++f) {
                folk = theFolks.get(f);
                if (folk.theirJob == null || folk.vocation != Job.Vocation.SOLDIER) continue;
                JobSoldier job = (JobSoldier)folk.theirJob;
                float pay = (float)job.kills * 0.2f;
                if (job.kills <= 0) continue;
                SimukraftReloaded.sendChat("\u4ed8\u8d39" + folk.name + " " + SimukraftReloaded.displayMoney(pay) + "\u82b1\u8d39 Sim-u-credits\u6740\u5bb3" + job.kills + " \u6628\u5929\u654c\u5bf9\u7684\u66b4\u5f92\u3002");
                SimukraftReloaded.states.credits -= pay;
                job.kills = 0;
            }
            boolean updown = rand.nextBoolean();
            PricesForBlocks.adjustPrice(Blocks.field_150344_f, updown);
            updown = rand.nextBoolean();
            PricesForBlocks.adjustPrice(Blocks.field_150347_e, updown);
            updown = rand.nextBoolean();
            PricesForBlocks.adjustPrice(Blocks.field_150348_b, updown);
            updown = rand.nextBoolean();
            PricesForBlocks.adjustPrice(Blocks.field_150359_w, updown);
            updown = rand.nextBoolean();
            PricesForBlocks.adjustPrice(Blocks.field_150325_L, updown);
            updown = rand.nextBoolean();
            PricesForBlocks.adjustPrice(Blocks.field_150336_V, updown);
            updown = rand.nextBoolean();
            PricesForBlocks.adjustPrice(Blocks.field_150417_aV, updown);
            updown = rand.nextBoolean();
            PricesForBlocks.adjustPrice(Blocks.field_150422_aJ, updown);
        }
        states.saveStates();
        CommonProxy.Commodity.refreshAvailableCommoditities();
    }

    public static void demolishBlocks() {
        if (demolishBlocks.size() < 1) {
            return;
        }
        int count = demolishBlocks.size();
        if (count > 10) {
            count = 10;
        }
        for (int i = 0; i < count; ++i) {
            CommonProxy.V3 blockLoc = demolishBlocks.get(0);
            try {
                Block block = Block.func_149684_b((String)blockLoc.name);
                block.func_149697_b(demolishWorld, blockLoc.x.intValue(), blockLoc.y.intValue() + 10 + new Random().nextInt(20), blockLoc.z.intValue(), 0, 0);
                demolishBlocks.remove(0);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void upgradeFarm() {
        if (SimukraftReloaded.farmToUpgrade.level == 0) {
            SimukraftReloaded.farmToUpgrade.level = 1;
        }
        if (SimukraftReloaded.farmToUpgrade.level == 1) {
            if (farmToUpgradePoints == null) {
                farmToUpgradePoints = farmToUpgrade.getPerimeterPoints();
            }
            CommonProxy.V3 point = farmToUpgradePoints.get(farmToUpgradeCounter);
            WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(point.theDimension);
            Block id = theWorld.func_147439_a(point.x.intValue(), point.y.intValue(), point.z.intValue());
            boolean destroy = false;
            if (id != null) {
                TileEntity te = theWorld.func_147438_o(point.x.intValue(), point.y.intValue(), point.z.intValue());
                if (te == null) {
                    destroy = true;
                } else if (!(te instanceof IInventory)) {
                    destroy = true;
                }
            } else {
                destroy = true;
            }
            if (destroy) {
                theWorld.func_147480_a(point.x.intValue(), point.y.intValue(), point.z.intValue(), true);
                theWorld.func_147465_d(point.x.intValue(), point.y.intValue(), point.z.intValue(), Blocks.field_150422_aJ, 0, 3);
                theWorld.func_147471_g(point.x.intValue(), point.y.intValue(), point.z.intValue());
            }
            if (farmToUpgradeCounter % 6 == 0) {
                theWorld.func_147465_d(point.x.intValue(), point.y.intValue() - 1, point.z.intValue(), SimukraftReloadedBlocks.lightBox, 0, 3);
                theWorld.func_147471_g(point.x.intValue(), point.y.intValue() - 1, point.z.intValue());
            }
        } else if (SimukraftReloaded.farmToUpgrade.level == 2) {
            if (farmToUpgradePoints == null) {
                farmToUpgradePoints = farmToUpgrade.getSoilBlockPoints();
            }
            CommonProxy.V3 point = farmToUpgradePoints.get(farmToUpgradeCounter);
            WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(point.theDimension);
            if (point.x.intValue() % 5 == 0 && point.z.intValue() % 5 == 0) {
                theWorld.func_147465_d(point.x.intValue(), point.y.intValue() - 1, point.z.intValue(), Blocks.field_150355_j, 0, 3);
                theWorld.func_147465_d(point.x.intValue(), point.y.intValue() - 2, point.z.intValue(), SimukraftReloadedBlocks.lightBox, 0, 3);
                theWorld.func_147471_g(point.x.intValue(), point.y.intValue() - 1, point.z.intValue());
                theWorld.func_147471_g(point.x.intValue(), point.y.intValue() - 2, point.z.intValue());
            }
        }
        if (++farmToUpgradeCounter > farmToUpgradePoints.size() - 1) {
            ++SimukraftReloaded.farmToUpgrade.level;
            farmToUpgradePoints = null;
            farmToUpgrade = null;
            farmToUpgradeCounter = 0;
            log.info("\u5b8c\u6210\u5347\u7ea7");
            return;
        }
    }

    public static String getDayOfWeek() {
        return dow[SimukraftReloaded.states.dayOfWeek];
    }

    public static ArrayList<String> loadSK2(String fullFilename) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(fullFilename));
            String line = br.readLine();
            while (line != null) {
                ret.add(line);
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveSK2(String fullFilename, ArrayList<String> strings) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(fullFilename));
            for (String line : strings) {
                bw.write(line + "\r\n");
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

