/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.core.building;

import ashjack.simukraftreloaded.core.ModSimukraft;
import ashjack.simukraftreloaded.core.game.GameMode;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedBlocks;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.infrastructure.Infrastructure;
import ashjack.simukraftreloaded.infrastructure.InfrastructureElectricity;
import ashjack.simukraftreloaded.infrastructure.InfrastructureWater;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public class Building
implements Serializable {
    private static final long serialVersionUID = -1132989807904279141L;
    public String displayName;
    public String type;
    public String[] structure;
    public String description = "None";
    public Infrastructure infrastructureRequirement = null;
    public Infrastructure infrastructureProducer = null;
    public int layerCount = 0;
    public int ftbCount = 0;
    public int ltrCount = 0;
    public String dimensions = "";
    public int elevationLevel = 0;
    public CommonProxy.V3 primaryXYZ;
    public CommonProxy.V3 livingXYZ;
    public boolean buildingComplete = false;
    public int capacity = -1;
    public String buildDirection = "";
    public CommonProxy.V3 lumbermillMarker = null;
    public int blocksInBuilding = 0;
    public String pk = "0";
    public String author = "Satscape";
    public String displayNameWithoutPK = "";
    public Float rent = Float.valueOf(0.0f);
    public ArrayList<String> tennants = new ArrayList();
    public ArrayList<CommonProxy.V3> blockLocations = new ArrayList();
    public transient HashMap<ItemStack, Integer> requirements = new HashMap();
    public transient CommonProxy.V3 conBoxLocation = null;
    private static transient ArrayList<Building> buildingsRes = new ArrayList();
    private static transient ArrayList<Building> buildingsCom = new ArrayList();
    private static transient ArrayList<Building> buildingsInd = new ArrayList();
    private static transient ArrayList<Building> buildingsOth = new ArrayList();
    private static transient ArrayList<Building> buildingsSpec = new ArrayList();
    public ArrayList<CommonProxy.V3> blockSpecial = new ArrayList();
    private static boolean runningInitThread = false;

    public Building() {
    }

    public Building(String fname, String theType) {
        this.type = theType;
        this.displayName = fname;
        this.buildingComplete = false;
        if (this.requirements == null) {
            this.requirements = new HashMap();
        }
    }

    public Building(String fname, String theType, CommonProxy.V3 pxyz, CommonProxy.V3 lxyz, boolean isComplete) {
        this.type = theType;
        this.displayName = fname;
        this.primaryXYZ = pxyz;
        this.livingXYZ = lxyz;
        this.buildingComplete = isComplete;
        if (this.requirements == null) {
            this.requirements = new HashMap();
        }
    }

    public Building clone() {
        Building ret = new Building();
        ret.displayName = this.displayName;
        ret.type = this.type;
        ret.layerCount = this.layerCount;
        ret.infrastructureRequirement = this.infrastructureRequirement;
        ret.infrastructureProducer = this.infrastructureProducer;
        ret.ftbCount = this.ftbCount;
        ret.ltrCount = this.ltrCount;
        ret.dimensions = this.dimensions;
        ret.elevationLevel = this.elevationLevel;
        ret.description = this.description;
        try {
            ret.primaryXYZ = this.primaryXYZ.clone();
        }
        catch (Exception e) {
            ret.primaryXYZ = null;
        }
        try {
            ret.livingXYZ = this.livingXYZ.clone();
        }
        catch (Exception e) {
            ret.livingXYZ = null;
        }
        ret.buildingComplete = this.buildingComplete;
        ret.capacity = -1;
        ret.buildDirection = this.buildDirection;
        ret.blocksInBuilding = this.blocksInBuilding;
        ret.pk = this.pk;
        ret.author = this.author;
        ret.displayNameWithoutPK = this.displayNameWithoutPK;
        ret.rent = this.rent;
        ret.tennants = new ArrayList();
        ret.blockLocations = new ArrayList();
        ret.blockSpecial = new ArrayList();
        ret.loadStructure();
        return ret;
    }

    public ArrayList<CommonProxy.V3> getSpecialBlocks(int meta) {
        ArrayList<CommonProxy.V3> ret = new ArrayList<CommonProxy.V3>();
        for (CommonProxy.V3 v3 : this.blockSpecial) {
            if (v3.meta != meta) continue;
            ret.add(v3);
        }
        return ret;
    }

    public void removeTennant(String tennant) {
        for (int t = 0; t < this.tennants.size(); ++t) {
            String ten = this.tennants.get(t);
            if (!ten.contentEquals(tennant)) continue;
            this.tennants.remove(t);
            break;
        }
    }

    private void loadStructure() {
        try {
            if (this.requirements != null) {
                this.requirements.clear();
            } else {
                this.requirements = new HashMap();
            }
            this.displayNameWithoutPK = this.displayName;
            if (this.displayName.startsWith("PKID")) {
                int hyphen = this.displayName.indexOf("-");
                this.pk = this.displayName.substring(4, hyphen);
                this.displayNameWithoutPK = this.displayName.substring(hyphen + 1);
            }
            this.blocksInBuilding = 0;
            File f = new File(SimukraftReloaded.getSimukraftFolder() + "/buildings/" + this.type + "/" + this.displayName + ".txt");
            if (!f.exists()) {
                return;
            }
            FileInputStream fstream = new FileInputStream(SimukraftReloaded.getSimukraftFolder() + "/buildings/" + this.type + "/" + this.displayName + ".txt");
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine = br.readLine().toString().toLowerCase().trim();
            String[] d = strLine.split("x");
            int[] di = new int[]{0, 0, 0};
            di[0] = Integer.parseInt(d[0]);
            di[1] = Integer.parseInt(d[1]);
            di[2] = Integer.parseInt(d[2]);
            this.structure = new String[di[0] * di[1] * di[2]];
            this.ltrCount = di[0];
            this.ftbCount = di[1];
            this.layerCount = di[2];
            this.dimensions = d[0] + "x" + d[1] + "x" + d[2];
            strLine = br.readLine().toString().trim();
            HashMap<String, String> thekey = new HashMap<String, String>();
            d = strLine.split(";");
            for (int i = 0; i < d.length; ++i) {
                String[] k = d[i].split("=");
                thekey.put(k[0], k[1]);
                if (k[0].toUpperCase().contentEquals("AU")) {
                    this.author = k[1].trim();
                    continue;
                }
                if (k[0].toUpperCase().contentEquals("DESC")) {
                    this.description = k[1];
                    continue;
                }
                if (k[0].toUpperCase().contentEquals("ELEV")) {
                    this.description = k[1];
                    continue;
                }
                if (!k[0].toUpperCase().contentEquals("INFREQ")) continue;
                if (k[1].toLowerCase().contentEquals("water")) {
                    this.infrastructureRequirement = new InfrastructureWater();
                }
                if (!k[1].toLowerCase().contentEquals("electricity")) continue;
                this.infrastructureRequirement = new InfrastructureElectricity();
            }
            int acount = 0;
            int bcount = 0;
            for (int i = 0; i < this.layerCount; ++i) {
                strLine = br.readLine().trim();
                bcount = 0;
                for (int ftb = 0; ftb < this.ftbCount; ++ftb) {
                    for (int ltr = 0; ltr < this.ltrCount; ++ltr) {
                        try {
                            String ch = strLine.substring(bcount, bcount + 1);
                            char cha = ch.charAt(0);
                            if (ch.contentEquals("!")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.livingBlock) + ":0";
                            } else if (ch.contentEquals("$")) {
                                this.structure[acount] = "" + Block.func_149682_b((Block)SimukraftReloadedBlocks.controlBox) + ":0";
                            } else if (ch.contentEquals("*")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.lightBox) + ":0";
                            } else if (ch.contentEquals("+")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.lightBox) + ":3";
                            } else if (ch.contentEquals("-")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.lightBox) + ":5";
                            } else if (ch.contentEquals("0")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.specialBlock) + ":0";
                            } else if (ch.contentEquals("1")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.specialBlock) + ":1";
                            } else if (ch.contentEquals("2")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.specialBlock) + ":2";
                            } else if (ch.contentEquals("3")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.specialBlock) + ":3";
                            } else if (ch.contentEquals("4")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.specialBlock) + ":4";
                            } else if (ch.contentEquals("5")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.specialBlock) + ":5";
                            } else if (ch.contentEquals("6")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.specialBlock) + ":6";
                            } else if (ch.contentEquals("7")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.specialBlock) + ":7";
                            } else if (ch.contentEquals("8")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.specialBlock) + ":8";
                            } else if (cha >= '0' && cha <= '9') {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.specialBlock) + ":" + cha;
                            } else if (ch.contentEquals("\u00c3\u20ac")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.lightBox) + ":0";
                            } else if (ch.contentEquals("\u00c3\u2020")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.lightBox) + ":1";
                            } else if (ch.contentEquals("\u00c3\u2021")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.lightBox) + ":2";
                            } else if (ch.contentEquals("\u00c3\u02c6")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.lightBox) + ":3";
                            } else if (ch.contentEquals("\u00c3\u0152")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.lightBox) + ":4";
                            } else if (ch.contentEquals("\u00c3\ufffd")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.lightBox) + ":5";
                            } else if (ch.contentEquals("\u00c3\u2018")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.lightBox) + ":6";
                            } else if (ch.contentEquals("\u00c3\u2019")) {
                                this.structure[acount] = Block.func_149682_b((Block)SimukraftReloadedBlocks.lightBox) + ":7";
                            } else {
                                this.structure[acount] = (String)thekey.get(ch);
                                String[] sbid = this.structure[acount].split(":");
                                int bid = Integer.parseInt(sbid[0]);
                                this.addToRequirements(Block.func_149729_e((int)bid), 1);
                            }
                            ++acount;
                            ++bcount;
                            if (ch.contentEquals("A")) continue;
                            ++this.blocksInBuilding;
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            br.close();
            in.close();
            this.rent = Float.valueOf((float)this.blocksInBuilding * 0.01f);
        }
        catch (Exception e) {
            SimukraftReloaded.log.warning("Building loadStructure() " + e.toString());
        }
    }

    private void addToRequirements(Block block, int amount) {
        int val = 0;
        ItemStack theBlock = new ItemStack(block, 1, 0);
        if (GameMode.gameMode == GameMode.GAMEMODES.NORMAL) {
            String name = "";
            try {
                name = theBlock.func_82833_r().toLowerCase();
            }
            catch (Exception e) {
                name = "????";
            }
            if (name.contains("planks") || name.contentEquals("cobblestone") || name.contentEquals("glass") || name.contains("wool") || name.contentEquals("bricks") || name.contentEquals("dirt") || name.contentEquals("stone bricks") || name.contentEquals("fence") || name.contentEquals("stone") || name.contains("wood") && !name.contains("slab") && !name.contains("door") && !name.contains("stairs") && !name.contains("grass")) {
                Iterator<Map.Entry<ItemStack, Integer>> it = this.requirements.entrySet().iterator();
                boolean got = false;
                while (it.hasNext()) {
                    Map.Entry<ItemStack, Integer> pairs = it.next();
                    ItemStack is = pairs.getKey();
                    if (is.func_77973_b() != theBlock.func_77973_b()) continue;
                    val = pairs.getValue();
                    pairs.setValue(++val);
                    got = true;
                    break;
                }
                if (!got) {
                    this.requirements.put(theBlock, 1);
                }
            }
        } else {
            if (GameMode.gameMode == GameMode.GAMEMODES.CREATIVE) {
                return;
            }
            if (GameMode.gameMode == GameMode.GAMEMODES.HARDCORE) {
                String name = "";
                try {
                    name = theBlock.func_82833_r().toLowerCase();
                }
                catch (Exception e) {
                    name = "????";
                }
                if (!name.contains("grass") && !name.contains("bed")) {
                    Iterator<Map.Entry<ItemStack, Integer>> it = this.requirements.entrySet().iterator();
                    boolean got = false;
                    while (it.hasNext()) {
                        Map.Entry<ItemStack, Integer> pairs = it.next();
                        ItemStack is = pairs.getKey();
                        if (is.func_77973_b() != theBlock.func_77973_b()) continue;
                        val = pairs.getValue();
                        pairs.setValue(++val);
                        got = true;
                        break;
                    }
                    if (!got) {
                        this.requirements.put(theBlock, 1);
                    }
                }
            }
        }
    }

    private static void copyArrayList(ArrayList<Building> from, ArrayList<Building> to) {
        for (int i = 0; i < from.size(); ++i) {
            to.add(from.get(i));
        }
    }

    public static ArrayList<Building> getBuildingBlueprints(String theType, String searchWords) {
        ArrayList<Building> retBuildings;
        block23: {
            retBuildings = new ArrayList<Building>();
            try {
                int sizesearch = 0;
                if (theType.contentEquals("residential")) {
                    Building.copyArrayList(buildingsRes, retBuildings);
                } else if (theType.contentEquals("commercial")) {
                    Building.copyArrayList(buildingsCom, retBuildings);
                } else if (theType.contentEquals("industrial")) {
                    Building.copyArrayList(buildingsInd, retBuildings);
                } else if (theType.contentEquals("other")) {
                    Building.copyArrayList(buildingsOth, retBuildings);
                } else if (theType.contentEquals("special")) {
                    Building.copyArrayList(buildingsSpec, retBuildings);
                }
                if (searchWords.contentEquals("")) break block23;
                try {
                    sizesearch = Integer.parseInt(searchWords.substring(2));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (searchWords.startsWith("w:")) {
                    for (int i = retBuildings.size() - 1; i >= 0; --i) {
                        Building build = retBuildings.get(i);
                        if (build.ltrCount == sizesearch) continue;
                        retBuildings.remove(i);
                    }
                } else if (searchWords.startsWith("d:")) {
                    for (int i = retBuildings.size() - 1; i >= 0; --i) {
                        Building build = retBuildings.get(i);
                        if (build.ftbCount == sizesearch) continue;
                        retBuildings.remove(i);
                    }
                } else if (searchWords.startsWith("h:")) {
                    for (int i = retBuildings.size() - 1; i >= 0; --i) {
                        Building build = retBuildings.get(i);
                        if (build.layerCount == sizesearch) continue;
                        retBuildings.remove(i);
                    }
                } else {
                    for (int i = retBuildings.size() - 1; i >= 0; --i) {
                        Building build = retBuildings.get(i);
                        if (build.displayName.toLowerCase().contains(searchWords.toLowerCase())) continue;
                        retBuildings.remove(i);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retBuildings;
    }

    public static Building getBuilding(CommonProxy.V3 primaryXYZ) {
        Building b = null;
        if (SimukraftReloaded.theBuildings.size() == 0) {
            Building.loadAllBuildings();
        }
        for (int x = 0; x < SimukraftReloaded.theBuildings.size(); ++x) {
            try {
                b = SimukraftReloaded.theBuildings.get(x);
                if (!b.primaryXYZ.isSameCoordsAs(primaryXYZ, false, true)) continue;
                return b;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Building getBuildingBySearch(String searchWord) {
        Building b = null;
        for (int x = 0; x < SimukraftReloaded.theBuildings.size(); ++x) {
            b = SimukraftReloaded.theBuildings.get(x);
            if (!b.displayName.contains(searchWord)) continue;
            return b;
        }
        return null;
    }

    public static ArrayList<Building> getBuildingBySearch(String searchWord, boolean findAll) {
        ArrayList<Building> ret = new ArrayList<Building>();
        for (int x = 0; x < SimukraftReloaded.theBuildings.size(); ++x) {
            Building b = SimukraftReloaded.theBuildings.get(x);
            if (!b.displayName.toLowerCase().contains(searchWord.toLowerCase())) continue;
            ret.add(b);
        }
        return ret;
    }

    public static Building getBuildingByConBox(CommonProxy.V3 conBoxLoc) {
        Building b = null;
        for (int x = 0; x < SimukraftReloaded.theBuildings.size(); ++x) {
            b = SimukraftReloaded.theBuildings.get(x);
            try {
                if (!b.conBoxLocation.isSameCoordsAs(conBoxLoc, true, true)) continue;
                return b;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void saveThisBuilding() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.clear();
        if (this.primaryXYZ != null) {
            String xyz = "b" + this.primaryXYZ.toString().replaceAll(",", "_");
            strings.add("displayname|" + this.displayName);
            strings.add("type|" + this.type);
            strings.add("primaryxyz|" + this.primaryXYZ.toString());
            if (this.livingXYZ == null) {
                strings.add("livingxyz|null");
            } else {
                strings.add("livingxyz|" + this.livingXYZ.toString());
            }
            strings.add("buildingcomplete|" + this.buildingComplete);
            strings.add("capacity|" + this.capacity);
            strings.add("builddir|" + this.buildDirection);
            if (this.lumbermillMarker == null) {
                strings.add("lmarker|null");
            } else {
                strings.add("lmarker|" + this.lumbermillMarker.toString());
            }
            strings.add("blocksinbuilding|" + this.blocksInBuilding);
            String temp = "tennants|";
            for (String tennant : this.tennants) {
                if (tennant.trim().contentEquals("")) continue;
                temp = temp + tennant.trim() + ",";
            }
            strings.add(temp);
            temp = "blocklocs|";
            for (CommonProxy.V3 block : this.blockLocations) {
                if (!(block != null & block.toString().contains(","))) continue;
                temp = temp + block.toString() + "B";
            }
            strings.add(temp);
            if (this.blockSpecial.size() > 0) {
                temp = "blockspecial|";
                for (CommonProxy.V3 block : this.blockSpecial) {
                    if (!(block != null & block.toString().contains(","))) continue;
                    temp = temp + block.toString() + "," + block.meta + "B";
                }
                strings.add(temp);
            }
            SimukraftReloaded.saveSK2(SimukraftReloaded.getSavesDataFolder() + "Buildings" + File.separator + xyz + ".sk2", strings);
        }
    }

    public static void saveAllBuildings() {
        Minecraft mc = Minecraft.func_71410_x();
        ArrayList<String> strings = new ArrayList<String>();
        for (int b = 0; b < SimukraftReloaded.theBuildings.size(); ++b) {
            strings.clear();
            Building building = SimukraftReloaded.theBuildings.get(b);
            if (building == null || building.primaryXYZ == null) continue;
            CommonProxy.V3 pxyz = building.primaryXYZ;
            WorldServer buildingWorld = MinecraftServer.func_71276_C().func_71218_a(building.primaryXYZ.theDimension);
            Block id = buildingWorld.func_147439_a(pxyz.x.intValue(), pxyz.y.intValue(), pxyz.z.intValue());
            String xyz = "b" + building.primaryXYZ.toString().replaceAll(",", "_");
            if (id == SimukraftReloadedBlocks.controlBox || id == SimukraftReloadedBlocks.buildingConstructor) {
                strings.add("displayname|" + building.displayName);
                strings.add("type|" + building.type);
                strings.add("primaryxyz|" + building.primaryXYZ.toString());
                if (building.livingXYZ == null) {
                    strings.add("livingxyz|null");
                } else {
                    strings.add("livingxyz|" + building.livingXYZ.toString());
                }
                strings.add("buildingcomplete|" + building.buildingComplete);
                strings.add("capacity|" + building.capacity);
                strings.add("builddir|" + building.buildDirection);
                if (building.lumbermillMarker == null) {
                    strings.add("lmarker|null");
                } else {
                    strings.add("lmarker|" + building.lumbermillMarker.toString());
                }
                strings.add("blocksinbuilding|" + building.blocksInBuilding);
                String temp = "tennants|";
                for (String tennant : building.tennants) {
                    if (tennant.trim().contentEquals("")) continue;
                    temp = temp + tennant.trim() + ",";
                }
                strings.add(temp);
                try {
                    temp = "blocklocs|";
                    for (CommonProxy.V3 block : building.blockLocations) {
                        if (!(block != null & block.toString().contains(","))) continue;
                        temp = temp + block.toString() + "B";
                    }
                    strings.add(temp);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (building.blockSpecial.size() > 0) {
                        temp = "blockspecial|";
                        for (CommonProxy.V3 block : building.blockSpecial) {
                            if (!(block != null & block.toString().contains(","))) continue;
                            temp = temp + block.toString() + "," + block.meta + "B";
                        }
                        strings.add(temp);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                SimukraftReloaded.saveSK2(SimukraftReloaded.getSavesDataFolder() + "Buildings" + File.separator + xyz + ".sk2", strings);
                continue;
            }
            File f = new File(SimukraftReloaded.getSavesDataFolder() + "Buildings" + File.separator + xyz + ".sk2");
            if (!f.exists()) continue;
            f.delete();
        }
        SimukraftReloaded.log.info("Building.saveAllBuildings " + SimukraftReloaded.theBuildings.size() + " buildings");
    }

    public static void loadAllBuildings() {
        File buildingsFolder = new File(SimukraftReloaded.getSavesDataFolder() + "Buildings" + File.separator);
        buildingsFolder.mkdirs();
        boolean useNewFormat = false;
        for (File f : buildingsFolder.listFiles()) {
            if (!f.getName().endsWith(".sk2")) continue;
            useNewFormat = true;
            break;
        }
        if (useNewFormat) {
            SimukraftReloaded.theBuildings.clear();
            for (File f : buildingsFolder.listFiles()) {
                if (!f.getName().endsWith(".sk2")) continue;
                ArrayList<String> strings = SimukraftReloaded.loadSK2(f.getAbsoluteFile().toString());
                Building build = new Building();
                for (String line : strings) {
                    String[] blocks;
                    if (!line.contains("|")) continue;
                    int m1 = line.indexOf("|");
                    String name = line.substring(0, m1);
                    String value = line.substring(m1 + 1);
                    if (name.contentEquals("displayname")) {
                        build.displayName = value;
                        continue;
                    }
                    if (name.contentEquals("type")) {
                        build.type = value;
                        continue;
                    }
                    if (name.contentEquals("primaryxyz")) {
                        build.primaryXYZ = new CommonProxy.V3(value);
                        continue;
                    }
                    if (name.contentEquals("livingxyz")) {
                        if (value.contentEquals("null")) continue;
                        build.livingXYZ = new CommonProxy.V3(value);
                        continue;
                    }
                    if (name.contentEquals("buildingcomplete")) {
                        build.buildingComplete = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (name.contentEquals("capacity")) {
                        build.capacity = Integer.parseInt(value);
                        continue;
                    }
                    if (name.contentEquals("builddir")) {
                        build.buildDirection = value;
                        continue;
                    }
                    if (name.contentEquals("lmarker")) {
                        if (value.contentEquals("null")) continue;
                        build.lumbermillMarker = new CommonProxy.V3(value);
                        continue;
                    }
                    if (name.contentEquals("blocksinbuilding")) {
                        build.blocksInBuilding = Integer.parseInt(value);
                        continue;
                    }
                    if (name.contentEquals("tennants")) {
                        String[] tennants;
                        if (value.trim().contentEquals("")) {
                            build.tennants.clear();
                            continue;
                        }
                        for (String tennant : tennants = value.split(",")) {
                            if (tennant.trim().contentEquals("")) continue;
                            build.tennants.add(tennant);
                        }
                        continue;
                    }
                    if (name.contentEquals("blocklocs")) {
                        if (!value.contains("B") || !value.contains(",")) continue;
                        for (String block : blocks = value.split("B")) {
                            if (!block.contains(",")) continue;
                            build.blockLocations.add(new CommonProxy.V3(block));
                        }
                        continue;
                    }
                    if (!name.contentEquals("blockspecial") || !value.contains("B") || !value.contains(",")) continue;
                    for (String block : blocks = value.split("B")) {
                        if (!block.contains(",")) continue;
                        int p1 = block.lastIndexOf(",");
                        String v = block.substring(0, p1);
                        String meta = block.substring(p1 + 1);
                        CommonProxy.V3 v3 = new CommonProxy.V3(v);
                        v3.meta = Integer.parseInt(meta);
                        build.blockSpecial.add(v3);
                    }
                }
                build.loadStructure();
                SimukraftReloaded.theBuildings.add(build);
            }
        } else {
            Minecraft mc = Minecraft.func_71410_x();
            SimukraftReloaded.theBuildings.clear();
            for (File f : buildingsFolder.listFiles()) {
                Building building;
                if (!f.getName().endsWith(".suk") || (building = (Building)ModSimukraft.proxy.loadObject(f.getAbsoluteFile().toString())) == null) continue;
                CommonProxy.V3 xyz = building.primaryXYZ;
                WorldServer buildingWorld = MinecraftServer.func_71276_C().func_71218_a(building.primaryXYZ.theDimension);
                Block id = buildingWorld.func_147439_a(xyz.x.intValue(), xyz.y.intValue(), xyz.z.intValue());
                Building dupe = null;
                if (SimukraftReloaded.theBuildings.size() > 0) {
                    dupe = Building.getBuilding(xyz);
                }
                if (id == SimukraftReloadedBlocks.controlBox && dupe == null) {
                    building.loadStructure();
                    SimukraftReloaded.theBuildings.add(building);
                    continue;
                }
                f.delete();
                SimukraftReloaded.log.info("Building: Deleted building as id=" + id + " or dupe");
            }
        }
    }

    public static void checkTennants() {
        for (int b = 0; b < SimukraftReloaded.theBuildings.size(); ++b) {
            Building building = SimukraftReloaded.theBuildings.get(b);
            for (int t = 0; t < building.tennants.size(); ++t) {
                try {
                    String tennant = building.tennants.get(t);
                    boolean exists = false;
                    for (int f = 0; f < SimukraftReloaded.theFolks.size(); ++f) {
                        FolkData folk = SimukraftReloaded.theFolks.get(f);
                        if (!folk.name.contentEquals(tennant)) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    building.tennants.remove(tennant);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void initialiseAllBuildings() {
        if (runningInitThread) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                runningInitThread = true;
                buildingsRes.clear();
                buildingsCom.clear();
                buildingsInd.clear();
                buildingsOth.clear();
                buildingsSpec.clear();
                Building.initBuildingsOfType("residential");
                Building.initBuildingsOfType("commercial");
                Building.initBuildingsOfType("industrial");
                Building.initBuildingsOfType("other");
                Building.initBuildingsOfType("special");
                runningInitThread = false;
                SimukraftReloaded.log.info("Building: Thread Done Initialising all buildings from disk");
            }
        });
        t.start();
    }

    public static Building getBuildingForFolk(String partialFilename, String type) {
        File f = new File(SimukraftReloaded.getSimukraftFolder() + "/buildings/" + type + "/" + partialFilename);
        if (f.exists()) {
            String name = f.getName().substring(0, f.getName().length() - 4);
            Building build = new Building(name, type);
            build.loadStructure();
            return build;
        }
        return null;
    }

    private static void initBuildingsOfType(String type) {
        File f = new File(SimukraftReloaded.getSimukraftFolder() + "/buildings/" + type);
        for (int i = 0; i < f.list().length; ++i) {
            String name = f.list()[i];
            name = name.substring(0, name.length() - 4);
            Building build = new Building(name, type);
            build.loadStructure();
            if (type.contentEquals("residential")) {
                buildingsRes.add(build);
            } else if (type.contentEquals("commercial")) {
                buildingsCom.add(build);
            } else if (type.contentEquals("industrial")) {
                buildingsInd.add(build);
            } else if (type.contentEquals("other")) {
                buildingsOth.add(build);
            } else if (type.contentEquals("special")) {
                buildingsSpec.add(build);
            }
            try {
                Thread.sleep(30L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static Building getFromAllBuildings(String fullname, String type) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (!type.contentEquals("residential")) break block5;
                            for (Building build : buildingsRes) {
                                if (!build.displayName.contentEquals(fullname)) continue;
                                return build.clone();
                            }
                            break block6;
                        }
                        if (!type.contentEquals("commercial")) break block7;
                        for (Building build : buildingsCom) {
                            if (!build.displayName.contentEquals(fullname)) continue;
                            return build.clone();
                        }
                        break block6;
                    }
                    if (!type.contentEquals("industrial")) break block8;
                    for (Building build : buildingsInd) {
                        if (!build.displayName.contentEquals(fullname)) continue;
                        return build.clone();
                    }
                    break block6;
                }
                if (!type.contentEquals("other")) break block9;
                for (Building build : buildingsOth) {
                    if (!build.displayName.contentEquals(fullname)) continue;
                    return build.clone();
                }
                break block6;
            }
            if (!type.contentEquals("special")) break block6;
            for (Building build : buildingsSpec) {
                if (!build.displayName.contentEquals(fullname)) continue;
                return build.clone();
            }
        }
        return null;
    }
}

