/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.game.GameMode;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobTerraformer
extends Job {
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient TerraformerType theType;
    private transient int radius;
    private transient ArrayList<IInventory> constructorChests = new ArrayList();
    private transient int totalBlockCount = 0;
    private transient int counter = 0;
    private transient int buckets = 0;

    public JobTerraformer() {
    }

    public JobTerraformer(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
        this.theFolk.isWorking = false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.WAITINGFORRESOURCES) {
            this.runDelay = 4000;
        }
        if (this.theStage == Stage.INPROGRESS) {
            this.runDelay = GameMode.gameMode == GameMode.GAMEMODES.CREATIVE ? 1 : 300;
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.WAITINGFORRESOURCES) {
                this.stageWaitingForResources();
            } else if (this.theStage == Stage.INPROGRESS) {
                this.stageInProgress();
            } else if (this.theStage == Stage.COMPLETE) {
                this.stageComplete();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void stageWaitingForResources() {
        this.theFolk.isWorking = false;
        this.theFolk.statusText = "\u68c0\u67e5\u89c4\u5212\u8d44\u6e90...";
        this.constructorChests = JobTerraformer.inventoriesFindClosest(this.theFolk.employedAt, 5);
        if (this.step == 1) {
            if (this.constructorChests.isEmpty()) {
                this.theFolk.statusText = "\u81f3\u5c11\u9644\u8fd1\u6709\u4e00\u4e2a\u7684\u5efa\u7b51\u76d2";
                return;
            }
            this.theType = this.theFolk.terraformerType;
            this.radius = this.theFolk.terraformerRadius;
            if (this.theType == null) {
                this.step = 4;
                return;
            }
            this.step = 2;
            this.constructorChests.get(0).func_70295_k_();
            return;
        }
        if (this.step == 2) {
            this.constructorChests.get(0).func_70305_f();
            this.theStage = Stage.INPROGRESS;
            this.step = 1;
            return;
        }
        if (this.step != 3) {
            if (this.step != 4) return;
            this.theFolk.statusText = "\u8bf7\u9009\u62e9\u4e00\u4e2a\u89c4\u5212\u9009\u9879";
            this.step = 1;
            return;
        }
        if (this.vocation == Job.Vocation.TERRAFORMER) {
            this.step = 4;
            this.theStage = Stage.INPROGRESS;
            return;
        }
        this.theFolk.selfFire();
    }

    private void stageInProgress() {
        this.theFolk.isWorking = true;
        Random rand = new Random();
        boolean hasPlacedTree = false;
        ItemStack is = null;
        this.constructorChests = JobTerraformer.inventoriesFindClosest(this.theFolk.employedAt, 5);
        if (this.step == 1) {
            if (this.theType == TerraformerType.WATERTODIRT) {
                ArrayList<Block> blockIDs = new ArrayList<Block>();
                blockIDs.add(Blocks.field_150355_j);
                blockIDs.add(Blocks.field_150355_j);
                this.closestBlocks = null;
                this.setClosestBlocksOfType(this.theFolk.employedAt, blockIDs, this.radius, false, true, false);
            } else if (this.theType == TerraformerType.NATURE) {
                ArrayList<Block> blockIDs = new ArrayList<Block>();
                blockIDs.add(Blocks.field_150346_d);
                blockIDs.add((Block)Blocks.field_150349_c);
                this.closestBlocks = null;
                this.setClosestBlocksOfType(this.theFolk.employedAt, blockIDs, this.radius, true, true, false);
            } else if (this.theType == TerraformerType.LAWNMOWER) {
                ArrayList<Block> blockIDs = new ArrayList<Block>();
                blockIDs.add((Block)Blocks.field_150329_H);
                blockIDs.add((Block)Blocks.field_150328_O);
                blockIDs.add((Block)Blocks.field_150327_N);
                this.closestBlocks = null;
                this.setClosestBlocksOfType(this.theFolk.employedAt, blockIDs, this.radius, false, true, false);
            } else if (this.theType == TerraformerType.FLATTENIZER) {
                ArrayList<Block> blockIDs = new ArrayList<Block>();
                blockIDs.add((Block)Blocks.field_150349_c);
                blockIDs.add(Blocks.field_150346_d);
                blockIDs.add((Block)Blocks.field_150329_H);
                blockIDs.add(Blocks.field_150348_b);
                blockIDs.add((Block)Blocks.field_150354_m);
                blockIDs.add(Blocks.field_150322_A);
                blockIDs.add(Blocks.field_150351_n);
                this.closestBlocks = null;
                this.setClosestBlocksOfType(this.theFolk.employedAt, blockIDs, this.radius, false, false, false);
            } else if (this.theType == TerraformerType.VALUEPACK) {
                ArrayList<Block> blockIDs = new ArrayList<Block>();
                blockIDs.add(Blocks.field_150350_a);
                blockIDs.add((Block)Blocks.field_150329_H);
                blockIDs.add((Block)Blocks.field_150328_O);
                blockIDs.add((Block)Blocks.field_150327_N);
                CommonProxy.V3 v = new CommonProxy.V3(this.theFolk.employedAt.x, this.theFolk.employedAt.y - 1.0, this.theFolk.employedAt.z, this.theFolk.employedAt.theDimension);
                this.closestBlocks = null;
                this.setClosestBlocksOfType(v, blockIDs, this.radius, false, true, true);
            } else if (this.theType == TerraformerType.GLACIAL) {
                ArrayList<Block> blockIDs = new ArrayList<Block>();
                blockIDs.add(Blocks.field_150350_a);
                blockIDs.add((Block)Blocks.field_150329_H);
                blockIDs.add(Blocks.field_150355_j);
                blockIDs.add(Blocks.field_150355_j);
                CommonProxy.V3 v = new CommonProxy.V3(this.theFolk.employedAt.x, this.theFolk.employedAt.y, this.theFolk.employedAt.z, this.theFolk.employedAt.theDimension);
                this.closestBlocks = null;
                this.setClosestBlocksOfType(v, blockIDs, this.radius, true, true, false);
            } else if (this.theType == TerraformerType.MOISTURIZER) {
                ArrayList<Block> blockIDs = new ArrayList<Block>();
                blockIDs.add(Blocks.field_150353_l);
                blockIDs.add(Blocks.field_150353_l);
                CommonProxy.V3 v = new CommonProxy.V3(this.theFolk.employedAt.x, this.theFolk.employedAt.y, this.theFolk.employedAt.z, this.theFolk.employedAt.theDimension);
                this.closestBlocks = null;
                this.setClosestBlocksOfType(v, blockIDs, this.radius, false, true, false);
            } else if (this.theType == TerraformerType.THERMALIZER) {
                ArrayList<Block> blockIDs = new ArrayList<Block>();
                blockIDs.add(Blocks.field_150353_l);
                CommonProxy.V3 v = new CommonProxy.V3(this.theFolk.employedAt.x, this.theFolk.employedAt.y, this.theFolk.employedAt.z, this.theFolk.employedAt.theDimension);
                this.closestBlocks = null;
                this.setClosestBlocksOfType(v, blockIDs, this.radius, false, true, false);
            } else if (this.theType == TerraformerType.DEICER) {
                ArrayList<Block> blockIDs = new ArrayList<Block>();
                blockIDs.add(Blocks.field_150433_aE);
                CommonProxy.V3 v = new CommonProxy.V3(this.theFolk.employedAt.x, this.theFolk.employedAt.y, this.theFolk.employedAt.z, this.theFolk.employedAt.theDimension);
                this.closestBlocks = null;
                this.setClosestBlocksOfType(v, blockIDs, this.radius, false, true, false);
            }
            this.step = 2;
        } else if (this.step == 2) {
            this.theFolk.statusText = "\u626b\u63cf\u5730\u5f62...";
        } else if (this.step == 3) {
            this.totalBlockCount = this.closestBlocks.size();
            if (this.totalBlockCount == 0) {
                this.theFolk.statusText = "\u9519\u8bef\u7684\u89c4\u5212 \uff01";
                SimukraftReloaded.sendChat("\u8fd9\u91cc\u6ca1\u6709\u4ec0\u4e48\u533a\u57df\u53ef\u4ee5\u4ee5\u8fd9\u4e2a\u65b9\u5f0f\u89c4\u5212");
                this.theFolk.selfFire();
                return;
            }
            this.step = 4;
            this.theFolk.statusText = "\u542f\u52a8\u89c4\u5212\u8fc7\u7a0b\u4e2d...";
        } else if (this.step == 4) {
            block92: {
                ItemStack gotDirt;
                boolean count = false;
                if (this.theType == TerraformerType.WATERTODIRT) {
                    if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (gotDirt = JobTerraformer.inventoriesGet(this.constructorChests, new ItemStack(Blocks.field_150346_d, 1), false, false)) == null) {
                        this.theFolk.statusText = "\u6211\u9700\u8981\u66f4\u591a\u7684\u6ce5\u571f\uff01";
                        this.theStage = Stage.WAITINGFORRESOURCES;
                        this.step = 1;
                        return;
                    }
                } else if (this.theType == TerraformerType.NATURE) {
                    ++this.counter;
                    hasPlacedTree = false;
                    if (this.counter % 15 == 0) {
                        hasPlacedTree = true;
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                            is = JobTerraformer.inventoriesGet(this.constructorChests, null, true, false);
                            if (is == null) {
                                this.theFolk.statusText = "\u8bf7\u63d0\u4f9b\u66f4\u591a\u7684\u5c0f\u6811\u82d7";
                                this.theStage = Stage.WAITINGFORRESOURCES;
                                this.step = 1;
                                return;
                            }
                        } else {
                            is = new ItemStack(Blocks.field_150345_g, 1, new Random().nextInt(4));
                        }
                    }
                } else if (this.theType != TerraformerType.LAWNMOWER && this.theType != TerraformerType.DEICER && this.theType != TerraformerType.FLATTENIZER) {
                    ItemStack gotStuff;
                    if (this.theType == TerraformerType.VALUEPACK) {
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (gotDirt = JobTerraformer.inventoriesGet(this.constructorChests, new ItemStack(Blocks.field_150346_d, 1), false, false)) == null) {
                            this.theFolk.statusText = "\u6211\u9700\u8981\u66f4\u591a\u7684\u6ce5\u571f\uff01";
                            this.theStage = Stage.WAITINGFORRESOURCES;
                            this.step = 1;
                            return;
                        }
                    } else if (this.theType == TerraformerType.GLACIAL || this.theType == TerraformerType.MOISTURIZER) {
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                            if (this.buckets == 0) {
                                gotDirt = JobTerraformer.inventoriesGet(this.constructorChests, new ItemStack(Items.field_151131_as, 1), false, false);
                                if (gotDirt == null) {
                                    this.theFolk.statusText = "\u9700\u8981\u4e00\u6876\u6c34";
                                    this.theStage = Stage.WAITINGFORRESOURCES;
                                    this.step = 1;
                                    return;
                                }
                                this.inventoriesPut(this.constructorChests, new ItemStack(Items.field_151133_ar, 1), true);
                                this.buckets = 1000;
                            } else {
                                --this.buckets;
                            }
                        }
                    } else if (this.theType == TerraformerType.THERMALIZER && GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (gotStuff = JobTerraformer.inventoriesGet(this.constructorChests, new ItemStack(Items.field_151133_ar, 1), false, false)) == null) {
                        this.theFolk.statusText = "\u6211\u9700\u8981\u4e00\u4e9b\u7a7a\u6876\u88c5\u7194\u5ca9\u3002";
                        this.theStage = Stage.WAITINGFORRESOURCES;
                        this.step = 1;
                        return;
                    }
                }
                Double x = this.totalBlockCount;
                Double y = this.closestBlocks.size();
                Double percent = (x - y) / x;
                percent = percent * 100.0;
                this.theFolk.statusText = "\u89c4\u5212," + percent.intValue() + " % complete";
                CommonProxy.V3 v = (CommonProxy.V3)this.closestBlocks.get(0);
                if (this.theType == TerraformerType.WATERTODIRT) {
                    this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150346_d, 0, 3);
                    if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                        SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.009);
                    }
                } else if (this.theType == TerraformerType.NATURE) {
                    if (hasPlacedTree) {
                        this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue() + 1, v.z.intValue(), Blocks.field_150345_g, is.func_77960_j(), 3);
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                            SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.009);
                        }
                        this.runDelay = 500;
                    } else {
                        int r = rand.nextInt(10);
                        if (r == 2) {
                            this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue() + 1, v.z.intValue(), (Block)Blocks.field_150328_O, 0, 3);
                            this.jobWorld.func_147471_g(v.x.intValue(), v.y.intValue() + 1, v.z.intValue());
                        } else if (r == 5) {
                            this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue() + 1, v.z.intValue(), (Block)Blocks.field_150327_N, 0, 3);
                        }
                        this.runDelay = 50;
                    }
                } else if (this.theType == TerraformerType.LAWNMOWER) {
                    ArrayList<ItemStack> minedStacks = this.translateBlockWhenMined(this.jobWorld, v);
                    if (minedStacks != null) {
                        for (int s = 0; s < minedStacks.size(); ++s) {
                            ItemStack stack = minedStacks.get(s);
                            if (stack == null) continue;
                            this.inventoriesPut(this.constructorChests, stack, false);
                        }
                    }
                    if (this.mc.field_71441_e.field_72995_K) {
                        this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150350_a, 0, 3);
                        SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.009);
                    }
                } else if (this.theType == TerraformerType.FLATTENIZER) {
                    ArrayList<ItemStack> minedStacks = this.translateBlockWhenMined(this.jobWorld, v);
                    if (minedStacks != null) {
                        for (int s = 0; s < minedStacks.size(); ++s) {
                            ItemStack stack = minedStacks.get(s);
                            if (stack == null) continue;
                            this.inventoriesPut(this.constructorChests, stack, false);
                        }
                    }
                    try {
                        if (!this.mc.field_71441_e.field_72995_K) break block92;
                        this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150350_a, 0, 3);
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                            SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.009);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (this.theType == TerraformerType.VALUEPACK) {
                    if (this.mc.field_71441_e.field_72995_K) {
                        this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150346_d, 0, 3);
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                            SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.009);
                        }
                    }
                } else if (this.theType == TerraformerType.GLACIAL) {
                    Block blockId = this.jobWorld.func_147439_a(v.x.intValue(), v.y.intValue(), v.z.intValue());
                    if (blockId == null || blockId == Blocks.field_150329_H) {
                        Block idBelow = this.jobWorld.func_147439_a(v.x.intValue(), v.y.intValue() - 1, v.z.intValue());
                        if (idBelow != null && idBelow != Blocks.field_150432_aD && idBelow != Blocks.field_150355_j && idBelow != Blocks.field_150355_j && idBelow != Blocks.field_150433_aE && this.mc.field_71441_e.field_72995_K) {
                            this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150433_aE, 0, 3);
                            if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                                SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.009);
                            }
                        }
                    } else if ((blockId == Blocks.field_150355_j || blockId == Blocks.field_150355_j) && this.mc.field_71441_e.field_72995_K) {
                        this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150432_aD, 0, 3);
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                            SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.009);
                        }
                    }
                } else if (this.theType == TerraformerType.MOISTURIZER) {
                    if (this.mc.field_71441_e.field_72995_K) {
                        this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150343_Z, 0, 3);
                        this.jobWorld.func_147471_g(v.x.intValue(), v.y.intValue(), v.z.intValue());
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                            SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.009);
                        }
                    }
                } else if (this.theType == TerraformerType.THERMALIZER) {
                    if (this.mc.field_71441_e.field_72995_K) {
                        this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150350_a, 0, 3);
                        this.jobWorld.func_147471_g(v.x.intValue(), v.y.intValue(), v.z.intValue());
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                            SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.009);
                        }
                        this.inventoriesPut(this.constructorChests, new ItemStack(Items.field_151129_at, 1), false);
                    }
                } else if (this.theType == TerraformerType.DEICER && this.mc.field_71441_e.field_72995_K) {
                    this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), (Block)Blocks.field_150349_c, 0, 3);
                    this.jobWorld.func_147471_g(v.x.intValue(), v.y.intValue(), v.z.intValue());
                    ++this.counter;
                    if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                        SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.009);
                    }
                    if (this.counter % 4 == 0) {
                        this.inventoriesPut(this.constructorChests, new ItemStack(Blocks.field_150433_aE, 1, 0), false);
                    }
                }
            }
            this.closestBlocks.remove(0);
            if (this.closestBlocks.size() == 0) {
                this.theStage = Stage.COMPLETE;
            }
        }
    }

    private void stageComplete() {
        this.theFolk.isWorking = false;
        SimukraftReloaded.sendChat(this.theFolk.name + " \u5df2\u5b8c\u6210\u5730\u5f62\u6539\u9020");
        this.mc.field_71441_e.func_72980_b(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u, this.mc.field_71439_g.field_70161_v, "ashjacksimukraftreloaded:cash", 1.0f, 1.0f, false);
        this.theFolk.stayPut = false;
        this.theFolk.terraformerRadius = 1;
        this.theFolk.terraformerType = null;
        this.theFolk.selfFire();
        this.theStage = Stage.IDLE;
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u62b5\u8fbe\u73b0\u573a";
            this.theStage = Stage.WAITINGFORRESOURCES;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    public static enum TerraformerType {
        WATERTODIRT,
        NATURE,
        LAWNMOWER,
        FLATTENIZER,
        VALUEPACK,
        GLACIAL,
        MOISTURIZER,
        THERMALIZER,
        DEICER;

    }

    public static enum Stage {
        IDLE,
        WAITINGFORRESOURCES,
        INPROGRESS,
        COMPLETE;

    }
}

