/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.io.Serializable;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;

public class JobSoldier
extends Job
implements Serializable {
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient Entity badGuy;
    private transient int count = 60;
    private transient long timeSinceLastBTB = 0L;
    public transient int kills = 0;
    Random rand = new Random();

    public JobSoldier() {
    }

    public JobSoldier(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage == Stage.IDLE) {
            this.theStage = Stage.ONPATROL;
            if (this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        } else if (this.theStage == Stage.ONPATROL) {
            this.stageOnPatrol();
        } else if (this.theStage == Stage.ATTACKING) {
            this.stageAttacking();
        }
    }

    private void stageOnPatrol() {
        this.theFolk.isWorking = false;
        this.theFolk.stayPut = false;
        this.theFolk.action = FolkData.FolkAction.ATWORK;
        this.theFolk.statusText = "Patroling town";
        this.runDelay = 10000;
        if (this.jobWorld == null) {
            this.jobWorld = MinecraftServer.func_71276_C().func_71218_a(this.theFolk.employedAt.theDimension);
        }
        if (System.currentTimeMillis() - this.timeSinceLastBTB > 120000L) {
            EntityPlayer player;
            if (this.theFolk.isSpawned() && (player = this.jobWorld.func_72977_a(this.theFolk.theEntity.field_70165_t, this.theFolk.theEntity.field_70163_u, this.theFolk.theEntity.field_70161_v, 50.0)) != null) {
                this.theFolk.gotoXYZ(new CommonProxy.V3(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_71093_bK), FolkData.GotoMethod.WALK);
            }
            this.timeSinceLastBTB = System.currentTimeMillis();
            this.runDelay = 60000;
        } else {
            int xo = this.rand.nextInt(60) - 30;
            int zo = this.rand.nextInt(60) - 30;
            CommonProxy.V3 wanderTo = new CommonProxy.V3(this.theFolk.location.x + (double)xo, this.theFolk.location.y - 1.0, this.theFolk.location.z + (double)zo, this.theFolk.location.theDimension);
            while (this.jobWorld.func_147439_a(wanderTo.x.intValue(), wanderTo.y.intValue(), wanderTo.z.intValue()) != null && wanderTo.y < 255.0) {
                CommonProxy.V3 v3 = wanderTo;
                Double d = v3.y;
                Double d2 = v3.y = Double.valueOf(v3.y + 1.0);
            }
            this.theFolk.gotoXYZ(wanderTo, FolkData.GotoMethod.WALK);
        }
        List list = this.jobWorld.func_72839_b((Entity)this.mc.field_71439_g, AxisAlignedBB.func_72330_a((double)this.theFolk.employedAt.x, (double)this.theFolk.employedAt.y, (double)this.theFolk.employedAt.z, (double)(this.theFolk.employedAt.x + 1.0), (double)(this.theFolk.employedAt.y + 1.0), (double)(this.theFolk.employedAt.z + 1.0)).func_72314_b(100.0, 5.0, 100.0));
        try {
            this.badGuy = this.findClosestHostileMob(list);
            if (this.badGuy != null) {
                this.runDelay = 1000;
                this.theStage = Stage.ATTACKING;
                this.count = 100;
                this.theFolk.statusText = "Going to attack a " + this.badGuy.getEntityData();
                if (this.theFolk.isSpawned()) {
                    this.theFolk.gotoXYZ(new CommonProxy.V3(this.badGuy.field_70165_t, this.badGuy.field_70163_u, this.badGuy.field_70161_v, this.theFolk.theEntity.field_71093_bK), FolkData.GotoMethod.WALK);
                } else {
                    this.theFolk.gotoXYZ(new CommonProxy.V3(this.badGuy.field_70165_t, this.badGuy.field_70163_u, this.badGuy.field_70161_v, this.theFolk.theEntity.field_71093_bK), FolkData.GotoMethod.SHIFT);
                }
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageAttacking() {
        try {
            this.runDelay = 200;
            if (this.theFolk.theEntity == null) {
                return;
            }
            this.theFolk.stayPut = false;
            int distance = (int)this.theFolk.theEntity.func_70032_d(this.badGuy);
            if (this.theFolk.destination == null) {
                if (this.theFolk.isSpawned()) {
                    this.theFolk.gotoXYZ(new CommonProxy.V3(this.badGuy.field_70165_t, this.badGuy.field_70163_u, this.badGuy.field_70161_v, this.theFolk.theEntity.field_71093_bK), FolkData.GotoMethod.WALK);
                } else {
                    this.theFolk.gotoXYZ(new CommonProxy.V3(this.badGuy.field_70165_t, this.badGuy.field_70163_u, this.badGuy.field_70161_v, this.theFolk.theEntity.field_71093_bK), FolkData.GotoMethod.SHIFT);
                }
            }
            distance = (int)this.theFolk.theEntity.func_70032_d(this.badGuy);
            --this.count;
            if (this.count <= 0) {
                this.theStage = Stage.ONPATROL;
            }
            if (distance > 5) {
                return;
            }
            distance = (int)this.theFolk.theEntity.func_70032_d(this.badGuy);
            if (distance < 4) {
                this.theFolk.isWorking = true;
                this.runDelay = 50;
                this.badGuy.func_70097_a(DamageSource.field_76377_j, 3.0f);
            }
            if (this.badGuy.field_70128_L) {
                this.theStage = Stage.ONPATROL;
                this.runDelay = (int)((11.0f - this.theFolk.levelSoldier) * 500.0f * (11.0f - this.theFolk.levelSoldier));
                ++this.kills;
                if (this.theFolk.levelSoldier < 10.0f) {
                    this.theFolk.levelSoldier += 0.03f;
                    if (this.theFolk.levelSoldier > 10.0f) {
                        this.theFolk.levelSoldier = 10.0f;
                    }
                }
                this.theFolk.statusText = "Killed " + this.badGuy.getEntityData();
                this.theFolk.isWorking = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private Entity findClosestHostileMob(List<Entity> mobs) {
        Entity closestBadGuy = null;
        int dist = 9999;
        if (!this.theFolk.isSpawned()) {
            return null;
        }
        for (int j = 0; j < mobs.size(); ++j) {
            PathEntity path;
            Entity entity1 = mobs.get(j);
            if (!(entity1 instanceof EntityMob) && !(entity1 instanceof IMob) || (path = this.jobWorld.func_72844_a((Entity)this.theFolk.theEntity, (int)entity1.field_70165_t, (int)entity1.field_70163_u, (int)entity1.field_70161_v, 40.0f, true, true, true, true)) == null) continue;
            closestBadGuy = entity1;
            break;
        }
        return closestBadGuy;
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "Reporting for duty";
            this.theStage = Stage.ONPATROL;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    public static enum Stage {
        IDLE,
        ONPATROL,
        ATTACKING;

    }
}

