/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.ModSimukraft;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class JobShepherd
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112207904191941L;
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient ArrayList<IInventory> farmChests = new ArrayList();
    private transient EntitySheep sheepToShear = null;
    private transient boolean isShearing = false;

    public JobShepherd() {
    }

    public JobShepherd(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, FolkData.GotoMethod.BEAM);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
        this.theFolk.isWorking = false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        this.runDelay = this.theStage == Stage.WAITINGFORWOOL ? 15000 : 2000;
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATFARM) {
                this.theStage = Stage.WAITINGFORWOOL;
            } else if (this.theStage == Stage.WAITINGFORWOOL) {
                this.stageWaiting();
            } else if (this.theStage == Stage.SHEARING) {
                this.stageShearing();
            } else if (this.theStage == Stage.CANTWORK) {
                this.stageCantWork();
            }
        }
    }

    private void stageWaiting() {
        Random rand = new Random();
        this.theFolk.isWorking = false;
        this.theFolk.statusText = "Sharpening Shears";
        this.theFolk.stayPut = false;
        List list = this.jobWorld.func_72872_a(EntitySheep.class, AxisAlignedBB.func_72330_a((double)this.theFolk.employedAt.x, (double)this.theFolk.employedAt.y, (double)this.theFolk.employedAt.z, (double)(this.theFolk.employedAt.x + 1.0), (double)(this.theFolk.employedAt.y + 1.0), (double)(this.theFolk.employedAt.z + 1.0)).func_72314_b(3.0, 2.0, 3.0));
        Double playerdist = this.mc.field_71439_g.func_70011_f(this.theFolk.employedAt.x.doubleValue(), this.theFolk.employedAt.y.doubleValue(), this.theFolk.employedAt.z.doubleValue());
        if (playerdist > 60.0) {
            try {
                this.sheepToShear = (EntitySheep)list.get(0);
                this.sheepToShear.func_70893_e(false);
            }
            catch (Exception e) {
                this.placeWoolIntoAChest(1, 1);
            }
        } else if (list.size() > 0) {
            try {
                int r = rand.nextInt(list.size() - 1);
                this.sheepToShear = (EntitySheep)list.get(r);
                this.sheepToShear.func_70893_e(false);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (int s = 0; s < list.size(); ++s) {
            this.sheepToShear = (EntitySheep)list.get(s);
            if (this.sheepToShear.func_70892_o()) continue;
            this.theStage = Stage.SHEARING;
            this.step = 1;
            break;
        }
    }

    private void stageShearing() {
        this.theFolk.stayPut = false;
        if (this.step == 1) {
            if (this.theFolk.getDistanceToPlayer() < 50) {
                this.theFolk.gotoXYZ(new CommonProxy.V3(this.sheepToShear.field_70165_t, this.sheepToShear.field_70163_u, this.sheepToShear.field_70161_v, this.theFolk.employedAt.theDimension), FolkData.GotoMethod.WALK);
            }
            this.step = 2;
        } else if (this.step == 2) {
            this.step = 3;
            if (this.theFolk.theEntity != null) {
                this.theFolk.theEntity.func_70625_a((Entity)this.sheepToShear, 1.0f, 1.0f);
            }
        } else if (this.step == 3) {
            this.theFolk.statusText = "\u526a\u6bdb" + FolkData.generateName(0, true, "") + " \u7f8a\uff01";
            this.sheepToShear.func_70893_e(true);
            if (this.theFolk.theEntity != null) {
                this.theFolk.theEntity.func_70625_a((Entity)this.sheepToShear, 1.0f, 1.0f);
                this.theFolk.isWorking = true;
                this.mc.field_71441_e.func_72980_b(this.theFolk.theEntity.field_70165_t, this.theFolk.theEntity.field_70163_u, this.theFolk.theEntity.field_70161_v, "ashjacksimukraftreloaded:shears", 1.0f, 1.0f, false);
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        JobShepherd.this.isShearing = true;
                        for (int d = 0; d < 12; ++d) {
                            JobShepherd.this.spawnExplosionParticle((Entity)JobShepherd.this.sheepToShear);
                            try {
                                Thread.sleep(150L);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        JobShepherd.this.isShearing = false;
                        JobShepherd.this.theFolk.statusText = "Watching the herd";
                    }
                });
                t.start();
                this.theFolk.theEntity.func_70625_a((Entity)this.sheepToShear, 1.0f, 1.0f);
                this.step = 4;
            }
        } else if (this.step == 4) {
            Random ra = new Random();
            int count = ra.nextInt(3) + 1;
            this.placeWoolIntoAChest(this.sheepToShear.func_70896_n(), count);
            this.theStage = Stage.WAITINGFORWOOL;
            this.theFolk.isWorking = false;
            this.step = 1;
        }
    }

    public void spawnExplosionParticle(Entity ent) {
        Random rand = new Random();
        for (int var1 = 0; var1 < 20; ++var1) {
            double var2 = rand.nextGaussian() * 0.02;
            double var4 = rand.nextGaussian() * 0.02;
            double var6 = rand.nextGaussian() * 0.02;
            double var8 = 10.0;
            try {
                ModSimukraft.proxy.getClientWorld().func_72869_a("explode", ent.field_70165_t + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0 - var2 * var8, ent.field_70163_u + (double)(rand.nextFloat() * 1.0f) - var4 * var8, ent.field_70161_v + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0 - var6 * var8, var2, var4, var6);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void stageCantWork() {
        this.theFolk.statusText = "\u7bb1\u5b50\u88c5\u6ee1\u4e86\u7f8a\u6bdb\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5de5\u4f5c\uff01";
        this.theFolk.isWorking = false;
    }

    private boolean placeWoolIntoAChest(int metaColor, int amount) {
        SimukraftReloaded.states.credits -= 0.02f * (float)amount;
        this.farmChests = JobShepherd.inventoriesFindClosest(this.theFolk.employedAt, 4);
        this.inventoriesPut(this.farmChests, new ItemStack(Blocks.field_150325_L, amount, metaColor), true);
        return true;
    }

    public void spawnSheepIfNeeded(CommonProxy.V3 controlBox) {
        List list = this.jobWorld.func_72872_a(EntitySheep.class, AxisAlignedBB.func_72330_a((double)controlBox.x, (double)controlBox.y, (double)controlBox.z, (double)(controlBox.x + 1.0), (double)(controlBox.y + 1.0), (double)(controlBox.z + 1.0)).func_72314_b(3.0, 2.0, 3.0));
        Random ra = new Random();
        if (list.size() > 0 && list.size() < 6) {
            for (int fuck = 0; fuck < 6 - list.size(); ++fuck) {
                EntitySheep sheep = new EntitySheep(this.jobWorld);
                sheep.func_70012_b(controlBox.x.doubleValue(), controlBox.y + 1.0, controlBox.z.doubleValue(), 0.0f, 0.0f);
                sheep.func_70891_b(ra.nextInt(12) + 1);
                this.jobWorld.func_72838_d((Entity)sheep);
            }
        } else if (list.size() == 0) {
            EntitySheep sheep = new EntitySheep(this.jobWorld);
            sheep.func_70012_b(controlBox.x - 1.0, controlBox.y + 1.0, controlBox.z - 1.0, 0.0f, 0.0f);
            sheep.func_70891_b(ra.nextInt(12) + 1);
            this.jobWorld.func_72838_d((Entity)sheep);
            sheep = new EntitySheep(this.jobWorld);
            sheep.func_70012_b(controlBox.x.doubleValue(), controlBox.y + 1.0, controlBox.z - 1.0, 0.0f, 0.0f);
            sheep.func_70891_b(ra.nextInt(12) + 1);
            this.jobWorld.func_72838_d((Entity)sheep);
            sheep = new EntitySheep(this.jobWorld);
            sheep.func_70012_b(controlBox.x + 1.0, controlBox.y + 1.0, controlBox.z - 1.0, 0.0f, 0.0f);
            sheep.func_70891_b(ra.nextInt(12) + 1);
            this.jobWorld.func_72838_d((Entity)sheep);
            sheep = new EntitySheep(this.jobWorld);
            sheep.func_70012_b(controlBox.x + 1.0, controlBox.y + 1.0, controlBox.z.doubleValue(), 0.0f, 0.0f);
            sheep.func_70891_b(ra.nextInt(12) + 1);
            this.jobWorld.func_72838_d((Entity)sheep);
            sheep = new EntitySheep(this.jobWorld);
            sheep.func_70012_b(controlBox.x + 1.0, controlBox.y + 1.0, controlBox.z + 1.0, 0.0f, 0.0f);
            sheep.func_70891_b(ra.nextInt(12) + 1);
            this.jobWorld.func_72838_d((Entity)sheep);
            sheep = new EntitySheep(this.jobWorld);
            sheep.func_70012_b(controlBox.x + 2.0, controlBox.y + 1.0, controlBox.z + 2.0, 0.0f, 0.0f);
            this.jobWorld.func_72838_d((Entity)sheep);
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u5230\u8fbe\u7f8a\u573a";
            this.theStage = Stage.ARRIVEDATFARM;
            this.spawnSheepIfNeeded(this.theFolk.employedAt);
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, FolkData.GotoMethod.BEAM);
        }
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATFARM,
        WAITINGFORWOOL,
        SHEARING,
        CANTWORK;

    }
}

