/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedItems;
import ashjack.simukraftreloaded.folk.FolkData;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class JobPubLandlord
extends Job {
    public Job.Vocation vocation = null;
    public Stage theStage;
    public FolkData theFolk;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    public int breweryNumber = 0;
    public Building brewerySingle = null;
    public ArrayList<Building> breweryBuildings;

    public JobPubLandlord() {
    }

    public JobPubLandlord(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.ARRIVEDATPUB) {
            this.runDelay = 10000;
        }
        if (this.theStage == Stage.COLLECTINGBEER) {
            this.runDelay = 1000;
        }
        if (this.theStage == Stage.SELLINGBEER) {
            this.runDelay = 10000;
        }
        if (this.theStage == Stage.BOTTLINGBEER) {
            this.runDelay = 10000;
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATPUB) {
                this.theStage = Stage.GOINGTOBREWERY;
                this.step = 1;
            } else if (this.theStage == Stage.GOINGTOBREWERY) {
                this.stageGoingToBrewery();
            } else if (this.theStage == Stage.GOBACKTOPUB) {
                this.stageGoBackToPub();
            } else if (this.theStage == Stage.BOTTLINGBEER) {
                this.stageBottlingBeer();
            } else if (this.theStage == Stage.SELLINGBEER) {
                this.stageSellingBeer();
            }
        }
    }

    private void stageSellingBeer() {
    }

    private void stageBottlingBeer() {
    }

    private void stageGoBackToPub() {
    }

    private void stageGoingToBrewery() {
        if (this.step < 4) {
            this.doPickup("brewery", new ItemStack(SimukraftReloadedItems.itemDrinkBeer, 1, 0).func_77973_b(), true);
        } else {
            this.theStage = Stage.GOINGTOBREWERY;
            this.step = 1;
        }
    }

    private void doPickup(String buildingSearch, Item pickUpItem, boolean doCompareMeta) {
        if (this.step == 1) {
            this.breweryNumber = 0;
            this.breweryBuildings.clear();
            ArrayList<Building> brewery = Building.getBuildingBySearch("Brewery", true);
            if (this.breweryBuildings.size() == 0) {
                this.step = 4;
                return;
            }
            this.theFolk.gotoXYZ(this.breweryBuildings.get((int)this.breweryNumber).primaryXYZ, null);
            this.theFolk.statusText = "On my way to the brewery";
            this.step = 2;
        } else if (this.step == 2) {
            if (this.theFolk.destination == null) {
                this.step = 3;
            }
        } else if (this.step == 3) {
            int count;
            int buy;
            this.theFolk.statusText = "Buying items at the " + this.breweryBuildings.get((int)this.breweryNumber).displayName;
            ArrayList<IInventory> chests = JobPubLandlord.inventoriesFindClosest(this.breweryBuildings.get((int)this.breweryNumber).primaryXYZ, 5);
            if (!chests.isEmpty() && (buy = (count = this.getItemCountInChests(chests, new ItemStack(pickUpItem, 1), doCompareMeta)) / 4) > 0) {
                SimukraftReloaded.log.info("JobBurgersManager: buying " + buy + " out of " + count + " items");
                this.inventoriesTransferLimitedToFolk(this.theFolk.inventory, chests, new ItemStack(pickUpItem, 1), buy, doCompareMeta);
            }
            ++this.breweryNumber;
            if (this.breweryNumber <= this.breweryBuildings.size() - 1) {
                this.theFolk.gotoXYZ(this.breweryBuildings.get((int)this.breweryNumber).primaryXYZ, null);
                this.step = 2;
            } else {
                this.step = 4;
            }
        }
    }

    @Override
    public void onArrivedAtWork() {
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATPUB,
        GOINGTOBREWERY,
        COLLECTINGBEER,
        GOBACKTOPUB,
        BOTTLINGBEER,
        SELLINGBEER;

    }
}

