/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.blocks.functionality.MiningBox;
import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.game.GameMode;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedBlocks;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobMiner
extends Job
implements Serializable {
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient int step = 1;
    private long timeSinceLastChestFullMessage = 0L;
    transient Long timeSinceLastGoto = 0L;
    transient ArrayList<IInventory> miningChests = null;
    String mineDir = "";
    String mineHorizontalDir = "";
    CommonProxy.V3 vNextMineableBlock = null;
    transient boolean swingToggle = true;
    private boolean isChestsFull = false;
    private MiningBox theMiningBox;
    private String lastMinedBlockName = "";

    public JobMiner() {
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
        this.theFolk.isWorking = false;
    }

    public JobMiner(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        this.theMiningBox = MiningBox.getMiningBlockByBoxXYZ(folk.employedAt);
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
        if (this.theMiningBox == null) {
            SimukraftReloaded.sendChat("There's a problem with the mining box that " + this.theFolk.name + " was using. Please replace it");
            this.theFolk.selfFire();
            return;
        }
        if (this.theMiningBox.marker1XYZ != null && this.theMiningBox.marker2XYZ == null) {
            CommonProxy.V3 xyz = this.theMiningBox.location;
            int mbX = xyz.x.intValue();
            int mbZ = xyz.z.intValue();
            xyz = this.theMiningBox.marker1XYZ;
            int mX = xyz.x.intValue();
            int mZ = xyz.z.intValue();
            if (mbX < mX) {
                this.mineHorizontalDir = "+x";
            } else if (mbX > mX) {
                this.mineHorizontalDir = "-x";
            } else if (mbZ < mZ) {
                this.mineHorizontalDir = "+z";
            } else if (mbZ > mZ) {
                this.mineHorizontalDir = "-z";
            }
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        try {
            if (!SimukraftReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
                this.theFolk.action = FolkData.FolkAction.WANDER;
                this.theFolk.statusText = "Finished work for the day";
                this.theFolk.isWorking = false;
                return;
            }
            super.onUpdateGoingToWork(this.theFolk);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.theStage == Stage.WAITINGFORCHEST) {
            this.runDelay = 6000;
        }
        if (this.theStage == Stage.BEAMINGDOWN) {
            this.runDelay = 4000;
        }
        if (this.theStage == Stage.MINING) {
            this.runDelay = (int)(2000.0f / this.theFolk.levelMiner);
            if (GameMode.gameMode == GameMode.GAMEMODES.CREATIVE) {
                this.runDelay = 10;
            }
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theFolk.vocation != Job.Vocation.MINER) {
            this.theFolk.selfFire();
            return;
        }
        if (this.theStage == Stage.IDLE && SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.WAITINGFORCHEST;
        } else if (this.theStage == Stage.WAITINGFORCHEST) {
            this.stageWaitingForChest();
        } else if (this.theStage == Stage.BEAMINGDOWN) {
            this.stageBeamingDown();
        } else if (this.theStage == Stage.MINING) {
            this.stageMining();
        } else if (this.theStage == Stage.BEAMINGUP) {
            this.stageBeamingUp();
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u6765\u5230\u77ff\u533a";
            this.step = 1;
            this.theStage = Stage.WAITINGFORCHEST;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    private void stageWaitingForChest() {
        this.theFolk.stayPut = true;
        this.theFolk.isWorking = false;
        if (this.isChestsFull) {
            if (System.currentTimeMillis() - this.timeSinceLastChestFullMessage > 120000L) {
                SimukraftReloaded.sendChat(this.theFolk.name + "\u7bb1\u5b50\u6ee1\u4e86\uff0c\u4ed6\u4eec\u5df2\u7ecf\u505c\u6b62\u4e86\u5f00\u91c7\u3002");
                this.timeSinceLastChestFullMessage = System.currentTimeMillis();
            }
            this.theFolk.statusText = "\u6240\u6709\u7684\u7bb1\u5b50\u90fd\u6ee1\u4e86\uff0c\u8bf7\u6e05\u7a7a\u6216\u6dfb\u52a0\u66f4\u591a\u7684\u7bb1\u5b50";
            this.miningChests = JobMiner.inventoriesFindClosest(this.theFolk.employedAt, 5);
            ItemStack is = new ItemStack(Blocks.field_150346_d, 1);
            Boolean placedOk = this.inventoriesPut(this.miningChests, is, true);
            if (placedOk.booleanValue()) {
                JobMiner.inventoriesGet(this.miningChests, is, false, false);
                this.theFolk.inventory.clear();
                this.isChestsFull = false;
                this.theStage = Stage.BEAMINGDOWN;
                this.setNextMineableBlock();
            }
        } else {
            this.theFolk.statusText = "\u68c0\u67e5\u50a8\u7269\u7bb1......";
            this.miningChests = JobMiner.inventoriesFindClosest(this.theFolk.employedAt, 5);
            if (this.miningChests.size() == 0) {
                this.theFolk.statusText = "\u81f3\u5c11\u6709\u4e00\u4e2a\u9644\u8fd1\u7684\u77ff\u4e1a\u76d2";
            } else {
                this.theStage = Stage.BEAMINGDOWN;
                if (this.theFolk.theEntity != null) {
                    try {
                        if (this.theFolk.gender == 0) {
                            this.mc.field_71441_e.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "ashjacksimukraftreloaded:readym", 1.0f, 1.0f, false);
                        } else {
                            this.mc.field_71441_e.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "ashjacksimukraftreloaded:readyf", 1.0f, 1.0f, false);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void stageBeamingDown() {
        if (this.vNextMineableBlock == null) {
            this.setNextMineableBlock();
        }
        if (this.vNextMineableBlock == null) {
            return;
        }
        this.theFolk.updateLocationFromEntity();
        if (this.theFolk.location.getDistanceTo(this.vNextMineableBlock) < 10 || this.vNextMineableBlock.y <= 20.0) {
            this.theStage = Stage.MINING;
            this.theFolk.stayPut = true;
            return;
        }
        if (this.step == 1) {
            if (this.theFolk.beamingTo == null) {
                this.theFolk.statusText = "Beam me down, Scotty!";
                if (this.theFolk.theEntity != null) {
                    if (this.theFolk.gender == 0) {
                        this.mc.field_71441_e.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "ashjacksimukraftreloaded:beamm", 1.0f, 1.0f, false);
                    } else {
                        this.mc.field_71441_e.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "ashjacksimukraftreloaded:beamf", 1.0f, 1.0f, false);
                    }
                }
                this.theFolk.stayPut = true;
                this.theFolk.beamMeTo(this.vNextMineableBlock.clone());
                this.step = 2;
            }
        } else if (this.step == 2 && this.theFolk.destination == null) {
            this.theStage = Stage.MINING;
            return;
        }
    }

    private void stageBeamingUp() {
        this.theFolk.beamMeTo(this.theFolk.employedAt.clone());
        this.theStage = Stage.IDLE;
        this.theFolk.action = FolkData.FolkAction.WANDER;
        SimukraftReloaded.sendChat(this.theFolk.name + " \u4ed6\u4eec\u5df2\u7ecf\u5b8c\u6210\u4e86\u6316\u6398\u77ff\u4e95\u3002");
        this.mc.field_71441_e.func_72980_b(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u, this.mc.field_71439_g.field_70161_v, "ashjacksimukraftreloaded:cash", 1.0f, 1.0f, false);
    }

    private void setNextMineableBlock() {
        int xxx = 0;
        int yyy = 0;
        int zzz = 0;
        CommonProxy.V3 m1 = this.theMiningBox.marker1XYZ;
        CommonProxy.V3 m2 = this.theMiningBox.marker2XYZ;
        CommonProxy.V3 m3 = this.theMiningBox.marker3XYZ;
        if (m1 == null) {
            SimukraftReloaded.sendChat("\u77ff\u4e95\u4e2d\u9047\u5230\u4e86\u4e00\u4e2a\u95ee\u9898\u3002");
            return;
        }
        if (this.mineHorizontalDir.contentEquals("")) {
            int mx = m1.x.intValue();
            int my = m1.y.intValue() - 1;
            int mz = m1.z.intValue();
            if (m2.x.intValue() == m1.x.intValue()) {
                this.mineDir = m2.z.intValue() > mz ? "z+" : "z-";
            } else if (m2.z.intValue() == m1.z.intValue()) {
                this.mineDir = m2.x.intValue() > mx ? "x+" : "x-";
            }
            Block id = null;
            int idmeta = 0;
            int ftbCount = 0;
            int ltrCount = 0;
            int xo = 0;
            int zo = 0;
            ltrCount = m1.x.intValue() == m2.x.intValue() ? Math.abs(m2.z.intValue() - m1.z.intValue()) - 1 : Math.abs(m2.x.intValue() - m1.x.intValue()) - 1;
            ftbCount = m1.x.intValue() == m3.x.intValue() ? Math.abs(m3.z.intValue() - m1.z.intValue()) - 1 : Math.abs(m3.x.intValue() - m1.x.intValue()) - 1;
            block8: for (int l = my; l > 0; --l) {
                for (int ftb = 0; ftb <= ftbCount; ++ftb) {
                    for (int ltr = 1; ltr <= ltrCount; ++ltr) {
                        if (this.mineDir.contentEquals("x+")) {
                            xo = ltr;
                            zo = -ftb;
                        } else if (this.mineDir.contentEquals("x-")) {
                            xo = -ltr;
                            zo = ftb;
                        } else if (this.mineDir.contentEquals("z+")) {
                            xo = ftb;
                            zo = ltr;
                        } else if (this.mineDir.contentEquals("z-")) {
                            xo = -ftb;
                            zo = -ltr;
                        }
                        xxx = mx + xo;
                        yyy = l;
                        zzz = mz + zo;
                        id = this.jobWorld.func_147439_a(xxx, yyy, zzz);
                        idmeta = this.jobWorld.func_72805_g(xxx, yyy, zzz);
                        if (id == Blocks.field_150357_h) {
                            SimukraftReloaded.sendChat(this.theFolk.name + " \u56e0\u4e3a\u8be5\u77ff\u4e95\u73b0\u5df2\u8fbe\u5230\u57fa\u5ca9\uff0c\u4ece\u77ff\u4e95\u5e95\u90e8\u8fd4\u56de\u5730\u9762\u3002");
                            this.theFolk.beamMeTo(this.theFolk.employedAt);
                            this.theFolk.selfFire();
                            return;
                        }
                        try {
                            Block block = id;
                            if (id == Blocks.field_150350_a || id == Blocks.field_150355_j || id == Blocks.field_150355_j || id == Blocks.field_150353_l || id == Blocks.field_150353_l || block.toString().toLowerCase().contains("oil")) continue;
                        }
                        catch (Exception e) {}
                        break block8;
                    }
                }
            }
            try {
                this.vNextMineableBlock = new CommonProxy.V3(Double.valueOf(xxx), Double.valueOf(yyy), Double.valueOf(zzz), this.theFolk.employedAt.theDimension);
            }
            catch (Exception e) {}
        } else {
            Double ltrCount;
            Double ftbCount;
            CommonProxy.V3 idmeta;
            CommonProxy.V3 vMine = new CommonProxy.V3(m1.x, m1.y, m1.z, this.theFolk.employedAt.theDimension);
            if (this.mineHorizontalDir.contentEquals("+x")) {
                idmeta = vMine;
                ftbCount = idmeta.x;
                ltrCount = idmeta.x = Double.valueOf(idmeta.x + 1.0);
            } else if (this.mineHorizontalDir.contentEquals("-x")) {
                idmeta = vMine;
                ftbCount = idmeta.x;
                ltrCount = idmeta.x = Double.valueOf(idmeta.x - 1.0);
            } else if (this.mineHorizontalDir.contentEquals("+z")) {
                idmeta = vMine;
                ftbCount = idmeta.z;
                ltrCount = idmeta.z = Double.valueOf(idmeta.z + 1.0);
            } else if (this.mineHorizontalDir.contentEquals("-z")) {
                idmeta = vMine;
                ftbCount = idmeta.z;
                ltrCount = idmeta.z = Double.valueOf(idmeta.z - 1.0);
            }
            CommonProxy.V3 vMineable = new CommonProxy.V3();
            Object id = null;
            int meta = 0;
            int xo = 0;
            int yo = 0;
            int zo = 0;
            boolean flagFound = false;
            block11: for (int ftb = 0; ftb < 1024; ++ftb) {
                for (int btt = 0; btt < this.theMiningBox.size; ++btt) {
                    for (int ltr = 0; ltr < this.theMiningBox.size; ++ltr) {
                        if (this.mineHorizontalDir.contentEquals("+x")) {
                            xo = ftb;
                            zo = ltr;
                        } else if (this.mineHorizontalDir.contentEquals("-x")) {
                            xo = -ftb;
                            zo = -ltr;
                        } else if (this.mineHorizontalDir.contentEquals("+z")) {
                            xo = -ltr;
                            zo = ftb;
                        } else if (this.mineHorizontalDir.contentEquals("-z")) {
                            xo = ltr;
                            zo = -ftb;
                        }
                        yo = btt;
                        try {
                            if (this.theFolk.employedAt == null) {
                                this.theStage = Stage.IDLE;
                                return;
                            }
                            vMineable = new CommonProxy.V3(vMine.x + (double)xo, vMine.y + (double)yo, vMine.z + (double)zo, this.theFolk.employedAt.theDimension);
                            id = this.jobWorld.func_147439_a(vMineable.x.intValue(), vMineable.y.intValue(), vMineable.z.intValue());
                            meta = this.jobWorld.func_72805_g(vMineable.x.intValue(), vMineable.y.intValue(), vMineable.z.intValue());
                            if (ftb % 10 == 0 && (double)btt == Math.floor(this.theMiningBox.size / 2) && ltr == 0) {
                                Double d;
                                CommonProxy.V3 v3;
                                CommonProxy.V3 lightbox = vMineable.clone();
                                if (this.mineHorizontalDir.contentEquals("+x")) {
                                    v3 = lightbox;
                                    d = v3.z;
                                    Double d2 = v3.z = Double.valueOf(v3.z - 1.0);
                                } else if (this.mineHorizontalDir.contentEquals("-x")) {
                                    v3 = lightbox;
                                    d = v3.z;
                                    Double d3 = v3.z = Double.valueOf(v3.z + 1.0);
                                } else if (this.mineHorizontalDir.contentEquals("+z")) {
                                    v3 = lightbox;
                                    d = v3.x;
                                    Double d4 = v3.x = Double.valueOf(v3.x + 1.0);
                                } else if (this.mineHorizontalDir.contentEquals("-z")) {
                                    v3 = lightbox;
                                    d = v3.x;
                                    Double d5 = v3.x = Double.valueOf(v3.x - 1.0);
                                }
                                Block lbid = this.jobWorld.func_147439_a(lightbox.x.intValue(), lightbox.y.intValue(), lightbox.z.intValue());
                                if (this.miningChests.size() > 0 && lbid != SimukraftReloadedBlocks.lightBox) {
                                    ItemStack light = null;
                                    for (int lightmeta = 0; light == null && lightmeta < 8; ++lightmeta) {
                                        light = JobMiner.inventoriesGet(this.miningChests, new ItemStack(SimukraftReloadedBlocks.lightBox, 1, lightmeta), false, true);
                                    }
                                    if (light != null) {
                                        SimukraftReloaded.log.info("Light box placed at " + lightbox.toString());
                                        this.jobWorld.func_147465_d(lightbox.x.intValue(), lightbox.y.intValue(), lightbox.z.intValue(), SimukraftReloadedBlocks.lightBox, light.func_77960_j(), 3);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (id == Blocks.field_150357_h) {
                            SimukraftReloaded.sendChat(this.theFolk.name + " \u56e0\u4e3a\u8be5\u77ff\u4e95\u73b0\u5df2\u8fbe\u5230\u57fa\u5ca9\uff0c\u8bf7\u63d0\u5347\u6316\u6398\u533a\u57df\u7684\u6c34\u5e73\u9ad8\u5ea6");
                            this.theFolk.beamMeTo(this.theFolk.employedAt);
                            this.theFolk.selfFire();
                            return;
                        }
                        try {
                            Object block = id;
                            if (id == Blocks.field_150350_a || id == Blocks.field_150355_j || id == Blocks.field_150355_j || id == Blocks.field_150353_l || id == Blocks.field_150353_l || block.toString().toLowerCase().contains("oil")) continue;
                            flagFound = true;
                        }
                        catch (Exception e) {
                            flagFound = true;
                        }
                        break block11;
                    }
                }
            }
            if (!flagFound) {
                SimukraftReloaded.sendChat(this.theFolk.name + "  \u56e0\u4e3a\u6c34\u5e73\u77ff\u4e95\u5df2\u8fbe\u52301\u516c\u91cc\u6781\u9650\u3002\u5982\u679c\u4f60\u9700\u8981\u4e00\u4e2a\u8f83\u957f\u7684\u77ff\u4e95\uff0c\u5219\u91cd\u65b0\u8bbe\u7f6e\u4e00\u4e2a\u6316\u6398\u70b9\u3002");
                this.theFolk.beamMeTo(this.theFolk.employedAt);
                this.theFolk.isWorking = false;
                this.theFolk.selfFire();
                return;
            }
            this.vNextMineableBlock = vMineable.clone();
        }
    }

    private void stageMining() {
        this.theFolk.isWorking = true;
        if (this.theFolk.theEntity != null) {
            this.theFolk.theEntity.field_71093_bK = this.theFolk.employedAt.theDimension;
        } else {
            this.theFolk.location.theDimension = this.theFolk.employedAt.theDimension;
        }
        this.theFolk.action = FolkData.FolkAction.ATWORK;
        if (this.theFolk.isSpawned() && System.currentTimeMillis() - this.timeSinceLastGoto > 7000L) {
            this.theFolk.updateLocationFromEntity();
            if (this.theFolk.location.y - this.vNextMineableBlock.y > 4.0) {
                this.vNextMineableBlock.doNotTimeout = false;
                if (this.vNextMineableBlock.y > 20.0) {
                    this.theFolk.gotoXYZ(this.vNextMineableBlock, FolkData.GotoMethod.BEAM);
                } else {
                    this.theFolk.stayPut = true;
                }
            } else {
                this.vNextMineableBlock.doNotTimeout = true;
                if (this.vNextMineableBlock.y > 20.0) {
                    this.theFolk.stayPut = false;
                    this.theFolk.gotoXYZ(this.vNextMineableBlock, FolkData.GotoMethod.WALK);
                } else {
                    this.theFolk.stayPut = true;
                }
            }
            this.timeSinceLastGoto = System.currentTimeMillis();
            this.theFolk.timeStartedGotoing = System.currentTimeMillis();
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int d = 0; d < 5; ++d) {
                    try {
                        JobMiner.this.jobWorld.func_72980_b(JobMiner.this.vNextMineableBlock.x.doubleValue(), JobMiner.this.vNextMineableBlock.y.doubleValue(), JobMiner.this.vNextMineableBlock.z.doubleValue(), "dig.stone", 1.0f, 1.0f, false);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        t.start();
        if (this.lastMinedBlockName.contentEquals("")) {
            this.theFolk.statusText = "Diggy diggy hole!";
        }
        int id = 0;
        int idmeta = 0;
        id = Block.func_149682_b((Block)this.jobWorld.func_147439_a(this.vNextMineableBlock.x.intValue(), this.vNextMineableBlock.y.intValue(), this.vNextMineableBlock.z.intValue()));
        idmeta = this.jobWorld.func_72805_g(this.vNextMineableBlock.x.intValue(), this.vNextMineableBlock.y.intValue(), this.vNextMineableBlock.z.intValue());
        if (this.jobWorld == null) {
            return;
        }
        ArrayList<ItemStack> minedStacks = this.translateBlockWhenMined(this.jobWorld, this.vNextMineableBlock);
        this.jobWorld.func_147465_d(this.vNextMineableBlock.x.intValue(), this.vNextMineableBlock.y.intValue(), this.vNextMineableBlock.z.intValue(), Blocks.field_150350_a, 0, 3);
        if (this.theFolk.theEntity != null) {
            try {
                this.mc.field_71441_e.func_72869_a("explode", (double)this.vNextMineableBlock.x.intValue(), (double)this.vNextMineableBlock.y.intValue(), (double)this.vNextMineableBlock.z.intValue(), (double)0.1f, (double)0.3f, 0.0);
                this.mc.field_71441_e.func_72869_a("explode", (double)this.vNextMineableBlock.x.intValue(), (double)this.vNextMineableBlock.y.intValue(), (double)this.vNextMineableBlock.z.intValue(), 0.0, (double)0.2f, 0.0);
                this.mc.field_71441_e.func_72869_a("explode", (double)this.vNextMineableBlock.x.intValue(), (double)this.vNextMineableBlock.y.intValue(), (double)this.vNextMineableBlock.z.intValue(), 0.0, (double)0.1f, (double)0.1f);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
            int aft;
            SimukraftReloaded.states.credits -= 0.012f;
            int b4 = (int)Math.floor(this.theFolk.levelMiner);
            if (this.theFolk.levelMiner < 10.0f) {
                this.theFolk.levelMiner = (float)((double)this.theFolk.levelMiner + 0.001 / (double)b4);
            }
            if (b4 != (aft = (int)Math.floor(this.theFolk.levelMiner))) {
                SimukraftReloaded.sendChat(this.theFolk.name + " \u521a\u521a\u77ff\u5de5\u7b49\u7ea7\u63d0\u5347\u4e86" + aft);
            }
        } else {
            this.theFolk.levelMiner = 10.0f;
        }
        if (this.theFolk.employedAt == null) {
            return;
        }
        if (this.theFolk.employedAt.y - this.vNextMineableBlock.y > 3.0) {
            if (this.theMiningBox.addGlassCover && this.mineHorizontalDir.contentEquals("")) {
                ItemStack glass;
                Block gid = this.jobWorld.func_147439_a(this.vNextMineableBlock.x.intValue(), this.theFolk.employedAt.y.intValue(), this.vNextMineableBlock.z.intValue());
                if (gid == null && this.miningChests.size() > 0 && (glass = JobMiner.inventoriesGet(this.miningChests, new ItemStack(Blocks.field_150359_w, 1), false, false)) != null) {
                    this.jobWorld.func_147465_d(this.vNextMineableBlock.x.intValue(), this.theFolk.employedAt.y.intValue(), this.vNextMineableBlock.z.intValue(), Blocks.field_150359_w, 0, 3);
                }
            } else {
                this.jobWorld.func_147465_d(this.vNextMineableBlock.x.intValue(), this.theFolk.employedAt.y.intValue(), this.vNextMineableBlock.z.intValue(), Blocks.field_150350_a, 0, 2);
            }
        }
        boolean keep = false;
        if (this.theMiningBox.discards == 0) {
            keep = true;
        }
        if (this.theMiningBox.discards == 1) {
            keep = id != Block.func_149682_b((Block)Blocks.field_150346_d) && id != Block.func_149682_b((Block)Blocks.field_150349_c);
        }
        if (this.theMiningBox.discards == 2) {
            keep = id != Block.func_149682_b((Block)Blocks.field_150346_d) && id != Block.func_149682_b((Block)Blocks.field_150349_c) && id != Block.func_149682_b((Block)Blocks.field_150348_b) && id != Block.func_149682_b((Block)Blocks.field_150347_e);
        }
        if (this.theMiningBox.discards == 3) {
            keep = id != Block.func_149682_b((Block)Blocks.field_150346_d) && id != Block.func_149682_b((Block)Blocks.field_150349_c) && id != Block.func_149682_b((Block)Blocks.field_150354_m);
        }
        if (this.theMiningBox.discards == 4) {
            keep = id != Block.func_149682_b((Block)Blocks.field_150346_d) && id != Block.func_149682_b((Block)Blocks.field_150349_c) && id != Block.func_149682_b((Block)Blocks.field_150348_b) && id != Block.func_149682_b((Block)Blocks.field_150347_e) && id != Block.func_149682_b((Block)Blocks.field_150354_m);
        }
        try {
            Block block = Block.func_149729_e((int)id);
            if (id == Block.func_149682_b((Block)Blocks.field_150355_j) || id == Block.func_149682_b((Block)Blocks.field_150355_j) || id == Block.func_149682_b((Block)Blocks.field_150353_l) || id == Block.func_149682_b((Block)Blocks.field_150353_l) || id == Block.func_149682_b((Block)Blocks.field_150329_H) || block.toString().toLowerCase().contains("oil")) {
                keep = false;
            }
        }
        catch (Exception e) {
            keep = false;
        }
        boolean placedOk = true;
        if (keep && minedStacks != null) {
            this.miningChests = Job.inventoriesFindClosest(this.theFolk.employedAt, 5);
            for (int s = 0; s < minedStacks.size(); ++s) {
                ItemStack stack = minedStacks.get(s);
                if (stack == null) continue;
                this.lastMinedBlockName = stack.func_82833_r();
                this.theFolk.statusText = "Diggy diggy \u53d1\u73b0\u91c7\u77ff\u6d1e\u7a74" + this.lastMinedBlockName + "!";
                placedOk = this.inventoriesPut(this.miningChests, stack, false);
            }
        }
        if (!placedOk) {
            this.isChestsFull = true;
            this.theStage = Stage.WAITINGFORCHEST;
            this.theFolk.inventory.clear();
            this.theFolk.inventory.add(new ItemStack(Block.func_149729_e((int)id), idmeta, 1));
        }
        this.setNextMineableBlock();
    }

    public static enum Stage {
        IDLE,
        WAITINGFORCHEST,
        BEAMINGDOWN,
        MINING,
        BEAMINGUP;

    }
}

