/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedConfig;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class JobLumberjack
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112207904887741L;
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient ArrayList<IInventory> millChests = new ArrayList();
    private transient CommonProxy.V3 foundWoodAt = new CommonProxy.V3();
    private transient Building lumbermill = null;
    private transient long startedGoing = 0L;
    private transient boolean isChopping = false;
    private transient float pay = 0.0f;
    private transient boolean onRoute = false;

    public JobLumberjack() {
    }

    public JobLumberjack(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
        this.theFolk.isWorking = false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage == Stage.IDLE && SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.SCANFORTREE;
        } else if (this.theStage == Stage.ARRIVEDATMILL) {
            this.theStage = Stage.SCANFORTREE;
        } else if (this.theStage == Stage.SCANFORTREE) {
            this.stageScanForTree();
        } else if (this.theStage == Stage.GOTOTREE) {
            this.pickUpSaplings();
            this.stageGotoTree();
        } else if (this.theStage == Stage.CHOPPINGTREE) {
            this.stageChoppingTree();
            this.pickUpSaplings();
        } else if (this.theStage == Stage.RETURNWOOD) {
            this.stageReturnWood();
            this.pickUpSaplings();
        }
    }

    private void stageScanForTree() {
        this.theFolk.action = FolkData.FolkAction.ATWORK;
        this.theFolk.isWorking = false;
        CommonProxy.V3 searchXYZ = null;
        this.lumbermill = Building.getBuilding(this.theFolk.employedAt);
        CommonProxy.V3 ts = null;
        try {
            searchXYZ = this.lumbermill.lumbermillMarker != null ? this.lumbermill.lumbermillMarker : (this.theFolk.employedAt != null ? this.theFolk.employedAt.clone() : this.theFolk.location.clone());
            ts = searchXYZ.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonProxy.V3 searchpos = ts != null ? ts.clone() : this.theFolk.location.clone();
        try {
            this.foundWoodAt = JobLumberjack.findClosestBlockType(searchpos, Blocks.field_150364_r, SimukraftReloadedConfig.configLumberArea, false);
            this.foundWoodAt.theDimension = this.jobWorld.field_73011_w.field_76574_g;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.theStage = Stage.GOTOTREE;
        this.onRoute = false;
        if (this.foundWoodAt == null) {
            SimukraftReloaded.sendChat(this.theFolk.name + " \u627e\u4e0d\u5230\u5728\u8be5\u533a\u57df\u4e2d\u7684\u4efb\u4f55\u6811\u6728\u3002");
            this.theFolk.selfFire();
            return;
        }
    }

    private void stageGotoTree() {
        this.theFolk.isWorking = false;
        if (!this.onRoute) {
            this.theFolk.statusText = "\u53bb\u64b8\u6811...";
            this.theFolk.gotoXYZ(this.foundWoodAt, null);
            this.startedGoing = System.currentTimeMillis();
            this.onRoute = true;
        } else {
            double dist;
            if (this.theFolk.gotoMethod == FolkData.GotoMethod.WALK) {
                this.theFolk.updateLocationFromEntity();
            }
            if ((dist = (double)this.theFolk.location.getDistanceTo(this.foundWoodAt)) < 7.0) {
                this.theStage = Stage.CHOPPINGTREE;
                this.theFolk.stayPut = true;
                this.step = 1;
            } else {
                if (this.theFolk.destination != null || this.theFolk.theEntity != null) {
                    // empty if block
                }
                if (System.currentTimeMillis() - this.startedGoing > 25000L) {
                    this.theStage = Stage.CHOPPINGTREE;
                    this.theFolk.stayPut = true;
                    this.theFolk.destination = null;
                    this.step = 1;
                }
            }
        }
    }

    private void stageChoppingTree() {
        if (this.step == 1) {
            this.theFolk.statusText = "Choppy Choppy \u53d1\u73b0\u6811\u60f9!";
            this.theFolk.isWorking = true;
            for (int down = 0; down < 20; ++down) {
                int x = this.foundWoodAt.x.intValue();
                int y = this.foundWoodAt.y.intValue() - 0;
                int z = this.foundWoodAt.z.intValue();
                if (this.jobWorld == null) {
                    this.theFolk.selfFire();
                    return;
                }
                if (this.jobWorld.func_147439_a(x, y, z) != Blocks.field_150364_r) break;
                this.foundWoodAt.y = y;
            }
            this.step = 2;
        } else if (this.step == 2) {
            if (this.jobWorld.func_147439_a(this.foundWoodAt.x.intValue(), this.foundWoodAt.y.intValue(), this.foundWoodAt.z.intValue()) == Blocks.field_150364_r || this.jobWorld.func_147439_a(this.foundWoodAt.x.intValue(), this.foundWoodAt.y.intValue(), this.foundWoodAt.z.intValue()) == Blocks.field_150363_s) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        JobLumberjack.this.isChopping = true;
                        for (int d = 0; d < 12; ++d) {
                            try {
                                JobLumberjack.this.mc.field_71441_e.func_72980_b(JobLumberjack.this.theFolk.location.x.doubleValue(), JobLumberjack.this.theFolk.location.y.doubleValue(), JobLumberjack.this.theFolk.location.z.doubleValue(), "step.wood", 1.0f, 1.0f, false);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (JobLumberjack.this.theFolk.theEntity == null) continue;
                            JobLumberjack.this.theFolk.theEntity.field_70733_aJ = 0.3f;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            JobLumberjack.this.theFolk.theEntity.field_70733_aJ = 0.7f;
                            try {
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        JobLumberjack.this.isChopping = false;
                    }
                });
                t.start();
                this.step = 3;
            } else {
                this.step = 4;
            }
        } else if (this.step == 3) {
            if (this.isChopping) {
                return;
            }
            ArrayList<ItemStack> log = this.translateBlockWhenMined(this.jobWorld, this.foundWoodAt);
            this.jobWorld.func_147465_d(this.foundWoodAt.x.intValue(), this.foundWoodAt.y.intValue(), this.foundWoodAt.z.intValue(), Blocks.field_150350_a, 0, 3);
            if (log != null) {
                for (int l = 0; l < log.size(); ++l) {
                    ItemStack isl = log.get(l);
                    this.theFolk.inventory.add(isl);
                }
            }
            int count = this.getInventoryCount(this.theFolk, Item.func_150898_a((Block)Blocks.field_150364_r));
            this.theFolk.statusText = "Got " + count + " logs so far";
            this.theFolk.stayPut = false;
            this.foundWoodAt.y = this.foundWoodAt.y + 1.0;
            this.step = 2;
        } else if (this.step == 4) {
            int count;
            if (this.theFolk.isSpawned()) {
                count = this.getInventoryCount(this.theFolk, Item.func_150898_a((Block)Blocks.field_150345_g));
                if (count > 0) {
                    for (int i = 0; i < this.theFolk.inventory.size(); ++i) {
                        ItemStack fis = this.theFolk.inventory.get(i);
                        if (fis == null || Block.func_149634_a((Item)fis.func_77973_b()) != Blocks.field_150345_g) continue;
                        this.theFolk.inventory.remove(i);
                        this.plantSapling(Block.func_149634_a((Item)fis.func_77973_b()));
                        break;
                    }
                }
            } else {
                this.plantSapling(Blocks.field_150345_g);
            }
            if ((count = this.getInventoryCount(this.theFolk, Item.func_150898_a((Block)Blocks.field_150364_r))) < 12) {
                this.theStage = Stage.SCANFORTREE;
            } else {
                this.theStage = Stage.RETURNWOOD;
                this.step = 1;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void stageReturnWood() {
        this.theFolk.isWorking = false;
        if (this.step == 1) {
            this.theFolk.statusText = "\u83b7\u5f97\u6728\u5934\u9001\u56de\u952f\u6728\u5382";
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            this.step = 2;
            return;
        }
        if (this.step == 2) {
            int dist;
            if (this.theFolk.gotoMethod == FolkData.GotoMethod.WALK) {
                this.theFolk.updateLocationFromEntity();
            }
            if ((dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt)) <= 1) {
                this.step = 3;
                return;
            }
            if (this.theFolk.destination != null) return;
            if (this.theFolk.theEntity == null) return;
            return;
        } else {
            if (this.step != 3) return;
            this.theFolk.stayPut = true;
            int count = this.getInventoryCount(this.theFolk, Item.func_150898_a((Block)Blocks.field_150364_r));
            this.millChests = JobLumberjack.inventoriesFindClosest(this.theFolk.employedAt, 6);
            this.inventoriesTransferFromFolk(this.theFolk.inventory, this.millChests, new ItemStack(Item.func_150898_a((Block)Blocks.field_150364_r)));
            this.pay = (float)count * 0.03f;
            SimukraftReloaded.states.credits -= this.pay;
            SimukraftReloaded.sendChat(this.theFolk.name + " has delivered " + count + " logs at the lumbermill");
            this.theStage = Stage.SCANFORTREE;
            this.step = 1;
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u6211\u662f\u4e00\u540d\u4f10\u6728\u5de5\u4eba\uff0c\u6211\u76f8\u4fe1\u6211\u80fd\u884c\uff01";
            this.theStage = Stage.ARRIVEDATMILL;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    private void pickUpSaplings() {
        if (!this.theFolk.isSpawned()) {
            return;
        }
        List list1 = this.jobWorld.func_72839_b((Entity)this.theFolk.theEntity, AxisAlignedBB.func_72330_a((double)this.theFolk.theEntity.field_70165_t, (double)this.theFolk.theEntity.field_70163_u, (double)this.theFolk.theEntity.field_70161_v, (double)(this.theFolk.theEntity.field_70165_t + 1.0), (double)(this.theFolk.theEntity.field_70163_u + 1.0), (double)(this.theFolk.theEntity.field_70161_v + 1.0)).func_72314_b(3.0, 4.0, 3.0));
        Iterator iterator1 = list1.iterator();
        if (!list1.isEmpty()) {
            while (iterator1.hasNext()) {
                Entity entity1 = (Entity)iterator1.next();
                if (!(entity1 instanceof EntityItem)) continue;
                EntityItem entityitem = (EntityItem)entity1;
                ItemStack is = entityitem.func_92059_d();
                try {
                    Item ID = is.func_77973_b();
                    if (ID != Item.func_150898_a((Block)Blocks.field_150345_g)) continue;
                    this.theFolk.inventory.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150345_g), is.func_77960_j(), 1));
                    entityitem.func_70106_y();
                }
                catch (Exception e) {}
            }
        }
    }

    private void plantSapling(Block is) {
        if (this.theFolk.isSpawned()) {
            if (this.jobWorld.func_147439_a((int)this.theFolk.theEntity.field_70165_t, (int)this.theFolk.theEntity.field_70163_u, (int)this.theFolk.theEntity.field_70161_v) == null) {
                this.jobWorld.func_147449_b((int)this.theFolk.theEntity.field_70165_t, (int)this.theFolk.theEntity.field_70163_u, (int)this.theFolk.theEntity.field_70161_v, is);
            }
        } else {
            this.jobWorld.func_147465_d(this.theFolk.location.x.intValue(), this.theFolk.location.y.intValue(), this.theFolk.location.z.intValue(), Blocks.field_150345_g, 0, 3);
        }
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATMILL,
        SCANFORTREE,
        GOTOTREE,
        CHOPPINGTREE,
        RETURNWOOD;

    }
}

