/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class JobLivestockFarmer
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112209988279141L;
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private ArrayList<IInventory> farmChests = new ArrayList();
    EntityAnimal redShirt = null;

    public JobLivestockFarmer() {
    }

    public JobLivestockFarmer(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, FolkData.GotoMethod.BEAM);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.WAITINGFORMATUREANIMAL) {
            this.runDelay = 20000;
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATFARM) {
                this.stageArrived();
            } else if (this.theStage == Stage.WAITINGFORMATUREANIMAL) {
                this.stageWaiting();
            } else if (this.theStage == Stage.SLAUGHTERING) {
                this.stageSlaughtering();
            } else if (this.theStage == Stage.CANTWORK) {
                this.stageCantWork();
            }
        }
    }

    private void stageArrived() {
        this.vocation = this.theFolk.vocation;
        this.theStage = Stage.WAITINGFORMATUREANIMAL;
        this.theFolk.statusText = "\u5728\u519c\u573a\u5f00\u59cb\u5de5\u4f5c";
        int count = 0;
        if (this.vocation == Job.Vocation.CATTLEFARMER) {
            count = this.getAnimalCountInPen(this.theFolk.employedAt, EntityCow.class);
            if (count < 2) {
                this.spawnAnimals(this.theFolk.employedAt, "\u725b", 6 - count);
            }
        } else if (this.vocation == Job.Vocation.CHICKENFARMER) {
            count = this.getAnimalCountInPen(this.theFolk.employedAt, EntityChicken.class);
            if (count < 2) {
                this.spawnAnimals(this.theFolk.employedAt, "\u9e21", 6 - count);
            }
        } else if (this.vocation == Job.Vocation.PIGFARMER && (count = this.getAnimalCountInPen(this.theFolk.employedAt, EntityPig.class)) < 2) {
            this.spawnAnimals(this.theFolk.employedAt, "\u732a", 6 - count);
        }
    }

    private void stageWaiting() {
        this.vocation = this.theFolk.vocation;
        this.theFolk.updateLocationFromEntity();
        double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist > 10.0) {
            this.theFolk.beamMeTo(this.theFolk.employedAt);
        }
        List list = null;
        if (this.vocation == Job.Vocation.CATTLEFARMER) {
            this.theFolk.statusText = "\u9972\u517b\u725b";
            list = this.jobWorld.func_72872_a(EntityCow.class, AxisAlignedBB.func_72330_a((double)this.theFolk.employedAt.x, (double)this.theFolk.employedAt.y, (double)this.theFolk.employedAt.z, (double)(this.theFolk.employedAt.x + 1.0), (double)(this.theFolk.employedAt.y + 1.0), (double)(this.theFolk.employedAt.z + 1.0)).func_72314_b(4.0, 2.0, 4.0));
        } else if (this.vocation == Job.Vocation.CHICKENFARMER) {
            this.theFolk.statusText = "\u9972\u517b\u9e21";
            list = this.jobWorld.func_72872_a(EntityChicken.class, AxisAlignedBB.func_72330_a((double)this.theFolk.employedAt.x, (double)this.theFolk.employedAt.y, (double)this.theFolk.employedAt.z, (double)(this.theFolk.employedAt.x + 1.0), (double)(this.theFolk.employedAt.y + 1.0), (double)(this.theFolk.employedAt.z + 1.0)).func_72314_b(4.0, 2.0, 4.0));
        } else if (this.vocation == Job.Vocation.PIGFARMER) {
            this.theFolk.statusText = "\u5582\u732a";
            list = this.jobWorld.func_72872_a(EntityPig.class, AxisAlignedBB.func_72330_a((double)this.theFolk.employedAt.x, (double)this.theFolk.employedAt.y, (double)this.theFolk.employedAt.z, (double)(this.theFolk.employedAt.x + 1.0), (double)(this.theFolk.employedAt.y + 1.0), (double)(this.theFolk.employedAt.z + 1.0)).func_72314_b(4.0, 2.0, 4.0));
        }
        int adultCount = 0;
        EntityAnimal animal = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                animal = (EntityAnimal)list.get(i);
                if (animal.func_70631_g_()) continue;
                ++adultCount;
                this.redShirt = animal;
            }
        } else {
            return;
        }
        if (adultCount > 2) {
            this.theStage = Stage.SLAUGHTERING;
        } else if (adultCount <= 2 && list.size() < 10) {
            EntityAnimal a1 = null;
            EntityAnimal a2 = null;
            for (int i = 0; i < list.size(); ++i) {
                animal = (EntityAnimal)list.get(i);
                if (animal.func_70631_g_()) continue;
                if (a1 == null) {
                    a1 = animal;
                    continue;
                }
                if (a2 != null) continue;
                a2 = animal;
            }
            if (a1 != null && a2 != null) {
                a2.func_70778_a(this.jobWorld.func_72865_a((Entity)a2, (Entity)a1, 20.0f, true, true, true, true));
                this.procreate(a1, new CommonProxy.V3(a1.field_70165_t, a1.field_70163_u, a1.field_70161_v, this.theFolk.location.theDimension));
            }
            this.theStage = Stage.WAITINGFORMATUREANIMAL;
            this.theFolk.statusText = "\u8019\u7caa";
        }
    }

    private void stageSlaughtering() {
        Random rand = new Random();
        this.theFolk.statusText = "\u4e3a\u4e86\u90e8\u843d\uff0c\u780d\u6389\u4ed6\u4eec\u7684\u5934\uff01";
        if (this.theFolk.theEntity != null) {
            this.theFolk.theEntity.func_70625_a((Entity)this.redShirt, 1.0f, 1.0f);
        }
        this.redShirt.func_70606_j(0.0f);
        this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        int quant = 0;
        this.farmChests = JobLivestockFarmer.inventoriesFindClosest(this.theFolk.employedAt, 5);
        boolean ok = true;
        if (this.vocation == Job.Vocation.CATTLEFARMER) {
            quant = rand.nextInt(2) + 1;
            ok = this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151082_bd, quant, 0), true);
            this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151116_aA, 1, 0), false);
        } else if (this.vocation == Job.Vocation.PIGFARMER) {
            quant = rand.nextInt(2) + 1;
            ok = this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151147_al, quant, 0), true);
        } else if (this.vocation == Job.Vocation.CHICKENFARMER) {
            quant = rand.nextInt(2) + 1;
            ok = this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151076_bf, quant, 0), true);
            this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151008_G, 1, 0), false);
        }
        if (!ok) {
            this.theStage = Stage.CANTWORK;
            SimukraftReloaded.sendChat(this.theFolk.name + "\u755c\u7267\u573a\u7684\u7bb1\u5b50\u6ee1\u4e86\uff01");
            return;
        }
        SimukraftReloaded.states.credits -= 0.02f * (float)quant;
        this.theStage = Stage.WAITINGFORMATUREANIMAL;
    }

    private void stageCantWork() {
        this.theFolk.statusText = " \u7bb1\u5b50\u6ee1\u4e86\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5de5\u4f5c\uff01";
    }

    private void procreate(EntityAnimal parentAnimal, CommonProxy.V3 pos) {
        EntityAgeable babyAnimal = parentAnimal.func_90011_a((EntityAgeable)parentAnimal);
        Random rand = new Random();
        if (babyAnimal != null) {
            parentAnimal.func_90011_a(babyAnimal);
            babyAnimal.func_70873_a(-3000);
            babyAnimal.func_70012_b(parentAnimal.field_70165_t, parentAnimal.field_70163_u, parentAnimal.field_70161_v, parentAnimal.field_70177_z, parentAnimal.field_70125_A);
            for (int var3 = 0; var3 < 7; ++var3) {
                double d = rand.nextGaussian() * 0.02;
                double d1 = rand.nextGaussian() * 0.02;
                double d2 = rand.nextGaussian() * 0.02;
                this.mc.field_71441_e.func_72869_a("heart", pos.x + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0, pos.y + 0.5 + (double)(rand.nextFloat() * 1.0f), pos.z + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0, d, d1, d2);
            }
            parentAnimal.field_70170_p.func_72838_d((Entity)babyAnimal);
        }
    }

    private void spawnAnimals(CommonProxy.V3 controlBox, String animal, int count) {
        EntityPig newAnimal = null;
        for (int c = 1; c <= count; ++c) {
            if (animal.contentEquals("\u732a")) {
                newAnimal = new EntityPig(this.jobWorld);
            } else if (animal.contentEquals("\u725b")) {
                newAnimal = new EntityCow(this.jobWorld);
            } else if (animal.contentEquals("\u9e21")) {
                newAnimal = new EntityChicken(this.jobWorld);
            }
            newAnimal.func_70012_b(controlBox.x.doubleValue(), controlBox.y + 1.0, controlBox.z.doubleValue(), 0.0f, 0.0f);
            if (this.jobWorld.field_72995_K) continue;
            this.jobWorld.func_72838_d((Entity)newAnimal);
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u5230\u8fbe\u519c\u573a";
            this.theStage = Stage.ARRIVEDATFARM;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATFARM,
        WAITINGFORMATUREANIMAL,
        SLAUGHTERING,
        CANTWORK;

    }
}

