/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.blocks.functionality.FarmingBox;
import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class JobGrocer
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177119265904279141L;
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient float pay = 0.0f;
    private transient ArrayList<IInventory> grocerChests = new ArrayList();
    private transient ArrayList<IInventory> farmChests = new ArrayList();
    private transient int currentFarmNum = 0;
    private transient FarmingBox farm = null;
    private transient boolean onRoute = false;

    public JobGrocer() {
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    public JobGrocer(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.ARRIVEDATSHOP) {
            this.runDelay = 10000;
            this.theFolk.action = FolkData.FolkAction.ATWORK;
        }
        if (this.theStage == Stage.COLLECTINGFOOD) {
            this.runDelay = 4000;
        }
        if (this.theStage == Stage.SELLINGFOOD) {
            this.runDelay = 10000;
            this.theFolk.action = FolkData.FolkAction.ATWORK;
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATSHOP) {
                this.stageArrived();
            } else if (this.theStage == Stage.GOINGTOFOODFARM) {
                this.stageGoingToFoodFarm();
            } else if (this.theStage == Stage.COLLECTINGFOOD) {
                this.stageCollectingFood();
            } else if (this.theStage == Stage.GOBACKTOSTORE) {
                this.stageGoBackToStore();
            } else if (this.theStage == Stage.SELLINGFOOD) {
                this.stageSellingFood();
            }
        }
    }

    private void stageArrived() {
        this.currentFarmNum = 0;
        this.theFolk.stayPut = true;
        this.theStage = Stage.GOINGTOFOODFARM;
    }

    private void stageGoingToFoodFarm() {
        this.theFolk.statusText = "\u83b7\u53d6\u6765\u81ea\u519c\u573a\u7684\u65b0\u9c9c\u98df\u54c1";
        if (!this.onRoute) {
            this.farm = this.getCurrentFarm();
            if (this.farm == null) {
                this.theStage = Stage.GOBACKTOSTORE;
            } else {
                this.onRoute = true;
                this.theFolk.gotoXYZ(this.farm.getLocation(), null);
            }
        } else {
            double dist = 0.0;
            try {
                if (this.theFolk.gotoMethod == FolkData.GotoMethod.WALK) {
                    this.theFolk.updateLocationFromEntity();
                }
                dist = this.theFolk.location.getDistanceTo(this.farm.location);
            }
            catch (Exception e) {
                this.theStage = Stage.GOBACKTOSTORE;
            }
            if (dist < 3.0) {
                if (this.theFolk.theEntity != null) {
                    this.theFolk.theEntity.field_70159_w = 0.0;
                    this.theFolk.theEntity.field_70179_y = 0.0;
                }
                this.onRoute = false;
                this.theStage = Stage.COLLECTINGFOOD;
                this.step = 1;
                this.theFolk.stayPut = true;
                return;
            }
            if (this.theFolk.destination == null) {
                this.onRoute = false;
            }
        }
    }

    private void stageCollectingFood() {
        this.theFolk.statusText = "Collecting Fresh Food";
        if (this.step == 1) {
            if (this.farm == null) {
                this.theStage = Stage.GOINGTOFOODFARM;
                return;
            }
            this.farmChests = JobGrocer.inventoriesFindClosest(this.farm.getLocation(), 5);
            if (this.farmChests.size() > 0) {
                this.theFolk.stayPut = true;
                this.farmChests.get(0).func_70295_k_();
                this.step = 2;
            }
        } else if (this.step == 2) {
            this.inventoriesTransferToFolk(this.theFolk.inventory, this.farmChests, new ItemStack(Items.field_151127_ba, 640));
            this.inventoriesTransferToFolk(this.theFolk.inventory, this.farmChests, new ItemStack(Blocks.field_150423_aK, 640));
            this.inventoriesTransferToFolk(this.theFolk.inventory, this.farmChests, new ItemStack(Items.field_151172_bF, 640));
            this.inventoriesTransferToFolk(this.theFolk.inventory, this.farmChests, new ItemStack(Items.field_151174_bG, 640));
            this.step = 3;
        } else if (this.step == 3) {
            this.farmChests.get(0).func_70305_f();
            this.theStage = Stage.GOINGTOFOODFARM;
        }
    }

    private void stageGoBackToStore() {
        this.theFolk.statusText = "Taking fresh food back to store";
        if (!this.onRoute) {
            this.onRoute = true;
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        } else {
            double dist;
            if (this.theFolk.gotoMethod == FolkData.GotoMethod.WALK) {
                this.theFolk.updateLocationFromEntity();
            }
            if ((dist = (double)this.theFolk.location.getDistanceTo(this.theFolk.employedAt)) <= 1.0) {
                if (this.theFolk.theEntity != null) {
                    this.theFolk.theEntity.field_70159_w = 0.0;
                    this.theFolk.theEntity.field_70179_y = 0.0;
                }
                this.onRoute = false;
                this.theStage = Stage.SELLINGFOOD;
                this.step = 1;
                this.theFolk.stayPut = true;
                return;
            }
            if (this.theFolk.destination == null) {
                this.onRoute = false;
            }
        }
    }

    private void stageSellingFood() {
        this.grocerChests = JobGrocer.inventoriesFindClosest(this.theFolk.employedAt, 5);
        if (this.step == 1) {
            this.theFolk.statusText = "\u5378\u65b0\u9c9c\u98df\u54c1";
            int pumpkins = this.getInventoryCount(this.theFolk, Blocks.field_150423_aK);
            int melons = this.getInventoryCount(this.theFolk, Items.field_151127_ba);
            int carrots = this.getInventoryCount(this.theFolk, Items.field_151172_bF);
            int potatoes = this.getInventoryCount(this.theFolk, Items.field_151174_bG);
            this.pay = (float)((double)pumpkins * 0.2);
            this.pay += (float)((double)melons * 0.05);
            this.pay += (float)((double)carrots * 0.05);
            this.pay += (float)((double)potatoes * 0.05);
            this.inventoriesTransferFromFolk(this.theFolk.inventory, this.grocerChests, null);
            SimukraftReloaded.states.credits -= this.pay;
            this.step = 2;
        } else if (this.step == 2) {
            this.theFolk.updateLocationFromEntity();
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist > 2 && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
            this.theFolk.statusText = "\u9500\u552e\u65b0\u9c9c\u98df\u54c1";
            if (MinecraftServer.func_71276_C().field_71305_c[0].func_72820_D() % 24000L > 11600L) {
                this.step = 3;
            }
        } else if (this.step == 3) {
            this.theFolk.statusText = "Closing the shop";
            int sell = 0;
            ItemStack piece = null;
            block2: for (int f = 0; f < SimukraftReloaded.theFolks.size(); ++f) {
                for (int c = 0; c < this.grocerChests.size(); ++c) {
                    IInventory chest = this.grocerChests.get(c);
                    for (int g = 0; g < chest.func_70302_i_(); ++g) {
                        ItemStack chestStack = chest.func_70301_a(g);
                        try {
                            int count = new Random().nextInt(3) + 1;
                            ItemFood food = (ItemFood)chestStack.func_77973_b();
                            piece = JobGrocer.inventoriesGet(this.grocerChests, new ItemStack(chestStack.func_77973_b(), count), false, false);
                            FolkData folk = SimukraftReloaded.theFolks.get(f);
                            folk.levelFood = 10;
                            sell += count;
                            continue block2;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                }
            }
            if (sell > 0) {
                SimukraftReloaded.sendChat(this.theFolk.name + "(\u98df\u54c1 )\u4eca\u5929\u5356\u51fa " + sell + " \u4e2a\u7ed9\u987e\u5ba2\u3002");
            } else {
                SimukraftReloaded.sendChat(this.theFolk.name + " \u4eca\u5929\u6ca1\u6709\u5356\u519c\u4ea7\u54c1\u7ed9\u987e\u5ba2\u3002");
            }
            this.step = 4;
        } else if (this.step == 4) {
            // empty if block
        }
    }

    private FarmingBox getCurrentFarm() {
        boolean found = false;
        FarmingBox farm = null;
        while (!found) {
            try {
                farm = SimukraftReloaded.theFarmingBoxes.get(this.currentFarmNum);
            }
            catch (Exception e) {
                return null;
            }
            if (farm == null) {
                return null;
            }
            if (farm.farmType == FarmingBox.FarmType.MELON || farm.farmType == FarmingBox.FarmType.PUMPKIN || farm.farmType == FarmingBox.FarmType.CARROT || farm.farmType == FarmingBox.FarmType.POTATO) {
                found = true;
                ++this.currentFarmNum;
                return farm;
            }
            ++this.currentFarmNum;
            if (this.currentFarmNum <= SimukraftReloaded.theFarmingBoxes.size() - 1) continue;
            return null;
        }
        return null;
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u62b5\u8fbe\u5546\u5e97";
            this.theStage = Stage.ARRIVEDATSHOP;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATSHOP,
        GOINGTOFOODFARM,
        COLLECTINGFOOD,
        GOBACKTOSTORE,
        SELLINGFOOD;

    }
}

