/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobFisherman
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112207254191941L;
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient long timeSinceLastCaughtFish = 0L;
    private transient int fishCount = 0;
    private transient ArrayList<IInventory> dockChests = new ArrayList();

    public JobFisherman(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        this.runDelay = this.theStage == Stage.CAUGHTFISH ? 20000 + new Random().nextInt(20000) : 2000;
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATDOCK) {
                this.stageArrived();
            } else if (this.theStage == Stage.FISHING) {
                this.stageFishing();
            } else if (this.theStage == Stage.CAUGHTFISH) {
                this.stageCaughtFish();
            } else if (this.theStage == Stage.SELLINGFISH) {
                this.stageSellingFish();
            } else if (this.theStage == Stage.CANTWORK) {
                this.stageCantWork();
            }
        }
    }

    private void stageArrived() {
        CommonProxy.V3 water = Job.findClosestBlockType(this.theFolk.employedAt, Blocks.field_150355_j, 5, false);
        if (water == null) {
            this.theStage = Stage.CANTWORK;
            SimukraftReloaded.sendChat(this.theFolk.name + " (\u6e14\u592b)\u8fd9\u4e2a\u533a\u57df\u6ca1\u6709\u9c7c\u53ef\u4ee5\u9493\uff01");
        } else {
            this.theStage = Stage.FISHING;
            this.theFolk.statusText = "Casting out my line";
            this.fishCount = 0;
            if (!this.jobWorld.field_72995_K) {
                // empty if block
            }
        }
    }

    private void stageCantWork() {
        this.theFolk.statusText = "\u8fd9\u91cc\u6ca1\u6709\u9c7c\uff01";
    }

    private void stageFishing() {
        this.theFolk.updateLocationFromEntity();
        int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist > 3) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            return;
        }
        this.theFolk.stayPut = true;
        this.theFolk.statusText = "\u5782\u9493\u4e2d";
        if (System.currentTimeMillis() - this.timeSinceLastCaughtFish > 50000L) {
            this.theStage = Stage.CAUGHTFISH;
        }
        if (this.mc.func_71401_C().field_71305_c[0].func_72820_D() % 24000L > 11980L) {
            this.theStage = Stage.SELLINGFISH;
            this.step = 1;
        }
    }

    private void stageCaughtFish() {
        this.timeSinceLastCaughtFish = System.currentTimeMillis();
        this.theFolk.statusText = "\u8036\uff01\u9493\u4e86\u4e00\u6761\u9c7c\u4e86";
        ++this.fishCount;
        SimukraftReloaded.states.credits -= 0.02f;
        this.dockChests = JobFisherman.inventoriesFindClosest(this.theFolk.employedAt, 4);
        if (this.dockChests.size() == 0) {
            this.theFolk.statusText = "\u8be5\u6b7b\u7684\uff01\u6709\u4eba\u4ece\u7bb1\u5b50\u91cc\u5077\u4e86\u6211\u9c7c\uff01";
            SimukraftReloaded.sendChat(this.theFolk.name + "\uff08\u6e14\u592b\uff09\u65e0\u6cd5\u627e\u5230\u4efb\u4f55\u9493\u9c7c\u7801\u5934\uff01");
            if (this.theFolk.theEntity != null) {
                this.theFolk.theEntity.func_145779_a(Items.field_151115_aP, 1);
            }
        } else {
            this.inventoriesPut(this.dockChests, new ItemStack(Items.field_151115_aP, 1), true);
        }
        this.theStage = Stage.FISHING;
        this.theFolk.updateLocationFromEntity();
        int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist > 3) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            return;
        }
        this.theFolk.stayPut = true;
    }

    private void stageSellingFish() {
        if (this.mc.func_71401_C().field_71305_c[0].func_72820_D() % 24000L < 11600L) {
            this.theStage = Stage.IDLE;
            return;
        }
        this.theFolk.statusText = "\u6293\u4f4f\u4e86\uff01\u6240\u505a\u7684\u4e00\u5207\u90fd\u662f\u4e3a\u4e86\u4eca\u5929" + this.fishCount + " \u9c7c\uff01";
        if (this.step == 1) {
            int \u5356 = 0;
            ItemStack fishStack = null;
            if (SimukraftReloaded.theFolks.size() > 1) {
                \u5356 = SimukraftReloaded.theFolks.size() + 1;
                this.dockChests = JobFisherman.inventoriesFindClosest(this.theFolk.employedAt, 4);
                fishStack = JobFisherman.inventoriesGet(this.dockChests, new ItemStack(Items.field_151115_aP, \u5356), false, false);
            }
            if (fishStack == null) {
                this.theStage = Stage.IDLE;
                return;
            }
            SimukraftReloaded.sendChat(this.theFolk.name + " \u6293" + this.fishCount + " \u4eca\u5929\u5df2\u7ecf\u5356\u7ed9\u987e\u5ba2" + fishStack.field_77994_a + " \u6761\u9c7c");
            for (int f = 0; f < SimukraftReloaded.theFolks.size(); ++f) {
                FolkData folk = SimukraftReloaded.theFolks.get(f);
                if (fishStack.field_77994_a <= 0) continue;
                folk.levelFood = 10;
                --fishStack.field_77994_a;
            }
            this.step = 2;
        } else if (this.step == 2) {
            // empty if block
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u5230\u8fbe\u7801\u5934";
            this.theStage = Stage.ARRIVEDATDOCK;
            this.timeSinceLastCaughtFish = System.currentTimeMillis();
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
        this.fishCount = 0;
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATDOCK,
        FISHING,
        CAUGHTFISH,
        SELLINGFISH,
        CANTWORK;

    }
}

