/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobEggFarmer
extends Job {
    public Job.Vocation vocation = null;
    public Stage theStage;
    public FolkData theFolk;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private ArrayList<IInventory> farmChests = new ArrayList();

    public JobEggFarmer(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        this.runDelay = this.theStage == Stage.FEEDINGCHICKENS ? 40000 : 10000;
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATFARM) {
                this.stageArrived();
            } else if (this.theStage == Stage.FEEDINGCHICKENS) {
                this.stageWaiting();
            } else if (this.theStage == Stage.COLLECTINGEGGS) {
                this.stageCollectingEggs();
            } else if (this.theStage == Stage.STORINGEGGS) {
                this.stageStoringEggs();
            } else if (this.theStage == Stage.CANTWORK) {
                this.stageCantWork();
            }
        }
    }

    private void stageArrived() {
        this.vocation = this.theFolk.vocation;
        this.theStage = Stage.FEEDINGCHICKENS;
        this.theFolk.statusText = "Feeding Chickens";
        int count = 0;
        count = this.getAnimalCountInPen(this.theFolk.employedAt, EntityChicken.class);
        if (count < 6) {
            this.spawnHens(this.theFolk.employedAt, 6 - count);
        }
    }

    private void stageWaiting() {
        this.theFolk.updateLocationFromEntity();
        double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist > 10.0) {
            this.theFolk.beamMeTo(this.theFolk.employedAt);
        }
        this.theFolk.statusText = "\u8019\u7caa";
        this.theStage = Stage.COLLECTINGEGGS;
    }

    private void stageCollectingEggs() {
        this.theFolk.statusText = "\u6536\u96c6\u9e21\u86cb";
        this.theStage = Stage.STORINGEGGS;
        this.theFolk.isWorking = true;
    }

    private void stageStoringEggs() {
        Random rand = new Random();
        int c = rand.nextInt(7);
        this.theFolk.statusText = "\u7528\u51b7\u85cf\u65b9\u5f0f\u4fdd\u5b58\u9e21\u86cb";
        this.theFolk.isWorking = false;
        this.farmChests = JobEggFarmer.inventoriesFindClosest(this.theFolk.employedAt, 5);
        if (this.farmChests.size() > 0) {
            boolean ok = this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151110_aK, c + 1, 0), true);
            if (!ok) {
                SimukraftReloaded.sendChat(this.theFolk.name + "\u9e21\u86cb\u519c\u573a\u7684\u7bb1\u5b50\u88c5\u6ee1\u86cb\uff01");
                this.theFolk.statusText = "\u7bb1\u5b50\u6ee1\u4e86\u4e0d\u80fd\u7ee7\u7eed\u5de5\u4f5c\uff01";
                this.theStage = Stage.CANTWORK;
            } else {
                SimukraftReloaded.states.credits -= 0.05f;
                this.theStage = Stage.FEEDINGCHICKENS;
            }
        } else {
            this.theFolk.statusText = "\u8c01\u5077\u4e86\u6211\u7684\u86cb\uff01";
            this.theStage = Stage.CANTWORK;
        }
    }

    private void stageCantWork() {
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u5230\u8fbe\u519c\u573a";
            this.theStage = Stage.ARRIVEDATFARM;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    private void spawnHens(CommonProxy.V3 controlBox, int count) {
        EntityChicken newAnimal = null;
        for (int c = 1; c <= count; ++c) {
            newAnimal = new EntityChicken(this.jobWorld);
            newAnimal.func_70012_b(controlBox.x + 1.0, controlBox.y + 1.0, controlBox.z.doubleValue(), 0.0f, 0.0f);
            if (this.jobWorld.field_72995_K) continue;
            this.jobWorld.func_72838_d((Entity)newAnimal);
        }
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATFARM,
        FEEDINGCHICKENS,
        COLLECTINGEGGS,
        STORINGEGGS,
        CANTWORK;

    }
}

