/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobDairyFarmer
extends Job {
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private ArrayList<IInventory> farmChests = new ArrayList();
    private String[] cowNames = new String[6];

    public JobDairyFarmer(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, FolkData.GotoMethod.BEAM);
        }
    }

    private void createCowNames() {
        for (int i = 0; i < 6; ++i) {
            this.cowNames[i] = FolkData.generateName(1, true, "");
        }
    }

    @Override
    public void onUpdate() {
        if (this.cowNames[0] == null || this.cowNames[0].contentEquals("")) {
            this.createCowNames();
        }
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        this.runDelay = this.theStage == Stage.WAITINGFORMILKING ? 40000 : 10000;
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATFARM) {
                this.stageArrived();
            } else if (this.theStage == Stage.WAITINGFORMILKING) {
                this.stageWaiting();
            } else if (this.theStage == Stage.MILKING) {
                this.stageMilking();
            } else if (this.theStage == Stage.STORINGMILK) {
                this.stageStoringMilk();
            } else if (this.theStage == Stage.CANTWORK) {
                this.stageCantWork();
            }
        }
    }

    private void stageArrived() {
        this.vocation = this.theFolk.vocation;
        this.theStage = Stage.WAITINGFORMILKING;
        this.theFolk.statusText = "Warming up cow's udders";
        int count = 0;
        count = this.getAnimalCountInPen(this.theFolk.employedAt, EntityCow.class);
        if (count < 6) {
            this.spawnCows(this.theFolk.employedAt, 6 - count);
        }
    }

    private void stageWaiting() {
        this.theFolk.updateLocationFromEntity();
        double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist > 10.0) {
            this.theFolk.beamMeTo(this.theFolk.employedAt);
        }
        this.theFolk.statusText = "\u6d88\u6bd2\u7a7a\u6876";
        this.theStage = Stage.MILKING;
    }

    private void stageMilking() {
        Random rand = new Random();
        int c = rand.nextInt(6);
        this.theFolk.statusText = "\u6324\u5976" + this.cowNames[c] + " \u725b";
        this.theStage = Stage.STORINGMILK;
        this.theFolk.isWorking = true;
    }

    private void stageStoringMilk() {
        this.theFolk.statusText = "\u7528\u51b7\u85cf\u7684\u65b9\u5f0f\u4fdd\u5b58\u725b\u5976";
        this.theFolk.isWorking = false;
        this.farmChests = JobDairyFarmer.inventoriesFindClosest(this.theFolk.employedAt, 5);
        if (this.farmChests.size() > 0) {
            boolean ok = this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151117_aB, 1, 0), true);
            if (!ok) {
                SimukraftReloaded.sendChat(this.theFolk.name + "\u5976\u725b\u573a\u7684\u7bb1\u5b50\u88c5\u6ee1\u4e86\u725b\u5976\uff01");
                this.theFolk.statusText = "\u7bb1\u5b50\u5df2\u6ee1\u65e0\u6cd5\u7ee7\u7eed\u5de5\u4f5c\uff01";
                this.theStage = Stage.CANTWORK;
            } else {
                SimukraftReloaded.states.credits -= 0.05f;
                this.theStage = Stage.WAITINGFORMILKING;
            }
        } else {
            this.theFolk.statusText = "Who stole my dairy chests!";
            this.theStage = Stage.CANTWORK;
        }
    }

    private void stageCantWork() {
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u5230\u8fbe\u519c\u573a";
            this.theStage = Stage.ARRIVEDATFARM;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    private void spawnCows(CommonProxy.V3 controlBox, int count) {
        EntityCow newAnimal = null;
        for (int c = 1; c <= count; ++c) {
            newAnimal = new EntityCow(this.jobWorld);
            newAnimal.func_70012_b(controlBox.x + 1.0, controlBox.y + 1.0, controlBox.z.doubleValue(), 0.0f, 0.0f);
            if (this.jobWorld.field_72995_K) continue;
            this.jobWorld.func_72838_d((Entity)newAnimal);
        }
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATFARM,
        WAITINGFORMILKING,
        MILKING,
        STORINGMILK,
        CANTWORK;

    }
}

