/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.blocks.functionality.FarmingBox;
import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.game.GameMode;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class JobCropFarmer
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112214234279141L;
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient boolean doneSomeWork = false;
    private transient FarmingBox farmingBlock = null;
    private transient ArrayList<IInventory> farmingChests = new ArrayList();
    private transient String farmDir = "";
    private transient int ftbCount = 0;
    private transient int ltrCount = 0;
    private transient int xo = 0;
    private transient int zo = 0;
    private transient Block id = null;
    private transient int mx;
    private transient int my;
    private transient int mz;
    private transient int xxx = 0;
    private transient int yyy = 0;
    private transient int zzz = 0;
    private transient int ftb = 1;
    private transient int ltr = -1;
    private transient int meta = 0;
    private transient long lastFarmCycle = 0L;
    private transient long lastCustomHarvest = 0L;
    private transient int rowCounter = 0;

    public JobCropFarmer() {
    }

    public JobCropFarmer(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
        this.farmingBlock = FarmingBox.getFarmingBlockByBoxXYZ(folk.employedAt);
        this.runDelay = 1000;
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
        this.theFolk.isWorking = false;
    }

    @Override
    public void onUpdate() {
        if (SimukraftReloaded.theFarmingBoxes.size() == 0) {
            return;
        }
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.CHECKINGFORCHESTS) {
            this.runDelay = 1000;
        }
        if (this.theStage == Stage.HARVEST || this.theStage == Stage.HOELAND || this.theStage == Stage.PLANTSEEDS) {
            this.runDelay = 500;
        }
        if (this.theStage == Stage.HANGOUT) {
            this.runDelay = this.step == 1 ? 1000 : 60000;
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATFARM) {
                this.theStage = Stage.CHECKINGFORCHESTS;
            } else if (this.theStage == Stage.CHECKINGFORCHESTS) {
                this.stageCheckingForChests();
            } else if (this.theStage == Stage.HARVEST) {
                this.stageHarvest();
            } else if (this.theStage == Stage.HOELAND) {
                this.stageHoeland();
            } else if (this.theStage == Stage.PLANTSEEDS) {
                this.stagePlantSeeds();
            } else if (this.theStage == Stage.HANGOUT) {
                this.stageHangout();
            }
        }
    }

    public void stageCheckingForChests() {
        if (this.farmingChests.isEmpty()) {
            this.farmingChests = JobCropFarmer.inventoriesFindClosest(this.theFolk.employedAt, 5);
        }
        SimukraftReloaded.log.info("JobCropFarmer: found " + this.farmingChests.size() + " chests at the farm");
        this.theFolk.stayPut = true;
        int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist > 3) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
        if (this.farmingChests.isEmpty()) {
            this.theFolk.statusText = "\u81f3\u5c11\u9644\u8fd1\u6709\u4e00\u4e2a\u517b\u6b96\u7bb1";
        } else {
            this.theStage = Stage.HARVEST;
            this.step = 1;
            this.theFolk.stayPut = true;
            if (this.theFolk.gender == 0) {
                this.jobWorld.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "ashjacksimukraftreloaded:readym", 1.0f, 1.0f, false);
            } else {
                this.jobWorld.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "ashjacksimukraftreloaded:readyf", 1.0f, 1.0f, false);
            }
        }
    }

    private void setupFarming() {
        this.ftb = 0;
        this.ltr = -1;
        if (this.farmingBlock == null) {
            SimukraftReloaded.log.warning("JobCropFarmer: FarmingBlock is null - not there or not found?!");
            return;
        }
        CommonProxy.V3 m1 = this.farmingBlock.marker1XYZ;
        CommonProxy.V3 m2 = this.farmingBlock.marker2XYZ;
        CommonProxy.V3 m3 = this.farmingBlock.marker3XYZ;
        if (this.farmingBlock.marker1XYZ == null) {
            SimukraftReloaded.log.warning("JobCropFarmer: FarmingBlock's markers are null");
            return;
        }
        try {
            this.mx = m1.x.intValue();
            this.my = m1.y.intValue() - 1;
            this.mz = m1.z.intValue();
            int m2x = m2.x.intValue();
            int m1x = m1.x.intValue();
            int m2z = m2.z.intValue();
            int m1z = m1.z.intValue();
            if (m2x == m1x) {
                this.farmDir = m2z > this.mz ? "z+" : "z-";
            } else if (m2z == m1z) {
                this.farmDir = m2x > this.mx ? "x+" : "x-";
            }
            this.ltrCount = this.farmingBlock.getSizeWidth();
            this.ftbCount = this.farmingBlock.getSizeLength();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private boolean setXYZ() {
        boolean ret = false;
        ++this.ltr;
        if (this.ltr > this.ltrCount + 1) {
            this.ltr = 0;
            ++this.ftb;
            if (this.ftb > this.ftbCount + 1) {
                ret = true;
            }
        }
        if (this.farmDir.contentEquals("x+")) {
            this.xo = this.ltr;
            this.zo = -this.ftb;
        } else if (this.farmDir.contentEquals("x-")) {
            this.xo = -this.ltr;
            this.zo = this.ftb;
        } else if (this.farmDir.contentEquals("z+")) {
            this.xo = this.ftb;
            this.zo = this.ltr;
        } else if (this.farmDir.contentEquals("z-")) {
            this.xo = -this.ftb;
            this.zo = -this.ltr;
        }
        try {
            this.xxx = this.mx + this.xo;
            this.yyy = this.farmingBlock.location.y.intValue();
            this.zzz = this.mz + this.zo;
        }
        catch (Exception e) {
            SimukraftReloaded.sendChat("\u8fd8\u6709\u4e00\u4e2a\u95ee\u9898" + this.theFolk.name + "\u7684\u517b\u6b96\u7bb1\uff0c\u8bf7\u66f4\u6362\u5427\uff01");
            this.theFolk.selfFire();
            return false;
        }
        return ret;
    }

    public void stageHarvest() {
        if (this.farmingBlock == null || this.farmingBlock.farmType == null) {
            SimukraftReloaded.sendChat("\u519c\u4e1a\u76d2\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u6446\u653e");
            if (this.theFolk != null) {
                this.theFolk.selfFire();
            }
        }
        if (this.step == 1) {
            this.setupFarming();
            this.theFolk.statusText = "\u6536\u83b7";
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist > 3) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
            this.step = 2;
            this.theFolk.isWorking = true;
        } else if (this.step == 2) {
            boolean done = this.setXYZ();
            boolean hasHarvest = false;
            if (!done) {
                while (!hasHarvest) {
                    this.id = this.jobWorld.func_147439_a(this.xxx, this.yyy, this.zzz);
                    this.meta = this.jobWorld.func_72805_g(this.xxx, this.yyy, this.zzz);
                    try {
                        if (!this.theFolk.isSpawned() && this.farmingBlock.farmType != FarmingBox.FarmType.CUSTOM && this.farmingBlock.farmType != FarmingBox.FarmType.SUGAR && this.farmingBlock.farmType != FarmingBox.FarmType.CACTUS && this.meta < 7) {
                            ++this.meta;
                            this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, this.id, this.meta, 3);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    boolean canHarvest = false;
                    CommonProxy.V3 harvestBlock = new CommonProxy.V3(Double.valueOf(this.xxx), Double.valueOf(this.yyy), Double.valueOf(this.zzz), this.jobWorld.field_73011_w.field_76574_g);
                    ArrayList<ItemStack> minedStacks = this.translateBlockWhenMined(this.jobWorld, harvestBlock);
                    if (this.farmingBlock.farmType == FarmingBox.FarmType.SUGAR || this.farmingBlock.farmType == FarmingBox.FarmType.CACTUS) {
                        Block sid1 = this.jobWorld.func_147439_a(this.xxx, this.yyy + 1, this.zzz);
                        Block sid2 = this.jobWorld.func_147439_a(this.xxx, this.yyy + 2, this.zzz);
                        if (sid1 == Blocks.field_150436_aH && sid2 == Blocks.field_150436_aH) {
                            canHarvest = true;
                        }
                        if (sid1 == Blocks.field_150434_aF && sid2 == Blocks.field_150434_aF) {
                            canHarvest = true;
                        }
                    } else if (this.id == Blocks.field_150440_ba || this.id == Blocks.field_150423_aK || this.farmingBlock.farmType == FarmingBox.FarmType.CUSTOM || this.meta >= 7) {
                        if (this.id != Blocks.field_150393_bb && this.id != Blocks.field_150394_bc) {
                            canHarvest = true;
                        }
                        if (this.id == null) {
                            canHarvest = false;
                        }
                    }
                    if (canHarvest) {
                        if (this.farmingBlock.farmType == FarmingBox.FarmType.SUGAR || this.farmingBlock.farmType == FarmingBox.FarmType.CACTUS) {
                            this.farmingChests = JobCropFarmer.inventoriesFindClosest(this.theFolk.employedAt, 5);
                            this.jobWorld.func_147465_d(this.xxx, this.yyy + 1, this.zzz, this.id, 0, 3);
                            this.jobWorld.func_147465_d(this.xxx, this.yyy + 2, this.zzz, this.id, 0, 3);
                            if (this.farmingBlock.farmType == FarmingBox.FarmType.SUGAR) {
                                this.inventoriesPut(this.farmingChests, new ItemStack(Items.field_151120_aE, 2), false);
                            } else if (this.farmingBlock.farmType == FarmingBox.FarmType.CACTUS) {
                                this.inventoriesPut(this.farmingChests, new ItemStack(Blocks.field_150434_aF, 2), false);
                            }
                        } else if (this.farmingBlock.farmType != FarmingBox.FarmType.CUSTOM) {
                            if (minedStacks != null) {
                                this.farmingChests = JobCropFarmer.inventoriesFindClosest(this.theFolk.employedAt, 5);
                                for (int s = 0; s < minedStacks.size(); ++s) {
                                    ItemStack stack = minedStacks.get(s);
                                    if (stack == null) continue;
                                    this.inventoriesPut(this.farmingChests, stack, false);
                                }
                            }
                            this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, this.id, 0, 3);
                        } else {
                            if (System.currentTimeMillis() - this.lastCustomHarvest < 3600000L) {
                                this.theStage = Stage.HOELAND;
                                this.step = 1;
                                this.theFolk.isWorking = false;
                                return;
                            }
                            this.jobWorld.func_147480_a(this.xxx, this.yyy, this.zzz, true);
                            this.pickUpDroppedCrops(harvestBlock);
                        }
                        if (this.farmingBlock.farmType != FarmingBox.FarmType.CUSTOM) {
                            // empty if block
                        }
                        SimukraftReloaded.states.credits -= 0.02f;
                        this.doneSomeWork = true;
                        hasHarvest = true;
                        continue;
                    }
                    hasHarvest = false;
                    done = this.setXYZ();
                    if (!done) continue;
                    this.theStage = Stage.HOELAND;
                    this.step = 1;
                    this.theFolk.isWorking = false;
                    return;
                }
            } else {
                this.theStage = Stage.HOELAND;
                this.step = 1;
                this.theFolk.isWorking = false;
                this.lastCustomHarvest = System.currentTimeMillis();
                return;
            }
        }
    }

    private void pickUpDroppedCrops(CommonProxy.V3 v3center) {
        if (this.theFolk.theEntity == null) {
            return;
        }
        List list1 = this.jobWorld.func_72839_b((Entity)this.theFolk.theEntity, AxisAlignedBB.func_72330_a((double)v3center.x, (double)v3center.y, (double)v3center.z, (double)(v3center.x + 1.0), (double)(v3center.y + 1.0), (double)(v3center.z + 1.0)).func_72314_b(3.0, 2.0, 3.0));
        Iterator iterator1 = list1.iterator();
        if (!list1.isEmpty()) {
            while (iterator1.hasNext()) {
                Entity entity1 = (Entity)iterator1.next();
                if (!(entity1 instanceof EntityItem)) continue;
                EntityItem entityitem = (EntityItem)entity1;
                ItemStack is = entityitem.func_92059_d();
                try {
                    boolean ok;
                    ItemFood food = (ItemFood)is.func_77973_b();
                    if (food == null || !(ok = this.inventoriesPut(this.farmingChests, is, false))) continue;
                    entityitem.func_70106_y();
                }
                catch (Exception e) {}
            }
        }
    }

    public void stageHoeland() {
        if (this.step == 1) {
            this.setupFarming();
            this.theFolk.statusText = "Tilling the land";
            this.theFolk.stayPut = true;
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.step = 2;
            this.theFolk.isWorking = true;
            this.rowCounter = 0;
        } else if (this.step == 2) {
            boolean done = false;
            boolean hasTilled = false;
            while (!hasTilled && !done) {
                done = this.setXYZ();
                if (done) {
                    this.theStage = Stage.PLANTSEEDS;
                    this.step = 1;
                    return;
                }
                this.id = this.jobWorld.func_147439_a(this.xxx, this.yyy - 1, this.zzz);
                this.meta = this.mc.field_71441_e.func_72805_g(this.xxx, this.yyy - 1, this.zzz);
                if (this.farmingBlock.farmType == FarmingBox.FarmType.SUGAR) {
                    this.theFolk.statusText = "preparing the land";
                    if (this.rowCounter % 3 == 0 || (this.rowCounter + 1) % 3 == 0) {
                        if (this.id != Blocks.field_150346_d && this.id != Blocks.field_150349_c) {
                            this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150346_d, 0, 3);
                            this.jobWorld.func_72980_b((double)this.xxx, (double)(this.yyy - 1), (double)this.zzz, Blocks.field_150349_c.field_149762_H.func_150498_e(), 1.0f, 1.0f, false);
                            hasTilled = true;
                            SimukraftReloaded.states.credits -= 0.01f;
                        }
                    } else if ((this.rowCounter + 2) % 3 == 0 && this.id != Blocks.field_150355_j) {
                        this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150355_j, 0, 3);
                        hasTilled = true;
                        SimukraftReloaded.states.credits -= 0.01f;
                    }
                    ++this.rowCounter;
                    if (this.rowCounter > this.farmingBlock.getSizeWidth() + 1) {
                        this.rowCounter = 0;
                    }
                } else if (this.farmingBlock.farmType == FarmingBox.FarmType.CACTUS) {
                    this.theFolk.statusText = "preparing the land";
                    if ((this.xxx + this.zzz) % 2 == 0 && this.id != Blocks.field_150354_m) {
                        this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, (Block)Blocks.field_150354_m, 0, 3);
                        hasTilled = true;
                        SimukraftReloaded.states.credits -= 0.01f;
                    }
                } else if (!(this.id != Blocks.field_150349_c && this.id != Blocks.field_150346_d || (this.farmingBlock.farmType != FarmingBox.FarmType.MELON && this.farmingBlock.farmType != FarmingBox.FarmType.PUMPKIN || this.ftb % 4 != 0 && this.ftb % 4 != 1) && this.farmingBlock.farmType != FarmingBox.FarmType.WHEAT && this.farmingBlock.farmType != FarmingBox.FarmType.CARROT && this.farmingBlock.farmType != FarmingBox.FarmType.POTATO && this.farmingBlock.farmType != FarmingBox.FarmType.CUSTOM)) {
                    this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                    this.jobWorld.func_72980_b((double)this.xxx, (double)(this.yyy - 1), (double)this.zzz, Blocks.field_150349_c.field_149762_H.func_150498_e(), 1.0f, 1.0f, false);
                    hasTilled = true;
                    SimukraftReloaded.states.credits -= 0.01f;
                }
                if (!done) continue;
                this.theStage = Stage.PLANTSEEDS;
                this.step = 1;
                this.theFolk.isWorking = false;
                return;
            }
        }
    }

    public void stagePlantSeeds() {
        if (this.step == 1) {
            this.setupFarming();
            this.theFolk.stayPut = true;
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.step = 2;
            this.theFolk.isWorking = true;
        } else if (this.step == 2) {
            boolean done = false;
            boolean hasSown = false;
            while (!hasSown && !done) {
                done = this.setXYZ();
                if (done) {
                    this.theStage = Stage.HANGOUT;
                    this.theFolk.statusText = "\u5728\u519c\u573a\u91cc\u653e\u677e";
                    this.step = 1;
                    return;
                }
                Block gid = this.jobWorld.func_147439_a(this.xxx, this.yyy - 1, this.zzz);
                Block aid = this.jobWorld.func_147439_a(this.xxx, this.yyy, this.zzz);
                if (gid != Blocks.field_150354_m && gid != Blocks.field_150349_c && gid != Blocks.field_150346_d && gid != Blocks.field_150458_ak || aid != Blocks.field_150350_a) continue;
                try {
                    if (this.farmingBlock.farmType != FarmingBox.FarmType.CUSTOM) {
                        this.theFolk.statusText = "\u79cd\u690d" + this.farmingBlock.farmType.toString() + " seeds";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.farmingBlock.farmType == FarmingBox.FarmType.WHEAT) {
                    ItemStack seed;
                    if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Items.field_151014_N, 1), false, false)) == null) {
                        this.theFolk.statusText = "No more wheat seeds to plant";
                        this.theStage = Stage.HANGOUT;
                        this.step = 1;
                        return;
                    }
                    this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                    this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150464_aj, 0, 3);
                    hasSown = true;
                } else if (this.farmingBlock.farmType == FarmingBox.FarmType.PUMPKIN) {
                    if (this.ftb % 4 == 0 || this.ftb % 4 == 1) {
                        ItemStack seed;
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Items.field_151080_bb, 1), false, false)) == null) {
                            this.theFolk.statusText = "I need more pumpkin seeds!";
                            this.theStage = Stage.HANGOUT;
                            this.step = 1;
                            return;
                        }
                        this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                        this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150393_bb, 0, 3);
                        hasSown = true;
                    }
                } else if (this.farmingBlock.farmType == FarmingBox.FarmType.MELON) {
                    if (this.ftb % 4 == 0 || this.ftb % 4 == 1) {
                        ItemStack seed;
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Items.field_151081_bc, 1), false, false)) == null) {
                            this.theFolk.statusText = "I need more melon seeds!";
                            this.theStage = Stage.HANGOUT;
                            this.step = 1;
                            return;
                        }
                        this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                        this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150394_bc, 0, 3);
                        hasSown = true;
                    }
                } else if (this.farmingBlock.farmType == FarmingBox.FarmType.CARROT) {
                    ItemStack seed;
                    if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Items.field_151172_bF, 1), false, false)) == null) {
                        this.theFolk.statusText = "I need more carrots to plant!";
                        this.theStage = Stage.HANGOUT;
                        this.step = 1;
                        return;
                    }
                    this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                    this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150459_bM, 0, 3);
                    hasSown = true;
                } else if (this.farmingBlock.farmType == FarmingBox.FarmType.POTATO) {
                    ItemStack seed;
                    if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Items.field_151174_bG, 1), false, false)) == null) {
                        this.theFolk.statusText = "I need more potatoes to plant!";
                        this.theStage = Stage.HANGOUT;
                        this.step = 1;
                        return;
                    }
                    this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                    this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150469_bN, 0, 3);
                    hasSown = true;
                } else if (this.farmingBlock.farmType == FarmingBox.FarmType.SUGAR) {
                    Block cid = this.jobWorld.func_147439_a(this.xxx, this.yyy - 1, this.zzz);
                    if (cid == Blocks.field_150346_d || cid == Blocks.field_150349_c || cid == Blocks.field_150354_m) {
                        ItemStack seed;
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Items.field_151120_aE, 1), false, false)) == null) {
                            this.theFolk.statusText = "No more sugar cane to plant";
                            this.theStage = Stage.HANGOUT;
                            this.step = 1;
                            return;
                        }
                        this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150436_aH, 0, 3);
                        hasSown = true;
                    }
                } else if (this.farmingBlock.farmType == FarmingBox.FarmType.CACTUS) {
                    if ((this.xxx + this.zzz) % 2 == 0) {
                        ItemStack seed;
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Blocks.field_150434_aF, 1), false, false)) == null) {
                            this.theFolk.statusText = "No more cactus to plant";
                            this.theStage = Stage.HANGOUT;
                            this.step = 1;
                            return;
                        }
                        this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150434_aF, 0, 3);
                        hasSown = true;
                    }
                } else if (this.farmingBlock.farmType == FarmingBox.FarmType.CUSTOM) {
                    block3: for (int ch = 0; ch < this.farmingChests.size(); ++ch) {
                        IInventory chest = this.farmingChests.get(ch);
                        for (int g = 0; g < chest.func_70302_i_(); ++g) {
                            ItemStack chestStack = chest.func_70301_a(g);
                            if (chestStack == null) continue;
                            this.theFolk.statusText = "\u79cd\u690d" + chestStack.func_82833_r();
                            ItemStack seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(chestStack.func_77973_b(), 1), false, false);
                            if (seed == null) continue;
                            this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                            hasSown = seed.func_77973_b().func_77648_a(seed, (EntityPlayer)this.mc.field_71439_g, this.jobWorld, this.xxx, this.yyy - 1, this.zzz, 1, 0.0f, 0.0f, 0.0f);
                            if (hasSown) break block3;
                            this.theFolk.inventory.add(seed);
                            break block3;
                        }
                    }
                }
                if (!hasSown) continue;
                this.jobWorld.func_72980_b((double)this.xxx, (double)this.yyy, (double)this.zzz, Blocks.field_150349_c.field_149762_H.func_150498_e(), 1.0f, 1.0f, false);
                SimukraftReloaded.states.credits -= 0.01f;
                this.doneSomeWork = true;
            }
            if (done) {
                this.theStage = Stage.HANGOUT;
                this.theFolk.statusText = "\u5728\u519c\u573a\u91cc\u653e\u677e";
                this.step = 1;
                this.theFolk.isWorking = false;
                this.inventoriesTransferFromFolk(this.theFolk.inventory, this.farmingChests, null);
                return;
            }
        }
    }

    public void stageHangout() {
        if (this.step == 1) {
            this.lastFarmCycle = System.currentTimeMillis();
            this.step = 2;
            this.theFolk.isWorking = false;
        } else if (this.step == 2) {
            int r;
            Random ra = new Random();
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist > 3) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
            if ((r = ra.nextInt(10)) == 0) {
                this.theFolk.statusText = GameMode.gameMode == GameMode.GAMEMODES.HARDCORE ? "\u54c7\uff0c\u4e13\u5bb6\u6a21\u5f0f\u771f\u7684\u5f88\u96be\uff01" : "\u5728Facebook\u4e0a\u53d1\u6211\u7684\u519c\u573a\u7684\u7167\u7247\uff0c\u4f60\u77e5\u9053\u4e0d\u8fd9\u4e2a\u6a21\u7ec4\u662f\u7531Kylin\u9ed8\u5bd2\u6c49\u5316\u7684yo\uff01";
            } else if (r == 1) {
                this.theFolk.statusText = "\u68c0\u67e5\u5929\u6c14\u9884\u62a5";
            } else if (r == 2) {
                this.theFolk.statusText = "\u5e0c\u671b\u6211\u6709\u4e00\u53f0\u62d6\u62c9\u673a";
            } else if (r == 3) {
                this.theFolk.statusText = "\u4f11\u606f";
            } else if (r == 4) {
                this.theFolk.statusText = "\u6e05\u6d01\u6211\u9504\u5934\u7684\u6c61\u57a2";
            } else if (r == 5) {
                this.theFolk.statusText = "\u4fee\u590d\u6211\u7684\u9504\u5934";
            } else if (r == 6) {
                this.theFolk.statusText = "\u5403\u6211\u7684\u5348\u9910";
            } else if (r == 7) {
                this.theFolk.statusText = "\u7f51\u72b6\u5316\u6211\u7684\u82b1\u952e";
            } else if (r == 8) {
                this.theFolk.statusText = "\u653e\u677e\u4e00\u4f1a\u513f";
            } else if (r == 9) {
                this.theFolk.statusText = "\u5e0c\u671b\u6211\u5728\u73a9\u7684Minecraft";
            }
            if (System.currentTimeMillis() - this.lastFarmCycle > 180000L) {
                this.theStage = Stage.HARVEST;
                this.step = 1;
                return;
            }
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u62b5\u8fbe\u519c\u573a";
            this.theStage = Stage.ARRIVEDATFARM;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATFARM,
        CHECKINGFORCHESTS,
        HOELAND,
        PLANTSEEDS,
        HARVEST,
        HANGOUT;

    }
}

