/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.CourierTask;
import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobCourier
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112207901844141L;
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient ArrayList<CourierTask> courierTasks = new ArrayList();
    private transient ArrayList<IInventory> chests = new ArrayList();
    private transient int currentTask = 0;
    private transient long timeSinceLastCycle = 0L;
    private transient CommonProxy.V3 pickup;
    private transient CommonProxy.V3 dropoff;
    private transient boolean onRoute = false;

    public JobCourier() {
    }

    public JobCourier(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        this.runDelay = this.theStage == Stage.ATDEPOT ? 15000 : 3000;
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage == Stage.IDLE && SimukraftReloaded.isDayTime()) {
            this.onUpdateGoingToWork(this.theFolk);
        } else if (this.theStage == Stage.ATDEPOT) {
            this.stageAtDepot();
        } else if (this.theStage == Stage.GOINGTOPICKUP) {
            this.stageGoingToPickup();
        } else if (this.theStage == Stage.PICKINGUP) {
            this.stagePickingUp();
        } else if (this.theStage == Stage.GOINGTODROPOFF) {
            this.stageGoingToDropoff();
        } else if (this.theStage == Stage.DROPPINGOFF) {
            this.stageDroppingOff();
        }
    }

    private void stageAtDepot() {
        if (System.currentTimeMillis() - this.timeSinceLastCycle < 180000L) {
            return;
        }
        this.currentTask = 0;
        this.courierTasks.clear();
        for (int t = 0; t < SimukraftReloaded.theCourierTasks.size(); ++t) {
            CourierTask task = SimukraftReloaded.theCourierTasks.get(t);
            if (task == null || task.pickup == null || !task.folkname.contentEquals(this.theFolk.name)) continue;
            try {
                this.courierTasks.add(task);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.courierTasks.size() == 0) {
            this.theFolk.statusText = "\u6ca1\u6709\u76ae\u5361\u8f66\u6216\u8d27\u7269\u6765\u8fd0\u9001\uff01";
            return;
        }
        this.theStage = Stage.GOINGTOPICKUP;
        this.onRoute = false;
    }

    private void stageGoingToPickup() {
        if (!this.onRoute) {
            CourierTask task = this.courierTasks.get(this.currentTask);
            this.pickup = task.pickup;
            if (this.pickup != null) {
                CommonProxy.V3 d;
                this.theFolk.statusText = "\u5728\u6211\u53bb" + this.pickup.name + " (pick-up)";
                CommonProxy.V3 v3 = d = this.pickup.clone();
                Double d2 = v3.y;
                Double d3 = v3.y = Double.valueOf(v3.y + 1.0);
                this.theFolk.gotoXYZ(d, FolkData.GotoMethod.BEAM);
                this.onRoute = true;
            } else {
                this.theStage = Stage.IDLE;
            }
        } else {
            double dist;
            if (this.theFolk.gotoMethod == FolkData.GotoMethod.WALK) {
                this.theFolk.updateLocationFromEntity();
            }
            if ((dist = (double)this.theFolk.location.getDistanceTo(this.pickup)) < 3.0) {
                this.theStage = Stage.PICKINGUP;
                this.onRoute = false;
            } else if (this.theFolk.destination == null) {
                this.onRoute = false;
            }
        }
    }

    private void stagePickingUp() {
        CourierTask task = this.courierTasks.get(this.currentTask);
        CommonProxy.V3 pickup = task.pickup;
        this.chests.clear();
        this.chests = JobCourier.inventoriesFindClosest(pickup, 4);
        if (this.chests.size() == 0) {
            SimukraftReloaded.log.warning("JobCourier: StagePickingup() No chest at pickup:" + pickup.name + "\uff0c\u5220\u9664\u4efb\u52a1\u3002");
            ++this.currentTask;
            if (this.currentTask >= this.courierTasks.size()) {
                this.currentTask = 0;
                this.theStage = Stage.IDLE;
            } else {
                this.onRoute = false;
                this.theStage = Stage.GOINGTOPICKUP;
            }
        } else {
            this.theFolk.stayPut = true;
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.statusText = "\u62ff\u8d77\u7269\u54c1";
            SimukraftReloaded.log.info("JobCourier: pickupStage() " + this.theFolk.name + "(courier) found " + this.chests.size() + " \u5728\u7bb1\u5b50" + pickup.name);
            this.inventoriesTransferToFolk(this.theFolk.inventory, this.chests, null);
        }
        if (this.theFolk.inventory.size() == 0) {
            ++this.currentTask;
            if (this.currentTask >= this.courierTasks.size()) {
                this.currentTask = 0;
                this.theStage = Stage.IDLE;
                this.timeSinceLastCycle = System.currentTimeMillis();
            } else {
                this.theStage = Stage.GOINGTOPICKUP;
            }
        } else {
            this.theStage = Stage.GOINGTODROPOFF;
            this.theFolk.statusText = "\u9a76\u53bb\u5378\u8d27\u70b9";
            this.onRoute = false;
        }
    }

    private void stageGoingToDropoff() {
        CourierTask task = this.courierTasks.get(this.currentTask);
        if (task != null && task.dropoff != null) {
            this.dropoff = task.dropoff.clone();
        } else {
            this.theStage = Stage.ATDEPOT;
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            if (task != null) {
                this.courierTasks.remove(task);
            }
        }
        if (this.dropoff == null) {
            this.dropoff = this.theFolk.employedAt;
            this.dropoff.name = "The depot";
        }
        if (!this.onRoute) {
            this.theFolk.statusText = "\u5728\u6211\u53bb" + this.dropoff.name + " (drop-off)";
            CommonProxy.V3 d = this.dropoff.clone();
            if (d == null) {
                d = this.theFolk.employedAt.clone();
            }
            CommonProxy.V3 v3 = d;
            Double d2 = v3.y;
            Double d3 = v3.y = Double.valueOf(v3.y + 1.0);
            this.theFolk.beamMeTo(d);
            this.theFolk.gotoXYZ(d, FolkData.GotoMethod.BEAM);
            this.onRoute = true;
        } else {
            double dist;
            if (this.theFolk.gotoMethod == FolkData.GotoMethod.WALK) {
                this.theFolk.updateLocationFromEntity();
            }
            if ((dist = (double)this.theFolk.location.getDistanceTo(this.dropoff)) < 4.0) {
                this.theStage = Stage.DROPPINGOFF;
                this.onRoute = false;
            } else if (this.theFolk.destination == null) {
                this.onRoute = false;
            }
        }
    }

    private void stageDroppingOff() {
        CourierTask task = this.courierTasks.get(this.currentTask);
        CommonProxy.V3 dropoff = task.dropoff;
        if (dropoff == null) {
            dropoff = this.theFolk.employedAt;
            dropoff.name = "\u4ed3\u5e93";
        }
        this.chests.clear();
        this.chests = JobCourier.inventoriesFindClosest(dropoff, 5);
        if (this.chests.size() == 0) {
            SimukraftReloaded.log.warning("JobCourierL dropoff() No chest found at dropoff");
            ++this.currentTask;
            if (this.currentTask >= this.courierTasks.size()) {
                this.currentTask = 0;
                this.theStage = Stage.IDLE;
            } else {
                this.theStage = Stage.GOINGTOPICKUP;
            }
        } else {
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u6389\u843d\u7269\u54c1\u5173\u95ed";
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            SimukraftReloaded.log.info("JobCourier: " + this.theFolk.name + " found " + this.chests.size() + " \u5728\u7bb1\u5b50" + dropoff.name);
            while (this.theFolk.inventory.size() > 0) {
                int oldSize = this.theFolk.inventory.size();
                SimukraftReloaded.states.credits -= 0.11f;
                ItemStack invItem = this.theFolk.inventory.get(0);
                this.theFolk.statusText = this.theFolk.inventory.size() > 1 ? this.theFolk.inventory.size() + " stacks of items to unload" : "\u6700\u540e\u8d1f\u8377...";
                boolean placed = this.inventoriesTransferFromFolk(this.theFolk.inventory, this.chests, null);
                if (placed) continue;
                SimukraftReloaded.sendChat(this.theFolk.name + "(\u5feb\u9012)\u4e0d\u80fd\u5c06\u7269\u54c1\u653e\u5165" + dropoff.name + "\u56e0\u4e3a\u7bb1\u5b50\u6ee1\u4e86\uff0c\u8bf7\u6dfb\u52a0\u66f4\u591a\u7684\u50a8\u5b58\u7bb1\u3002");
                break;
            }
        }
        ++this.currentTask;
        if (this.currentTask >= this.courierTasks.size()) {
            this.theFolk.statusText = "\u68c0\u67e5\u6211\u7684\u4efb\u52a1\u5217\u8868";
            this.currentTask = 0;
            this.timeSinceLastCycle = System.currentTimeMillis();
            this.theFolk.stayPut = false;
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            this.theStage = Stage.IDLE;
        } else {
            this.theStage = Stage.GOINGTOPICKUP;
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u5230\u8fbe\u4ed3\u5e93";
            this.theStage = Stage.ATDEPOT;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    public static enum Stage {
        IDLE,
        ATDEPOT,
        GOINGTOPICKUP,
        PICKINGUP,
        GOINGTODROPOFF,
        DROPPINGOFF;

    }
}

