/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedBlocks;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedItems;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class JobCheesemaker
extends Job {
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public int runDelay = 1000;
    private ArrayList<IInventory> chestsAtDairy = new ArrayList();
    private int currentFarmNum = 0;
    private Building farm = null;
    private long timeSinceLastRun = 0L;
    private Building theCheeseFactory = null;
    private boolean tubToggle = true;
    private int stirCount = 0;
    private CommonProxy.V3 currentStirPos;

    public JobCheesemaker(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.theCheeseFactory == null) {
            this.theCheeseFactory = Building.getBuilding(this.theFolk.employedAt);
        }
        if (this.theCheeseFactory == null) {
            Building.loadAllBuildings();
            this.theCheeseFactory = Building.getBuilding(this.theFolk.employedAt);
        }
        if (this.theCheeseFactory == null) {
            this.theFolk.selfFire();
            SimukraftReloaded.sendChat("\u5976\u916a\u5de5\u5382\u6709\u95ee\u9898\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u542f\u52a8\u7684Minecraft");
            return;
        }
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.ARRIVEDATFACTORY) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.runDelay = 11000;
        } else {
            this.runDelay = this.theStage == Stage.EMPTYINGMILK ? 1000 : 5000;
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATFACTORY) {
                this.stageArrivedAtFactory();
            } else if (this.theStage == Stage.GOINGTODAIRYFARM) {
                this.stageGoingToDairyFarm();
            } else if (this.theStage == Stage.COLLECTINGMILK) {
                this.stageCollectingMilk();
            } else if (this.theStage == Stage.GOINGTOTANK) {
                this.stageGoingToTank();
            } else if (this.theStage == Stage.EMPTYINGMILK) {
                this.stageEmptyingMilk();
            } else if (this.theStage == Stage.STIRING) {
                this.stageStiring();
            } else if (this.theStage == Stage.HARVESTCHEESE) {
                this.stageHarvestCheese();
            } else if (this.theStage == Stage.SLICECHEESE) {
                this.stageSliceCheese();
            }
        }
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
    }

    private void stageArrivedAtFactory() {
        try {
            ArrayList<CommonProxy.V3> cheesechest = this.theCheeseFactory.getSpecialBlocks(5);
            ArrayList<IInventory> chests = JobCheesemaker.inventoriesFindClosest(cheesechest.get(0), 4);
            this.inventoriesTransferToFolk(this.theFolk.inventory, chests, new ItemStack(Items.field_151117_aB, 64));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.theStage = Stage.GOINGTODAIRYFARM;
        this.currentFarmNum = -1;
    }

    private void stageGoingToDairyFarm() {
        this.theFolk.statusText = "\u53bb\u6536\u96c6\u725b\u5976";
        ++this.currentFarmNum;
        ArrayList<Building> dairyFarms = Building.getBuildingBySearch("\u5976\u725b\u519c\u573a", true);
        if (!dairyFarms.isEmpty() && dairyFarms.size() - 1 <= this.currentFarmNum) {
            this.farm = dairyFarms.get(this.currentFarmNum);
            this.theFolk.gotoXYZ(this.farm.primaryXYZ, FolkData.GotoMethod.BEAM);
            this.theStage = Stage.COLLECTINGMILK;
            this.step = 1;
            return;
        }
        if (dairyFarms.isEmpty()) {
            SimukraftReloaded.sendChat(this.theFolk.name + "\u56e0\u4e3a\u6ca1\u6709\u5976\u725b\u519c\u573a\uff0c\u6240\u4ee5\u5012\u95ed\u4e86\uff01");
            this.theFolk.selfFire();
            return;
        }
        this.theStage = Stage.GOINGTOTANK;
    }

    private void stageCollectingMilk() {
        this.theFolk.statusText = "Collecting milk";
        if (this.step == 1) {
            if (this.theFolk.destination == null && this.theFolk.location.getDistanceTo(this.farm.primaryXYZ) < 5) {
                this.step = 2;
                this.theFolk.isWorking = true;
            } else {
                SimukraftReloaded.log.info("JobCheeseMaker: not arrived at farm yet");
            }
        } else if (this.step == 2) {
            this.chestsAtDairy = Job.inventoriesFindClosest(this.farm.primaryXYZ, 5);
            if (this.chestsAtDairy.isEmpty()) {
                SimukraftReloaded.sendChat(this.theFolk.name + "\uff1a\u627e\u4e0d\u4efb\u4f55\u5976\u725b\u519c\u573a\uff0c\u6211\u4e0d\u5e72\u4e86\uff01");
                this.theFolk.selfFire();
                return;
            }
            this.inventoriesTransferToFolk(this.theFolk.inventory, this.chestsAtDairy, new ItemStack(Items.field_151117_aB, 1));
            if (this.theFolk.inventory == null || this.theFolk.inventory.isEmpty()) {
                SimukraftReloaded.sendChat(this.theFolk.name + "\u4eca\u5929\u8fd8\u6ca1\u6709\u53d1\u73b0\u4efb\u4f55\u725b\u5976\u6765\u505a\u4e73\u5236\u54c1\u3002");
                this.theStage = Stage.SLICECHEESE;
                this.step = 1;
                this.theFolk.isWorking = false;
                this.theFolk.statusText = "\u6ca1\u6709\u725b\u5976\u52a0\u5de5\u4f1a\u662f\u5bb9\u6613\u7684\u4e00\u5929\u5427\uff01";
                return;
            }
            ArrayList<CommonProxy.V3> tanktop = this.theCheeseFactory.getSpecialBlocks(3);
            if (!tanktop.isEmpty()) {
                this.theFolk.gotoXYZ(tanktop.get(0), FolkData.GotoMethod.BEAM);
                this.theStage = Stage.GOINGTOTANK;
                this.step = 1;
                this.theFolk.isWorking = false;
            } else {
                SimukraftReloaded.log.warning("JobCheesemaker: no tank top point");
                this.theFolk.selfFire();
            }
        }
    }

    private void stageGoingToTank() {
        if (this.step == 1) {
            if (this.theFolk.destination == null) {
                this.step = 2;
                this.theFolk.statusText = "\u51c6\u5907\u52a0\u6ee1\u6c34\u7bb1";
            } else {
                SimukraftReloaded.log.info("JobCheeseMaker: not arrived at back yet");
            }
        } else if (this.step == 2) {
            this.theStage = Stage.EMPTYINGMILK;
            this.step = 1;
        }
    }

    private void stageEmptyingMilk() {
        if (this.step == 1) {
            if (this.theFolk.inventory != null && !this.theFolk.inventory.isEmpty()) {
                this.theFolk.statusText = this.theFolk.inventory.size() > 1 ? "\u6e05\u7a7a" + this.theFolk.inventory.size() + " \u6876\u725b\u5976" : "\u6e05\u7a7a\u6240\u6709\u7684\u725b\u5976";
                this.theFolk.isWorking = true;
                this.theFolk.stayPut = true;
                this.step = 2;
            } else {
                this.step = 3;
            }
        } else if (this.step == 2) {
            ArrayList<CommonProxy.V3> milkblocks = this.theCheeseFactory.getSpecialBlocks(0);
            int lightID = Block.func_149682_b((Block)SimukraftReloadedBlocks.lightBox);
            SimukraftReloaded.log.info(Integer.toString(lightID));
            boolean filledOk = false;
            for (CommonProxy.V3 milkBlock : milkblocks) {
                Block id = this.jobWorld.func_147439_a(milkBlock.x.intValue(), milkBlock.y.intValue(), milkBlock.z.intValue());
                int meta = this.jobWorld.func_72805_g(milkBlock.x.intValue(), milkBlock.y.intValue(), milkBlock.z.intValue());
                if (id != Blocks.field_150350_a && (id != SimukraftReloadedBlocks.blockFluidMilk || meta != 1)) continue;
                this.jobWorld.func_147465_d(milkBlock.x.intValue(), milkBlock.y.intValue(), milkBlock.z.intValue(), SimukraftReloadedBlocks.blockFluidMilk, 0, 3);
                try {
                    this.theFolk.inventory.remove(0);
                }
                catch (Exception e) {
                    SimukraftReloaded.log.info("Caught Exception" + e.toString());
                }
                filledOk = true;
                break;
            }
            if (filledOk) {
                this.theFolk.isWorking = false;
                this.step = 1;
            } else {
                this.theStage = Stage.STIRING;
                this.step = 1;
                this.theFolk.isWorking = false;
                ArrayList<CommonProxy.V3> cheesechest = this.theCheeseFactory.getSpecialBlocks(5);
                ArrayList<IInventory> chests = JobCheesemaker.inventoriesFindClosest(cheesechest.get(0), 4);
                this.inventoriesTransferFromFolk(this.theFolk.inventory, chests, null);
            }
        } else if (this.step == 3) {
            this.theStage = Stage.STIRING;
            this.step = 1;
            this.theFolk.isWorking = false;
        }
    }

    private void stageStiring() {
        ArrayList<CommonProxy.V3> stirPositions = this.theCheeseFactory.getSpecialBlocks(4);
        if (this.step == 1) {
            this.theFolk.statusText = "\u68c0\u67e5\u725b\u5976\u7c98\u5ea6";
            if (!stirPositions.isEmpty()) {
                if (this.tubToggle) {
                    this.currentStirPos = stirPositions.get(0);
                    this.theFolk.gotoXYZ(this.currentStirPos, null);
                } else {
                    this.currentStirPos = stirPositions.get(1);
                    this.theFolk.gotoXYZ(this.currentStirPos, null);
                }
                this.tubToggle = !this.tubToggle;
                this.stirCount = 0;
                this.step = 2;
            } else {
                SimukraftReloaded.sendChat("\u6709\u7684\u5976\u916a\u5382\u51fa\u4e86\u95ee\u9898\uff0c\u628a\u5efa\u7b51\u6784\u9020\u4e0b\u6765\uff0c\u91cd\u65b0\u6784\u5efa\u5b83");
                this.theFolk.selfFire();
            }
        } else if (this.step == 2) {
            if (this.theFolk.destination == null) {
                this.step = 3;
            }
        } else if (this.step == 3) {
            String say = "";
            switch (this.stirCount) {
                case 0: {
                    say = "\u6405\u62cc\u725b\u5976";
                    break;
                }
                case 1: {
                    say = "\u52a0\u5165\u7edd\u5bc6\u6210\u5206";
                    break;
                }
                case 2: {
                    say = "\u6dfb\u52a0\u7ec6\u83cc\u57f9\u517b";
                    break;
                }
                case 3: {
                    say = "\u9664\u53bb\u4e0d\u9700\u8981\u7684\u5b62\u5b50";
                    break;
                }
                case 4: {
                    say = "\u68c0\u67e5\u53d1\u9175\u8fdb\u5ea6";
                    break;
                }
                case 5: {
                    say = "\u52a0\u5165\u51dd\u4e73\u9176";
                    break;
                }
                case 6: {
                    say = "\u7f51\u6761\u72b6\u5976\u916a";
                }
            }
            this.theFolk.statusText = say;
            this.theFolk.isWorking = true;
            this.theFolk.stayPut = true;
            if (this.stirCount == 6) {
                this.transformMilkToCheese(this.currentStirPos);
            }
            ++this.stirCount;
            if (this.stirCount > 6) {
                this.theFolk.isWorking = false;
                this.step = 1;
            }
            if (MinecraftServer.func_71276_C().field_71305_c[0].func_72820_D() % 24000L > 9900L) {
                this.step = 1;
                this.theFolk.isWorking = false;
                this.theStage = Stage.HARVESTCHEESE;
            }
        }
    }

    private void transformMilkToCheese(CommonProxy.V3 currentStirPos) {
        Block id;
        ArrayList<CommonProxy.V3> milkBlocks = this.theCheeseFactory.getSpecialBlocks(0);
        ArrayList<CommonProxy.V3> cheeseBlocks = this.theCheeseFactory.getSpecialBlocks(1);
        if (milkBlocks.isEmpty() || cheeseBlocks.isEmpty()) {
            this.theFolk.selfFire();
            SimukraftReloaded.sendChat("\u6709\u4e00\u4e2a\u4e0e\u5976\u916a\u5de5\u5382\u95ee\u9898\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u5efa\u7acb\u5b83 - \u6ca1\u6709\u5976\u5757");
            return;
        }
        boolean placedCheese = false;
        int milkGotCount = 0;
        for (int m = milkBlocks.size() - 1; m > 0; --m) {
            CommonProxy.V3 milk = milkBlocks.get(m);
            id = this.jobWorld.func_147439_a(milk.x.intValue(), milk.y.intValue(), milk.z.intValue());
            int meta = this.jobWorld.func_72805_g(milk.x.intValue(), milk.y.intValue(), milk.z.intValue());
            if (id != SimukraftReloadedBlocks.blockFluidMilk || meta != 0) continue;
            this.jobWorld.func_147465_d(milk.x.intValue(), milk.y.intValue(), milk.z.intValue(), id, 0, 3);
            if (++milkGotCount > 1) break;
        }
        if (milkGotCount > 0) {
            for (CommonProxy.V3 cheese : cheeseBlocks) {
                id = this.jobWorld.func_147439_a(cheese.x.intValue(), cheese.y.intValue(), cheese.z.intValue());
                int dist = cheese.getDistanceTo(currentStirPos);
                if (id == SimukraftReloadedBlocks.blockCheese || dist >= 5) continue;
                this.jobWorld.func_147465_d(cheese.x.intValue(), cheese.y.intValue(), cheese.z.intValue(), SimukraftReloadedBlocks.blockCheese, 0, 3);
                placedCheese = true;
                break;
            }
        }
        if (milkGotCount == 0 || !placedCheese) {
            this.step = 1;
            this.theFolk.isWorking = false;
            this.theStage = Stage.HARVESTCHEESE;
        }
    }

    private void stageHarvestCheese() {
        ArrayList<CommonProxy.V3> cheeseBlocks = this.theCheeseFactory.getSpecialBlocks(1);
        ArrayList<CommonProxy.V3> stirPositions = this.theCheeseFactory.getSpecialBlocks(4);
        this.theFolk.statusText = "\u63d0\u53d6\u5976\u916a\u5757";
        if (this.step == 1) {
            this.theFolk.gotoXYZ(stirPositions.get(0), null);
            this.step = 2;
        } else if (this.step == 2) {
            if (this.theFolk.destination == null) {
                this.step = 3;
                this.theFolk.isWorking = true;
            }
        } else if (this.step == 3) {
            this.theFolk.isWorking = false;
            boolean gotBlock = false;
            for (CommonProxy.V3 block : cheeseBlocks) {
                Block id = this.jobWorld.func_147439_a(block.x.intValue(), block.y.intValue(), block.z.intValue());
                if (stirPositions.get(0).getDistanceTo(block) >= 5 || id != SimukraftReloadedBlocks.blockCheese) continue;
                gotBlock = true;
                this.theFolk.inventory.add(new ItemStack(SimukraftReloadedBlocks.blockCheese));
                this.jobWorld.func_147465_d(block.x.intValue(), block.y.intValue(), block.z.intValue(), id, 0, 3);
                this.theFolk.isWorking = true;
                SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.45);
                break;
            }
            if (!gotBlock) {
                this.theFolk.isWorking = false;
                this.step = 4;
                this.theFolk.gotoXYZ(stirPositions.get(1), null);
            }
        } else if (this.step == 4) {
            if (this.theFolk.destination == null) {
                this.step = 5;
                this.theFolk.isWorking = true;
            }
        } else if (this.step == 5) {
            this.theFolk.isWorking = false;
            boolean gotBlock = false;
            for (CommonProxy.V3 block : cheeseBlocks) {
                Block id = this.jobWorld.func_147439_a(block.x.intValue(), block.y.intValue(), block.z.intValue());
                if (stirPositions.get(1).getDistanceTo(block) >= 5 || id != SimukraftReloadedBlocks.blockCheese) continue;
                gotBlock = true;
                this.theFolk.inventory.add(new ItemStack(SimukraftReloadedBlocks.blockCheese));
                this.jobWorld.func_147465_d(block.x.intValue(), block.y.intValue(), block.z.intValue(), id, 0, 3);
                break;
            }
            if (!gotBlock) {
                this.step = 1;
                this.theStage = Stage.SLICECHEESE;
                this.theFolk.statusText = "\u8ba1\u7b97\u5976\u916a\u5757";
            }
        }
    }

    private void stageSliceCheese() {
        ArrayList<CommonProxy.V3> slicewaypoint = this.theCheeseFactory.getSpecialBlocks(5);
        if (slicewaypoint.isEmpty()) {
            this.theFolk.selfFire();
            SimukraftReloaded.sendChat("\u6709\u4e00\u4e2a\u4e0e\u5976\u916a\u5382\u7684\u95ee\u9898\uff0c\u5c1d\u8bd5\u91cd\u65b0\u5efa\u7acb\u5b83\u7684\u822a\u70b9\u95ee\u9898");
            return;
        }
        if (this.step == 1) {
            this.theFolk.gotoXYZ(slicewaypoint.get(0), null);
            this.step = 2;
        } else if (this.step == 2) {
            if (this.theFolk.destination == null) {
                this.step = 3;
                this.theFolk.stayPut = true;
            }
        } else if (this.step == 3) {
            ArrayList<IInventory> chests = Job.inventoriesFindClosest(slicewaypoint.get(0), 4);
            if (chests.isEmpty()) {
                SimukraftReloaded.sendChat(this.theFolk.name + ":\u6709\u4eba\u5728\u5976\u916a\u5de5\u5382\u7bb1\u5b50\u91cc\u5077\u5976\u916a\uff0c\u6211\u4e0d\u5e72\u4e86\uff01");
                this.theFolk.selfFire();
            }
            this.inventoriesTransferFromFolk(this.theFolk.inventory, chests, null);
            this.step = 4;
        } else if (this.step == 4) {
            ArrayList<IInventory> chests = Job.inventoriesFindClosest(slicewaypoint.get(0), 4);
            this.theFolk.statusText = "\u5207\u7247\u5976\u916a";
            ItemStack cheese = JobCheesemaker.inventoriesGet(chests, new ItemStack(SimukraftReloadedBlocks.blockCheese, 1), false, false);
            if (cheese != null) {
                boolean placedOK = this.inventoriesPut(chests, new ItemStack(SimukraftReloadedItems.itemFood, 9, 0), true);
                if (!placedOK) {
                    SimukraftReloaded.sendChat(this.theFolk.name + "'\u5976\u916a\u5de5\u5382\u7684\u7bb1\u5b50\u88c5\u6ee1\u4e86\u5976\u916a\uff01");
                    this.theFolk.selfFire();
                }
            } else {
                this.step = 5;
            }
        } else if (this.step == 5) {
            this.theFolk.statusText = "\u6211\u559c\u6b22\u7684\u5976\u916a\uff01";
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u5230\u8fbe\u5de5\u5382";
            this.theStage = Stage.ARRIVEDATFACTORY;
            this.currentFarmNum = 0;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATFACTORY,
        GOINGTODAIRYFARM,
        COLLECTINGMILK,
        GOINGTOTANK,
        EMPTYINGMILK,
        STIRING,
        HARVESTCHEESE,
        SLICECHEESE;

    }
}

