/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobButcher
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112207904271422L;
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient float pay = 0.0f;
    private transient ArrayList<IInventory> chestsAtFarm = new ArrayList();
    private transient ArrayList<IInventory> chestsAtShop = new ArrayList();
    private transient int currentFarmNum = 0;
    private transient Building farm = null;
    private transient boolean onRoute = false;

    public JobButcher() {
    }

    public JobButcher(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.ARRIVEDATSHOP) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.runDelay = 11000;
        } else {
            this.runDelay = 3000;
        }
        if (this.theStage == Stage.SELLINGMEAT) {
            this.runDelay = 10000;
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATSHOP) {
                this.theStage = Stage.GOINGTOMEATFARM;
            } else if (this.theStage == Stage.GOINGTOMEATFARM) {
                this.stageGoingToFarm();
            } else if (this.theStage == Stage.COLLECTINGMEAT) {
                this.stageCollectingMeat();
            } else if (this.theStage == Stage.GOBACKTOSTORE) {
                this.stageGoBackToStore();
            } else if (this.theStage == Stage.SELLINGMEAT) {
                this.stageSellingMeat();
            }
        }
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        if (this.theStage == Stage.ARRIVEDATSHOP) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.runDelay = 11000;
        } else {
            this.runDelay = 3000;
        }
        if (this.theStage == Stage.SELLINGMEAT) {
            this.runDelay = 10000;
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
    }

    private void stageGoingToFarm() {
        block8: {
            this.theFolk.statusText = "Fetching meat from livestock farms";
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            if (!this.onRoute) {
                this.farm = this.getCurrentFarm();
                try {
                    if (this.farm == null || this.farm.primaryXYZ == null) {
                        this.theStage = Stage.GOBACKTOSTORE;
                        break block8;
                    }
                    this.onRoute = true;
                    this.theFolk.gotoXYZ(this.farm.primaryXYZ, FolkData.GotoMethod.BEAM);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.theStage = Stage.GOBACKTOSTORE;
                }
            } else {
                int dist = this.theFolk.location.getDistanceTo(this.farm.primaryXYZ);
                if (dist < 3) {
                    if (this.theFolk.theEntity != null) {
                        this.theFolk.theEntity.field_70159_w = 0.0;
                        this.theFolk.theEntity.field_70179_y = 0.0;
                    }
                    this.onRoute = false;
                    this.theStage = Stage.COLLECTINGMEAT;
                    this.step = 1;
                    this.theFolk.stayPut = true;
                    return;
                }
                if (this.theFolk.destination == null) {
                    this.onRoute = false;
                }
            }
        }
    }

    private void stageCollectingMeat() {
        this.theFolk.statusText = "\u4ece\u7bb1\u5b50\u91cc\u53d6\u8089";
        this.theFolk.action = FolkData.FolkAction.ATWORK;
        if (this.step == 1) {
            this.chestsAtFarm.clear();
            this.chestsAtFarm = JobButcher.inventoriesFindClosest(this.farm.primaryXYZ, 5);
            if (this.chestsAtFarm.size() > 0) {
                this.step = 2;
            }
        } else if (this.step == 2) {
            this.inventoriesTransferToFolk(this.theFolk.inventory, this.chestsAtFarm, new ItemStack(Items.field_151076_bf, 1, 640));
            this.inventoriesTransferToFolk(this.theFolk.inventory, this.chestsAtFarm, new ItemStack(Items.field_151147_al, 1, 640));
            this.inventoriesTransferToFolk(this.theFolk.inventory, this.chestsAtFarm, new ItemStack(Items.field_151082_bd, 1, 640));
            this.step = 3;
        } else if (this.step == 3) {
            this.theStage = Stage.GOINGTOMEATFARM;
        }
    }

    private void stageGoBackToStore() {
        this.theFolk.action = FolkData.FolkAction.ATWORK;
        this.theFolk.statusText = "\u5e26\u8089\u56de\u8089\u5e97";
        if (!this.onRoute) {
            this.onRoute = true;
            this.theFolk.gotoXYZ(this.theFolk.employedAt, FolkData.GotoMethod.BEAM);
        } else {
            double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist < 2.0) {
                this.onRoute = false;
                if (this.theFolk.theEntity != null) {
                    this.theFolk.theEntity.field_70159_w = 0.0;
                    this.theFolk.theEntity.field_70179_y = 0.0;
                }
                this.theFolk.stayPut = true;
                this.theFolk.statusText = "\u5378\u8f7d\u8089";
                int meat1 = this.getInventoryCount(this.theFolk, Items.field_151147_al);
                int meat2 = this.getInventoryCount(this.theFolk, Items.field_151076_bf);
                int meat3 = this.getInventoryCount(this.theFolk, Items.field_151082_bd);
                this.pay = (float)((double)(meat1 + meat2 + meat3) * 0.03);
                this.chestsAtShop = JobButcher.inventoriesFindClosest(this.theFolk.employedAt, 3);
                this.inventoriesTransferFromFolk(this.theFolk.inventory, this.chestsAtShop, null);
                this.theStage = Stage.SELLINGMEAT;
                this.step = 1;
                return;
            }
            if (this.theFolk.destination == null) {
                this.onRoute = false;
            }
        }
    }

    private void stageSellingMeat() {
        this.theFolk.action = FolkData.FolkAction.ATWORK;
        this.theFolk.statusText = "\u628a\u8089\u5356\u7ed9\u987e\u5ba2";
        if (this.step == 1) {
            this.chestsAtShop = JobButcher.inventoriesFindClosest(this.theFolk.employedAt, 3);
            this.openCloseChest(this.chestsAtShop.get(0), 2000);
            if (this.pay > 0.0f) {
                SimukraftReloaded.states.credits -= this.pay;
                SimukraftReloaded.sendChat(this.theFolk.name + "\u5df2\u5207\u597d\u8ba2\u8d2d\u7684\u8089" + SimukraftReloaded.displayMoney(this.pay) + " Sim-u-credits.");
                this.mc.field_71441_e.func_72980_b(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u, this.mc.field_71439_g.field_70161_v, "ashjacksimukraftreloaded:cash", 1.0f, 1.0f, false);
            }
            this.step = 2;
        } else if (this.step == 2) {
            if (this.mc.func_71401_C().field_71305_c[0].func_72820_D() % 24000L > 11600L) {
                this.step = 3;
            }
            this.theFolk.updateLocationFromEntity();
            double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist > 8.0) {
                this.theFolk.beamMeTo(this.theFolk.employedAt);
            }
        } else if (this.step == 3) {
            this.theFolk.statusText = "\u5173\u5e97\u95e8";
            int sell = 0;
            boolean notEnough = false;
            ItemStack piece = null;
            this.chestsAtShop = JobButcher.inventoriesFindClosest(this.theFolk.employedAt, 3);
            for (int f = 0; f < SimukraftReloaded.theFolks.size(); ++f) {
                piece = JobButcher.inventoriesGet(this.chestsAtShop, new ItemStack(Items.field_151147_al, 1), false, false);
                if (piece == null) {
                    piece = JobButcher.inventoriesGet(this.chestsAtShop, new ItemStack(Items.field_151076_bf, 1), false, false);
                }
                if (piece == null) {
                    piece = JobButcher.inventoriesGet(this.chestsAtShop, new ItemStack(Items.field_151082_bd, 1), false, false);
                }
                if (piece == null) continue;
                FolkData folk = SimukraftReloaded.theFolks.get(f);
                folk.levelFood = 10;
                ++sell;
            }
            if (sell > 0) {
                SimukraftReloaded.sendChat(this.theFolk.name + "\u5df2\u7ecf\u5356\u7ed9\u987e\u5ba2" + sell + "\u5757\u8089");
            }
            this.step = 4;
        } else if (this.step == 4) {
            // empty if block
        }
    }

    private Building getCurrentFarm() {
        boolean found = false;
        while (!found) {
            try {
                Building farm = SimukraftReloaded.theBuildings.get(this.currentFarmNum);
                if (farm.displayNameWithoutPK.contains("\u725b\u725b\u541b\u519c\u573a") || farm.displayNameWithoutPK.contains("\u732a\u732a\u541b\u519c\u573a") || farm.displayNameWithoutPK.contains("\u9b54\u90fd\u517b\u9e21\u573a")) {
                    found = true;
                    ++this.currentFarmNum;
                    return farm;
                }
                ++this.currentFarmNum;
                if (this.currentFarmNum <= SimukraftReloaded.theBuildings.size() - 1) continue;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u62b5\u8fbe\u5546\u5e97";
            this.theStage = Stage.ARRIVEDATSHOP;
            this.currentFarmNum = 0;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATSHOP,
        GOINGTOMEATFARM,
        COLLECTINGMEAT,
        GOBACKTOSTORE,
        SELLINGMEAT;

    }
}

